<?php
require_once "request.php";

if (!isset($tutorials_php)) {
  $tutorials_php = "tutorials.php";
}
$page_title = $_CONF['page_title'];

if ($req->ok) {
  $opt = new DisplayOptions($req->headers['display_options'], $req->headers['run_mode'], $req->headers['demo_path'], isset($_CONF['formats']) ? $_CONF['formats'] : '');
  $head = $opt->include_css_js($uri_to_dw, $_CONF['disable_jquery']);
  
  $series = $req->headers['series'];
  $demos = $req->headers['demos'];
  $groups = $req->headers['groups'];
  
  /* 
   * Add any purchased series to the end of $series and $demos
   */
  
  if (isset($p_series)) {
    // If displaying subscription + purchased demos, add SWF to any purchased demos that are present in both lists.
    foreach ($p_series as $_series) {
      if (isset($series[$_series->id]) && !$_series->has_format('swf')) {
        $_series->add_format('swf');
      }
    }
    
    $series = $p_series + $series;
  }
  
  if (isset($p_demos)) {
    $demos = $p_demos + $demos;
  }
  
  if (isset($p_series_groups)) {
    $groups = $p_series_groups;
  }
  
  /*
   * Make the show/hide variables easier to work with.
   */
  foreach (array("hide_series", "hide_demos", "show_series", "show_demos") as $var) {
    if (isset($$var)) {
      $$var = array_flip($$var);
    }
  }
  
  SeriesData::normalize($series);
  DemoData::normalize($demos);
  SeriesGroupData::normalize($groups);
  
  /*
   * We'll only be displaying a single series if $_GET['series'] is set.
   */
  $disable_paging = '';
  if (!empty($_GET['series'])) {
    if (isset($series[$_GET['series']])) {
      $series = array($series[$_GET['series']]);
      $disable_paging = '<script type="text/javascript">disable_paging = true;</script>';
    }
  }
  
  /*
   * Now sort.
   */
  
  if (isset($sort_series)) {
    $sorted = array();
    foreach ($sort_series as $id) {
      if (isset($series[$id])) {
        $sorted[$id] = $series[$id];
        unset($series[$id]);
      }
    }
    
    $series = $sorted + $series;
  }
  
  if (isset($sort_demos)) {
    foreach ($sort_demos as $series_id => $demo_ids) {
      $sorted = array();
      
      foreach ($demo_ids as $id) {
        if (isset($demos[$series_id][$id])) {
          $sorted[$id] = $demos[$series_id][$id];
          unset($demos[$series_id][$id]);
        }
      }
      
      $demos[$series_id] = $sorted + $demos[$series_id];
    }
  }
  
  /*
   * Store some frequently-accessed values as variables
   */
  
  $accordion = $opt->is_set('accordion');
  $paged = $opt->is_set('paged');
  $nested = $opt->is_set('colorbox') && $paged;
  $search = new DWSearch($opt->is_set('search'), $series, $demos);
  
  if ($nested) {
    $paged = false;
  }

  /*
   * Check if we should be using columns
   */

  $columns = 1;
  
  if (!$opt->is_set('accordion')) {
    if ($opt->is_set('two-columns')) {
      $column_class = 'dw-two-columns';
      $columns = 2;
    } else if ($opt->is_set('three-columns')) {
      $column_class = 'dw-three-columns';
      $columns = 3;
    }
  }
  
  /*
   * div#all-dw-series should be hidden if we're set to nested mode.
   */ 
  
  $hide_all = "";
  if ($nested && !isset($_GET['series'])) {
    $hide_all = ' style="display: none;"';
  }
  
  /*
   * Display Search Form & Filter Results
   */
  
  $search_str = "";
  
  if ($search->enabled) {
    $wp = isset($_GET['page_id']) ? "\n<input type=\"hidden\" name=\"page_id\" value=\"$_GET[page_id]\" />" : ""; // For WordPress
	  $search_query_key = DWSearch::$query_key;
    $search_str = <<<HTML
  <div id="dw-search">
    <script type="text/javascript">var search_query_key = "$search_query_key";</script>
    <form action="$tutorials_php" method="get">
      <input type="text" id="search_query" name="$search_query_key" value="$search->query" />$wp
      <input type="submit" value="Search" />
      <input type="submit" name="reset" value="Reset" />
    </form>
  </div>

HTML;
  }
  
  /*
   * Now prepare strings for all series
   */
  
  $content = <<<HTML
  <div id="all-dw-series"$hide_all>

HTML;
  
  $series_links = array();
  $all_series = array();
  $total_demos = 0;
  
  if (is_array($series))
  foreach ($series as $s) {
    if (!$s->visible) continue;
    
    if (!empty($_GET['series'])) {
      $page_title = $s->title;
    }
    
    $h3 = "<h3>$s->title</h3>";
    
    if (defined('STATIC_MODE')) {
      $series_href = $s->path . ".html";
    } else {
      $series_href = $tutorials_php;
      
      if (defined('USE_KAYAKO4_SERIES_LINKS')) {
        $series_href .= "/Index/$s->id";
      } else {
        if (strpos($tutorials_php, "?") !== false) {
          $series_href .= '&amp;';
        } else {
          $series_href .= '?';
        }
        $series_href .= "series=$s->id";
        
        if ($search->enabled && !empty($search->query)) {
          $series_href .=  "&amp;" . DWSearch::$query_key . "=" . urlencode($search->query);
        }
      }
    }
    
    $series_link = <<<HTML
<h3><a href="{$series_href}" target="_blank" title="$s->title" id="dw-series{$s->id}-link">$s->title</a></h3>
HTML;
    
    /*
     * Only the accordion's div.dw-series-list > h3 elements should be a link. They must be, in fact.
     */
    if ($accordion) {
      $h3 = $series_link;
    }
    
    /*
     * Otherwise, the h3 links should be in dw-series-titles.
     * Don't populate $series_links if we're displaying a single series. Likewise, don't make the h3 a link if that's the case.
     */
    if (($paged || $nested) && empty($_GET['series'])) {
      $str = "";
      
      if (isset($text_before_series[$s->id])) {
        $str .= $text_before_series[$s->id];
      }
      
      $str .= "    $series_link\n";
      
      if (isset($text_after_series[$s->id])) {
        $str .= $text_after_series[$s->id];
      }
      
      $series_links[] = $str;
    }
    
    /*
     * We still need the dw-series-list divs to be populated if we're set to nested -- Colorbox pulls the HTML out of these divs. 
     */
    if ((!$paged || !empty($_GET['series'])) && isset($demos[$s->id])) {
      $series_str = "";
      
      if (!$accordion && isset($text_before_series[$s->id])) {
        $series_str .= $text_before_series[$s->id];
      }
    
      $div = <<<HTML
<div class="dw-series-list" id="dw-series{$s->id}-list">
HTML;

      /*
       * Accordions must display the h3 before the div.
       */
      if ($accordion) {
        $series_str .= <<<HTML
    $h3
    $div

HTML;
      } else {
      $series_str .= <<<HTML
    $div
      $h3

HTML;
      }
      
      if ($accordion && (!isset($accordion_text_after) || $accordion_text_after == "inside") && isset($text_before_series[$s->id])) {
        $series_str .= $text_before_series[$s->id];
      }
      
      list($demos_str, $actual_count) = $opt->list_demos($demos[$s->id], $uri_to_dw, $s);      
      $series_str .= $demos_str;
      
      if ($accordion && isset($text_after_series[$s->id])) {
        $series_str .= $text_after_series[$s->id];
      }
      
      $series_str .= "    </div>\n";
      $total_demos += $actual_count;
      
      if ((!$accordion || (isset($accordion_text_after) && $accordion_text_after == "outside")) && isset($text_after_series[$s->id])) {
        $series_str .= $text_after_series[$s->id];
      }
      
      $all_series[] = array('str' => $series_str, 'actual_count' => $actual_count);
    }
  }
  
  /*
   * For displaying ALL demos inline
   */
  
  $count_series = count($all_series);
  
  if ($count_series > 0) {
    if ($count_series == 1) {
      $content .= $all_series[0]['str'];
    } else {
      if ($columns > 1) {
        $per_column = $total_demos / $columns;
        for ($column = 1, $i = 0; $column <= $columns; $column++) {
          $content .= "  <div class=\"$column_class\" id=\"dw-series-column$column\">\n";
          
          for ($in_col = 0; $i < $count_series; $in_col += $all_series[$i]['actual_count'], $i++) {
            if ($column != $columns && $in_col > $per_column) {
              break;
            }
            $content .= $all_series[$i]['str'];
          }
          
          $content .= "  </div>\n";
        }
      } else {
        for ($i = 0; $i < $count_series; $i++) {
          $content .= $all_series[$i]['str'];
        }
      }
    }
  }
  
  $content .= "  </div>\n";
  
  /*
   * If we're set to paged or nested, output series links separately.
   */
  
  if (!empty($series_links)) {
    $count_series = count($series_links);
    if ($columns > 1) {
      $per_column = $count_series / $columns;
      $str = "";
      for ($column = 1, $i = 0; $column <= $columns; $column++) {
        $str .= "  <div class=\"$column_class\" id=\"dw-series-column$column\">\n";
        
        for ($in_col = 0; $in_col < $per_column && $i < $count_series; $in_col++, $i++) {
          $str .= $series_links[$i];
        }
        
        $str .= "  </div>\n";
      }
      $series_links = $str;
    } else {
      $series_links = implode("", $series_links);
    }
    
    $series_links = <<<HTML
  <div id="dw-series-titles">
$series_links
  </div>

HTML;

    $content = $series_links . $content;
  } else {
    if ($search->enabled && !empty($search->query)) {
      if (($paged || $nested) && empty($_GET['series'])) {
        $content .= "No results.";
      } else if (empty($all_series)) {
        $content .= "No results.";
      }
    }
  }
  
  $content = $disable_paging . $search_str . $content;
  
  $content .= '<br style="clear: both;" />';
  
  /*
   * Depending on the run mode, put all output in PHP variables or echo it using the template.
   */
  if (in_array($req->headers['run_mode'], array('php', 'whmcs', 'kayako', 'wordpress'))) {
    $dw_page_title = $page_title;
    $dw_head = $head;
    $dw_content = $content;
    unset($page_title, $head, $content);
  } else {
    $tpl = file_get_contents("templates/tutorials.tpl");
    echo str_replace(array("{{title}}", "{{head}}", "{{content}}"), array($page_title, $head, $content), $tpl);
  }
}
?>