<?php
/**
 * =======================================
 * ###################################
 * SWIFT Framework
 *
 * @package	SWIFT
 * @author	Kayako Infotech Ltd.
 * @copyright	Copyright (c) 2001-2009, Kayako Infotech Ltd.
 * @license	http://www.kayako.com/license
 * @link		http://www.kayako.com
 * @filesource
 * ###################################
 * =======================================
 */

define('MODULE_TUTORIALS', 'tutorials');

/**
 * The Main Installer
 * 
 * @author Sean Talbot
 */
class SWIFT_SetupDatabase_tutorials extends SWIFT_SetupDatabase
{

	/**
	 * Constructor
	 *
	 * @author Sean Talbot
	 * @return bool "true" on Success, "false" otherwise
	 */
	public function __construct()
	{
		parent::__construct(MODULE_TUTORIALS);

		// Widgets
		SWIFT_Loader::LoadLibrary('Widget:Widget');

		return true;
	}

	/**
	 * Destructor
	 *
	 * @author Sean Talbot
	 * @return bool "true" on Success, "false" otherwise
	 */
	public function __destruct()
	{
		parent::__destruct();

		return true;
	}

	/**
	 * Loads the table into the container
	 * 
	 * @author Sean Talbot
	 * @return bool "true" on Success, "false" otherwise
	 */
	public function LoadTables()
	{
		return true;
	}

	/**
	 * Function that does the heavy execution
	 * 
	 * @author Sean Talbot
	 * @param int $_pageIndex The Page Index
	 * @return bool "true" on Success, "false" otherwise
	 */
	public function Install($_pageIndex)
	{
		parent::Install($_pageIndex);

		// ======= WIDGET =======
		SWIFT_Widget::Create('Video Tutorials', 'tutorials', MODULE_TUTORIALS, '/Tutorials/List', '{$themepath}icon_widget_tutorials.png', '{$themepath}icon_widget_tutorials_small.png', 4, true, true, false, true, SWIFT_Widget::VISIBLE_ALL, false);

		return true;
	}

	/**
	 * Uninstalls the module
	 * 
	 * @author Sean Talbot
	 * @return bool "true" on Success, "false" otherwise
	 */
	public function Uninstall()
	{
		parent::Uninstall();

		SWIFT_Widget::DeleteOnModule(array(MODULE_TUTORIALS));
		
		return true;
	}

	/**
	 * Upgrade the Module
	 *
	 * @author Sean Talbot
	 * @return bool "true" on Success, "false" otherwise
	 */
	public function Upgrade()
	{
		return parent::Upgrade();
	}
}
?>