<?php
/**
 * =======================================
 * ###################################
 * SWIFT Framework
 *
 * @package	SWIFT
 * @author	Kayako Infotech Ltd.
 * @copyright	Copyright (c) 2001-2009, Kayako Infotech Ltd.
 * @license	http://www.kayako.com/license
 * @link		http://www.kayako.com
 * @filesource
 * ###################################
 * =======================================
 */

/**
 * The Knowledgebase List Controller
 *
 * @author Sean Talbot
 */
class Controller_List extends Controller_client
{
	/**
	 * Constructor
	 *
	 * @author Sean Talbot
	 * @return bool "true" on Success, "false" otherwise
	 */
	public function __construct()
	{
		parent::__construct();
		
		return true;
	}

	/**
	 * Destructor
	 *
	 * @author Sean Talbot
	 * @return bool "true" on Success, "false" otherwise
	 */
	public function __destruct()
	{
		parent::__destruct();

		return true;
	}

	/**
	 * Include the DemoWolf Tutorial Viewer.
	 *
	 * @author Sean Talbot
	 * @return bool "true" on Success, "false" otherwise
	 * @throws SWIFT_Exception If the Class is not Loaded
	 */
	public function Index($_seriesID = 0)
	{
		if (!$this->GetIsClassLoaded())
		{
			throw new SWIFT_Exception(SWIFT_CLASSNOTLOADED);

			return false;
		}
		
		if ($_seriesID != 0) {
		  $_GET['series'] = $_seriesID;
		}

		$this->UserInterface->Header('tutorials');
		$title = $this->Language->Get('tutorials');
		
		define('USE_KAYAKO4_SERIES_LINKS', true);
    $tutorials_php = "index.php?/Tutorials/List"; // The name of this PHP file.
    
    require("dw-tutorials.php");
    $this->Template->Assign("dw_head", $dw_head);
		
		echo <<<HTML
<div class="boxcontainer">
  <div class="boxcontainerlabel">$title</div>
  <div class="boxcontainercontent">
$dw_content
  </div>
</div>

HTML;
		$this->UserInterface->Footer();

		return true;
	}
}
?>