<?php
ob_start();
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
  <title>DemoWolf Importer v2.0</title>
  <link href="style.css" rel="stylesheet" type="text/css" />
  <link href="../../js/video-js.min.css" rel="stylesheet" type="text/css" />
  <script type="text/javascript" src="../../js/jquery-1.5.2.min.js"></script>
  <script type="text/javascript" src="../../js/video.min.js"></script>
  <script type="text/javascript" src="js/importer.js"></script>
</head>
<body>
<div id="main">
  <h2>DemoWolf Importer v2.0</h2>
  <div class="error">As a precaution, please make sure you have recently backed up your SQL database before running the importer.</div>
<?php
error_reporting(E_ALL);

require "includes/base.php";

if (!file_exists("../../request.php")) {
  die("<div class=\"error\">Sorry! The importer cannot function without access to the <b>entire</b> Tutorial Viewer script. It must remain in the default location (resources/importer/).</div>");
}

$cwd = getcwd();
chdir("../../");
require "request.php";

/*
 * Load series data
 */

$series = $s_series = $req->headers['series'];
$demos = $req->headers['demos'];
$groups = $req->headers['groups'];

if (isset($p_series)) {
  // If displaying subscription + purchased demos, add SWF to any purchased demos that are present in both lists.
  foreach ($p_series as $k => $_series) {
    if (isset($series[$_series->id]) && !$_series->has_format('swf')) {
      $_series->add_format('swf');
    }
  }
  $series = $p_series + $series;
}

if (isset($p_demos)) {
  $demos = $p_demos + $demos;
}

if (isset($p_series_groups)) {
  $groups = $p_series_groups;
}

if (empty($series) || empty($demos)) {
  echo "<div class=\"error\">Unable to find tutorial list!</div>";
  die;
}

SeriesData::normalize($series);
SeriesData::normalize($s_series);
DemoData::normalize($demos);
SeriesGroupData::normalize($groups);

/*
 * Predefined values
 */

$default_uri = $_SERVER['REQUEST_URI'];
$default_uri = preg_replace("#resources/importer/.*$#", "", $_SERVER['REQUEST_URI']);

$demo_path = isset($_CONF['demo_path']) ? $_CONF['demo_path'] : '';
$demo_uri = isset($_CONF['demo_uri']) ? $_CONF['demo_uri'] : $demo_path;

$values = array(
  "type" => "", "mode" => "pages", "path" => getcwd(), "category" => -2, "article_per" => 'demo', "demo_display" => "inline", "demo_window" => "colorbox", "demo_link_text" => "Click to Watch",
  "uri_to_viewer" => $default_uri, "demo_path" => $demo_path, "demo_uri" => $demo_uri, "article_author" => "", "formats" => array('swf' => true), "format_combine" => "together"
);
$types = array("whmcs" => "WHMCS", "kayako" => "Kayako 3", "kayako4" => "Kayako 4", "wordpress" => "WordPress"/*, "Joomla"*/);
$modes = array("pages" => "Pages &amp; Subpages", "posts" => "Categories &amp; Posts");

$steps[1] = array_flip(array("type", "mode", "path", "uri_to_viewer", "formats"));
$steps[2] = array_flip(array("category", "article_per", "article_author", "demo_display", "demo_window", "demo_link_text", "format_combine"));

$output = "";

if (file_exists('resources/importer/importer.lock')) {
  ImportErrors::handler("To run the importer, you must delete the importer.lock file.");
} else {
  if (empty($_GET['step'])) {
    $step = 1;
  } else {
    $step = floatval($_GET['step']);
  }
  
  if ($step > 1) {
    $im = Importer::from_post();
    
    if ($step == 3 && $_POST['category'] == -2) {
      $category_word = ($im->type == 'wordpress' && $im->mode == 'pages') ? 'page' : 'category';
      ImportErrors::handler("No $category_word was selected.");
    }
    
    if ($step == 4 && empty($_POST['selected'])) {
      ImportErrors::handler("No series were selected. Please choose at least one series.");
    }
    
    if (!empty(ImportErrors::$errors)) {
      $step = ceil($step - 1);
    } else {
      if ($im->type == "wordpress") {
        // I think this needs to be loaded in the global scope; couldn't get it to work any other way.
        require $im->path . "wp-load.php";
        require $im->path . "wp-admin/includes/taxonomy.php";
      }
    }
  }
  
  $hidden = "";
  
  foreach ($_POST as $k => $v) {
    $values[$k] = $v;
  }
  
  foreach ($values as $k => $v) {
    if (!isset($steps[strval($step)][$k])) {
      if (is_array($v)) {
        foreach ($v as $k2 => $v2) {
          $hidden .= <<<HTML

    <input type="hidden" id="$k-$k2" name="{$k}[$k2]" value="1" />
HTML;
        }
      } else {
        $hidden .= <<<HTML

    <input type="hidden" id="$k" name="$k" value="$v" />
HTML;
      }
    }
  }
  
  if ($step == 1) {
    echo "<h3>Step One - Where &amp; What To Import</h3>\n";
    
    if (!empty($p_demos)) {
      $formats = array("swf" => "SWF", "mp4" => "MP4", "text" => "Text");
      $format_opts = radio_helper("formats", true);
      $format_field = <<<HTML
      <dt><label for="formats">5) If you have purchased the tutorials in <b>additional or alternative formats</b>, choose which formats you would like to import.</label></dt>
      <dd>
$format_opts
      </dd>

HTML;
      
      $path_field = <<<HTML
      <dt><label for="demo_path">4) <b>For Purchased Demos Only:</b> Be sure that you've uploaded your tutorial series folders named exactly as they were provided to you, and that you've configured your <b>includes/conf.php</b> file with the location where you uploaded them. The <b>demo_path</b> and <b>demo_uri</b> settings allow you to do that.</label></dt>
      <dd>
        <ul>
          <li>Current setting for <b>demo_path</b> (expected location for <b>SWF format</b> series folders): $values[demo_path]</li>
          <li>Current setting for <b>demo_uri</b> (expected location for <b>SWF format</b> series folders): $demo_uri</li>
          <li>Expected location for Text/Image format <b>HTML files</b>: {$demo_uri}html/</li>
          <li>Expected location for Text/Image format <b>Image folders</b>: {$demo_uri}images/</li>
          <li>Expected location for <b>MP4 format</b> series folders: {$demo_uri}mp4/</li>
        </ul>
      </dd>

HTML;
    } else {
      $format_field = $path_field = "";
    }
    
    $type_options = select_helper("type");
    $mode_options = select_helper("mode");
    
    $output .= <<<HTML
  <form action="?step=1.5" method="post">
    <dl>
      <dt><label for="type">1) Where would you like to import your tutorials?</label></dt>
      <dd>
        <select id="type" name="type">
$type_options
        </select>
      </dd>
      <dt class="importer_mode hidden"><label for="mode">1.1) <b>WordPress only:</b> Import as pages or categories and posts?</label></dt>
      <dd class="importer_mode hidden">
        <select id="mode" name="mode">
$mode_options
        </select>
      </dd>
      <dt><label for="path">2) Please enter the full <u><b>filesystem path</b></u> to the script chosen above. Example: /home/user/public_html/whmcs</label></dt>
      <dd><input type="text" id="path" name="path" value="$values[path]" style="width: 400px;" /></dd>
      <dt><label for="uri_to_viewer">3) <b>Absolute URI</b> to the Tutorial Viewer script. For example, if you'll be importing your demos to a WHMCS installation at /clients/ and your tutorial viewer is in /clients/viewer/, you should enter /clients/viewer/</label></dt>
      <dd><input type="text" id="uri_to_viewer" name="uri_to_viewer" value="$values[uri_to_viewer]" style="width: 300px;" /></dd>
      $path_field
      $format_field
      <dt><input type="submit" value="Submit" /></dt>
    </dl>
$hidden
  </form>

HTML;
  } else if ($step == '1.5') {
    echo <<<HTML
<h3>Initiating Precheck... Ignore warnings at your own risk!</h3>
<div class="error">NOTE - If your tutorials do not load or you are unable to submit this page via the Continue button, please go back and check that the value entered for #2 is correct.</div>
<base href="$im->base_url" />

Your DemoWolf series list <b>has been found</b>!<br />
Your {$types[$im->type]} config file <b>has been found</b>!<br />
Your {$types[$im->type]} installation is assumed to be accessible via <b>{$im->base_url}</b><br />

HTML;
    
    $need_swf = !empty($im->formats['swf']);
    $need_mp4 = !empty($im->formats['mp4']);
    $need_text = !empty($im->formats['text']);
    
    if ($need_swf && count($series) > count($p_series)) {
      foreach ($series as $s) {
        if (!isset($p_series[$s->id])) {
          echo "<br />You should see an SWF tutorial from your subscription below. <b>If the tutorial doesn't load, this import will most likely <i>fail</i>.</b>";
          $demo = reset($demos[$s->id]);
          $demo->series = &$s;
          echo $im->create_demo_article_string($demo, 'swf', true);
          echo '<br /><br />';
          break;
        }
      }
    }
    
    if (!empty($p_demos)) {
      echo "<br /><br />Checking that your purchased tutorial files exist...<br /><br />";
      
      $last_swf = $last_mp4 = $last_text = NULL;
      
      foreach ($series as $s) {
        if (!isset($p_series[$s->id])) {
          continue;
        }
        
        if (stripos($s->formats, 'swf') !== false && !$s->swf_from_subscr) {
          $last_swf = $s;
        }
        
        if (stripos($s->formats, 'mp4') !== false) {
          $last_mp4 = $s;
        }
        
        if (stripos($s->formats, 'text') !== false) {
          $last_text = $s;
        }
        
        echo $s->orig_title . ': ';
        
        $any_errors = false;
        
        foreach ($demos[$s->id] as $demo) {
          $swf_path = $im->demo_path . $s->path . '/' . $demo->path;
          $html_path = $im->demo_path . 'html/' . $s->path . '/' . str_replace('.swf', '.html', $demo->path);
          $mp4_path = $im->demo_path . 'mp4/' . $s->path . '/' . str_replace('.swf', '.mp4', $demo->path);
          
          echo $demo->num . ' ';
          
          if ($need_swf && !file_exists($swf_path)) {
            echo "<div class=\"error\">Could not find $swf_path.</div>";
          }
          if ($need_mp4 && !file_exists($mp4_path)) {
            echo "<div class=\"error\">Could not find $mp4_path.</div>";
          }
          if ($need_text && !file_exists($html_path)) {
            echo "<div class=\"error\">Could not find $html_path.</div>";
          }
        }
        
        if (!$any_errors) {
          echo ' <b>OK!</b>';
        }
        
        echo "<br />\n";
        
        if ($need_swf && isset($last_swf)) {
          $demo = reset($demos[$last_swf->id]);
          $demo->series = &$last_swf;
          echo "<br /><br />You should see a sample SWF tutorial below. <b>If the tutorial doesn't load, this import will most likely <i>fail</i>.</b>";
          echo $im->create_demo_article_string($demo, 'swf', true);
          echo "<br /><br />";
        }
        
        if ($need_mp4 && isset($last_mp4)) {
          $demo = reset($demos[$last_mp4->id]);
          $demo->series = &$last_mp4;
          echo "<br /><br />You should see a sample MP4 video below. <b>If the video doesn't load, this import will most likely <i>fail</i>.</b>";
          echo $im->create_demo_article_string($demo, 'mp4', true, true);
          echo "<br /><br />";
        }
        
        if ($need_text && isset($last_text)) {
          $demo = reset($demos[$last_text->id]);
          $demo->series = &$last_text;
          echo "<br /><br />You should see a sample tutorial article below. <b>If the article doesn't load, this import will most likely <i>fail</i>.</b>";
          echo $im->create_demo_article_string($demo, 'text', true);
          echo "<br /><br />";
        }
      }
    }
    
    $output .= <<<HTML
  <div class="error">NOTE - If your tutorials do not load or you are unable to submit this page via the Continue button, please go back and check that the value entered for #2 is correct.</div>
  <form action="{$im->uri_to_viewer}resources/importer/?step=2" method="post">
    <dl>
      <dt><input type="submit" value="Continue" /></dt>
    </dl>
$hidden
  </form>

HTML;
  } else if ($step == 2) {
    $categories = $im->list_cats($im->category);
    
    $article_per = array("series" => "Series", "demo" => "Demo", "series_demo" => "Series &amp; Demo");
    $article_per_opts = radio_helper("article_per");
    
    $demo_display = array("inline" => "Inline", "play" => "<i>Play Button</i> w/ Link to Video", "link" => "<i>Text Link</i> to Video");
    $demo_display_opts = radio_helper("demo_display");
    
    $demo_window = array("colorbox" => "Colorbox (JavaScript popup box) - <b>This will only work if Colorbox is enabled in your Display Options.</b><br />", "new" => "New Window", "same" => "Same Window");
    $demo_window_opts = radio_helper("demo_window");
    
    if (count($im->formats) > 1) {
      $format_combine = array("together" => "Together", "separate" => "Separate", "separate_crosslink" => "Separate (With Crosslinks)");
      $format_combine_opts = radio_helper("format_combine");
      $format_combine_field = <<<HTML
      <dt class="format_combine">5) You've chosen to import multiple formats. Would you like the different versions of the tutorials to be together in the same article or in separate articles?</dt>
      <dd class="format_combine">
$format_combine_opts
      </dd>

HTML;
    } else {
      $format_combine_field = "";
    }
    
    $category_desc = "Select the category in which to create the subcategories and articles.";
    $article_per_desc = "Create articles for each:";
    $demo_display_desc = "How should the videos appear in their articles?";
    $author_field = "";
    
    if ($im->type == "wordpress") {
      if ($im->mode == "pages") {
        $category_desc = "Select the page under which to create the subpages.";
        $article_per_desc = "Create pages for each:";
        $demo_display_desc = "How should the videos appear on their pages?";
      }
      
      $author_field_options = "";
      
      foreach ($im->list_users() as $user) {
        $author_field_options .= <<<HTML
          <option value="$user[ID]">$user[user_nicename]</option>

HTML;
      }
      
      $author_field_word = $im->mode;
      $author_field = <<<HTML
      <dt>2.1) Choose the user that should be the author of the $author_field_word.</dt>
      <dd>
        <select id="article_author" name="article_author">
          <option value="0">Select a User</option>
$author_field_options
        </select>
      </dd>

HTML;
    } else if ($im->type == "whmcs") {
      $demo_display_desc .= " <b>Please note that many WHMCS 4 themes don't provide enough room to display the tutorials properly using the <i>Inline</i> option.</b>";
    }
    
    echo "<h3>Step Two - Options</h3>\n";
    $output .= <<<HTML
  <form action="?step=3" method="post">
    <dl>
      <dt>1) <label for="category">$category_desc</label></dt>
      <dd>
        <select id="category" name="category">
$categories
        </select>
      </dd>
      <dt>2) $article_per_desc</dt>
      <dd>
$article_per_opts
      </dd>
$author_field
      <dt class="demo_display hidden">3) $demo_display_desc</dt>
      <dd class="demo_display hidden">
$demo_display_opts
      </dd>
      <dt class="demo_link_text hidden"><label for="demo_link_text">3.1) Enter the text to use for the links to the videos.</label></dt>
      <dd class="demo_link_text hidden">
        <input type="text" id="demo_link_text" name="demo_link_text" value="$values[demo_link_text]" />
      </dd>
      <dt class="demo_window hidden">4) Where should links to the demos open?</dt>
      <dd class="demo_window hidden">
$demo_window_opts
      </dd>
$format_combine_field
      <dt><input type="submit" value="Submit" /></dt>
    </dl>
$hidden
  </form>

HTML;
  } else if ($step == 3) {
    echo "<h3>Step Three - Which Series To Import</h3>\n";
    
    $series_list = series_list($s_series);
    $p_series_list = series_list($p_series, 'p_');
    
    if ($series_list == "") {
      $series_list = "    <tr><td colspan=\"2\">No subscription series.</td></tr>\n";
    }
    if ($p_series_list == "") {
      $p_series_list = "    <tr><td colspan=\"2\">No purchased series.</td></tr>\n";
    }
    
    $buttons = <<<HTML
  <input type="button" id="select_all" value="Select All" />
  <input type="button" id="deselect_all" value="Deselect All" />
HTML;
    
    $output .= <<<HTML
  <form action="?step=4" method="post">
$buttons
  <h4>Subscription Series</h4>
  <table>
$series_list
  </table>
  
  <h4>Purchased Series</h4>
  <table>
$p_series_list
  </table>
<input type="submit" id="submit" name="submit" value="Import Now" style="margin-top: 20px;" />
$hidden
  </form>

HTML;
  } else if ($step == 4) {
    echo "<h3>Step Four - Importing</h3>\n";
    
    $i = 1;
    
    foreach ($_POST['selected'] as $k => $v) {
      $s = $series[$k];
      $s->demos = $demos[$s->id];
      
      echo "Importing $s->title.<br />";
      
      $im->import($s, $i++);
    }
    
    $im->cleanup();
    
    echo "<h4>Import Complete!</h4>";
    
    if (touch("resources/importer/importer.lock")) {
      echo "The importer has locked itself down and will not run again unless the importer.lock file is deleted.";
    } else {
      ImportErrors::handler("<div class=\"error\">The importer could not lock itself down. You should delete the importer/ folder.</div>");
    }
  }
}

ImportErrors::prepend($output);
echo $output;
?>
</div>
</body>
</html>