<?php
function radio_helper($var, $use_checkboxes = false) {
  global $$var, $values;
    
  $str = "";
    
  foreach ($$var as $k => $v) {
    $checked = "";
    if ((!$use_checkboxes && $values[$var] == $k) || ($use_checkboxes && !empty($values[$var][$k]))) {
      $checked = ' checked="checked"';
    }
    
    if ($use_checkboxes) {
      $type = 'checkbox';
      $name_suffix = "[$k]";
      $value = "";
    } else {
      $type = 'radio';
      $name_suffix = '';
      $value = " value=\"$k\"";
    }
    
    $str .= <<<HTML
        <label><input type="$type" id="$var-$k" name="$var$name_suffix"$value$checked />$v</label>

HTML;
  }
  
  return $str;
}

function select_helper($var) {
  global ${$var . 's'}, $values;
  
  $str = "";
  
  foreach (${$var . 's'} as $k => $v) {
    $selected = "";
    if ($values[$var] == $k) {
      $selected = ' selected="selected"';
    }
    
    $str .= <<<HTML
          <option value="$k"$selected>$v</option>

HTML;
  }
  
  return $str;
}

function series_list(&$series, $prefix = "s_") {
  $str = "";
  
  if (!is_array($series)) {
    return $str;
  }
  
  foreach ($series as $s) {
    $checked = "";
    if (isset($_POST['selected'][$s->id])) {
      $checked = ' checked="checked"';
    }
    
    $str .= <<<HTML
    <tr><td><input type="checkbox" id="{$prefix}selected[$s->id]" name="selected[$s->id]"$checked /></td><td><label for="{$prefix}selected[$s->id]">$s->title</label></td></tr>

HTML;
  }
  
  return $str;
}

function path_trailing_slash($path) {
  return rtrim($path, DIRECTORY_SEPARATOR) . DIRECTORY_SEPARATOR;
}
?>