<?php
class ImporterWordPress extends Importer {
  public $mode = "posts";
  private $table_prefix, $siteurl;
  
  public function connect() {
    $this->config_path = $this->path . 'wp-config.php';
    
    if (is_readable($this->config_path)) {
      if (!$this->extract_db_config()) {
        ImportErrors::handler("Unable to extract MySQL settings from WordPress config file.");
        return;
      }
      
      $host = $this->extract_host_info();
      
      $this->db = new MySQLi($host['name'], $this->db_user, $this->db_password, $this->db_name, $host['port'], $host['socket']);
      
      $err = mysqli_connect_error();
      
      if ($err != NULL) {
        ImportErrors::handler("Could not connect to the MySQL server: $err");
      } else {
        $this->load_base_url();
      }
    } else {
      ImportErrors::handler("WordPress configuration file does not exist in specified path.");
    }
  }
  
  private function extract_host_info() {
    $exp = explode(":", $this->db_host);
    
    $name = $exp[0];
    $port = ini_get("mysqli.default_port");
    $socket = ini_get("mysqli.default_socket");
    
    if (count($exp) > 1) {
      if (is_numeric($exp[1])) {
        $port = $exp[1];
      } else {
        $socket = $exp[1];
      }
    }
    
    return compact('name', 'port', 'socket');
  }
  
  private function extract_db_config() {
    $str = file_get_contents($this->config_path);
    $constants = array('DB_NAME', 'DB_USER', 'DB_PASSWORD', 'DB_HOST');
    
    foreach ($constants as $constant) {
      if (preg_match("#define\('$constant',\s*'(.*)'\);#", $str, $matches)) {
        $this->{strtolower($constant)} = $matches[1];
      }
    }
    
    if (preg_match("#\\\$table_prefix\s*=\s*'(.*)';#m", $str, $matches)) {
      $this->table_prefix = $matches[1];
    }
    
    return isset($this->db_host, $this->db_user, $this->db_password, $this->db_name, $this->table_prefix);
  }
  
  protected function load_base_url() {
    $result = $this->query("SELECT option_value FROM {$this->table_prefix}options WHERE option_name = 'siteurl'");
    $row = $result->fetch_array(MYSQLI_ASSOC);
    $this->siteurl = $this->base_url = $row['option_value'];
  }
  
  public function create_article($cat, $title, $article, $order = 0) {
    $post = array(
      'post_title' => $title,
      'post_content' => $article,
      'post_author' => $this->article_author,
      'post_status' => 'publish',
      'filter' => true, // Prevent WordPress from stripping out the object / embed tags 
    );
    
    // Setting 'filter' no longer works in newer versions
    if (function_exists('kses_remove_filters') && function_exists('kses_init_filters')) {
      $kses = true;
      kses_remove_filters();
    }
    
    if ($this->mode == "pages") {
      $post = array_merge($post, array(
        'post_parent' => $cat,
        'menu_order' => $order,
        'post_type' => 'page'
      ));
    } else {
      $post = array_merge($post, array(
        'post_category' => array($cat),
        'post_type' => 'post'
      ));
    }
    
    $ret = wp_insert_post($post);
    
    if ($kses) {
      kses_init_filters();
    }
    
    return $ret;
  }
  
  public function update_article($id, $article) {
    // Setting 'filter' no longer works in newer versions
    if (function_exists('kses_remove_filters') && function_exists('kses_init_filters')) {
      $kses = true;
      kses_remove_filters();
    }
    
    $ret = wp_update_post(array(
      'ID' => $id,
      'post_content' => $article,
      'filter' => true, // Prevent WordPress from stripping out the object / embed tags
    ));
    
    if ($kses) {
      kses_init_filters();
    }
    
    return $ret;
  }
  
  public function create_category($parent, $name, $description = "", $totalarticles = 0, $order = 0) {
    if ($this->mode == "pages") {
      return $this->create_article($parent, $name, $description, $order);
    } else {
      return wp_create_category($name, $parent);
    }
  }
  
  public function list_cats($selected) {
    if ($this->mode == "pages") {
      $result = $this->query("SELECT * FROM {$this->table_prefix}posts WHERE post_type = 'page' AND post_parent = 0 ORDER BY post_title ASC");    
      return parent::list_cats($result, $selected, 'ID', 'post_title');
    } else {
      $result = $this->query("SELECT t.term_id, name FROM `wp_terms` t LEFT JOIN `wp_term_taxonomy` tx ON tx.term_id = t.term_id WHERE tx.taxonomy = 'category' ORDER BY name ASC");
      return parent::list_cats($result, $selected, 'term_id', 'name');
    }
  }
  
  public function cleanup() {
    return true;
  }
  
  public function article_url($article_id, $demo) {
    return get_permalink($article_id);
  }
  
  public function list_users() {
    $users = array();
    $result = $this->query("SELECT ID, user_nicename FROM {$this->table_prefix}users ORDER BY user_nicename ASC");
    
    while ($row = $result->fetch_array()) {
      $users[] = $row;
    }
    
    return $users;
  }
}
?>