<?php
class ImporterWHMCS extends Importer {  
  public function connect() {
    $this->config_path = $this->path . 'configuration.php';
    
    if (is_readable($this->config_path)) {
      require $this->config_path;
      $this->db = new MySQLi($db_host, $db_username, $db_password, $db_name);
      
      $err = mysqli_connect_error();
      
      if ($err != NULL) {
        ImportErrors::handler("Could not connect to the MySQL server: $err");
      } else {
        $this->load_base_url();
      }
    } else {
      ImportErrors::handler("WHMCS configuration file does not exist in specified path.");
    }
  }
  
  protected function load_base_url() {
    $result = $this->query("SELECT value FROM tblconfiguration WHERE setting = 'SystemURL'");
    $row = $result->fetch_array(MYSQLI_ASSOC);
    $this->base_url = $row['value'];
  }
  
  public function create_article($cat, $title, $article, $order = 0) {
    $cat = intval($cat);
    $title = $this->db->escape_string($title);
    $article = $this->db->escape_string($article);
    
    $query = "INSERT INTO tblknowledgebase (title, article) VALUES('$title', '$article')";
    $this->query($query);
    
    $insert_id = $this->db->insert_id;
    
    $query = "INSERT INTO tblknowledgebaselinks VALUES($cat, $insert_id)";
    $this->query($query);
    
    return $insert_id;
  }
  
  public function update_article($id, $article) {
    $id = intval($id);
    $article = $this->db->escape_string($article);
    $query = "UPDATE tblknowledgebase SET article = '$article' WHERE id = $id";
    $this->query($query);
  }
  
  public function create_category($parent, $name, $description = "", $totalarticles = 0, $order = 0) {
    $name = $this->db->escape_string($name);
    $description = $this->db->escape_string($description);
    
    $query = "INSERT INTO tblknowledgebasecats (parentid, name, description) VALUES($parent, '$name', '$description')";
    $this->query($query);
    
    return $this->db->insert_id;
  }
  
  public function list_cats($selected) {
    $result = $this->query("SELECT * FROM tblknowledgebasecats ORDER BY parentid ASC, name ASC");
    return parent::list_cats($result, $selected, 'id', 'name');
  }
  
  public function cleanup() {
    return true;
  }
  
  public function article_url($article_id, $demo) {
    return "knowledgebase.php?action=displayarticle&amp;id=$article_id";
  }
}
?>