<?php
// Dummy class to prevent errors when including the config file.
class SWIFT {
  public static function Set($str, $arr) { }
}

class ImporterKayako4 extends Importer {
  protected $table_prefix = "sw";
  
  public function connect() {
    $this->config_path = $this->path . '__swift/config/config.php';
    
    if (is_readable($this->config_path)) {
      require $this->config_path;
      $this->db = new MySQLi(DB_HOSTNAME, DB_USERNAME, DB_PASSWORD, DB_NAME, DB_PORT);
      
      if (defined('TABLE_PREFIX')) {
        $this->table_prefix = TABLE_PREFIX;
      }
      
      $err = mysqli_connect_error();
      
      if ($err != NULL) {
        ImportErrors::handler("Could not connect to the MySQL server: $err");
      } else {
        $this->load_base_url();
      }
    } else {
      ImportErrors::handler("Kayako configuration file does not exist in specified path.");
    }
  }
  
  protected function load_base_url() {
    $result = $this->query("SELECT data FROM {$this->table_prefix}settings WHERE vkey = 'general_producturl'");
    $row = $result->fetch_array(MYSQLI_ASSOC);
    $this->base_url = $row['data'];
  }
  
  public function create_article($cat, $title, $article, $order = 0) {
    $cat = intval($cat);
    $title = $this->db->escape_string($title);
    $article = $this->db->escape_string($article);
    $order = intval($order);
    
    $query = "INSERT INTO {$this->table_prefix}kbarticles (creator, creatorid, subject, dateline, articlestatus) VALUES(2, 1, '$title', UNIX_TIMESTAMP(), 1)";
    $this->query($query);
        
    $insert_id = $this->db->insert_id;
    
    $query = "INSERT INTO {$this->table_prefix}kbarticledata VALUES(NULL, $insert_id, '$article', '')";
    $this->query($query);
    
    $query = "INSERT INTO {$this->table_prefix}kbarticlelinks VALUES(NULL, $insert_id, 2, $cat)";
    $this->query($query);
    
    return $insert_id;
  }
  
  public function update_article($id, $article) {
    $id = intval($id);
    $article = $this->db->escape_string($article);
    $query = "UPDATE {$this->table_prefix}kbarticledata SET contents = '$article' WHERE kbarticleid = $id";
    $this->query($query);
  }
  
  public function create_category($parent, $name, $description = "", $totalarticles = 0, $order = 0) {
    $name = $this->db->escape_string($name);
    $description = $this->db->escape_string($description);
    $totalarticles = intval($totalarticles);
    
    $query = "INSERT INTO {$this->table_prefix}kbcategories VALUES(NULL, $parent, 0, '$name', UNIX_TIMESTAMP(), $totalarticles, 1, $order, 1, 1, 1, 1, 0, 0, 0)";
    $this->query($query);
    
    return $this->db->insert_id;
  }
  
  public function list_cats($selected) {
    $result = $this->query("SELECT * FROM {$this->table_prefix}kbcategories ORDER BY parentkbcategoryid ASC, title ASC");
    return parent::list_cats($result, $selected, 'kbcategoryid', 'title');
  }
  
  public function cleanup() {
    $this->query("UPDATE {$this->table_prefix}kbcategories SET totalarticles = totalarticles + {$this->total_demo_articles} WHERE kbcategoryid = $this->category");
    return true;
  }
  
  public function article_url($article_id, $demo) {
    $title = strtr(strtolower($demo->title), array(" " => "-", "'" => "", '"' => "", "/" => "", "(" => "", ")" => "", "," => "", "?" => "", "&" => "", "&amp;" => ""));
    return "index.php?/Knowledgebase/Article/View/$article_id/$demo->series_cat_id/$title";
  }
}
?>