<?php
class ImporterKayako extends Importer {
  protected $table_prefix = "sw";
  
  public function connect() {
    $this->config_path = $this->path . 'config/config.php';
    
    if (is_readable($this->config_path)) {
      require $this->config_path;
      $this->db = new MySQLi($_DB['hostname'], $_DB['username'], $_DB['password'], $_DB['name'], $_DB['port']);
      
      if (defined('TABLE_PREFIX')) {
        $this->table_prefix = TABLE_PREFIX;
      }
      
      $err = mysqli_connect_error();
      
      if ($err != NULL) {
        ImportErrors::handler("Could not connect to the MySQL server: $err");
      } else {
        $this->load_base_url();
      }
    } else {
      ImportErrors::handler("Kayako configuration file does not exist in specified path.");
    }
  }
  
  protected function load_base_url() {
    $result = $this->query("SELECT data FROM {$this->table_prefix}settings WHERE vkey = 'general_producturl'");
    $row = $result->fetch_array(MYSQLI_ASSOC);
    $this->base_url = $row['data'];
  }
  
  public function create_article($cat, $title, $article, $order = 0) {
    $cat = intval($cat);
    $title = $this->db->escape_string($title);
    $article = $this->db->escape_string($article);
    $order = intval($order);
    
    $query = "INSERT INTO {$this->table_prefix}kbarticles (subject, dateline, displayorder) VALUES('$title', UNIX_TIMESTAMP(), $order)";
    $this->query($query);
        
    $insert_id = $this->db->insert_id;
    
    $query = "INSERT INTO {$this->table_prefix}kbarticledata VALUES(NULL, $insert_id, '$article')";
    $this->query($query);
    
    $query = "INSERT INTO {$this->table_prefix}kbarticlelinks VALUES(NULL, $cat, $insert_id)";
    $this->query($query);
    
    return $insert_id;
  }
  
  public function update_article($id, $article) {
    $id = intval($id);
    $article = $this->db->escape_string($article);
    $query = "UPDATE {$this->table_prefix}kbarticledata SET contents = '$article' WHERE kbarticleid = $id";
    $this->query($query);
  }
  
  public function create_category($parent, $name, $description = "", $totalarticles = 0, $order = 0) {
    $name = $this->db->escape_string($name);
    $description = $this->db->escape_string($description);
    $totalarticles = intval($totalarticles);
    
    $query = "INSERT INTO {$this->table_prefix}kbcategories VALUES(NULL, $parent, 0, '$name', UNIX_TIMESTAMP(), $totalarticles, 'public', 0)";
    $this->query($query);
    
    $insert_id = $this->db->insert_id;
    
    $result = $this->all_tgroups();
    
    while ($row = $result->fetch_array()) {
      $this->query("INSERT INTO {$this->table_prefix}tgroupassigns VALUES(NULL, $insert_id, 5, $row[tgroupid])");
    }
    
    return $insert_id;
  }
  
  public function list_cats($selected) {
    $result = $this->query("SELECT * FROM {$this->table_prefix}kbcategories");    
    return parent::list_cats($result, $selected, 'kbcategoryid', 'title');
  }
  
  public function all_tgroups() {
    return $this->query("SELECT * FROM {$this->table_prefix}templategroups");
  }
  
  public function cleanup() {
    $this->query("UPDATE {$this->table_prefix}kbcategories SET totalarticles = totalarticles + {$this->total_demo_articles} WHERE kbcategoryid = $this->category");
    return true;
  }
  
  public function article_url($article_id, $demo) {
    return "index.php?_m=knowledgebase&amp;_a=viewarticle&amp;kbarticleid=$article_id";
  }
}
?>