<?php
abstract class Importer {
  public $db = NULL, $type = "", $mode = "", $formats = array(), $format_combine = "", $base_url = "";
  protected $path = "", $uri_to_viewer = "", $demo_path = "", $demo_uri = "";
  protected $category = "", $article_per = "", $demo_display = "", $demo_window = "", $demo_link_text = "";
  protected $demo_tpl = "", $colorbox_js = "";
  protected $total_demo_articles = 0;
  
  abstract public function connect();
  abstract public function create_article($cat, $title, $article, $order = 0);
  abstract public function create_category($parent, $name, $description = "", $totalarticles = 0, $order = 0);
  abstract public function cleanup();
  abstract public function article_url($article_id, $demo);
  
  abstract protected function load_base_url();
  
  public function __get($name) {
    return $this->$name;
  }
  
  public function __isset($name) {
    return isset($this->$name);
  }
  
  static public function from_post() {
    if (empty($_POST['path'])) {
      ImportErrors::handler("You must specify a path.");
    }
    
    if (empty(ImportErrors::$errors)) {
      if (empty($_POST['type'])) {
        ImportErrors::handler("Import type not specified.");
      } else {
        switch ($_POST['type']) {
          case "whmcs":
            $class = "ImporterWHMCS";
            break;
            
          case "kayako":
            $class = "ImporterKayako";
            break;
            
          case "kayako4":
            $class = "ImporterKayako4";
            break;
            
          case "wordpress":
            $class = "ImporterWordPress";
            break;
            
          case "joomla":
            $class = "ImporterJoomla";
            break;
            
          default:
            ImportErrors::handler("Specified import type not found.");
        }
      }
      
      if (isset($class)) {
        $obj = new $class($_POST);
        $obj->type = $_POST['type'];
        return $obj;
      }
    }
    
    return NULL;
  }
  
  public function __construct($arr) {
    if (!file_exists($arr['path'])) {
      ImportErrors::handler("The specified filesystem path does not exist.");
    } else {
      $this->path = path_trailing_slash($arr['path']);
      
      foreach (array("mode", "uri_to_viewer", "demo_path", "demo_uri", "category", "article_per", "demo_display", "demo_window", "demo_link_text", "article_author", "formats", "format_combine") as $v) {
        if (isset($arr[$v])) {
          $this->$v = $arr[$v];
        }
        
        if ($v == "uri_to_viewer" || $v == "demo_path" || $v == "demo_uri") {
          $this->$v = path_trailing_slash($this->$v);
        }
        
        if ($v == "category") {
          $this->$v = intval($this->$v);
        }
      }
      
      $this->connect();
    }
    
    $this->demo_tpl = file_get_contents("resources/importer/templates/demo.tpl");
    $colorbox_js = <<<JS
<link type="text/css" media="screen" rel="stylesheet" href="{$this->uri_to_viewer}js/colorbox.css" />
<script type="text/javascript" src="{$this->uri_to_viewer}js/jquery-1.5.2.min.js"></script>
<script type="text/javascript" src="{$this->uri_to_viewer}js/jquery.colorbox.js"></script>
<script type="text/javascript" src="{$this->uri_to_viewer}request.php?type=js"></script>
JS;
    $video_js = <<<JS
  <script type="text/javascript" src="{$this->uri_to_viewer}js/video.min.js"></script>
  <link href="{$this->uri_to_viewer}js/video-js.min.css" rel="stylesheet" type="text/css" />
  <script type="text/javascript"><!--
    _V_.options.flash.swf = "{$this->uri_to_viewer}js/video-js.swf";
  --></script>
JS;
    $this->switcher_js = <<<JS
<script type="text/javascript" src="{$this->uri_to_viewer}js/jquery-1.5.2.min.js"></script>
<script type="text/javascript" src="{$this->uri_to_viewer}js/dw-format-switcher.js"></script>
JS;
    $this->display_css = <<<CSS
<link href="{$this->uri_to_viewer}templates/dw-display-options.css" rel="stylesheet" type="text/css" />
CSS;
    $this->text_css = <<<CSS
<link href="{$this->uri_to_viewer}templates/dw-text-demos.css" rel="stylesheet" type="text/css" />
CSS;

    $this->colorbox = $this->target = $this->video_js = "";
    if ($this->demo_window == "colorbox") {
      $this->colorbox = $colorbox_js;
      $this->target = ' target="_blank"';
    } else if ($this->demo_window == "new") {
      $this->target = ' target="_blank"';
    }
    
    if (isset($this->formats['mp4'])) {
      $this->video_js = $video_js;
    }
  }
  
  public function list_cats($result, $selected, $id, $name, $root = 0) {
    $choose_text = ($this->type == 'wordpress' && $this->mode == 'pages') ? 'Choose a Page' : 'Choose a Category';
    $root_text = ($this->type == 'wordpress' && $this->mode == 'pages') ? 'No Parent' : 'Root Category';
    $str = "          <option value=\"-2\">$choose_text</option>\n";
    $str .= "          <option value=\"$root\">$root_text</option>\n";
    
    if (is_object($result) && $result->num_rows > 0) {
      while ($row = $result->fetch_array()) {
        $selected = "";
        if ($selected == $row[$id]) {
          $selected = ' selected="selected"';
        }
        
        $str .= "          <option value=\"$row[$id]\">$row[$name]</option>\n";
      }
    }
    
    return $str;
  }
  
  public function import($series, $order) {
    $demo_articles = array();
    $series_cat_id = 0;
    
    if ($this->article_per == "demo" || $this->article_per == "series_demo") {
      $series_cat_id = $this->create_series_category($series, count($series->demos), $order);
      
      $i = 1;
      foreach ($series->demos as $demo) {
        if (is_array($demo)) {
          $demo = DemoData::from_array($demo);
        }
        $demo->series = &$series;
        $demo->series_cat_id = $series_cat_id;
        $demo_articles[$demo->id] = $this->create_demo_articles($demo, $series_cat_id, $i);
        
        $count = count($demo_articles[$demo->id]);
        $i += $count;
        $this->total_demo_articles += $count;
      }
    }
    
    if ($this->article_per == "series" || $this->article_per == "series_demo") {
      $this->create_series_article($series, $demo_articles, $series_cat_id);
    }
  }
  
  public function create_series_article($series, $demo_articles, $series_cat_id) {
    global $req;
    
    $links = array();
    $formats = array_keys($this->formats);
    
    if (!empty($demo_articles)) {
      foreach ($demo_articles as $demo_id => $_formats) {
        foreach ($_formats as $format => $article_id) {
          $links[$demo_id][$format] = $this->article_url($article_id, $series->demos[$demo_id]);
        }
      }
      
      if ($this->format_combine == 'together') {
        $formats = array('all');
      }
    }
    
    $opt = new DisplayOptions($req->headers['display_options'], $req->headers['run_mode'], $req->headers['demo_path']);
    $list_demos = $opt->list_demos($series->demos, $this->uri_to_viewer, $series, $formats, $this->target, $links);
    $table = $list_demos[0];
    
    $colorbox = ($this->article_per == 'series') ? $this->colorbox : '';
    
    $article = <<<HTML
$colorbox
$this->video_js
$this->display_css
$this->text_css
<div class="dw-series-list" id="dw-series{$series->id}-list">
$table
</div>

HTML;
    
    if ($this->type == "wordpress" && $this->mode == "pages" && $series_cat_id != 0) {
      return $this->update_article($series_cat_id, $article);
    } else {
      return $this->create_article($this->category, $this->full_series_title($series), $article);
    }
  }
  
  public function create_series_category($series, $demo_count, $order = 0) {
    return $this->create_category($this->category, $this->full_series_title($series), "", $demo_count, $order);
  }
  
  public function full_series_title($series) {
    return isset($series->orig_title) ? $series->orig_title : $series->title;
    
    $info_string = "";
    
    if ($series->info_string != "") {
      $info_string = " ($series->info_string)";
    }
    
    return $series->title . $info_string;
  }
  
  public function create_demo_articles($demo, $series_cat_id, $order) {
    $article = "";
    $strings = $articles = array();
    $num_strings = 0;
    
    foreach ($this->formats as $format => $format_v) {
      if (stripos($demo->series->formats, $format) === false) {
        continue;
      }
      $strings[$format] = $this->create_demo_article_string($demo, $format);
      $num_strings++;
    }
    
    // Fall back to SWF if they didn't select a format the series is available in.
    if ($num_strings == 0 && stripos($demo->series->formats, 'swf') !== false) {
      $strings['swf'] = $this->create_demo_article_string($demo, 'swf');
      $num_strings = 1;
    }
    
    if ($num_strings > 1) {
      if ($this->format_combine == 'separate_crosslink' || $this->format_combine == 'separate') {
        $suffixes = array('swf' => ' [Flash Video]', 'mp4' => ' [MP4 Video]', 'text' => ' [Article]');
        
        foreach ($strings as $format => $string) {
          $strings[$format] = str_replace("{{demo}}", $strings[$format], $this->demo_tpl);
          $string = $this->display_css . "<div class=\"dw-series-list\" id=\"dw-series{$demo->series->id}-list\">" . $strings[$format] . '</div>';
          $articles[$format] = $this->create_article($series_cat_id, $demo->title . $suffixes[$format], $string, $order++);
        }
        
        if ($this->format_combine == 'separate_crosslink') {
          foreach ($articles as $format => $article_id) {
            $string = $this->create_format_crosslinks($demo, $articles) . $strings[$format];
            $this->update_article($article_id, $string);
          }
        }
      } else {
        // All formats together in one article; Create Format Switcher
        $article = $this->create_format_switcher();
      }
    }
    
    if ($num_strings == 1 || $this->format_combine == 'together') {
      $article .= $this->display_css;
      $article .= "<div class=\"dw-series-list\" id=\"dw-series{$demo->series->id}-list\">";
      
      foreach ($strings as $string) {
        $article .= $string;
      }
      
      $article .= '</div>';
      
      $article = str_replace("{{demo}}", $article, $this->demo_tpl);
      $articles['all'] = $this->create_article($series_cat_id, $demo->title, $article, $order++);
    }
    
    return $articles;
  }
  
  public function create_demo_article_string($demo, $format = 'swf', $force_inline = false, $autoplay = false) {
    if ($format == 'text') {
      $path = "{$this->demo_path}html/{$demo->series->path}/" . str_replace('.swf', '.html', $demo->path);
      
      if (!file_exists($path)) {
        return false;
      }
      
      $html = file_get_contents($path);

	    if (preg_match("#<div( id=\"demo\")? class=\"dw-text\">(.*)</div>#s", $html, $matches)) {
		    $html = $matches[2];
	    }
      
      $html = preg_replace(array("#<h1>[^<]*</h1>#", "#<h2>[^<]*</h2>#"), "", $html);
      $html = str_replace("../../", $this->demo_uri, $html);
      
      $article = <<<HTML
$this->text_css
<div id="dw-demo-text" class="dw-text dw-demo-text">
$html
</div>
HTML;
    } else {
      if ($this->demo_display == "inline" || $force_inline) {
        if ($format == 'mp4') {
          $path = "{$this->demo_uri}mp4/{$demo->series->path}/" . str_replace('.swf', '.mp4', $demo->path);
        } else if ($demo->series->purchased && !$demo->series->swf_from_subscr) {
          $path = "{$this->demo_uri}{$demo->series->path}/{$demo->path}";
        } else {
          $path = "{$this->uri_to_viewer}request.php?type=demo&amp;id={$demo->id}";
        }
        
        if ($format == 'mp4') {
          $article = $this->video_js . createMP4Object($demo->width, $demo->height, $path, "dw-demo-mp4", $autoplay);
        } else {
          $article = createFlashObject($demo->width, $demo->height, $path, "{$this->uri_to_viewer}js/ieupdate.js", false, NULL, "dw-demo-swf");
        }
      } else if ($this->demo_display == "play" || $this->demo_display == "link") {
        $path = "{$this->uri_to_viewer}demo.php?id={$demo->id}&amp;series={$demo->series->id}&amp;format=$format";
        
        if ($this->demo_display == "play") {
          $image_src = $this->get_image_src();
          $link = <<<HTML
<img src="$image_src" alt="{$this->demo_link_text}" style="border: 0;" />
HTML;
        } else {
          $link = $this->demo_link_text;
        }
        
        $format_str = ($format == 'swf') ? '' : "-$format";
        
        $article = <<<HTML
$this->video_js
$this->colorbox
  <div id="dw-demo-$format" class="dw-demo-$format">
    <h3><a href="$path"{$this->target} id="dw-demo{$demo->id}-link$format_str">$link</a></h3>
  </div>

HTML;
        
        if ($this->format_combine != 'together') {
          $article = <<<HTML
<div class="dw-series-list" id="dw-series{$demo->series->id}-list">
$article
</div>
HTML;
        }
      }
    }
    
    return $article;
  }
  
  public function create_format_switcher($demo = NULL, $articles = array()) {
    $str = $display_none = '';
    
    if (empty($articles)) {
      $str = $this->switcher_js;
      $display_none = ' display: none;';
    }
    
    $str .= '<div id="dw-format-switcher" class="dw-format-switcher" style="margin: 10px 0;' . $display_none . '">';
    
    $explicit_video_format = false;
    
    if (isset($this->formats['swf']) && isset($this->formats['mp4'])) {
      $explicit_video_format = true;
    }
    
    $i = 0;
    $last = count($this->formats) - 1;
    
    foreach ($this->formats as $format => $format_v) {
      $title = $href = $id = '';
      
      if ($format == 'text') {
        $title = '[Read Article]';
      } else if ($format == 'mp4') {
        $title = $explicit_video_format ? '[Watch MP4 Video]' : '[Watch Video]';
      } else {
        $title = $explicit_video_format ? '[Watch Flash Video]' : '[Watch Video]';
      }
      
      if (!empty($articles[$format])) {
        $href = $this->article_url($articles[$format], $demo);
      } else {
        $href = 'javascript:void(0);';
        $id = " data-target-class=\".dw-demo-$format\"";
      }
      
      $str .= <<<HTML
<a href="$href"$id>$title</a>
HTML;
      
      if ($i++ < $last) {
         $str .= ' &bull; ';
      }
    }
    
    return $str . '</div>';
  }
  
  public function create_format_crosslinks($demo, $articles) {
    return $this->create_format_switcher($demo, $articles);
  }
  
  public function query($query) {
    if (!is_object($this->db)) {
      die("Could not execute query.");
    } else {
      $result = $this->db->query($query);
      
      if (!empty($this->db->error)) {
        die("MySQL Error: {$this->db->error}");
      }
      
      return $result;      
    }
  }
  
  protected function get_image_src() {
    return $this->uri_to_viewer . 'templates/play.png';
  }
}
?>