<?php
require_once "includes/base.php";

get_empty_if_not_isset('type', 'id');

if (!isset($path_to_dw)) {
  $path_to_dw = "";
}

if (!isset($uri_to_dw)) {
  $uri_to_dw = $path_to_dw;
}

$req = new Request($_CONF, $_GET['type'], $path_to_dw);

if ($req->ok) {
  // Attempt to detect and fix any incorrect Run Mode settings.
  
  $integration_detected = defined('DEMOWOLF_INTEGRATION');
  $whmcs_detected = defined('CLIENTAREA');
  $kayako_detected = defined('SWIFT_AREA') || defined('USE_KAYAKO4_SERIES_LINKS');
  $wp_detected = defined('WPINC');
  
  $mode = &$req->headers['run_mode'];
  
  if ($mode == 'standalone') {
    if ($whmcs_detected) {
      $mode = 'whmcs';
    } else if ($kayako_detected) {
      $mode = 'kayako';
    } else if ($wp_detected) {
      $mode = 'wordpress';
    } else if ($integration_detected) {
      $mode = 'php';
    }
  }
  
  if (!$integration_detected) {
    if ($mode == 'whmcs' && !$whmcs_detected) {
      $mode = 'standalone';
    } else if ($mode == 'kayako' && !$kayako_detected) {
      $mode = 'standalone';
    } else if ($mode == 'wordpress' && !$wp_detected) {
      $mode = 'standalone';
    }
  }
}
?>