var search_href = window.location.href;

function processQuery(query) {
  query = trim(query);
  
  if (query.length < 2) {
    // Don't start working until 2 characters have been typed.
    query = "";
  }
  
  if (typeof processQuery.lastQuery != 'undefined' && processQuery.lastQuery == query) {
    return false; // Don't re-send the same query.
  }
  
  if (typeof demowolfSearchPreProcess !== 'undefined') {
    demowolfSearchPreProcess();
  }
  
  jQuery.get(search_href, { q: query, ajax: 1 }, function(data) {
    if (typeof data.s_visibility != 'undefined' && typeof data.d_visibility != 'undefined') {
      // Reset the accordion elements.
      if (typeof accordionOptions != 'undefined') {
        jQuery("#all-dw-series").find('[id$=-link]').parents('h3').show().end().find('[id$=-list]').show();
      }
    
      for (var k in data.s_visibility) {
        var h3 = jQuery(k + "-link").parents('h3');
        var list = jQuery(k + "-list");
        var accordion = false;
        
        if (h3.hasClass('ui-accordion-header')) {
          if (!data.s_visibility[k]) {
            h3.hide();
            list.hide();
          }
        } else {
          if (data.s_visibility[k]) {
            h3.fadeIn().slideDown();
            list.fadeIn().slideDown();
          } else {
            if ($(h3).is(':hidden')) {
              h3.hide(); // In case the parent is what's actually hidden.
            } else {
              h3.fadeOut().slideUp();
            }
            if ($(list).is(':hidden')) {
              list.hide(); // In case the parent is what's actually hidden.
            } else {
              list.fadeOut().slideUp();
            }
          }
        }
        
        if (typeof data.d_visibility[k] != 'undefined') {
          for (var d in data.d_visibility[k]) {
            var d_elem = jQuery(d + ', ' + d + '-text, ' + d + '-mp4').first().parents('li,tr');
            if (data.d_visibility[k][d]) {
              d_elem.show();
            } else {
              d_elem.hide();
            }
          }
        }
      }
      
      // Rebuild the accordion.
      if (typeof accordionOptions != 'undefined') {
        accordionOptions.active = false;
        jQuery("#all-dw-series").accordion('destroy').accordion(accordionOptions).accordion('activate', false);
      }
    }
    
    if (typeof demowolfSearchPostProcess !== 'undefined') {
      setTimeout(function() {
        demowolfSearchPostProcess();
      }, 1000);
    }
  }, "json");
  
  // Place the query in the query strings of all the series links
  jQuery("a[id^=dw-series]").each(function() {
    var href = jQuery(this).attr('href');
    
    if (href.indexOf(processQuery.lastQuery) != -1) {
      href = href.replace('q=' + processQuery.lastQuery, 'q=' + query);
    } else {
      if (href.indexOf('?') == -1) {
        href += '?';
      } else {
        href += '&';
      }
      href += "q=" + query;
    }
    
    jQuery(this).attr('href', href);
  });
  
  processQuery.lastQuery = query;
}

// From phpjs.org
function trim(str, charlist) {
  var whitespace, l = 0, i = 0;
  str += '';
  
  if (!charlist) {
      // default list
      whitespace = " \n\r\t\f\x0b\xa0\u2000\u2001\u2002\u2003\u2004\u2005\u2006\u2007\u2008\u2009\u200a\u200b\u2028\u2029\u3000";
  } else {
      // preg_quote custom list
      charlist += '';
      whitespace = charlist.replace(/([\[\]\(\)\.\?\/\*\{\}\+$\^\:])/g, '$1');
  }
  
  l = str.length;
  for (i = 0; i < l; i++) {
      if (whitespace.indexOf(str.charAt(i)) === -1) {
          str = str.substring(i);
          break;
      }
  }
  
  l = str.length;
  for (i = l - 1; i >= 0; i--) {
      if (whitespace.indexOf(str.charAt(i)) === -1) {
          str = str.substring(0, i + 1);
          break;
      }
  }
  
  return whitespace.indexOf(str.charAt(0)) === -1 ? str : '';
}

jQuery(function() {
  jQuery("#dw-series289-list a[id^='dw-']:not([id$='-text',id$='-mp4'])").attr('title', "cPanel 11.30 x3 (2011) end-user series").attr('rel', 'dw-series289-list');
  jQuery("#dw-series289-list a[id^='dw-'][id$='-text']").attr('title', "cPanel 11.30 x3 (2011) end-user series").attr('rel', 'dw-series289-list-text');
  jQuery("#dw-series289-list a[id^='dw-'][id$='-mp4']").attr('title', "cPanel 11.30 x3 (2011) end-user series").attr('rel', 'dw-series289-list-mp4');
  jQuery("#dw-series298-list a[id^='dw-']:not([id$='-text',id$='-mp4'])").attr('title', "cPanel 11.30 x3 (2011) end-user series (VOICE)").attr('rel', 'dw-series298-list');
  jQuery("#dw-series298-list a[id^='dw-'][id$='-text']").attr('title', "cPanel 11.30 x3 (2011) end-user series (VOICE)").attr('rel', 'dw-series298-list-text');
  jQuery("#dw-series298-list a[id^='dw-'][id$='-mp4']").attr('title', "cPanel 11.30 x3 (2011) end-user series (VOICE)").attr('rel', 'dw-series298-list-mp4');
  if (typeof jQuery.fn.accordion !== 'undefined') {
    accordionOptions = {
      collapsible: true,
      autoHeight: false,
      icons: {
        header: "ui-icon-circle-arrow-e",
        headerSelected: "ui-icon-circle-arrow-s"
      }
    };
    jQuery("#all-dw-series").accordion(accordionOptions);
  }
  
  searching = null;
  
  jQuery("#search_query").change(function() {
    processQuery(jQuery(this).val());
  }).keyup(function() {
    var elem = this;
    clearTimeout(searching);
    searching = setTimeout(function() {
      jQuery(elem).change();
    }, 500);
  });
  
  jQuery("#dw-search").find("input[value='Search']").click(function() {
    jQuery("#search_query").change();
    return false;
  }).end().find("input[name='reset']").click(function() {
    jQuery("#search_query").val('').change();
    return false;
  });

  jQuery("#dw-series289-list a[id^='dw-']:not([id$='-text',id$='-mp4'])").colorbox({fragment: "#demo", innerWidth:889, innerHeight: 524});
  jQuery("#dw-series289-list a[id^='dw-'][id$='-text']").colorbox({fragment: "#demo", innerWidth:961, innerHeight: 624});
  jQuery("#dw-series289-list a[id^='dw-'][id$='-mp4']").colorbox({fragment: "#demo", innerWidth:889, innerHeight: 504});
  jQuery("#dw-series298-list a[id^='dw-']:not([id$='-text',id$='-mp4'])").colorbox({fragment: "#demo", innerWidth:889, innerHeight: 524});
  jQuery("#dw-series298-list a[id^='dw-'][id$='-text']").colorbox({fragment: "#demo", innerWidth:961, innerHeight: 624});
  jQuery("#dw-series298-list a[id^='dw-'][id$='-mp4']").colorbox({fragment: "#demo", innerWidth:889, innerHeight: 504});

});