<?php
if (!function_exists('get_empty_if_not_isset')) {
function get_empty_if_not_isset() {
  $args = func_get_args();
  foreach ($args as $arg) {
    if (!isset($_GET[$arg])) {
      $_GET[$arg] = "";
    }
  }
}

// Obtain any Proxy IP addresses of the currently-browsing user.
function obtain_proxy_ips() {
  $keys = array('HTTP_CLIENT_IP', 'HTTP_X_FORWARDED_FOR', 'HTTP_X_FORWARDED',
                        'HTTP_FORWARDED_FOR', 'HTTP_FORWARDED');
  
  $str = "";
  $arr = array();
  
  foreach ($keys as $key) {
    if (isset($_SERVER[$key])) {
      $arr[] = $_SERVER[$key];
    }
  }
  
  if (count($arr) > 0) {
    $str = implode(",", $arr);
  }
  
  return $str;
}
  
function createFlashObject($width, $height, $url, $ieupdate = "ieupdate.js", $show_header = false, $bgcolor = NULL, $div_id = "demo") {
  if ($width == 0 || $height == 0) {
    $width = 776;
    $height = 450;
  }
  $height += 20; // The controls bar is 20px high.
  
  if (!$bgcolor) {
    $bgcolor = '#FFFFFF';
  }
  
  $header = "";
  
  if ($show_header) {
    $header_width = $width - 2;
    $header = <<<HTML

    <div class="dw-info-header" style="width: {$header_width}px;">
      <div class="dw-info-header-title">Powered by <a href="http://www.demowolf.com/" target="_blank">DemoWolf.com</a> - Support Tutorials for Hosting Companies</div>
      <div class="dw-info-header-sub">&bull; Flash Tutorials for Hosting Companies &nbsp;&bull; Custom Branded for your company &nbsp;&bull; Custom tutorials also available</diV>
    </div>
HTML;
  }
  
  if (use_secure()) {
    $http = "https://";
  } else {
    $http = "http://";
  }
  
  $html = <<<HTML
  <div id="$div_id" class="$div_id" style="text-align: center;">$header
    <object classid="clsid:D27CDB6E-AE6D-11cf-96B8-444553540000" codebase="{$http}fpdownload.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=8,0,0,0" width="$width" height="$height" id="movie">
      <param name="movie" value="$url" />
      <param name="quality" value="high" />
      <param name="bgcolor" value="$bgcolor" />
      <param name="wmode" value="opaque" />
      <embed src="$url" quality="high" bgcolor="$bgcolor" width="$width" height="$height" name="movie" type="application/x-shockwave-flash" pluginspage="http://get.adobe.com/flashplayer/" wmode="opaque"></embed>
    </object>
    <script type="text/javascript" src="$ieupdate"></script>
  </div>
HTML;
  return $html;
}
  
function createMP4Object($width, $height, $url, $div_id = "demo", $autoplay = true) {
  $autoplay = $autoplay ? ' autoplay="autoplay"' : '';
  
  if ($width == 0 || $height == 0) {
    $width = 776;
    $height = 450;
  }
  
  if (use_secure()) {
    $http = "https://";
  } else {
    $http = "http://";
  }
  
  // Will break in IE9 if not an absolute URL:
  if (substr($url, 0, 1) == '/') {
    $url = $http . $_SERVER['SERVER_NAME'] . $url;
  }
  
  $html = <<<HTML
  <div id="$div_id" class="$div_id">
    <video id="demo-video" width="$width" height="$height"$autoplay preload="auto" controls="controls" class="video-js vjs-default-skin" data-setup="{}" data-src="$url" style="margin: 0 auto;">
      <source src="$url" type="video/mp4" />
    </video>
  </div>
HTML;
  return $html;
}
  
function use_secure() {
  return (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] != 'off');
}

	function __show_404() {
		header('HTTP/1.0 404 Not Found');
		echo "<h1>404 Not Found</h1>This tutorial could not be found.";
		die;
	}
}
?>