<?php
/*
 * This file allows you to reorder the series and demos, show/hide them, override their titles,
 * as well as inject text between certain series & demos.
 * 
 * You will need the numeric ID of the demo or series you'd like to affect. The easiest
 * way to find a demo or series ID is to hover over its link and look in the URL. You will
 * see something similar to these examples:
 * 
 * http://www.yourdomain.com/viewer/tutorials.php?series=39
 * http://www.yourdomain.com/viewer/demo.php?id=710&series=39
 * 
 * Series IDs show up as series=XX, demo IDs show up as id=XX.
 * 
 * --
 * 
 * So, if you want to hide series #39 and #40, you would put:
 * 
 * $hide_series = array(39, 40);
 * 
 * --
 * 
 * Hiding demos works the same way:
 * 
 * $hide_demos = array(710, 715, 302, 333);
 * 
 * --
 * 
 * To show ONLY certain series/demos:
 * 
 * $show_series = array(39, 40);
 * 
 * $show_demos = array(710, 715, 302, 333);
 * 
 * --
 * 
 * To change the order of series and demos, you will need to list all of the IDs in the order you want:
 * 
 * $sort_series = array(180, 152, 182);
 * $sort_demos[152] = array(2446, 2447, 2448, 2449, 2450, 2451, 2452, 2453, 2454, 2455, 2456, 2457, 2458, 2459, 2460, 2461, 2462);
 * 
 * --
 * 
 * To change the titles of certain series/demos, use $series_titles and $demo_titles:
 * 
 * $series_titles = array(
 *  39 => "Configuring Email series OVERRIDDEN",
 *  40 => "Example Series"
 * );
 * 
 * --
 * 
 * To insert arbitrary text AFTER a series or demo, put it in $text_after_series / $text_after_demo:
 * 
 * $text_after_series = array(
 *   39 => "<b>This can be random HTML</b>, a list of custom tutorials, or whatever else you want.",
 * );
 * 
 * --
 * 
 * The variables $text_before_series and $text_before_demo work exactly the same way:
 * 
 * $text_before_series = array(
 *   40 => "This will show up after Series 39 but before Series 40."
 * );
 */
?>