<?php
if (!class_exists('SeriesData')) {
class SeriesData {
  public $id, $title, $orig_title, $demo_count, $info_string, $path, $base_id, $assoc, $group_id, $is_voice, $lang, $has_voice, $has_lang, $formats;
  public $visible = true, $swf_from_subscr = false, $purchased = false;
  
  public function __construct($id = 0, $title = "", $demo_count = "", $info_string = "", $path = "", $base_id = 0, $assoc = array(), $group_id = 0,
                                         $is_voice = false, $lang = "", $has_voice = false, $has_lang = false, $formats = 'swf') {
    $this->id = $id;
    $this->title = stripslashes($title);
    $this->demo_count = $demo_count;
    $this->info_string = $info_string;
    $this->path = $path;
    $this->base_id = $base_id;
    $this->assoc = $assoc;
    $this->group_id = $group_id;
    $this->is_voice = !!$is_voice;
    $this->lang = $lang;
    $this->has_voice = !!$has_voice;
    $this->has_lang = !!$has_lang;
    $this->formats = !empty($formats) ? $formats : 'swf';
  }
  
  public static function from_array($arr) {
    return new self ($arr['id'], $arr['title'], $arr['demo_count'], $arr['info_string'], $arr['path'], $arr['base_id'], $arr['assoc'], $arr['group_id'],
                            $arr['is_voice'], $arr['lang'], $arr['has_voice'], $arr['has_lang'], @$arr['formats']);
  }
  
  public static function normalize(&$series) {
    global $p_series;
    
    foreach ($series as $i => &$s) {
      if (is_array($s)) {
        $s = SeriesData::from_array($s);
      }
      
      if (isset($GLOBALS['hide_series'][$s->id]) || (isset($GLOBALS['show_series']) && !isset($GLOBALS['show_series'][$s->id]))) {
        $s->visible = false;
      }
      
      if (!empty($s->info_string)) {
        $s->info_string .= ", ";
      }
      
      $s->orig_title = $s->title;
      $s->title = "$s->title ($s->info_string$s->demo_count demos)";
      
      if (isset($GLOBALS['series_titles'][$s->id])) {
        $s->title = $GLOBALS['series_titles'][$s->id];
      }
      
      if (isset($p_series[$s->id])) {
        $s->purchased = true;
      } else {
        $s->purchased = false;
      }
    }
  }
  
  public function has_format($format) {
    return stripos($this->formats, $format) !== false;
  }
  
  public function add_format($format, $source = 'subscription') {
    $exp = explode(',', $this->formats);
    $exp[] = $format;
    $this->formats = implode(',', $exp);
    
    if ($format == 'swf' && $source == 'subscription') {
      $this->swf_from_subscr = true;
    }
  }
}
}
?>