<?php
class DWSearch {
  public $enabled, $query;
  private $words, $series, $demos;
  private $relevant_series, $relevant_demos;
  private $mode = 'standard';
	public static $query_key = 'q';
  
  private static $STOP_WORDS = array(
    'a', 'an', 'and', 'become', 'becoming', 'by', 'for', 'how', 'in', 'is', 'or', 'some', 'the', 'to', 'use', 'using', 'what', 'you', 'your',
    'series', 'demo', 'demos'
  );
  
  public function __construct($enabled, &$series, &$demos) {
    $this->enabled = $enabled;
    
    if (isset($_REQUEST['reset'])) {
      unset($_REQUEST[self::$query_key]);
      $this->query = "";
    } else {
      $this->query = isset($_REQUEST[self::$query_key]) ? trim($_REQUEST[self::$query_key]) : '';
      $this->words = explode(" ", $this->query);
      $this->series = &$series;
      $this->demos = &$demos;
      
      if (isset($_REQUEST['ajax']) && $_REQUEST['ajax'] == 1) {
        $this->mode = 'ajax';
      }
      
      if ($this->enabled && !empty($this->query)) {
        $this->filter();
      }
      
      if ($this->mode == 'ajax') {
        $this->json();
        die;
      }
    }
  }
  
  private function filter() {
    $all_words = $this->words; // Back up $this->words since we may be removing some words.
    
    // First determine the relevancy of each series and demo
    foreach ($this->series as $i => $s) {
      // Display all demos for this series if we have a match on the series title.
      $relevancy = $this->seriesRelevancy($s);
      
      $s->max_d_relevancy = $d_matches = 0;
      $s->different_matches = false;
      
      if (isset($this->demos[$s->id]))
      foreach ($this->demos[$s->id] as $j => $d) {
        $d_relevancy = $this->demoRelevancy($d);
        $this->relevant_demos[$s->id][$d_relevancy][] = $d;
        
        if ($d_relevancy > 0) {
          $d_matches++;
          $s->max_d_relevancy = max($s->max_d_relevancy, $d_relevancy);
          $s->different_matches = $s->different_matches || ($s->matches != $d->matches);
        }
      }
      
      // Sort the demos by relevancy.
      ksort($this->relevant_demos[$s->id]);
      
      // A series is more relevant if it has any relevant demos. 
      if ($d_matches > 0) {
        $relevancy++;
      }
      
      $this->relevant_series[$relevancy][] = $s;
      $this->words = $all_words; // Revert any changes made to the word list
    }
    
    ksort($this->relevant_series);
    
    // Hide all but the most relevant results.
    $r = 0;
    $count = count($this->relevant_series);
    
    foreach ($this->relevant_series as $relevancy => $series) {
      foreach ($series as $i => $s) {
        if ($r < $count - 1 || $relevancy == 0) {
          $s->visible = false;
        }
        
        $d_r = 0;
        $d_count = count($this->relevant_demos[$s->id]);
        
        // Don't hide demos unless there are some that match more (or different) words than the series.
        if ($s->max_d_relevancy > $relevancy || $s->different_matches)
        foreach ($this->relevant_demos[$s->id] as $d_relevancy => $demos) {
          foreach ($demos as $j => $d) {
            if ($d_r  < $d_count - 1) {
              $d->visible = false;
            }
          }
          
          $d_r++;
        }
      }
      
      $r++;
    }
  }
  
  // Output a JSON object containing the 
  private function json() {
    $s_visibility = $d_visibility = array();
    
    foreach ($this->series as $s) {
      $s_visibility["#dw-series{$s->id}"] = $s->visible;
      
      foreach ($this->demos[$s->id] as $d) {
        $d_visibility["#dw-series{$s->id}"]["#dw-demo{$d->id}-link"] = $d->visible;
      }
    }
    
    echo json_encode(compact('s_visibility', 'd_visibility'));
  }
  
  private function seriesRelevancy($s) {
    list($words_matched, $matches) = $this->match($s->title, true);
    $s->matches = $matches;
    return $words_matched;
  }
  
  private function demoRelevancy($d) {
    list($words_matched, $matches) = $this->match($d->title);
    $d->matches = $matches;
    return $words_matched;
  }
  
  // $remove_matches removes the word from $this->words upon matching. Used to prevent words in the series titles
  // from bringing up a bunch of less-relevant tutorials. 
  private function match($str, $remove_matches = false) {
    $words_matched = 0;
    $matches = array();
    $str_words = explode(" ", $str);
    $count_str_words = count($str_words);
    
    foreach ($this->words as $i => $word) {
      $word = strtolower($word);
      foreach (self::$STOP_WORDS as $stop_word) {
        if ($word == $stop_word) {
          continue(2);
        }
      }
      
      foreach ($str_words as $str_word) {
        $str_word = strtolower($str_word);
        
        // In order for this to be a match, the words either need to be very similar or the search $word needs to be fairly long.
        if ($this->matchWords($word, $str_word)) {
          if ($word == 'cpanel' && $str_word == 'panel') {
            continue; // Don't bring up Plesk if they're searching for cPanel
          }
          
          $words_matched++;
          $matches[] = $word;
          
          if ($remove_matches) {
            unset($this->words[$i]);
          }
        }
      }
    }
    
    return array($words_matched, $matches);
  }
  
  private function matchWords($needle, $haystack) {
    return stripos($haystack, $needle) !== false;
    
    /*if ($this->mode == 'ajax') {
      return stripos($haystack, $needle) !== false;
    } else {
      similar_text($haystack, $needle, $similarity);
      return $similarity > 90 || (strlen($needle) >= 4 && stripos($haystack, $needle) !== false);
    }*/
  }
}
?>