<?php
if (!class_exists('Request')) {
class Request {
  public $headers = array('demo_path' => ''), $response = "", $ok = false;
  private $verification_key = "", $access_key = "", $type = "", $_CONF = array();
  private $params = "", $servers = array(), $server_count = 0;
  private $header_delim = "__END_HEADER__", $mimetype = "";
  private $found_header_delim = false, $header_str = "";
  private $to_cache = array("css", "js", "series_demos"), $use_caching = false, $using_cache = false;
  private $cache_time = 0, $cache_time_file = "", $cache_file = "", $cache_str = "", $cache_expires;
  private $base_path = "";
  
  public function __construct($_CONF, $type, $base_path) {
    $this->_CONF = &$_CONF;
    $this->type = $type;
    $this->base_path = $base_path;
    
    if (isset($_CONF['access_key'])) {
      $this->verification_key = $_CONF['verification_key'];
      $this->access_key = $_CONF['access_key'];
      $this->servers = &$_CONF['servers'];
      $this->server_count = count($this->servers);
      
      $this->to_cache = array_combine($this->to_cache, $this->to_cache);
      
      $this->cache_expires = 3600; // Default to 60 minutes.
  
      if (isset($_GET['verify']) && $_GET['verify'] == $this->verification_key) {
        if ($_GET['type'] == 'clear_cache') {
          $this->clear_cache();
        }
      } else {
        $this->set_up();
        
        if ($this->use_caching && $this->load_cache_time()) {
          $fh = $this->load_from_cache();
        }
        
        if (!$this->using_cache) {
          $fh = $this->connect();
        }
        
        if ($this->connected($fh)) {
          if (!$this->found_header_delim) {
            die($this->header_str . $this->response);
          }
          
          if (!$this->ok) {
            die;
          }
          
          if ($this->use_caching && !$this->using_cache) {
            $this->write_cache();
            $this->write_cache_time();
          }
          
          if ($this->type == "export_data") {
            $this->import_data();
          }
        } else {
          echo "Could not connect.";
        }
      }
    } else {
      $this->ok = true;
      $this->headers['display_options'] = $_CONF['display_options'];
      $this->headers['run_mode'] = $_CONF['run_mode'];
      $this->headers['demo_path'] = $_CONF['demo_path'];
      $this->headers['status'] = 'OK';
      $this->headers['show_header'] = false;
      $this->headers['series'] = $this->headers['demos'] = $this->headers['groups'] = array(); // Anything in purchased_demos.php will already be loaded by tutorials.php
      
      if ($this->type == 'js') {
        if (file_exists("js/dw-display-options.js")) {
          $this->mimetype = "text/javascript";
          echo file_get_contents("js/dw-display-options.js");
        } else if (file_exists("{$this->base_path}js/dw-display-options.js")) {
          $this->mimetype = "text/javascript";
          echo file_get_contents("{$this->base_path}js/dw-display-options.js");
        }
      }
    }
  }
  
  private function connected(&$fh) {
    if (!is_object($fh)) {
      if ($fh !== false) {
        $this->read_response($fh);
        fclose($fh);
        return true;
      }
    } else {
      $fh->close();
      return $fh->exec;
    }
    
    return false;
  }
  
  private function load_cache_time() {
    $this->cache_time_file = "{$this->base_path}cache/{$this->type}.time";
    if (file_exists($this->cache_time_file)) {
      $this->cache_time = file_get_contents($this->cache_time_file);
      
      if (($this->cache_time + $this->cache_expires) < time()) {
        $this->clear_cache();        
        return false;
      } else {
        return true;
      }
    } else {
      return false;
    }
  }
  
  private function write_cache_time() {
    file_put_contents($this->cache_time_file, time());
  }
  
  private function load_from_cache() {
    $fh = false;
    
    if ($this->cache_time > 0) {
      $this->cache_file = "{$this->base_path}cache/$this->type";
      
      if (file_exists($this->cache_file)) {
        $fh = fopen($this->cache_file, "rb");
        
        if ($fh !== false) {
          $this->using_cache = true;
        }
      }
    }
    
    return $fh;
  }
  
  private function write_cache() {
    file_put_contents("{$this->base_path}cache/$this->type", $this->cache_str);
  }
  
  private function clear_cache() {
    foreach ($this->to_cache as $entry) {
      $file = "{$this->base_path}cache/$entry";
      $time_file = "{$this->base_path}cache/{$entry}.time";
      if (file_exists($file)) {
        unlink($file);
      }
      if (file_exists($time_file)) {
        unlink($time_file);
      }
    }
  }
  
  private function set_up() {
    switch ($this->type) {
      case "demo":
        $this->params .= "&id=$_GET[id]";
        $this->mimetype = "application/x-shockwave-flash";
        break;
        
      case "demo_info":
      case "series":
        $this->params .= "&id=$_GET[id]";
        break;
        
      case "css":
        $this->mimetype = "text/css";
        break;
        
      case "js":
        $this->mimetype = "text/javascript";
        break;
        
      case "export_data":
        break;
        
      case "series_demos":
      default:
        $this->type = "series_demos";
        break;
    }
    
    if (isset($this->to_cache[$this->type])) {
      $this->use_caching = true;
    }
  }
  
  private function connect() {
    $proxy_ips = urlencode(obtain_proxy_ips());
    $remote_addr = urlencode($_SERVER['REMOTE_ADDR']);
    $domain = !empty($_SERVER['HTTP_HOST']) ? $_SERVER['HTTP_HOST'] : $_SERVER['SERVER_NAME'];
    
    if (use_secure()) {
      $http = "https://";
    } else {
      $http = "http://";
    }
    $request_php_url = urlencode($http . $domain . dirname($_SERVER['REQUEST_URI']) . "/request.php");
    
    $domain = urlencode($domain);
    
    $params = "?access=$this->access_key&type=$this->type&proxy_ips=$proxy_ips&remote_addr=$remote_addr&domain=$domain&request_php_url=$request_php_url" . $this->params;
    
    $use_curl = function_exists("curl_exec");
    
    $fh = false;
    for ($i = 0; $i < $this->server_count; $i++) {
      $server = &$this->servers[$i];
      if (is_array($this->servers[$i])) {
        $url = $server['url'];
        
        if ($server['down'] && time() - $server['last_attempt'] < 7200 && $i < $this->server_count - 1) {
          continue;
        }
      } else {
        $url = $server;
      }
      $url .= $params;
      
      if ($use_curl) {
        $c = new cURL($url);
        $c->setopt_array(array(
          'CONNECTTIMEOUT' => 15,
          'FAILONERROR' => true,
          'WRITEFUNCTION' => array($this, 'curl_callback')
        ));
        $success = ($c->exec() !== false);
        $fh = &$c;
      } else {
        $ctx = stream_context_create(array('http' => array('timeout' => 15)));
        $fh = @fopen($url, "rb", false, $ctx);
        $success = ($fh !== false);
      }
      
      if ($success) {
        $this->update_server($i, false);
        break;
      } else {
        $this->update_server($i, true);
      }
    }
    
    $this->update_conf();
    
    return $fh;
  }
  
  public function curl_callback($ch, $str) {
    $this->parse_response($str);
    
    if (function_exists('mb_strlen')) {
      $bytes = mb_strlen($str);
    } else {
      $bytes = strlen($str);
    }
    
    return $bytes;
  }
  
  private function read_response($fh) {
    while (!feof($fh)) {
      $str = fread($fh, 8192);
      $this->parse_response($str);
    }
  }
  
  private function parse_response($str) {
    if (!$this->using_cache) {
      $this->cache_str .= str_replace("|verify={$this->verification_key}", "", $str);
    }
    
    if (!$this->found_header_delim) {
      $this->header_str .= $str;
      $str = "";
      
      if (strpos($this->header_str, $this->header_delim) !== false) {
        $this->found_header_delim = true;
        
        $arr = explode($this->header_delim, $this->header_str, 2);
        $this->header_str = $arr[0];
        $str = $arr[1];
        
        $this->parse_headers($this->header_str);
        
        if ($this->using_cache) {
          $this->ok = true;
        } else {
          $this->check_status();
        }
        
        if ($this->mimetype != "") {
          header("Content-Type: $this->mimetype");
        }
      }
    }
    $this->response .= $str;
    
    if ($this->mimetype != "") {
      echo $str;
    }
  }
  
  private function parse_headers($str) {
    $arr = explode("|", $str);
    
    foreach ($arr as $arr2) {
      list($k, $v) = explode("=", $arr2);
      if (strpos($k, "_json") !== false) {
        $k = str_replace("_json", "", $k);
        $v = json_decode($v, true);
      }
      $this->headers[$k] = $v;
    }
  }
  
  private function check_status() {
    if (!isset($this->headers['verify']) || $this->headers['verify'] != $this->verification_key) {
      die("Verification failed.");
    } else if ($this->headers['status'] != 'OK' && $this->headers['status'] != 'Expired') {
      die($this->headers['status']);
    } else {
      $this->ok = true;
    }
  }
  
  private function update_server($i, $down = true) {
    $server = &$this->servers[$i];
    
    if (!is_array($server)) {
      $url = (string) $server;
      $server = array('url' => $url);
    }
     
    $server['down'] = $down;
    $server['last_attempt'] = time();
  }
  
  private function update_conf() {
    $str = var_export($this->_CONF, true);
    $str = <<<STR
<?php\n
\$_CONF = $str;\n
?>
STR;
    file_put_contents("{$this->base_path}includes/conf.php", $str);
  }
  
  private function import_data() {
    global $db;
    
    $query_delim = ";\n\n";
    $exploded = explode($query_delim, $this->response);
    
    if (count($exploded) > 1) {
      foreach ($exploded as $query) {
        list($table, $query) = explode("|", $query);
        $query = str_replace("{{TABLE}}", $db->tables[$table], $query);
        
        if (!empty($query)) {
          $db->query($query);
        }
      }
    }
  }
}
}
?>