<?php
if (!class_exists('DisplayOptions')) {
class DisplayOptions {
  public $options_serialized = "", $formats = "";
  protected $options = array(), $run_mode = "", $demo_path = "", $subscr_id = "", $viewer_id = "";
  protected $custom_js = array("functions" => "", "series" => "", "demos" => "");
  /* options...
   * flat: paged, two-columns, three-columns, index (page jumping), categorize
   * split-screen: left, right, above, below, paged, index, categorize, [always] iframes
   * colorbox: paged, nested, [columns], index, categorize
   * accordion: categorize, colorbox
   * tabs: categorize, iframes
   * side-tabs: categorize, iframes
   * collapsible-list (a la SendOffsite... basically a simple accordion): categorize, columns
   * "Click here to view our Video Tutorials" showing all in a colorbox.
   */
  // run_mode = standalone, iframe, whmcs, kayako
  
  public function __construct($options, $run_mode, $demo_path, $formats = "swf") {
    $this->update("options", $options);
    $this->run_mode = $run_mode;
    $this->demo_path = $demo_path;
    $this->formats = $formats;
  
    if (!empty($_GET['subscr_id'])) {
      $this->subscr_id = "&amp;subscr_id=$_GET[subscr_id]";
    }
    if (!empty($_GET['viewer_id'])) {
      $this->viewer_id = "&amp;viewer_id=$_GET[viewer_id]";
    }
    
    if (!empty($this->subscr_id) || !empty($this->viewer_id)) {
      $this->options_serialized = $this->serialize_options();
    }
  }
  
  public function list_demos($demos, $base_path = "", $series = NULL, $formats = NULL, $target = '_blank', $links = array()) {
    $str = "      <table class=\"dw-series-table\">\n";
    
    if (!isset($formats)) {
      if (!empty($this->formats)) {
        $formats = explode(',', $this->formats);
      } else {
        $formats = array('swf');
      }
    }
    
    if (is_object($series)) {
      foreach ($formats as $k => $format) {
        if (!$series->has_format($format)) {
          unset($formats[$k]);
        }
      }
    }
    
    if (empty($formats)) {
      $formats = array('swf');
    }
    
    $count = count($demos);
    
    $i = 1;
    foreach ($demos as $d) {
      if (!$d->visible) {
        $count--;
        continue;
      }
      
      if (isset($GLOBALS['text_before_demo'][$d->id])) {
        if ($i != 1) {
          $str .= "      </tr>\n";
        }
        $str .= $GLOBALS['text_before_demo'][$d->id];
        $str .= "\n      <tr>\n";
      }
      
      if (defined('STATIC_MODE')) {
        $d_html = str_replace(".swf", ".html", $d->path);
        $demo_href = "{$this->demo_path}{$d->series_path}/{$d_html}";
        $demo_links = <<<HTML
<td><a href="$demo_href" target="_blank" id="dw-demo{$d->id}-link">$d->title</a></td>
HTML;
      } else {
        $demo_links = '';
        $separate_title = false;
          
        if (count($formats) > 1) {
          $separate_title = true;
          $demo_links = "<td>$d->title</td>";
        }
        
        foreach ($formats as $i => $format) {
          $format = trim($format);
          
          $suffix = $title = $format_param = $td_class = '';
          
          if ($format == 'text') {
            $format_param = '&amp;format=text';
            $td_class = 'text-link';
            $suffix = '-text';
            $title = '[Text]';
          } else if ($format == 'mp4') {
            $format_param = '&amp;format=mp4';
            $td_class = 'mp4-link';
            $suffix = '-mp4';
            $title = '[MP4]';
          } else {
            $td_class = 'swf-link';
            $title = '[Flash]';
          }
          
          if (!$separate_title) {
            $title = $d->title;
            $td_class = '';
          }
          
          if (isset($links[$d->id][$format])) {
            $demo_href = $links[$d->id][$format];
          } else if (isset($links[$d->id]['all'])) {
            $demo_href = $links[$d->id]['all'];
          } else {
            $demo_href = "{$base_path}demo.php?id=$d->id&amp;series=$d->series_id$format_param{$this->subscr_id}{$this->viewer_id}";
          }
          $demo_links .= <<<HTML
<td class="$td_class"><a href="$demo_href" target="_blank" id="dw-demo{$d->id}-link$suffix">$title</a></td>
HTML;
        }
      }
      
      $str .= <<<HTML
        <tr><td class="num">$d->num.</td>$demo_links</tr>

HTML;
      
      if (isset($GLOBALS['text_after_demo'][$d->id])) {
        $str .= "      </table>\n";
        $str .= $GLOBALS['text_after_demo'][$d->id];
        if ($i != $count) {
          $str .= "\n      <table>\n";
        }
      }
      
      $i++;
    }
      
    return array($str . "      </table>\n", $i);
  }
  
  public function include_css_js($base_path = "", $disable_jquery = false) {
    $css = $js = "";
    
    if ($this->is_set("colorbox")) {
      $css .= <<<HTML
  <link type="text/css" media="screen" rel="stylesheet" href="{$base_path}js/colorbox.css" />

HTML;
      $js .= <<<HTML
  <script type="text/javascript" src="{$base_path}js/jquery.colorbox.js"></script>

HTML;
    }
    
    if ($this->is_set("accordion")) {
      $css .= <<<HTML
  <link type="text/css" media="screen" rel="stylesheet" href="{$base_path}js/jquery-ui-smoothness/jquery-ui-1.8.custom.css" />

HTML;
      $js .= <<<HTML
  <script type="text/javascript" src="{$base_path}js/jquery-ui-1.8.custom.min.js"></script>

HTML;
    }
    
    if (!empty($js) || $this->is_set("search")) {
      if (!$disable_jquery) {
        $jQuery = <<<HTML
  <script type="text/javascript" src="{$base_path}js/jquery-1.5.2.min.js"></script>

HTML;
      } else {
        $jQuery = "";
      }
      
      if (defined('STATIC_MODE')) {
        $custom = <<<HTML
  <script type="text/javascript" src="{$base_path}js/dw-display-options.js"></script>

HTML;
      } else {
        $custom = <<<HTML
  <script type="text/javascript" src="{$base_path}request.php?type=js{$this->subscr_id}{$this->viewer_id}{$this->options_serialized}"></script>

HTML;
      }
      $js = $jQuery . $js . $custom;
    }
    
    if (strpos($this->formats, 'mp4') !== false) {
      $js .= <<<HTML
  <link href="{$base_path}js/video-js.min.css" rel="stylesheet" type="text/css" />
  <script type="text/javascript" src="{$base_path}js/video.min.js"></script>
  <script>
    _V_.options.flash.swf = "{$base_path}js/video-js.swf";
  </script>

HTML;
    }
    
    $css .= <<<HTML
  <link href="{$base_path}templates/dw-display-options.css" rel="stylesheet" type="text/css" />

HTML;
    
    return $css . $js;
  }
  
  public function is_set($key) {
    return isset($this->options[$key]);
  }
  
  public function update($field, $value) {
    if ($field == "options") {
      if (is_array($value)) {
        $this->$field = $this->combine($value);
      } else if (is_string($value)) {
        $this->updateFromString($field, $value);
      }
    }
    return $this;
  }
  
  public function updateFromString($field, $str) {
    if (empty($str)) {
      $this->$field = array();
    } else {
      $this->$field = $this->explode($str);
    }
  }
  
  public function updateFromPost($field, $var) {
    $this->$field = $this->fromPost($var);
  }
  
  public function readable() {
    $arr = array();
    
    foreach ($this->options as $option) {
      switch ($option) {
        case "two-columns":
          $arr[] = "2 Columns";
          break;
          
        case "three-columns":
          $arr[] = "3 Columns";
          break;
          
        case "flat":
        case "paged":
        case "accordion":
        case "colorbox":
        default:
          $arr[] = ucfirst($option);
      }
    }
    
    switch ($this->run_mode) {
      case "php":
        $arr[] = "PHP Include";
        break;
      
      case "iframe":
        $arr[] = "Inline Frame";
        break;
      
      case "whmcs":
        $arr[] = "WHMCS Integration";
        break;
      
      case "kayako":
        $arr[] = "Kayako Integration";
        break;
      
      case "standalone":
      default:
        $arr[] = ucfirst($this->run_mode);
    }
    
    return implode(", ", $arr);
  }
  
  public function imploded($str, $delim = ',') {
    if ($str == "options") {
      return $this->implode($this->$str, $delim);
    }
  }
  
  private function explode($var, $delim = ',') {
    $arr = explode($delim, $var);
    return $this->combine($arr);
  }
  
  private function implode($arr, $delim = ',') {
    return implode($delim, $arr);
  }
  
  private function fromPost($var) {
    if (!empty($var)) {
      if (is_array($var)) {
        $arr = array_keys($var);
      } else if (is_string($var)) {
        $arr = $this->explode($var);
      }
    } else {
      return $var;
    }
    return $this->combine($arr);
  }
  
  private function combine($arr) {
    return array_combine($arr, $arr);
  }
  
  private function serialize_options() {
    $str = "";
    
    foreach ($this->options as $k => $v) {
      $str .= "&amp;display_options[$k]=$k";
    }
    
    return $str;
  }
}
}
?>