<?php
if (!class_exists('DemoData')) {
class DemoData {
  public $id, $series_id, $title, $path, $width, $height, $series_path, $sort, $num;
  public $visible = true;
  
  public function __construct($id = 0, $series_id = 0, $title = "", $path = "", $width = "", $height = "", $series_path = "", $sort = 0) {
    $this->id = $id;
    $this->series_id = $series_id;
    $this->title = stripslashes($title);
    $this->path = $path;
    $this->width = $width;
    $this->height = $height;
    $this->series_path = $series_path;
    $this->sort = $sort;
  }
  
  public static function from_array($arr) {
    return new self($arr['id'], $arr['series_id'], $arr['title'], $arr['path'], $arr['width'], $arr['height'], $arr["series_path"], $arr["sort"]);
  }
  
  public static function normalize(&$demos) {
    foreach ($demos as $series_id => &$series_demos) {
      $num = 1;
      
      foreach ($series_demos as $i => &$d) {
        if (is_array($d)) {
          $d = self::from_array($d);
        }
        
        if (isset($GLOBALS['hide_demos'][$d->id]) || (isset($GLOBALS['show_demos']) && !isset($GLOBALS['show_demos'][$d->id]))) {
          $d->visible = false;
          continue;
        }
        
        if (isset($GLOBALS['demo_titles'][$d->id])) {
          $d->title = $GLOBALS['demo_titles'][$d->id];
        }
        
        $d->num = $num++;
      }
    }
  }
}
}
?>