<?php
require_once "request.php";

if (!isset($_GET['format']) || !in_array($_GET['format'], array('swf', 'text', 'mp4'))) {
  $format = 'swf';
} else {
  $format = $_GET['format'];
}

if ($req->ok) {
  $demos = $req->headers['demos'];
  DemoData::normalize($demos);
  
  if (isset($req->headers['demo_subs'])) {
    $subs = $req->headers['demo_subs'];
  }
  
  if (isset($_GET['series'])) {
    if (defined('DEMOWOLF_INTEGRATION') && isset($uri_to_dw)) {
	    $dir = $uri_to_dw;
    } else {
	    $dir = dirname($_SERVER['REQUEST_URI']);
    }
    
    if ($dir == "/") {
      $dir = "";
    }
    
    if ($format == 'swf' && isset($demos[$_GET['series']][$_GET['id']])) {
      $demo = $demos[$_GET['series']][$_GET['id']];
      $uri = "{$dir}/request.php?type=demo&amp;id=$_GET[id]";
    } else {
      if ($format == 'swf') {
        if (isset($subs[$_GET['series']][$_GET['id']])) {
          $sub = $subs[$_GET['series']][$_GET['id']];
        }
      }
      if (isset($sub, $demos[$sub['series']][$sub['demo']])) {
        $demo = $demos[$sub['series']][$sub['demo']];
        $uri = "{$dir}/request.php?type=demo&amp;id=$sub[demo]";
      } else if (isset($p_demos[$_GET['series']][$_GET['id']])) {
        $demo = $p_demos[$_GET['series']][$_GET['id']];
        $series = $p_series[$_GET['series']];
        
        $path = (isset($_CONF['demo_path'])) ? $_CONF['demo_path'] : "";
        $uri = (isset($_CONF['demo_uri'])) ? $_CONF['demo_uri'] : $path;
        
        $base_uri = $uri;
        $html_path = $path . "html/{$series->path}/" . str_replace('.swf', '.html', $demo->path);
        $mp4_uri = $uri . "mp4/{$series->path}/" . str_replace('.swf', '.mp4', $demo->path);
        $uri .= "{$series->path}/{$demo->path}";
      }
    }
    
    if (isset($demo)) {
      $demo_style_path = 'templates/demo-style.css';
      
      if ($format == 'text') {
        $tpl = 'demo-html.tpl';
        $demo_style_path = 'templates/dw-text-demos.css';
        
        if (!file_exists($html_path)) {
          __show_404();
        }
        
        $html = file_get_contents($html_path);
        
        if (preg_match("#<div( id=\"demo\")? class=\"dw-text\">(.*)</div>#s", $html, $matches)) {
          $html = $matches[2];
        }
        
        $output = str_replace("../../", $base_uri, $html);
      } else if ($format == 'mp4') {
        $tpl = 'demo-mp4.tpl';
      } else {
        $tpl = 'demo.tpl';
      }
      
      if (isset($demo_titles[$demo->id])) {
        $demo->title = $demo_titles[$demo->id];
      }
      
      /*
       * The expired movie has a grey background, so change the Object/Embed background to grey to match.
       */
      if ($req->headers['status'] == 'Expired') {
        $bgcolor = "#BABABA";
      } else {
        $bgcolor = "#FFFFFF";
      }
      
      $tpl = defined('DEMOWOLF_INTEGRATION') ? "{{demo}}" : file_get_contents("templates/$tpl");
      if ($format == 'mp4') {
        $output = createMP4Object($demo->width, $demo->height, $mp4_uri);
      } else if ($format != 'text') {
        $output = createFlashObject($demo->width, $demo->height, $uri, $uri_to_dw . "js/ieupdate.js", $req->headers['show_header'], $bgcolor);
      }
      echo str_replace(array("{{title}}", "{{demo}}", "{{demo_style_path}}", "{{js_path}}"), array($demo->title, $output, $uri_to_dw . $demo_style_path, $uri_to_dw . "js/"), $tpl);
    } else {
      __show_404();
    }
  }
}
?>