<script type="text/jscript">
jQuery(document).ready(function () {
    jQuery('#btnShowSidebar').click(function () {
        if (jQuery(".product-selection-sidebar").is(":visible")) {
            jQuery('.sm-content').removeClass('sidebar-active');
            jQuery('.product-selection-sidebar').hide();
            jQuery('#btnShowSidebar').html('<i class="fas fa-arrow-circle-right"></i> {$LANG.showMenu}');
        } else {
            jQuery('.product-selection-sidebar').show();
            jQuery('.sm-content').addClass('sidebar-active');
            jQuery('#btnShowSidebar').html('<i class="fas fa-arrow-circle-left"></i> {$LANG.hideMenu}');
        }
    });
});
</script>

<div id="order-premium_comparison" class="sm-content-container">
  <div class="sm-content">
    <div class="sm-page-heading">
      <h1>{if $productGroup.headline}
        {$productGroup.headline}
        {else}
        {$productGroup.name}
        {/if}</h1>
      {if $showSidebarToggle}
      <button type="button" class="btn btn-primary btn-sm" id="btnShowSidebar"> <i class="fas fa-arrow-circle-right"></i> {$LANG.showMenu} </button>
      {/if}
      {if $productGroup.tagline} <small> {$productGroup.tagline} </small> {/if}</div>
    {if $errormessage}
    <div class="alert alert-danger">
      <div class="alert-content">{$errormessage}</div>
    </div>
    {/if}
    <div id="products" class="price-table-container">
      <ul>
        {foreach $products as $product}
        <li id="product{$product@iteration}">
          <div class="price-table">
            <div class="top-head">
              <div class="top-area">
                <h4 id="product{$product@iteration}-name">{$product.name}</h4>
              </div>
              {if $product.tagLine}
              <p id="product{$product@iteration}-tag-line">{$product.tagLine}</p>
              {/if}
              {if $product.isFeatured}
              <div class="popular-plan"> {$LANG.featuredProduct|upper} </div>
              {/if}
              <div class="price-area">
                <div class="price" id="product{$product@iteration}-price"> {if $product.bid}
                  {$LANG.bundledeal}
                  {if $product.displayprice} <br />
                  <br />
                  <span>{$product.displayPriceSimple}</span> {/if}
                  {elseif $product.paytype eq "free"}
                  {$LANG.orderfree}
                  {elseif $product.paytype eq "onetime"} <span>{$product.pricing.onetime}</span> {$LANG.orderpaymenttermonetime}
                  {else}
                  {if $product.pricing.hasconfigoptions}
                  {$LANG.from}
                  {/if}
                  {$product.pricing.minprice.cycleText} <br>
                  {if $product.pricing.minprice.setupFee} <small>{$product.pricing.minprice.setupFee->toPrefixed()} {$LANG.ordersetupfee}</small> {/if}
                  {/if} </div>
                {if $product.qty eq "0"} <span id="product{$product@iteration}-unavailable" class="btn btn-primary btn-lg disabled">{$LANG.outofstock}</span> {else} <a href="{$smarty.server.PHP_SELF}?a=add&amp;{if $product.bid}bid={$product.bid}{else}pid={$product.pid}{/if}" class="btn btn-success btn-lg" id="product{$product@iteration}-order-button"> {$LANG.ordernowbutton} </a> {/if} </div>
            </div>
            <ul>
              {foreach $product.features as $feature => $value}
              <li id="product{$product@iteration}-feature{$value@iteration}"> {$value} {$feature} </li>
              {foreachelse}
              <li id="product{$product@iteration}-description"> {$product.description} </li>
              {/foreach}
            </ul>
          </div>
        </li>
        {/foreach}
      </ul>
    </div>
    {if count($productGroup.features) > 0}
    <div class="includes-features">
      <div class="row clearfix">
        <div class="col-md-12">
          <div class="head-area"> <span> {$LANG.orderForm.includedWithPlans} </span> </div>
          <ul class="list-features">
            {foreach $productGroup.features as $features}
            <li><i class="far fa-check-circle"></i> {$features.feature}</li>
            {/foreach}
          </ul>
        </div>
      </div>
    </div>
    {/if} </div>
</div>
<div id="premiumComparisonSidebar" class="sm-sidebar product-selection-sidebar">{include file="orderforms/swiftmodders_cart/sidebar-categories.tpl"}</div>
