<header class="allure-article-header">
    <div class="header-lined{if $productGroup.tagline} has-desc{/if}">
        <h1>
            {if $productGroup.headline}
                {$productGroup.headline}
            {else}
                {$productGroup.name}
            {/if}
            {if $productGroup.tagline}
                <small>
                    {$productGroup.tagline}
                </small>
            {/if}
        </h1>
    </div>
    {if $secondarySidebar->hasChildren()}
        <a class="btn allure-sidebar-toggle" href="#"><i class="fal fa-angle-left"></i><span class="sr-only">Toggle Sidebar</span></a>
    {/if}
</header>

<section id="order-premium_comparison" class="allure-content main-content">
    {if $errormessage}
        <div class="alert alert-danger">
            {$errormessage}
        </div>
    {elseif !$productGroup}
        <div class="alert alert-info">
            {lang key='orderForm.selectCategory'}
        </div>
    {/if}

    <div class="main-container price-01">
        <div id="products" class="price-table-container">
            <ul>
                {foreach $products as $product}
                    {$idPrefix = ($product.bid) ? ("bundle"|cat:$product.bid) : ("product"|cat:$product.pid)}
                    <li id="{$idPrefix}">
                        <div class="price-table">
                            <div class="top-head">
                                <div class="top-area">
                                    <h4 id="{$idPrefix}-name">{$product.name}</h4>
                                </div>
                                {if $product.tagLine}
                                    <p id="{$idPrefix}-tag-line">{$product.tagLine}</p>
                                {/if}
                                {if $product.isFeatured}
                                    <div class="popular-plan">
                                        {$LANG.featuredProduct|upper}
                                    </div>
                                {/if}

                                <div class="price-area">
                                    <div class="price" id="{$idPrefix}-price">
                                        {if $product.bid}
                                            {$LANG.bundledeal}
                                            {if $product.displayprice}
                                                <br /><br /><span>{$product.displayPriceSimple|replace:'.00':''}</span>
                                            {/if}
                                        {elseif $product.paytype eq "free"}
                                            {$LANG.orderfree}
                                        {elseif $product.paytype eq "onetime"}
                                            <span>{$product.pricing.minprice.price|replace:'.00':''}</span> {$LANG.orderpaymenttermonetime}
                                        {else}
                                            {if $product.pricing.hasconfigoptions}
                                                {$LANG.from}
                                            {/if}
                                            {$product.pricing.minprice.cycleText|replace:'.00':''}
                                            <br>
                                            {if $product.pricing.minprice.setupFee}
                                                <small>{$product.pricing.minprice.setupFee->toPrefixed()} {$LANG.ordersetupfee}</small>
                                            {/if}
                                        {/if}
                                    </div>
                                    {if $product.qty eq "0"}
                                        <span id="{$idPrefix}-unavailable" class="order-button unavailable">{$LANG.outofstock}</span>
                                    {else}
                                        <a href="{$product.productUrl}?a=add&amp;{if $product.bid}bid={$product.bid}{else}pid={$product.pid}{/if}" class="order-button" id="{$idPrefix}-order-button">
                                            {$LANG.ordernowbutton}
                                        </a>
                                    {/if}

                                </div>
                            </div>
                            <ul>
                                {foreach $product.features as $feature => $value}
                                    <li id="{$idPrefix}-feature{$value@iteration}">
                                        {$value} {$feature}
                                    </li>
                                {foreachelse}
                                    <li id="{$idPrefix}-description">
                                        {$product.description}
                                    </li>
                                {/foreach}
                            </ul>
                        </div>
                    </li>
                {/foreach}
            </ul>
        </div>
    </div>
    {if count($productGroup.features) > 0}
        <div class="includes-features">
            <div class="row clearfix">
                <div class="col-md-12">
                    <div class="head-area">
                        <span class="primary-bg-color">
                            {$LANG.orderForm.includedWithPlans}
                        </span>
                    </div>
                    <ul class="list-features">
                        {foreach $productGroup.features as $features}
                            <li>{$features.feature}</li>
                        {/foreach}
                    </ul>
                </div>
            </div>
        </div>
    {/if}
</section>

<aside class="sidebar allure-sidebar">
    <div class="overlay-scroller">
        {include file="orderforms/allure_cart/sidebar-categories.tpl"}
    </div>
</aside>