{include file="orderforms/allure_cart/common.tpl"}

<header class="allure-article-header">
    <div class="header-lined{if $productGroup.tagline} has-desc{/if}">
        <h1>{$LANG.orderconfirmation}</h1>
    </div>
    {if $secondarySidebar->hasChildren()}
    <a class="btn allure-sidebar-toggle" href="#"><i class="fal fa-angle-left"></i><span class="sr-only">Toggle Sidebar</span></a>
    {/if}
</header>

<section id="order-standard_cart" class="allure-content main-content cart-body">

    {include file="orderforms/allure_cart/sidebar-categories-collapsed.tpl"}

    <p>{$LANG.orderreceived}</p>

    <div class="row">
        <div class="col-sm-8 col-sm-offset-2 offset-sm-2">
            <div class="alert alert-info order-confirmation">
                {$LANG.ordernumberis} <span>{$ordernumber}</span>
            </div>
        </div>
    </div>

    <p>{$LANG.orderfinalinstructions}</p>

    {if $expressCheckoutInfo}
    <div class="alert alert-info text-center">
        {$expressCheckoutInfo}
    </div>
    {elseif $expressCheckoutError}
    <div class="alert alert-danger text-center">
        {$expressCheckoutError}
    </div>
    {elseif $invoiceid && !$ispaid}
    <div class="alert alert-warning text-center">
        {$LANG.ordercompletebutnotpaid}
        <br /><br />
        <a href="{$WEB_ROOT}/viewinvoice.php?id={$invoiceid}" target="_blank" class="alert-link">
            {$LANG.invoicenumber}{$invoiceid}
        </a>
    </div>
    {/if}

    {foreach $addons_html as $addon_html}
    <div class="order-confirmation-addon-output">
        {$addon_html}
    </div>
    {/foreach}

    {if $ispaid}
    <!-- Enter any HTML code which should be displayed when a user has completed checkout here -->
    <!-- Common uses of this include conversion and affiliate tracking scripts -->
    {/if}

    <div class="text-center">
        <a href="{$WEB_ROOT}/clientarea.php" class="btn btn-default">
            {$LANG.orderForm.continueToClientArea}
            &nbsp;<i class="fas fa-arrow-circle-right"></i>
        </a>
    </div>
</section>

<aside class="sidebar allure-sidebar cart-sidebar">
    <div class="overlay-scroller">
        {include file="orderforms/allure_cart/sidebar-categories.tpl"}
    </div>
</aside>