{foreach from=$addons_html item=addon_html}
    {$addon_html}
{/foreach}
<div class="client-home-panels">
	<div class="row">
		<div class="col-sm-6">
			{function name=outputHomePanels}
				<div menuItemName="{$item->getName()}" class="panel panel-default panel-accent-{$item->getExtra('color')}{if $item->getClass()} {$item->getClass()}{/if}"{if $item->getAttribute('id')} id="{$item->getAttribute('id')}"{/if}>
					<div class="panel-heading">
						<h3 class="panel-title">
							{if $item->getExtra('btn-link') && $item->getExtra('btn-text')}
								<div class="pull-right">
									<a href="{$item->getExtra('btn-link')}" class="btn btn-default bg-color-{$item->getExtra('color')} btn-xs">
										{if $item->getExtra('btn-icon')}<i class="fa {$item->getExtra('btn-icon')}"></i>{/if}
										{$item->getExtra('btn-text')}
									</a>
								</div>
							{/if}
							{if $item->hasIcon()}<i class="{$item->getIcon()}"></i>&nbsp;{/if}
							{$item->getLabel()}
							{if $item->hasBadge()}&nbsp;<span class="badge">{$item->getBadge()}</span>{/if}
						</h3>
					</div>
					{if $item->hasBodyHtml()}
						<div class="panel-body">
							{$item->getBodyHtml()}
						</div>
					{/if}
					{if $item->hasChildren()}
						<div class="list-group{if $item->getChildrenAttribute('class')} {$item->getChildrenAttribute('class')}{/if}">
							{foreach $item->getChildren() as $childItem}
								{if $childItem->getUri()}
									<a menuItemName="{$childItem->getName()}" href="{$childItem->getUri()}" class="list-group-item{if $childItem->getClass()} {$childItem->getClass()}{/if}{if $childItem->isCurrent()} active{/if}"{if $childItem->getAttribute('dataToggleTab')} data-toggle="tab"{/if}{if $childItem->getAttribute('target')} target="{$childItem->getAttribute('target')}"{/if} id="{$childItem->getId()}">
										{if $childItem->hasIcon()}<i class="{$childItem->getIcon()}"></i>&nbsp;{/if}
										{$childItem->getLabel()}
										{if $childItem->hasBadge()}&nbsp;<span class="badge">{$childItem->getBadge()}</span>{/if}
									</a>
								{else}
									<div menuItemName="{$childItem->getName()}" class="list-group-item{if $childItem->getClass()} {$childItem->getClass()}{/if}" id="{$childItem->getId()}">
										{if $childItem->hasIcon()}<i class="{$childItem->getIcon()}"></i>&nbsp;{/if}
										{$childItem->getLabel()}
										{if $childItem->hasBadge()}&nbsp;<span class="badge">{$childItem->getBadge()}</span>{/if}
									</div>
								{/if}
							{/foreach}
						</div>
					{/if}
					{if $item->hasFooterHtml()}
						<div class="panel-footer">
							{$item->getFooterHtml()}
						</div>
					{/if}
				</div>
			{/function}
			{foreach $panels as $item}
				{if $item@iteration is odd}
					{outputHomePanels}
				{/if}
			{/foreach}
		</div>
		<div class="col-sm-6">
			{foreach $panels as $item}
				{if $item@iteration is even}
					{outputHomePanels}
				{/if}
			{/foreach}
		</div>
	</div>
</div>