<!DOCTYPE html>
<html lang="en"{if !$lightStatus && $enableDark} data-theme="dark"{/if} data-dir="{if $enableRTL && ($language eq "hebrew" || $language eq "arabic" || $language eq "farsi")}rtl{else}ltr{/if}">
<head>
<meta charset="{$charset}" />
<meta http-equiv="X-UA-Compatible" content="IE=edge">
<meta name="viewport" content="width=device-width, initial-scale=1">
<title>{if $kbarticle.title}{$kbarticle.title} - {/if}{$pagetitle} | {$companyname}</title>
{include file="$template/includes/head.tpl"}
{$headoutput}
</head>
<body data-phone-cc-input="{$phoneNumberInputStyle}" class="no-badge {if $templatefile eq 'homepage' or $templatefile eq 'clientareahome'}home {/if}allure-body{if $showingLoginPage} login{/if}{if $primarySidebar->hasChildren() || $secondarySidebar->hasChildren()} has-sidebar{/if}{if $menuLocation eq 'top'} top-nav{/if}{if $enableMinMenuDefault || $minNav eq 'active'} min-nav{/if}{if $inShoppingCart && $hideSidebarCart} cart-view hide-sidebar{elseif $sidebarHidden} hide-sidebar{/if}"{if $primarySidebar->hasChildren() || $secondarySidebar->hasChildren()} data-sidebar="true"{/if}{if $enableMinMenuDefault} data-minmenu="true"{/if}>
{$headeroutput}
{if $enablePreloader}
<div class="allure-preloader">
    <div class="allure-preloader-anim">
        <div class="allure-anim-1"></div>
        <div class="allure-anim-2"></div>
        <div class="allure-anim-3"></div>
    </div>
</div>
{/if}
<div id="site-container" class="allure-container">
    <header id="header" class="allure-header">
        {if $menuLocation eq 'side'}
            <div class="allure-logo-mobile">
                <a class="allure-mobile-menu btn" href="#"><i class="fal fa-bars"></i><span class="sr-only">{$allureLang.mobilemenu}</span></a>
                <a class="allure-logo" href="{$systemurl}">{if $enableLogo}<img src="{if $headerStyle eq 'dark'}{$whiteLogo}{else}{$colorLogo}{/if}" alt="{$companyname}">{else}<span>{$companyname}</span>{/if}</a>
            </div>
            <div class="allure-menu-closer">
                <a class="allure-menu-toggle btn" href="#"><i class="fal fa-arrow-to-left"></i><span class="sr-only">{$allureLang.minimizemenu}</span></a>
            </div>
        {else}
            <div class="allure-header-logo">
                <a class="allure-mobile-menu btn" href="#"><i class="fal fa-bars"></i><span class="sr-only">{$allureLang.mobilemenu}</span></a>
                <a class="allure-logo" href="{$systemurl}">{if $enableLogo}<img src="{if $headerStyle eq 'dark'}{$whiteLogo}{else}{$colorLogo}{/if}" alt="{$companyname}">{else}<span>{$companyname}</span>{/if}</a>
            </div>
        {/if}
        <div class="allure-date-time">{$carbon->format($dateFormat)}</div>
        {if $menuLocation eq 'top' && $enableDark}
            <div class="allure-lightsout">
                <label>
                    <input type="checkbox" name="allure-lightsout" data-toggle="switch" data-size="mini"{if $enableRTL && ($language eq "hebrew" || $language eq "arabic" || $language eq "farsi")} data-inverse="true"{/if}{if !$enableDarkDefault} checked{/if}> {$allureLang.lightstoggle}
                </label>
            </div>
        {/if}
        <div class="allure-header-links">
            <ul>
                {if $languagechangeenabled && count($locales) > 1}
                    <li class="language">
                        <a href="#" class="btn choose-language" data-toggle="modal" data-target="#modalLanguage" data-toggle-allure="tooltip" data-placement="bottom" title="{$LANG.language}">
                            <i class="fas fa-language"></i><span class="sr-only">{$activeLocale.localisedName}</span>
                        </a>
                    </li>
                {/if}
                {if $loggedin}
                    <li class="notifications">
                        <a href="#" class="btn allure-notifications" data-toggle="popover" id="accountNotifications" data-placement="bottom" data-toggle-allure="tooltip" data-placement="bottom" title="{$LANG.notifications}">
                            <i class="fas fa-bell"></i><span class="sr-only">{$LANG.notifications}</span>
                            {if count($clientAlerts) > 0}
                                <span class="allure-new-indicator"></span>
                            {/if}
                        </a>
                        <div id="accountNotificationsContent" class="hidden">
                            <ul class="client-alerts">
                            {foreach $clientAlerts as $alert}
                                <li>
                                    <a href="{$alert->getLink()}">
                                        <i class="fas fa-fw fa-{if $alert->getSeverity() == 'danger'}exclamation-circle{elseif $alert->getSeverity() == 'warning'}exclamation-triangle{elseif $alert->getSeverity() == 'info'}info-circle{else}check-circle{/if}"></i>
                                        <div class="message">{$alert->getMessage()}</div>
                                    </a>
                                </li>
                            {foreachelse}
                                <li class="none">
                                    {$LANG.notificationsnone}
                                </li>
                            {/foreach}
                            </ul>
                        </div>
                    </li>
                {/if}
                <li class="primary-action">
                    <a href="{$WEB_ROOT}/cart.php?a=view" class="btn" data-toggle="tooltip" data-placement="bottom" title="{$LANG.viewcart}">
                        <i class="fas fa-shopping-cart"></i><span class="sr-only">{$LANG.viewcart}</span>
                        {if $cartitemcount > 0}<span class="badge">{$cartitemcount}</span>{/if}
                    </a>
                </li>
                {if $adminMasqueradingAsClient || $adminLoggedIn}
                    <li class="admin">
                        <a href="{$WEB_ROOT}/logout.php?returntoadmin=1" class="btn btn-logged-in-admin" data-toggle="tooltip" data-placement="bottom" title="{if $adminMasqueradingAsClient}{$LANG.adminmasqueradingasclient} {$LANG.logoutandreturntoadminarea}{else}{$LANG.adminloggedin} {$LANG.returntoadminarea}{/if}">
                            <i class="fas fa-undo"></i><span class="sr-only">{if $adminMasqueradingAsClient}{$LANG.logoutandreturntoadminarea}{else}{$LANG.returntoadminarea}{/if}</span>
                        </a>
                    </li>
                {/if}
                {include file="$template/includes/navbar.tpl" navbar=$secondaryNavbar}
            </ul>
        </div>
    </header> <!-- / #header -->

    {if $menuLocation eq 'top'}
        <nav id="nav" class="allure-top-nav">
            <ul class="allure-menu">
                {include file="$template/includes/navbar.tpl" navbar=$primaryNavbar}
            </ul>
        </nav>
    {/if}

    <nav id="{if $menuLocation eq 'side'}nav{else}mobile-nav{/if}" class="allure-nav">
        <div class="allure-header-logo">
            <a class="allure-logo" href="{$systemurl}">{if $enableLogo}<img src="{if $headerStyle eq 'dark'}{$whiteLogo}{else}{$colorLogo}{/if}" alt="{$companyname}">{else}<span>{$companyname}</span>{/if}</a>
            {if $enableLogo}<a class="allure-logo-icon" href="{$systemurl}"><img src="{if $headerStyle eq 'dark'}{$whiteIconLogo}{else}{$colorIconLogo}{/if}" alt="{$companyname}"></a>{/if}
            <a class="btn close" href="#"><i class="fal fa-times"></i><span class="sr-only">{$allureLang.closemobilemenu}</span></a>
        </div>
        <div class="overlay-scroller">
            <h2>{$allureLang.menu}</h2>
            <ul class="allure-menu">
                {include file="$template/includes/navbar.tpl" navbar=$primaryNavbar}
            </ul>
            {if $enableDark}
                <h2 class="spacer">{$allureLang.settings}</h2>
                <div class="allure-lightsout">
                    <label><input type="checkbox" name="allure-lightsout" data-toggle="switch" data-size="mini"{if $enableRTL && ($language eq "hebrew" || $language eq "arabic" || $language eq "farsi")} data-inverse="true"{/if}{if !$enableDarkDefault} checked{/if}> {$allureLang.lightstoggle}</label>
                </div>
            {/if}
            <div class="allure-mobile-options">
                {if $languagechangeenabled && count($locales) > 1}
                    <div class="language">
                        <a href="#" class="btn choose-language" data-toggle="modal" data-target="#modalLanguage">
                            <i class="fas fa-language"></i><span class="sr-only">{$activeLocale.localisedName}</span>
                        </a>
                    </div>
                {/if}
                <div class="primary-action">
                    <a href="{$WEB_ROOT}/cart.php?a=view" class="btn">
                        <i class="fas fa-shopping-cart"></i><span class="sr-only">{$LANG.viewcart}</span>
                        {if $cartitemcount > 0}<span class="badge">{$cartitemcount}</span>{/if}
                    </a>
                </div>
                {if $adminMasqueradingAsClient || $adminLoggedIn}
                    <div class="admin">
                        <a href="{$WEB_ROOT}/logout.php?returntoadmin=1" class="btn btn-logged-in-admin" data-toggle="tooltip" data-placement="bottom" title="{if $adminMasqueradingAsClient}{$LANG.adminmasqueradingasclient} {$LANG.logoutandreturntoadminarea}{else}{$LANG.adminloggedin} {$LANG.returntoadminarea}{/if}">
                            <i class="fas fa-undo"></i><span class="sr-only">{if $adminMasqueradingAsClient}{$LANG.logoutandreturntoadminarea}{else}{$LANG.returntoadminarea}{/if}</span>
                        </a>
                    </div>
                {/if}
            </div>
        </div>
    </nav> <!-- / #nav -->

    <main id="main-area" class="allure-main">
        {if $templatefile == 'homepage'}
            <div id="home-banner" style="background-image:url('{$domainBackground}');">
                <div class="container text-center">
                    {if $registerdomainenabled || $transferdomainenabled}
                        <h2>{$LANG.homebegin}</h2>
                        <form method="post" action="domainchecker.php" id="frmDomainHomepage">
                            <input type="hidden" name="transfer" />
                            <div class="row">
                                <div class="col-md-8 col-md-offset-2 col-sm-10 col-sm-offset-1">
                                    <div class="input-group input-group-lg force-ltr">
                                        <input type="text" class="form-control" name="domain" placeholder="{$LANG.exampledomain}" autocapitalize="none" data-toggle="tooltip" data-placement="left" data-trigger="manual" title="{lang key='orderForm.required'}" />
                                        <span class="input-group-btn">
                                            {if $registerdomainenabled}
                                                <input type="submit" class="btn search{$captcha->getButtonClass($captchaForm)}" value="{$LANG.search}" id="btnDomainSearch" />
                                            {/if}
                                            {if $transferdomainenabled}
                                                <input type="submit" id="btnTransfer" class="btn transfer{$captcha->getButtonClass($captchaForm)}" value="{$LANG.domainstransfer}" />
                                            {/if}
                                        </span>
                                    </div>
                                </div>
                            </div>

                            {include file="$template/includes/captcha.tpl"}
                        </form>
                    {else}
                        <h2>{$LANG.doToday}</h2>
                    {/if}
                </div>
            </div>
            <div class="home-shortcuts">
                <div class="container">
                    <div class="row">
                        <div class="col-md-4 hidden-sm hidden-xs text-center">
                            <p class="lead">
                                {$LANG.howcanwehelp}
                            </p>
                        </div>
                        <div class="col-sm-12 col-md-8">
                            <ul>
                                {if $registerdomainenabled || $transferdomainenabled}
                                    <li>
                                        <a id="btnBuyADomain" href="{$WEB_ROOT}/domainchecker.php">
                                            <i class="fad fa-globe"></i>
                                            <p>
                                                {$LANG.buyadomain} <span>&raquo;</span>
                                            </p>
                                        </a>
                                    </li>
                                {/if}
                                <li>
                                    <a id="btnOrderHosting" href="{$WEB_ROOT}/cart.php">
                                        <i class="fad fa-hdd"></i>
                                        <p>
                                            {$LANG.orderhosting} <span>&raquo;</span>
                                        </p>
                                    </a>
                                </li>
                                <li>
                                    <a id="btnMakePayment" href="{$WEB_ROOT}/clientarea.php">
                                        <i class="fad fa-credit-card"></i>
                                        <p>
                                            {$LANG.makepayment} <span>&raquo;</span>
                                        </p>
                                    </a>
                                </li>
                                <li>
                                    <a id="btnGetSupport" href="{$WEB_ROOT}/submitticket.php">
                                        <i class="fad fa-envelope"></i>
                                        <p>
                                            {$LANG.getsupport} <span>&raquo;</span>
                                        </p>
                                    </a>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        {/if}

        <article id="main-body" class="container allure-article">
            {if !$showingLoginPage && !$inShoppingCart && $templatefile != 'homepage' && !$skipMainBodyContainer}
                <header class="allure-article-header">
                    {include file="$template/includes/pageheader.tpl" title=$displayTitle desc=$tagline showbreadcrumb=true}
                </header>
            {/if}
            {if !$inShoppingCart}
                {include file="$template/includes/validateuser.tpl"}
                {include file="$template/includes/verifyemail.tpl"}
                <section class="allure-content main-content">
            {/if}