            {if !$inShoppingCart}
                </section><!-- / .main-content -->
            {/if}
            {if !$inShoppingCart && ($primarySidebar->hasChildren() || $secondarySidebar->hasChildren())}
                <aside class="sidebar allure-sidebar">
                    <div class="overlay-scroller">
                        {include file="$template/includes/sidebar.tpl" sidebar=$primarySidebar}
                        {include file="$template/includes/sidebar.tpl" sidebar=$secondarySidebar}
                    </div>
                </aside>
            {/if}
            {if $showingLoginPage}
                {if $languagechangeenabled && count($locales) > 1}
                    <div class="allure-language">
                        <a href="#" class="btn choose-language" id="languageChooser2" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                            <i class="fas fa-language"></i><span class="sr-only">{$activeLocale.localisedName}</span>
                        </a>
                        <ul class="dropdown-menu" aria-labelledby="languageChooser2">
                            {foreach $locales as $locale}
                                <li>
                                    <a href="{$currentpagelinkback}language={$locale.language}">{$locale.localisedName}</a>
                                </li>
                            {/foreach}
                        </ul>
                    </div>
                {/if}
                <footer class="allure-login-footer">{lang key="copyrightFooterNotice" year=$date_year company=$companyname}</footer>
            {/if}
        </article> <!-- / #main-body -->
        {if $showingLoginPage}<div class="allure-login-bg" style="background-image:url('{$loginBackground}');"></div>{/if}
    </main> <!-- / #main-area -->

    <footer id="footer" class="allure-footer">
        <div class="allure-copyright">&copy; {$date_year} {$companyname}. {$allureLang.allrightsreserved}.</div>
        {if $enableSupport}<div class="allure-slogan">{$allureLang.swiftmoddersfooter|replace:'%s':$affiliatesURL}</div>{/if}
    </footer> <!-- / #footer -->

    <a class="allure-back-top" href="#"><i class="fal fa-angle-up"></i><span class="sr-only">{$allureLang.backtotop}</span></a>
</div> <!-- / #site-container -->

<div id="fullpage-overlay" class="hidden">
    <div class="outer-wrapper">
        <div class="inner-wrapper">
            <img src="{$WEB_ROOT}/assets/img/overlay-spinner.svg">
            <br>
            <span class="msg"></span>
        </div>
    </div>
</div>
<div class="modal system-modal fade" id="modalAjax" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content panel-primary">
            <div class="modal-header panel-heading">
                <button type="button" class="close" data-dismiss="modal">
                    <span aria-hidden="true">&times;</span>
                    <span class="sr-only">{$LANG.close}</span>
                </button>
                <h4 class="modal-title">Title</h4>
            </div>
            <div class="modal-body panel-body">
                {$LANG.loading}
            </div>
            <div class="modal-footer panel-footer">
                <div class="pull-left loader">
                    <i class="fas fa-circle-notch fa-spin"></i> {$LANG.loading}
                </div>
                <button type="button" class="btn btn-default" data-dismiss="modal">
                    {$LANG.close}
                </button>
                <button type="button" class="btn btn-primary modal-submit">
                    {$LANG.submit}
                </button>
            </div>
        </div>
    </div>
</div>
{if $languagechangeenabled && count($locales) > 1}
<div class="modal system-modal fade" id="modalLanguage" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content panel panel-primary">
            <div class="modal-header panel-heading">
                <button type="button" class="close" data-dismiss="modal">
                    <span aria-hidden="true">&times;</span>
                    <span class="sr-only">Close</span>
                </button>
                <h4 class="modal-title">{$activeLocale.localisedName}</h4>
            </div>
            <div class="modal-body panel-body">
                <div id="languageChooserContent">
                    <ul>
                        {foreach $locales as $locale}
                            <li>
                                <a href="{$currentpagelinkback}language={$locale.language}">{$locale.localisedName}</a>
                            </li>
                        {/foreach}
                    </ul>
                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 689.01 317.53">
                        <path d="M686.48 275.21c.79-.07 1.86-.77 2.53-.13a5.29 5.29 0 0 1-2.53 2.78c-.55.25-1.27.16-1.85.4-1.11.45-1.69 1.6-2.65 2.39s-2.12 1.37-3.06 2-2.21 1.79-3.32.93c.09-1.56 1.74-1.54 2.13-2.79 0-.93-.83-1-.79-2 1.83-1.61 4.73-2.77 5.16-6.1.21-1.48-1-4.64.8-4.78 2.12-.16.92 2.13 1.07 3.32 0 .48.55.81.79 1.46.44 1.16.4 2.22 1.72 2.52zM673.61 283.17c-.73 2.21-4 3.37-6.1 4.77-.65.44-1.19 1.42-2 1.73-1 .41-2.21.27-3.31.79-1.76.83-3.07 2.44-4.65 3.46s-3.79 2.38-5.57 2.51c-2 .15-5.59-1.11-3.19-2.91a35.62 35.62 0 0 1 4.38-2.26c3.78-1.89 9.08-3.16 12.21-5.44 1.76-1.28 3.36-2.65 5-3.71.89-.54 2.3.89 3.23 1.06zM650.66 194.41c.43-.12.41.2.67.26-.16 1.9-1.3 3.14-3.72 2.92-1.08-.1-3-.91-3.05-1.46-.27-1.9 4.89-.73 6.1-1.72zM644.16 203.43c1 .27 5.22 3.29 3.85 4.64-.75.75-1.71-.4-2.92-.66-1.62-.36-2.87.08-4-.8s-1.57-3.14-2.92-4.38a5.92 5.92 0 0 0-3.71-1.32c-2.11.22-2.09 2.64-4 3.71-1.82-.19-2.89.33-4.25-.13s-2.16-2.35-3.45-2.52-4.54 2.17-5 .13c-.41-1.65 2.22-2.19 2.38-3.31s-1-2.95-1.59-3.46-1.33-.54-2-.92-1.2-1.19-2-1.6c-2.78-1.45-7-.86-8.09-3.18-.19-.41.1-.87-.13-1.46s-1.36-1-1.73-1.59c-.94-1.62-.28-4 1.33-4.25 1.45-.21 4.31 1.58 4.64 2.66.18.56-.12 1.2 0 1.85s1.33 2.7 2.39 2.79c1.37.11 2.19-2 3.45-2.79a6.56 6.56 0 0 1 3.45-1.06c1.13.09 1.89 1 3.18 1.46.93.35 2.09.49 3.19.8s1.79.83 2.78 1.19c3.16 1.15 6.92 1.82 8.63 3.85.46.56.45 1.38 1.06 2s3.63 1.12 3.71 2.39c.07 1-1.26 1-1.32 2-.09 1.91 2.61 1.8 3.07 3.96zM616.16 282.9a8.45 8.45 0 0 1-3.31 4.65c-1.2.83-5 2.51-5.44.13a15.73 15.73 0 0 1 1.06-4.38c.94-1.86 1.94-.64 3.45-.4s3.01-.9 4.24 0zM605.81 90c.54 1.59.91 3.16 1.33 4.64-1.46 1.82-4.35 1.15-6.5 2.12-1 .46-1.28 2.14-2.25 2.39-.78.21-1.39-.68-2.13-.66-1.9 0-2.83 3.19-5.17 2.39-1.34.79 0 3.85-1.59 4.11-1.17.18-1.82-1.33-2.53-2.26-.85-1.12-2.08-1.74-2.11-2.65s1.9-2.53 2.51-3.18c.76-.81 2.24-2.32 3.19-2.53 1.76-.38 3.56.17 4.91-.39 1.16-.5 1.23-2.33 1.85-2.79s1.14-.28 1.6-.53a4.83 4.83 0 0 0 1.86-5.31c-.45-1.48-2.9-3.1-1.33-4.91 2.35.25 5.45 2.57 5.84 4.91.15.92-.36 1.83-.27 2.79a13.64 13.64 0 0 0 .79 1.86zM606.35 75.52c-.3.68-.9.54-1.46.93s-1.19 1.6-1.86 1.73c-1.06.2-2.26-1.05-3.32-.8-1.24.3-.51 1.25-.92 2.39-1.09-.23-2.88-1.44-2.92-2.65 0-.76 1-1.23 1.19-2.13.4-1.51-.62-2.28-1.19-3.71 0-.22.12-.23.13-.4 1.29-.27 3.84 2.17 6.77 2.65 1.89.32 3.47.15 3.58 1.99zM601.44 210.2c.14 1.1-1.79 1-2 .26.05-.86 1.76-1.12 2-.26zM592.15 64.38c1.31.69 4.5 2.27 2.26 3.72-1.36-.51-2.78-2.22-2.26-3.72zM586.05 204.36c1.52-.83 3.18-2.64 5.84-1.73-.59 1.65-2.59 1.62-3.85 2.39s-2.36 2.1-4 2.26a1.26 1.26 0 0 0-.53-.54c.01-1.48 1.49-1.82 2.54-2.38zM582.47 179.41c1.56 0 3-.48 4.11.14-.21 3.31-5.35.79-8.76 1.32-.72.11-.94.68-1.73.4a2.88 2.88 0 0 1 2.53-2.39c.97-.1 2.38.53 3.85.53zM583.79 183.52c.15 1.84-2.35 2-3 3.46 1.1 1.68 1.53 4 2.79 5.57-.06 1 .2 2.33-.4 2.78-2.67.52-4.11-4.28-5.18-6-2 .38-.18 6.91-2.91 6.1-1.35-.4 0-2.27-.27-3.71-.25-1.28-1.5-1.54-1.59-2.53-.08-.82.9-1.69 1.19-2.52.42-1.2.15-3.52 1.59-3.58.71 0 1.66 1.49 2.13 1.59 1.53.38 3.41-1.58 5.65-1.16zM578.88 203.3c-.49 1-3.21.52-3.44-.4.46-1.05 3.21-.73 3.44.4zM576.36 206.48a3 3 0 0 1-.53.53c-1-.32-2.08-.57-2.38-1.59.74-1.09 2.88-.19 2.91 1.06zM572.78 203.16c-.67 1-3-.08-3.85.93-1.38 0-2.77-.05-3-1.19.4-1 1.66-.31 2.65-.4 1.56-.15 3.77-1.27 4.2.66z" fill="#231f20"/>
                        <path d="M554.07 254c0-1.17-.74-2.21-.93-3.45-.07-.45.07-1 0-1.6-.09-.82-.49-1.5-.4-2 .19-.87 1.21-1 1.47-1.72.41-1.24-.51-1.44-.54-2.92 0-1.05.8-1.56 1.33-2.92.25-.63.26-1.8.53-2.25s1.81-1 2.39-1.33c2-1 3.66-2.85 5.71-3.18.51-.09 1.22.06 1.59 0 1.2-.21 2.71-1.22 4.38-1.59s3-.23 4.24-.94a11 11 0 0 0 3.72-4c.6-1.46.42-2.69 1.59-3.19.57-.24 1.13 0 1.72-.13a8.23 8.23 0 0 0 2.39-1.19c.93-.83 1.08-2.19 2.12-3.06a18.52 18.52 0 0 1 3.06-2 5.28 5.28 0 0 1 2.12-.54c1.87.16 2.74 2.77 4.77 2.26.73-.19 1.47-1.73 2.13-2.66 1-1.35 1.65-3.17 3.32-3.58 1.34-.33 2.84.52 3.58-.66.16-.84-.63-1.34 0-1.86 1.54.1 4.16 2.18 6.5 2.25 1.26.05 3.6-1.37 3.85.54.11.84-1 1.52-1.2 2.39-.17.61.26.93-.13 1.59-1.08.42-2.22.65-2.26 1.85 0 1.52 2.15 2.23 3.45 3.06.9.57 1.65 1.43 2.13 1.72s1 .36 1.32.53c.86.56 1.47 1.83 2.66 1.86 1.35 0 2.69-1.68 3.45-3.32.88-1.91.93-4.23 1.32-6.23.13-.67.61-1.33.8-2 .51-1.82 1.21-4.27 2.78-4.91 1.59 1.67 2.13 4.94 1.87 7.7 1.05.8 2.92.53 3.18 2.38.09.64-.32 1.46-.27 2.12.09 1.12.92 2.1 1.07 3.06.26 1.76-.3 3.22.52 4.51 1 1.62 3.07 1.57 4.38 3.32a6.32 6.32 0 0 0 .66 2.38c.13.41 0 1.07.14 1.33.42.89 1.57 1 2 1.72.2.37.15 1.07.4 1.73a15.53 15.53 0 0 0 1.85 2.65c.6.92 1.58 1.93 1.73 2.66.26 1.32-.69 2.23-.93 3.31-.29 1.32 0 3-.53 4.38-.61 1.6-2.13 3.17-3.32 5.18a17.52 17.52 0 0 1-3.71 4.64c-.84.67-1.84 1.06-2.66 1.73a39 39 0 0 0-3.45 3.58c-1.19 1.26-2.64 2.23-3.58 3.31-1.36 1.58-2 4.13-4.38 4.38a14 14 0 0 0-3.85.53c-2 .78-3.26 2.22-4.24 2.26s-2-1.2-2.92-1.33-1.9.81-3.45.8c-.63 0-.95-.38-1.85-.67-1.9-.6-4-.57-4.25-2.65-.15-1.13.72-1.64.66-2.65s-1.1-1.18-1.47-2.08a2.19 2.19 0 0 0-.66-2.65 2.6 2.6 0 0 1 .53-1.86 17.39 17.39 0 0 0-2.66 1.07c-1 .58-1.66 1.92-2.78 1.72-1-.37-.24-1.41-.4-2.26a11.6 11.6 0 0 0-2.25-3.84 19 19 0 0 0-4.51-1.73c-4.1-.64-6.72 1.55-10 1.86-.83.08-1.73-.14-2.52 0-2.66.47-5.63 2.59-7.29 4-2.75.27-5.53-.56-8.37.27s-4.42 3.16-8.75 2.51c-.85-.73-2.38-1.1-2.39-2.38 0-1 1.5-1.67 2-2.39a9.41 9.41 0 0 0 1.45-3.72c0-.88-.59-1.93-.53-3.05.09-.88.58-1.81.57-2.65zM551.82 198.65c.72-.1 1.26-.63 2-.66 1.54-.06 3.07 1.14 4.9.93.4.42.13.78.14 1.46 1.55.83 4.1.68 4.9 2.25-1.16 1.23-2.88.35-4.37.13s-2.78-.09-4.25-.26c-1.85-.22-3.53-1.24-5.3-1.46-1.08-.13-2.18.15-3.19 0-1.19-.18-5.64-1.86-5.7-3s2-1.57 3.84-1.33c2.38.29 3.97 2.37 7.03 1.94zM555.4 189.5c-1-.28-1.95-.13-2.39-.4-.9-.56-.77-2.15-1.06-3s-1.4-1.41-2-2.66c-.86-1.81-1.23-5.86 1.06-6.23.92-.16 1.88.55 2.52.4 1.28-.32 1.06-2 2.12-2.66.6-.38 1.68-.22 2.53-.53a5.71 5.71 0 0 0 2.12-1.86c.55-.66 1-1.77 1.72-2.25s1.59-.56 2.26-1.06c1.74-1.33 1.79-3.18 3.18-4.78 1.18-1.35 3 1.3 3.19 2.39.66.84 2 1.05 2.52 2-.78 2.33-3 2.54-2.52 5.84a9.39 9.39 0 0 0 .79 2.25c.38.78 1.51 1.62 1.46 2.12-.08 1-2.08 1-2.52 2s0 1-.13 2.52c-.56 1.09-2.06 1.35-2.52 2.66-.56 1.58.08 3.62-1.2 4.78-.88-.05-1.84.76-2.91.66s-2.27-1.7-4.12-1.73c-.7 0-1.53.45-2.25.4-.56-.11-1.02-.63-1.85-.86zM546.81 186.55c3.38 0 3.38 5.23 0 5.23s-3.38-5.23 0-5.23z" fill="#231f20"/>
                        <path d="M541.86 185.91a5.48 5.48 0 0 1 1.86 2.66c0 .93-1.45.88-1.86 2.12-.62 1.91.28 4.07-.79 5.05a6.18 6.18 0 0 1-2.65.26 38.92 38.92 0 0 1-6.37-6 14.94 14.94 0 0 1-2.13-2.39c-.69-1.27-.93-2.66-1.72-3.85-.7-1-2-1.78-2.66-2.92-.55-.93-.6-2.15-1.19-3.05s-1.47-1.19-2.12-1.86c-.43-.43-.67-1.11-1.06-1.59-1.67-2-4.88-3-5-6 .68-.78 1.38.29 2.65.53.82.16 1.8-.06 2.39.13 1.2.41 2 2.29 3.31 3.32.72.58 1.66 1 2.39 1.59s1.36 1.61 2 2c.86.53 2.06.88 3.19 1.6 1.53 1 4.27 2 4.64 4 .09.49-.23 1.33-.13 1.72.18.7 1.06 1 1.59 1.59.65.74.79 1.85 1.72 2s.93-1.04 1.94-.91zM479.24 158.05c1.14.37 4.95 5 3.85 7.57a3 3 0 0 1-2.92 1.45c-2.63-.41-2.13-6.26-1.33-8.62a.66.66 0 0 1 .4-.4zM391 225.19a6 6 0 0 1 1.72-3.45c1.23-.91 2.88-.82 4.12-1.46a10.36 10.36 0 0 0 3.18-2.39c.64-.83.67-1.77 1.2-2.39.35-.42 1.16-.54 1.58-1.06s.31-1.34.94-1.85c1.84-.79 2.37 2.58 2.65 4.9a16.63 16.63 0 0 1 .4 1.86c-.2 1.06-1.36 1.27-1.73 2-.09 2.91-1.23 5.44-2.26 7.83-.88 2.06-1.39 4.32-2.12 6.1-.26.65-.82 1.15-1.06 1.72-.95 2.26-1.3 5.81-3.05 6.77a13.72 13.72 0 0 1-3.72.93 3.76 3.76 0 0 1-3.44-2.65 18.08 18.08 0 0 1-.14-2.39c-.16-1.06-.79-2-.66-3.19.29-2.7 2.92-4 3.05-6.23.11-1.69-.84-3.35-.66-5.05z" fill="#231f20"/>
                        <path d="M327.06 36.38c.15 2.23-3.4 1.95-3.85 3.85-.2.86.41 2 .27 2.79-.27 1.39-1.62 1-3.32 1.72-.87.38-1.71 1.76-2.65 1.86s-1.41-.51-2-.4c-.88.17-.58 1.24-1.86 1.46-1 .18-2.8-.91-2.92.4-.08.84 1.6 1.3 2.65 1.19.84-.08 1.45-.65 2.26-.66 1.57 0 2.59 1.17 3.58 1.2 2.28.06 4.51-2.11 6.9-1.86 1.08.11 1.72.87 2.52.79 1.28-.12 2.37-1.59 3.32-2.12-.41-2.24 0-5.18 2.12-5.31 1.43-.08 3.59 2.45 3.85 0 .11-1.06-1.14-2-2-2s-1.77 1.51-2.39.27c0-1.22 1.37-.89 2.12-1.2.57-.22 1-.83 1.59-1.06 3.16-1.11 7.54 1.09 8.76-1.59-2.8-2.39-7.57.87-10.75.66A4.36 4.36 0 0 1 331.7 34a17.23 17.23 0 0 1-.13-1.73c-.12-.84-.56-1.73-.53-2.26.13-2.39 6.1-2.84 6.1-5.83-1.14-1.09-4.48-.91-5.57.26-.39.42-.37 1.28-.93 2.13-1.19 1.81-5 2-6.24 4.24a4.83 4.83 0 0 0-.53 2.66c.32 1.25 3.13 1.59 3.19 2.91zm-31.58 129.76c-3.82-.56-7.73 1-10.35 2.12-1.51.67-3.05 1.67-4.38 1.73s-2.5-.67-3.71-.79a20 20 0 0 0-5.18.26c-1.52.27-2.9 1.36-4.24 1.46-2.58.19-5-2.32-6.64-3.58-1-.77-2-1.4-2.92-2.12s-2.27-1.25-3.05-2c-1-1-1-2.77-1.59-4.12-.65-1.58-2.61-2.74-4.11-4.24-1.13-1.13-3.7-2.8-4-4.25-.14-.74.31-1.59.26-2.39-.07-1.16-.94-1.82-.93-2.65 0-1.17 1.4-2.07 1.73-3.05.17-.51.09-1.22.26-1.86.38-1.35 1.27-2.14 1.07-4.11-.09-.79-.76-1.5-.8-2.52 0-.7.46-1.09.4-1.73-.1-1.13-1.57-1.35-1.73-2.65s1.28-2.45 2.13-4c.37-.69.58-1.73.92-2.26.75-1.13 2-1.67 2.53-2.78.41-.83.55-2 .92-2.66.49-.79 1.47-1.21 2.39-2.25.76-.85 1.07-1.88 1.59-2.26a13.91 13.91 0 0 1 2.39-.93 10.44 10.44 0 0 0 5.44-4.91c-.36-2.13.19-3 1.06-4.51s1.41-2.66 2.79-3.45c1.66-.94 3.22-1 4.38-2.78a8.3 8.3 0 0 0 1.46-3.32 3.7 3.7 0 0 0-2.52-3.19c-1.2-.19-3 .91-3.72-.39-.21-.42.08-1.4 0-1.86-.15-.87-.9-1.48-.93-2.12-.06-1.25 1.23-2.55 1.6-4 .49-2 0-3.46-.14-5.71 1.86-2.92 6-1.47 10.09-1.19.61 0 1.32-.15 2-.14 2.43.06 4.35.8 5.17-1.32a14.22 14.22 0 0 0 .4-4.51 10.37 10.37 0 0 0-2.79-3.72c-1.32-.84-3.23-.47-4-2 .61-2.62 3.55-.44 5.31-1.06.9-.32.8-1.87 1.59-2.12.55-.17 1.24.54 2 .53a13.05 13.05 0 0 0 3.58-1.6c.85-.57 1.11-1.76 1.86-2.25a10.86 10.86 0 0 1 1.73-.53 9.94 9.94 0 0 0 3.33-2.36c1.1-1.31 1.59-2.94 2.92-3.18 1.78-.33 5.8.35 6.11-1.6s-1.64-3.31-.93-5.3c.55-1.58 2-1.3 4-2.26 1 .69.69 2.65.79 3.85 1.24 0 3.74-.36 4-1.46.3-1.37-1.79-2.76-2.25-3.58s-.6-2.47-1.59-2.66c-2-.38-4 2.79-6.51 2.79a4.43 4.43 0 0 1-3.84-2.52 10.65 10.65 0 0 1-.14-2.12c-.16-1.09-.81-2.22-.53-3.72 1-1.74 3.36-2 5.05-2.92.63-.34 1.15-1.06 1.85-1.33 1.19-.43 3 0 4.12-.66.73-.42.53-1.14 1.06-2 .33-.53 1.14-.84 1.59-1.46.31-.42.35-1.07.66-1.46 1.16-1.43 3.26-2 4.11-3.45.38-.65-.65-.9-.39-1.85.43-.93 2.08-.25 3.05-.4 1.32-.21 2.54-1.81 4-2.12s3.11-.13 4.51-.67c.84-.32 1.6-1.08 2.39-1.19.28 0 1.06.15 1.46.13s1.05-.33 1.72-.4c1-.1 2.19.24 3.45.27 2.1 0 4.1-.63 5.84.13.91.4.81 1.43 2 1.86.59.21 1.38-.09 2.26 0 1.3.12 2.65 1 4.37 1.19.62.06 1.25-.07 1.86 0a31.91 31.91 0 0 1 5.84 1.86c1.55.52 4.85 1.18 4.91 2.65.07 1.75-2.87 2.26-4.11 2.26-2.09 0-4.86-1.22-7-.53 0 3 3.27 5.27 6.23 4.91.26-1.41-1.67-.63-1.46-2 1.32-1 2.91.67 4.78.39.73-.19.6-1.25.79-2 1.58-1 3.56-2.36 6-1.32a1.16 1.16 0 0 1 .54-.53c.15-1.46-1.6-2.22-.67-3.59.46-.94 2.94-.61 3.32.14.19.9-.61.8-.53 1.59a2.12 2.12 0 0 0 1.99 1.26c1.3-.07 1.56-1.23 2.79-1.85.49-.26 1.22-.28 1.85-.53s1.39-.91 2-1.07c.45-.11 1.11 0 1.73-.13.78-.17 1.61-.8 2.25-.79.81 0 1.38.92 2.39 1.06.56.07 1.19-.32 2-.4.65-.07 1.33.08 1.86 0 1.27-.18 2.14-.85 3.19-.8.74 0 2 1 2.52.53.85-.85-1.15-1.48-.53-2.25 2 .15 4.19.1 6.23.4 3 .43 5.89 1.93 8.63 2-.26-1.85-2.37-1.32-3.32-2.13a7.59 7.59 0 0 1-1.46-2.78 16.13 16.13 0 0 1 1.86-3.19c1.17-1.09 5-1.09 6.1.4.75 1 .5 2.55 1.59 2.52.94 0 1.44-2.33 2.52-2.39.9 0 1.36 1.48 2.26 1.46 1.1 0 1.86-2.07 3.32-2.12.78 0 1 .4 2.25.53.83-.53-.28-1.24.13-2 1.49-1.08 4.88-.26 6.77-.93.53-.63-.68-1.07-.13-1.72 1.63-1.15 4.38-1.25 7.16-1.73 1.71-.29 3.31-1.47 4.64-1.59s2.73.82 4 .8a7.66 7.66 0 0 0 2.39-.53c.75-.29 1.26-1 2-1.2 1.16-.28 2.63.14 4 0s2.68-.7 3.71-.53 1.74 1.18 2.65 1.33c2.8.43 5.68-.42 8.23.26.45.13.91.6 1.46.8 1.7.62 2.87.43 3.19 2.52 1.34.48 2.12 1.71 3.71 2.12 1.06.28 2.12-.13 3.32-.13a37.87 37.87 0 0 1 4.9.26c.76.12 1.39.68 2.13.8.53.09 1.24-.06 1.85 0 .84.08 1.58.42 2.26.4 1.39 0 2.44-1.28 3.58-1.46a10 10 0 0 1 2 .26c2.24.19 4.81-.29 6.64.14A13.18 13.18 0 0 1 512 9.45c.78.6 1.25 1.54 2 2a7.35 7.35 0 0 0 3.19 1.06c.85-.13.88-1.08 1.72-1.46 2.63-.58 7.3.84 9.42-.13.82-.38.66-1.25 1.33-1.73 4-.19 8 .17 11.67.27a29.9 29.9 0 0 1 3.85-.13c1.32.23 2.28 1.54 3.58 2 .87.29 2.41.14 3.72.4.88.17 1.6.7 2.25.79a18.75 18.75 0 0 0 4.12-.26c3-.25 6.95-.41 9.95.79 1.6.64 2.27 1.94 4 2.13 2.45.27 6.25-.21 8.76 0 .6.05 1.16.29 1.59.26.84-.06 1.35-.77 2.39-.79 1.31 0 3.4 2 5.31 1.72.82-.55-.66-1.33.12-1.86s1.77 0 2.93 0c.62 0 1.39-.32 2-.26 1.45.12 2.84 1.43 4.64 1.85a16.45 16.45 0 0 0 5.18.27 14.35 14.35 0 0 1 3.58-.4 17.84 17.84 0 0 1 1.72.67c.57.14 1.12 0 1.59.13s.88.53 1.33.66c2.47.71 5.75 1.06 8.36 1.86 1.54.47 3.1 1.42 4.38 1.46.63 0 1.19-.27 2-.27 4 0 8.72 1.7 8.35 5.44-4.69 1-8.61-3.23-13.53-2a2.13 2.13 0 0 0-1.59 1.86c.18 2.31 6 2.12 6.5 4.38-1 .71-2 0-2.79.13a9.8 9.8 0 0 0-4 2.12c-.89.84-1.68 3-2.65 3.19-1.18.23-3-1.17-4.78-.8-.65.14-1.28 1-1.85 1.06-1.47.28-3.33-.79-4.24.93.48 1.22.18 2.9 1.19 3.58.64.45 1.46.1 2.25.4s1.45 1.49 2.25 2.13 1.37.53 1.73 1.19c.09 1-.39 1.09-.26 1.73.2 1.11 1.94 1.36 2 2.12.06 1-1.1.75-1.33 1.72-.08.62.72.78.8 1.59 0 .55-.44 1.11-.4 1.73.06.88.76 1.47.66 2.25a2 2 0 0 1-1.2 1.46c-2.54-1.63-4.82-3.88-7.56-6s-7.23-4.77-7.69-9.28c0-.69 1.46-1.24 1.72-2.26.11-.42-.16-1-.13-1.59.1-1.56 1.38-3.06 1.33-4s-1.95-2.9-2.92-3.19c-.77.41 0 1.21-.13 1.86a2.65 2.65 0 0 1-2 1.86c-2.51.22-2.8-3.23-6.77-2.26a3.36 3.36 0 0 0-2.12 3.72c.11.58 1.7 1.2 1.59 2s-3.62 1-4.38.93c-2.14-.17-3.24-1.77-5.17-1.73-.95 0-1.78.8-2.53.93-4.17.76-10.38-2.06-11.8 1.59-.2.52-.09 1.19-.27 1.73a19.46 19.46 0 0 1-1.06 1.86c-.16.41-.13 1.21-.4 1.85s-2.75 2.85-.53 3.45c.53.15.78-.22 1.46-.13 1.14.15 3 2 4.38 2 .8 0 1.91-.9 2.52-.93 1.23-.06 2.12.74 3.05 1.2s2.26 1.36 2.92 1.32c1.25-.06.66-.93 1.86-1.32 2.29.68 3.37 3.11 5.57 5 .8.69 2 1.29 3 2.25.6.54 2.45 2 2.53 2.66s-.52.9-.67 1.46c-.22.8.29 1.4-.27 2-2.11-.79-2.59-2.87-4.11-4.65-.56-.66-1.13-1.44-2-2.39-.39-.42-1.79-1.92-2.66-1.59-1.66.64.92 3.17 1.33 3.72.88 1.17 2.05 2.74 2.13 4 .05.79-.52 2.23-.53 3.58 0 .92.23 1.75.13 2.52a16.64 16.64 0 0 1-.93 2.52c-.31 1-.38 2.14-.66 2.79a5 5 0 0 1-3.46 2.65c-1.1.05-1.57-.85-2.65-.79-1.63.07-1.93 1.58-2.91 2.78.08 1.31.49 1.76.26 2.66-.36 1.4-2.31 1.65-2.25 3s1.79 1.55 2.65 2.12a22.72 22.72 0 0 1 4.38 4c.74.95 1.8 2.71 1.72 3.71-.1 1.32-3.88 3.14-5.44 2.66s-1-1.88-1.32-3.19c-.28-1-1.06-1.43-1.46-2.25-.21-.43-.12-1.11-.4-1.59-.8-1.35-2.2-.61-3.85-1.46-1.08-.56-.77-1.73-1.2-2.79-.57-1.43-3-2.1-4.9-1.72-1.42.27-1.86 1.47-3.19 1.72-1.94-1.15.4-4-2-4.24-1.83-.2-3 2.62-4.11 3.45-.73.55-2 .66-2.12 1.45-.16 1.47 1.54 1.17 2.91 1.73s1.39 1.92 2.53 2c.94.06 1.57-1 2.52-1.06a6.55 6.55 0 0 1 4 1.19c-.66 1.61-4.23 2.79-4.24 4.91 0 1.23 1.42 1.44 2.52 2.26.93.68 2.15 2.62 3.45 4 .56.58 1.48 1 1.73 1.32.61.88.52 2 1.19 2.53.11.72-.33.9-.27 1.59.33 1 1.8.77 2.13 1.72-.27 2.29.68 4.45-1.19 5.31-.87 4.1-1.84 7.31-4.65 9.55-2.52 2-5.85 2.6-8.89 3.58-.79.26-1.42 1.09-2.12 1.33-1.77.6-4.91.24-5 2.39-.07 1.06 1.35 1.7 1.46 2.78a3.44 3.44 0 0 1-2.39 3.46c-.77.08-2.43-.46-2.52-1.86-.11-1.59 2-2.23 2.12-3.19.28-1.69-1.46-3.33-3.45-3.18-1.75.13-5.74 3.65-5.83 5.57-.08 1.44 2.84 4.43 3.84 5.31 3.73 3.28 7.68 5.25 7 13.27-.93 2-3.31 2.46-5.17 3.58-1.42.85-2.13 3.49-4.51 3.71-1-.32-.4-1.82-.67-2.52-.36-1-2.26-1.41-3.45-2.38-1-.8-1.38-2.06-2.12-2.79-.93-.92-2.32-1.11-3.45-1.73-.71-.39-1.27-1.75-2-1.72-1.17.05-.76 1.17-1.06 3.05s-1.64 3.26-1.2 5.44c.19.89 1.3 1.61 1.86 2.52.92 1.5 1 3.26 2 4.11.62.57 1.68.69 2.39 1.2 1.41 1 3.88 3.18 4.38 4.38.57 1.39 0 3 .4 4.51.44 1.7 2.66 2.91 1.33 4.64a10.68 10.68 0 0 1-3.46-1.72 10.57 10.57 0 0 1-3.84-4 12.67 12.67 0 0 1-1.07-1.59c-.46-1.19-.36-2.54-.79-4a12.28 12.28 0 0 0-2.92-4.25c-.93-.88-2.58-1.39-2.65-2.66-.1-1.78.6-3.87.53-6 0-.45-.33-.91-.4-1.45-.14-1 .1-2.27-.13-3.19a15.26 15.26 0 0 0-1.2-2.39c-.35-.76-.71-1.53-1.06-2.52-.54-1.53-1.14-4.49-2.39-4.64s-2.64 2.49-4.37 2.52a2.43 2.43 0 0 1-2.26-1.59c-.17-.82.42-1.64.4-2.52-.05-1.78-1.31-2.47-2.26-3.72-.38-.51-.48-1.22-.8-1.59-.6-.72-1.75-1.12-2.52-1.86a10.64 10.64 0 0 1-1.86-2.39c-.51-1-.67-2.38-1.45-2.52s-1.61.94-2.39 1.2a23.13 23.13 0 0 1-3.58.66c-2.67.18-4.83-.53-4.51 2.65-.42 1.43-1.93 1.45-2.92 2.12-1.27.87-2.2 2.6-3.59 4-.67.68-1.64 1.1-2.25 1.73s-.66 1.36-1.2 1.86c-1.41 1.34-3.54 1.45-4.5 3.32-.06 2.2 1 3.87.79 6-.11 1-.83 1.81-.93 2.79s.35 1.75.14 2.66c-.12.48-.66.73-1.07 1.32s-.52 1.23-.79 1.59c-.45.58-1.18 1-1.6 1.46-.67.8-.81 1.37-1.46 1.46-2.9.42-3.62-5.11-4.9-7.43-.6-1.06-1.8-2-2.39-3.31-.68-1.49-.89-3.36-1.86-5a31.75 31.75 0 0 1-2.52-4.37c-.47-1.27-.88-2.85-1.33-4.25a23.14 23.14 0 0 1-1.06-4.51c-.11-1.72.33-2.78-1.06-3.45-1.28.3-1.85 1.59-3.32 1.59s-5.22-2.45-4.11-4.64c-.93-1.32-3.26-2-5-3.58-1-.89-1.94-3-3.72-3.19a9.43 9.43 0 0 0-1.59.27c-1.12.09-3.11-.1-4.38 0a28.84 28.84 0 0 1-5.57.26c-1.3-.14-2.91-.39-4.25-.53-1.7-.17-3.95-.57-4.9-1.46-.59-.54-.83-2.28-1.86-2.52-1.23-.28-1.91.67-3.05.93-2.44.56-4.47-.5-6.11-1.59-1.16-.78-2.23-1.18-3.05-1.73-2-1.35-2.38-5.41-5.44-5.44-1.07 0-2.76.66-2.92 1.86-.1.85 1 2.41 1.46 3.05 1.49 2.1 4.22 2.89 5 5.71.55.21 1.67-.49 2.26.13.51 1.21 0 3.45 1.19 4 5.52.91 7.09-2.11 9.56-4.24 1.43.93.95 1.75 1.45 2.78a4.4 4.4 0 0 0 2.26 2.26c.67.25 1.52 0 2.52.39.63.24 3.24 2.72 3.32 3.59s-1.72 3.44-2.26 4.11-1.34 1-1.59 1.59-.13 1.43-.27 1.73c-.24.53-1.43 1.22-2.12 1.85a26.2 26.2 0 0 1-2.25 1.73c-.84.64-1.36 1.53-2.26 1.86-1.77.65-3.44.37-4.91 1.32-1 .63-1 2-2.12 2.79s-3.29.79-5 1.59c-1.13.52-1.81 1.51-2.79 1.86-.39.14-.89 0-1.33.13-.88.23-1.69.85-2.52 1.06-.65.17-1.35.09-2 .27-2 .59-3.91 2.67-6 1.46-1-2.24-1.12-5.05-2.25-7-.58-1-1.71-1.33-2.12-2.39-.06-.85 1-.62 1.05-1.33-.33-1.43-1.69-2.1-2.52-3.32-.4-.59-.59-1.44-1.06-2.12-1.58-2.3-4.7-3.5-5.31-6.37-.16-.78 0-1.39-.13-2a7.52 7.52 0 0 0-1.59-2.78c-.51-.59-1.54-1-2.12-1.86-.39-.57-.47-1.38-.8-2a22 22 0 0 0-5.31-6.37c-1.08.16-2.24.23-2.78.93a20.57 20.57 0 0 0 2.25 4.64 25.57 25.57 0 0 1 2.52 4.25c.21.55.17 1.28.4 1.86.84 2.1 3.46 2.75 4 5.17.36 1.63-.07 2.75.4 4.38s2.76 2.48 3.72 4c.77 1.22.78 2.95 1.32 4.11.8 1.7 3 2.44 4.65 3.58 1.46 1 2.5 2.62 3.71 3.72.71.64 1.69.76 1.86 1.46.22.9-.38 1.2-.53 2 1 1.06 2 3 3.71 3.18.7.07 1.59-.64 2.66-.79.54-.08 1.14.08 1.59 0 .7-.13 1.32-.76 2.12-.93 1.36-.29 2.93-.18 4.65-.4s2.73-1.58 4-1.19c1.36 1.49.38 3.19 0 4.64-.14.51-.14 1-.26 1.46-.72 2.36-2.6 4.11-3.46 6.24-.26.65-.22 1.44-.53 2.12-1 2.12-3 4.22-4.64 6a25.56 25.56 0 0 1-2.66 2.65c-.95.79-2.11 1.21-3.18 2a28.6 28.6 0 0 0-5.84 5.84c-.58.8-.86 1.72-1.46 2.39-.86 1-2.2 1.44-2.92 2.39a28.05 28.05 0 0 0-1.59 3.45c-.73 1.51-2.25 2.54-2 4.64.1.8.82 1.3 1.06 2.13a9 9 0 0 1-.13 4.11c.75 1.82 1.29 3.84 2.65 5 .17 2.68-.22 5.29 0 7.56.14 1.45.71 2.51.14 3.85a12.57 12.57 0 0 1-3.59 4c-1.25.81-3.17 1-4.51 2-.93.68-1.71 1.86-2.65 2.66-1.57 1.3-3.71 2.52-3.85 3.84-.08.76.6 1.92.79 2.65.52 2 1 4.78.14 6.9-1 2.3-5.83 1.82-6.37 4.25-.16.74.33 1.32.27 2.12a18.17 18.17 0 0 1-1.33 3.85c-.59 1.1-1.92 1.59-2.79 2.52-1.08 1.18-1.63 2.88-2.78 4.11a39.93 39.93 0 0 1-5.71 4.91 16.73 16.73 0 0 1-7.69 2.79c-1.61.11-3.34-.38-5-.13-.63.08-1.3.66-2.13.79-.48.08-1-.08-1.46 0-.83.14-1.61.81-2.38.8a4.67 4.67 0 0 1-4-4.11c0-.79.67-1.54.66-2.26s-1.05-1.91-1.86-3.45-1.08-3.16-1.86-4.37-1.91-1.91-2.52-2.93c-1.22-2-1.31-4.45-1.72-6.9-.14-.79-.68-1.66-.8-2.65-.14-1.22.15-2.57-.13-3.58a17.34 17.34 0 0 0-1.6-2.52c-.93-1.72-1.59-4-2.38-5.31s-2.26-2.56-2.39-4a20.08 20.08 0 0 1 .26-3.71c.15-.94.84-1.67 1.07-2.66.15-.65 0-1.4.13-2.12.67-3 4-4.14 3.58-7.83-.18-1.56-1.29-2.34-1.46-4.11-.08-.84.42-1.56.4-2.39 0-1.12-1-2.79-1.46-3.85-1.34-2.93-2.17-5.6-4.11-7.83-1.06-1.21-2.45-2.06-3.32-3.18a8.37 8.37 0 0 1-1.59-3.32c0-.76.58-1.23.79-2 .28-1 .3-2.83.67-4.38.17-.71.93-2.43.8-3.58a5.54 5.54 0 0 0-3.19-3.58c-1.85-.46-3.76.59-6.1.4-2.06-1.35-1.91-4.69-4.82-5.12zm73.37 47.5c.62-1 1.39-3.71 0-4.38h-.26c-.59 1.11-1.23 3.74.26 4.38zM367 185.91c.45-.92 1.5-1.89 1.33-3-.38-2.55-5.16-1.29-5.7.53-.37 1.23.21 2.21-.27 3.45.52 1 1.83 1.18 3.45 1.06.88-.44.77-1.19 1.19-2.04zm-8.09 13.67c.53-1-.84-1.61-1.06-2.65-.26-1.23.3-2.66-.8-3.32h-.39c-.98 2.17.34 5.76 2.24 5.97zm90.48-131.75c-.5-1-1.94.29-1.33 1.19.94.06 1.22-.46 1.33-1.19zm-30.92 5.44c2.16-.42 0-3.85-1.59-3.45-2.11.53.12 3.73 1.59 3.45zm-9.81 17.11c.66-4.6-2.93-4.94-3.59-8.22.31 0 .15-.38.4-.4.87-.42 2.19.67 2.65-.4 0-1.57-2-2.74-4-2-.57-.39-.65-1.29-.79-2.12-1.51-.89-5.23-2.85-5.18-4.64 0-1.48 1.95-2.31 4.12-2.26.91-.69.32-2.82-.53-3.32-3.43-.75-5.26-.24-7.44 1.33-1 .75-2.2 1.27-2.78 1.73a3.34 3.34 0 0 0-1.19 2.12c.08.82 1.25 1.3 1.72 2.39.24.56.19 1.26.4 1.72.58 1.28 2.06 2.11 3.18 3.18.79.77 3 2.41 3.05 3.32s-.68.93-.92 1.73a9.94 9.94 0 0 0-.4 3.31c.29 1.46 1.8 1.51 3.18 2.13s2.69 1.69 4.11 1.72a5.62 5.62 0 0 0 4.01-1.32zm-31.19-9.55c3.6-.65 2-3.69.14-4.77-1.38-.83-3-1.54-4.65-2.53-.93-.57-4.48-1.64-4.51-2.78s2.65-1.66 1.59-3.85c-1.81-.44-6.13.25-5.83 2.26.17 1.15 1.54.51 1.85 1.72-1.3.46-2.88 1.68-4.24 1.46-1.63-.25-2-2.25-2.92-3.45-1.26 0-2.09-1.22-3.58-1.06s-2.39 2.43-3.19 3.58c-.42.61-1.09.92-1.32 1.46-.14.33 0 .85-.13 1.33-.46 1.47-1.74 2-1.6 3.31.12 1.15 1.37 1.67 1.46 2.66-.09 1-1.72.49-1.59 1.72 2.37 2 2.51-.92 3.72-1.32 1-.33 2.87.26 4.11 0 1-.22 1.77-1.17 2.91-1.59a8 8 0 0 1 2.53-.54c4.22-.17 6.94 2.58 10.61 2.66a29.17 29.17 0 0 0 4.64-.27zM369 96.49c.08-1.43-.54-2.5-.66-4.51-2.45-1.48-4.28 1.37-6.77 1.06-1.52-.19-2.62-2-4.24-1.72-.9.13-1.34 1.28-2.26 1.45-1.9.35-2.76-1.52-4.77-.79-2.84-2.17-4.11-5.69-4.78-9.69-1.55-2-3.91-.38-5 .93-.7 0-1.57-.38-1.73.4-.52 2.45 3.47 2.71 3.45 4.38 0 1.08-1.56 1-2.25 1.72s-.25 1.49-1.2 2c-2.61.32-3.48-1.12-3.45-3.45-1.13-1.71-2.55-3-3.58-4.38a5.36 5.36 0 0 1-1.06-2.12c-.09-.62.29-1.41.13-2.12-.28-1.27-2.64-2.22-4.11-2.92a23.94 23.94 0 0 1-4.72-2.4c-.79-.66-1.16-1.81-1.86-2.25s-1.33-.3-1.86-.67c-.73-.51-.61-1.35-1.59-1.59-.5-.19-1.27.49-1.59.93-.65 2.89 1.71 3.09 2.78 4.38.74.88 1.11 2.2 1.86 2.78s1.89.51 2.92.93c.71.29 1.17 1.18 1.86 1.59 1.26.77 3.3.91 3.45 2.39-.79.54-2.58-.78-3.19.53-.15.87.69 1.31.67 2.12a2.77 2.77 0 0 1-2.77 2.53c-.13-.78.69-1.42.66-2.26 0-1.69-3.45-4.27-5.17-5-.81-.36-1.79-.38-2.52-.8a18.59 18.59 0 0 1-4.38-3.58c-.95-1.26-1.76-3.58-3.85-3.45-.85 0-1.55.83-2.25 1.2a16.75 16.75 0 0 0-2 1.06 4.73 4.73 0 0 1-2.13 1.06c-1.66.07-3.08-1.24-4.51-.93-.48.1-.88.54-1.46 1.06a20.21 20.21 0 0 1 .14 2.12c-.44.75-1.72.7-2.66 1.2a18.15 18.15 0 0 0-3.7 3.32c-.72.71-1.37 1.29-1.46 1.85s.37 1.27.26 1.86a6.24 6.24 0 0 1-2.12 2.52c-.47.32-1.09.37-1.59.66-1.05.62-1.52 1.43-2.39 1.6-2.32.43-6.53-.47-6.5 2 0 1.64 2.23 1.64 3.58 1.59 1.88-.08 3.47.4 4.51.13a17.38 17.38 0 0 0 2.25-1.33c.48-.21 1-.21 1.33-.39.8-.4 1.24-1 1.86-1.33a16.39 16.39 0 0 1 4.78-1.06c1.78-.11 3.65.18 6 0 .82-.07 1.63-.6 2.52-.67 1.44-.11 3.34.57 4.51.54.81 0 1.71-.81 2.65-.8a2.72 2.72 0 0 1 2.39 1.46c.11.39-.22 1-.13 1.59.15 1 1 1.36.93 2-.07.83-2.14 1.94-1.86 2.92.18.63 1.67 1.29 2.39 1.73a8.86 8.86 0 0 0 2.92 1.19c.75.08 1.41-.21 2.12-.13a10.36 10.36 0 0 1 3.72 1.32c1.24.88 1.07 2.29 2.52 2.79.61.21 1.72.09 2.52.27 1.93.41 3.36 2 4.77 1.85 2.22-.26 1.21-2.35 1.46-3.84.57-3.39 7.19-3.24 8.49-.94 1 .26 1.82 0 2.92.4.64.21 1.11.91 1.73 1.07.46.11 1.13-.07 1.72 0 2.55.28 4.85 2.18 7 1.85 1.38-.2 2.39-1.51 3.71-1.59 2.54-.16 4.16 1.89 6.9.93 2-.71 1.56-2.8 2.25-4.91.49-1.53 1.42-2.53 1.49-3.64zm143-45.25a4.73 4.73 0 0 0-1.33-4.51c-1.53.27-.42 1.86-.53 2.79-.15 1.32-1.54 2.23-1.46 3.58-.51.6-1.38.83-1.45 1.86.84.58 1.21-.46 1.85-1.06 1.03-.9 2.58-1.52 2.92-2.66zm-34.76-46a5.05 5.05 0 0 0-2.92 1.07c-.5.26-1.51.41-1.19 1.19 1.28-.2 3.81-.77 4.12-2.3zm-56 16.32a2.76 2.76 0 0 0 2.52-4.77c-.48-.47-2.11-.65-2.78-1.73-.82-1.29-.7-3-2.66-2.65 0 .15 0 .38-.13.4-.19 2.9 4 3.63 4 6-.03 1.19-1.33 1.28-.93 2.71z" fill="#231f20"/>
                        <path d="M377.61 16.48c-.39-1.43 2.33-1.2 1.86.14-.47.38-1.59.38-1.86-.14zM361.29 95.83c.06-1.1 2.56-1.5 3-.53-.12 1.06-2.49 1.79-3 .53zM315.78 88.66c1.38-1.12 4.46-.36 6.37-.4-.36 1-.41 2.33-1.2 2.92-2.17-.39-4.2-.93-5.17-2.52zM306.09 81.63c1.83-1.9 3.74-.9 3.06 2.78-.44 1.1-2.34 2.57-3.19.93a13.68 13.68 0 0 0 .13-3.71zM308.75 77.38a1.76 1.76 0 0 1-.93 2c-1.75-.31-.42-3.45.93-2zM283 50.45a2.24 2.24 0 0 0-1.2-2.12c-.43-.25-1.1-.14-1.59-.4-1.29-.71-1.76-2.2-2.52-2.52.1-1.46-.4-2.51 0-3.45a7.74 7.74 0 0 1 2.92-2.52c1.16-.41 2.37 0 3.05-.93a.86.86 0 0 1 .67.13c0 .84-.71 1-.8 1.72.16 1.21 2.29.46 2.52 1.6-.2 1.24-1.32 1.48-1.33 2.38s1.61 2.29 2.39 3.32c.58.77 1.6 1.34 2.12 2.13s.56 1.5.93 1.85c.7.66 2.27.77 2.39 1.73.16 1.26-1.57 1.76-1.33 3.18-1.82 1.43-4.86.69-7.83 1.06-1.34.17-2.82 1.51-4.24.4-.33-.89 1.18-1 1.33-1.85-.11-.79-1.1-.68-1.33-1.33.39-1 1.59-1.24 1.46-2.79.75-.81 2.18-.5 2.39-1.59z" fill="#231f20"/>
                        <path d="M273.06 47.26c1.77-1.08 4.87-.25 5 1.07.13 1-.94 1.13-1.33 2.25s.07 2.22-.39 2.92-1.51.57-2.26.8c-1.67.49-4.89 2.45-6.24.26.2-1.18 1.34-1.41 1.73-2.39 0-.76-.8-1.17-.67-2 .16-1 .92-.65 2-1.06.81-.29 1.15-1.23 2.16-1.85zM182.44 18.47c.28 1.18-3.49 2.72-3.85 1.2-.29-1.22 2.89-2.75 3.85-1.2zM178.06 317.53h-2a3.08 3.08 0 0 1 2 0zM172.09 9.05a.66.66 0 0 1 .8 0c-.14.32-.24.65-.8.53zM160.28 30.15c0 .73-2.64 1.94-2.92.53a1 1 0 0 1 .53-1.06c.71-.44 2.36-.19 2.39.53zM105.09 153.41c-.07.19-.2.33-.27.53-1.41-.05-.14-1.85.27-.53zM51.22 60.66c.93-.54 1.82.82 1.19 1.47-1.02.19-1.28-.98-1.19-1.47z" fill="#231f20"/>
                        <path d="M195.84 65.57c-.62-.15-1.47-.12-2.26-.26s-1.48-.32-2.12-.4c-1.64-.19-3.41.28-4.38-.66a42.81 42.81 0 0 1 5.71-6c.6-.54 1.9-.91 1.59-2-1.13-1-2.52.06-3.58.66a12 12 0 0 1-3.72 1.72c-2.19.33-5.1-.64-6.9.53-.24 1 2 .62 1.73 2.13a2.68 2.68 0 0 1-2.39-.4c-.62-.56-.27-1.39-.66-1.73-.68-.56-3.24-.71-4.38-.53a3.09 3.09 0 0 0-2.79 2.26c1.67.78 4.44-.81 5 1.2-.92 1.65-3.08 2.56-2.79 4.77a3 3 0 0 0 1.9 2.14c.74.13 1.15-.6 1.86-.53s.58.93 1.46.8c1.28-.55 2-2.34 3.45-2.26 1.75 2.13-1.59 3.17-3.45 3.85-2.12.77-4.88 1.18-6.5 1.86-.85.36-4.06 3.46-4.51 1.06-.33-1.73 1.59-1.23 2-2.66-2.06-.39-4 .89-5.84 1.6-2.67 1-7.18 1.65-7.83 4.64-.13.6.26 1.73-.13 2.12s-2.22.38-3.05.67c-1.28.44-2.4 1.37-3.19 1.59-.59.16-1.48.12-1.85.27-1.06.41-1.45 1.83-2.66 2.78-.49.39-1.59.67-2 1.06-.68.69-.77 2.4-2 2.66-.77.06-1.39-.58-2.12-.14-.09 1.7.59 4-.13 5.71a36.29 36.29 0 0 1-5.31 3.34c-1.11.62-2.11.78-3.45 1.46-.95.47-1.82 1.61-2.92 2.25-2.53 1.49-5.59 3.26-5.57 7 0 .82.42 1.7.53 2.66.06.56-.07 1.11 0 1.72.16 1.39 1.16 3.16 0 4.11-1.79-.73-4.06-1-5.31-2.25-.34-1.31.69-2.39.53-3.58-.12-1-1.47-2.67-2.25-2.79s-1.56.73-2.39.66c-1-.07-1.91-1.44-3.19-1.59-1.86-.22-3.24.43-5.3.14-2 1.07-2.59 3-5 2.78-.87-.06-1.66-.72-2.66-.93a17.17 17.17 0 0 0-3.85-.53c-2.25.15-3.89 1.78-5.83 2.79-1.71.89-4.14 2-4.65 3.85-.27 1 0 2.39-.39 3.31a16.47 16.47 0 0 1-1.07 1.73c-1.48 2.71-2.72 6.31-1.59 10.22a24.36 24.36 0 0 0 2.23 4.57 7.33 7.33 0 0 0 3.84 1.85 17.23 17.23 0 0 0 3.06-.66 30.72 30.72 0 0 0 3.45-.53c2.86-.92 2.3-4.8 5.17-6.11a13.69 13.69 0 0 1 4.91-.79 3 3 0 0 1 .93 2.52c-.07.68-.72 1.29-1.06 2.25s-.37 1.84-.67 2.53c-.39.89-1.27 1.55-1.59 2.39-.21.54-.09 1.22-.26 1.72-.31.87-1.48 1.49-.93 2.39 2.84 1.13 6.27-.32 8.75.13 1 .19 3.21 1.44 3.19 3.05 0 1.21-.93 2-1.07 3.32-.16 1.66-.85 3.7-.92 5-.12 2.2 3.23 6 5.57 6 2.52 0 4-2.51 7-1.19 1 .43 2.08 2.07 3.19 2 .92-.07 2.3-1.68 2.92-2.79.74-1.36.8-2.5 2.12-3.18s2.55-.38 4.38-1.07a10.69 10.69 0 0 0 2.25-1.32c.64-.44 1.32-1.6 2.13-.8 1.05 1.06-1.3 1.66-.4 2.79 1.84 1 2.78-1.81 4.11-1.86a9.29 9.29 0 0 1 2.65 1.33c1 .68 1.39 1.63 2.52 1.86.73.14 1.9-.28 2.92-.14 1.36.2 2.16 1.36 3.19 1.33 1.25 0 1.85-1.4 2.92-1.59 2.34-.43 3.21.26 4.24 1.72 1.16.2 1.2-1.33 2.26-.79-.58 1.15.19 1.69.66 2.65.3.62.25 1.06.53 1.33.64.6 1.86.6 2.79 1.19s1.53 1.76 2.65 3.05 3.1 2.69 4.64 2.79 2.65-.42 3.85-.27c2.75.34 4.45 1.71 6.37 3.19 1.08.82 2 1.4 2.39 2.38.24.69.12 1.62.4 2.39.58 1.66 3 2.45 2.12 5.31.4.84 1.3 1.14 2.26 1.73.77.47 1.42 1.45 2.25 1.59a11.07 11.07 0 0 0 1.59-.14 12.28 12.28 0 0 1 3.85 1.2 15.85 15.85 0 0 1 2.39.8c.68.45.76 2 1.59 2.38.55.27 1.75-.1 2.66 0 1.42.17 3.35 1 4.64 1.07.78 0 1.43-.32 2.12-.27 3.25.25 5.09 4.14 8.23 5.31 1 .36 2.51.11 3.18.4 1.18.51 2.17 4.1 2.26 5.7.27 4.82-3.44 6.37-5.57 9.55-.45.67-.7 1.73-1.33 2.66-1.27 1.87-2.69 2.26-2.52 5.7.05.95.53 1.87.53 2.92a19 19 0 0 1-.4 4.12c-.22.87-.94 1.59-1.06 2.39s.24 1.43.13 2.12a12.47 12.47 0 0 1-1.46 2.91c-1.22 2.27-1.49 4.93-4 5.84-1.46.54-3.44.24-5 .8-.64.23-1.46.82-2.26 1.19-2.3 1.08-5.6 2.53-6.23 4.91-.57 2.12.79 3.82.4 6.24a21.13 21.13 0 0 1-1.59 2.25c-.58.76-.86 1.64-1.46 2.39-.8 1-2 1.44-2.52 2.79-.17.46-.06 1-.27 1.72-.08.27-.57.68-.8 1.19s-.2 1.08-.4 1.47c-.6 1.22-2.4 4-3.71 4.38-2.76.77-5.66-1.17-7.56-.8.27 1.33 1.24 1.19 1.86 2.12a14.31 14.31 0 0 0 1.06 1.86c.59.69 1.12.94 1.19 1.72a4.71 4.71 0 0 1-2 3.85 11.94 11.94 0 0 1-3.85 1.06c-1 .17-3.51.18-4 .8-.68.92.36 3.2-.13 4.11-1 1.94-3.66-.05-5 .53a2.54 2.54 0 0 0 1.06 2.52c.83.49 2.1-.15 2.65.8-.27 1.32-1.69 1.49-2 2.79 0 1.26.43 1.6.27 2.38-.35 1.71-3 1.64-2.92 3.45.11 2.72 5.21 1.61 5.31 4.25 0 1.6-1.46 1.62-2 3.18-.29.84.16 1 0 1.73-.22.94-1.33 1.21-1.33 2.25 0 1.27 1.86 2.67 2.78 3.72a15 15 0 0 0 3.32 3.18c1.86 1 4.64.8 5.44 2.66-.25 1.11-1.33 1.41-2.39 1.72h-.26a3.08 3.08 0 0 0-2 0h-1.86c-1.77-.82-3.93-1.35-6.1-2.12-.79-.28-1.67-.94-2.52-1.32-.64-.3-1.36-.41-1.86-.67-1.14-.6-2.43-2.54-3.58-3.32-.7-.47-1.8-.72-2.26-1.19a21.84 21.84 0 0 1-1.06-2c-.43-.61-1.22-1.06-1.73-1.73-1.1-1.46-2.5-3.43-2.51-4.51s1-1.78.66-2.78-2.36-.74-2.66-1.86c-.17-.68.59-1.82.53-2.79 0-.55-1.07-1.32-.66-2.12s1.37.07 2.13-.4c-.57-1.91 0-5-1.86-5.57-1 .82 1 2.67-.67 3.18-1.6-.71-1.23-2.82-1.59-4.38a16.85 16.85 0 0 1-.79-3c0-.58.22-1.25.13-1.85-.28-1.79-2.27-3.25-2.39-5.05-.06-.86.53-1.59.66-2.52.1-.62-.09-1.33 0-2 .12-.84.59-1.61.67-2.38a21.31 21.31 0 0 0-.27-5.18c-.33-1.53-1.54-2.84-1.72-4.51-.07-.6.2-1.61.13-2.39s-.46-1.43-.53-2.26a15.66 15.66 0 0 1 .26-2.38c.15-1.67-.32-3.53-.26-5.18 0-.49.27-.85.26-1.32 0-1.37-.47-2.75-.53-4.12-.1-2.52.28-4.3-.13-6.63-.31-1.76-.69-4.47-1.33-5.57s-3.5-3.33-4.9-4.12c-.93-.51-2-.69-3.06-1.19-2.16-1.06-6.35-3.3-7.29-5.44-.28-.62-.24-1.44-.54-2.12-.57-1.36-1.79-2.54-2.65-3.85-1.64-2.51-3-5.64-4.64-8.23a34 34 0 0 0-2.52-3.84c-.55-.62-2.3-1.2-2.52-2.13-.3-1.23-1.21-2.91-1.07-3.85.2-1.27 2.66-2.29 2.66-3.44 0-1-1.32-1.56-1.59-2.39-.67-2 .39-3.22 1.19-4.91a17.57 17.57 0 0 1 .8-1.86c.48-.73 1.47-.94 2.12-1.73.36-.44.59-1.36 1.06-2 1-1.34 2.64-1.84 3-3.05a25.07 25.07 0 0 0 .13-7.56c-.23-.95-1.12-1.75-1.45-2.65-.6-1.61-.74-3.35-2.39-3.32-1 0-1.74 1.15-2.39 1.86-.16.94-.08 2-1.06 2.25-1.51.45-2.09-1.59-3.85-2.12-.7-.21-1.82-.2-2.26-.4-1.28-.58-1.69-2.46-3-3.19-1.13-.6-2.1-.39-2.79-1.32a10.73 10.73 0 0 1-.13-2.66c-1.45-.85-2.68-4-4.38-4.77-1.12-.5-2.84-.45-4.24-.93A17.1 17.1 0 0 0 93 148a11.24 11.24 0 0 1-2.39-.53c-2.62-1.31-4-5.53-7.29-5.44-1.39 0-2.73 1.33-4 1.32s-3.35-1-4.91-1.72-3.44-1.17-4.78-1.86c-1.08-.55-1.84-1.57-2.79-2-.72-.32-1.79-.38-2.38-.66a26.54 26.54 0 0 1-2.79-2c-1-.7-2.08-1.76-2.12-2.65s1-1.93 1.06-2.93c.34-3.16-2-5.43-3.45-7.29-1.09-1.39-2.36-2.57-3.45-3.85a9.63 9.63 0 0 0 0-1.86 25.25 25.25 0 0 1-2.39-3.18c-.79-1.08-2.32-2.24-2.52-3.45-.24-1.49.57-2.8 0-4.25-.94-2.4-4.28-1.32-3.85 1.86.12.88 1.35 2 1.73 2.92s.3 2 .66 3 1.37 1.9 1.73 3c.56 1.82.54 3.78 1.06 4.91s2.13 2 1.19 3.19c-1.26.26-1.74-1-2.52-1.73-.43-.41-2-1.18-2.25-2.12-.21-.78.49-1.83.26-2.79-.46-1.87-4.23-1.92-4.25-3.84 0-1.21 1.58-1.36 1.6-2.53s-1.75-2.36-2.13-3.45a20.44 20.44 0 0 1-.53-4 24.89 24.89 0 0 0-.26-3.85 6.35 6.35 0 0 0-2.52-2.65c-1.17-.65-2.09-.38-2.66-1.33a11.06 11.06 0 0 1-.93-3.44c-.19-1.6 0-3.34-.13-5a25.51 25.51 0 0 1 0-5.17c.66-1.28 1.85-1.92 2.52-3.19.47-.88.54-2 1.06-2.91 1-1.74 3.09-3.34 4.51-5A23.45 23.45 0 0 0 47 65.84c.32-.75 1.19-2.4 1.06-3.32-.17-1.28-2.58-2.33-2.39-3.85.13-.94 1.47-.92 1.86-1.85a9.27 9.27 0 0 0 .4-2.39c0-1.28-.65-2.61-.4-4 .22-1.17 2-1.64 1.07-2.92s-2.48.68-3.46-.13.19-1.67.27-3.06c0-.55-.32-1.18-.27-1.59.09-.59 1.24-1.59.93-2-.71-.9-1.52-3.21-3-4-2-1-4.05-.32-6.76-.79-1.67-.3-2.45-1.85-4-1.73-.95.08-1.49 1.16-2.79 1.73s-3 .37-4.25.66-1.93 1.21-3.27 1.11c-1.1-.08-1.1-1.07-2.39-1.19a20.19 20.19 0 0 0-2.25.4 31.12 31.12 0 0 1-7.83-.14 22.32 22.32 0 0 1-5.18-2C2.81 34.06-.12 33.16 0 32c.08-.74 2.78-1.53 3.85-1.85 1.73-.53 2.79-1.38 4.12-1.46.5 0 1.17.31 1.85.27s1.52-.68 2.39-.8c1.85-.26 4.47.09 4.24-1.73-1.4-1.11-7.14.83-7.29-1.59-.09-1.46 2.18-1.9 3.85-2.25a24.85 24.85 0 0 1 5.17-.8c1.52.08 3.51 1.77 4.38-.13.42-1.35-.52-2.49-.8-3.59 1.13-1.55 3.2-1.36 4.78-1.59a19.26 19.26 0 0 0 5-1.32 19.33 19.33 0 0 1 5-1.33c1.8-.24 3.55-.92 5.18-1.06a37.11 37.11 0 0 0 3.84-.27c1.14-.22 2.34-.85 3.59-.79.83 0 1.55.64 2.39.79s1.68 0 2.52.14c.64.13 1.21.56 1.85.66 1 .15 2.09-.14 3.06 0s1.65.68 2.52.79c2 .27 4.38-.1 6.37.27.75.14 1.43.51 2.25.66s1.63 0 2.39.14c1 .21 1.94 1.2 3 1.32 2.05.22 4.36-.89 6.5-1.06a39.13 39.13 0 0 0 4.78-.26 29.62 29.62 0 0 1 4.24-.93c.73 0 1.33.22 2 .13s1.52-.92 2.26-.8c1 .16.81 1.41 1.86 1.73 1.15-.6 2.31 0 3.58 0s2.35-.61 3.72-.4c2.41.38 5.79 2.74 7.69 1.46.48-.32.36-.88.8-1.72.58-1.15 1.74-2.49 1.46-4.12-2.66 0-5.2 1.34-8.23 1.46-3.06-1.91.82-3.1 3-4 1.84-.72 3.3-2.33 5.58-2.65 1.85-.27 3.89.41 6.1.66 1.28.15 2.57-.09 3.31.13 1.31.39 2 1.68 3.06 2 .46.14 1.23.12 1.85.27 1.2.28 2.26.91 3.45 0 .94.17 1 1.16 2 1.33.88-.48 1.56-1.69 2.92-2 .59-.14 1.21.1 1.86 0 1.08-.18 2.52-1.64 3.18-.27-.27 1-1.71 1.1-2.52 1.86s-1.81 2.22-1.72 2.92c.16 1.26 2.05.77 2.12 2.39-.28.92-1.36.51-2.25.92s-1.13 1.17-2 1.33c-2.41.46-4.41-.61-6.49-.53-.1.91 1 1.43 1.59 1.72 1.89 1 3.43.86 6.1.8 1.36 0 2.94.41 4.11-.4.75-.51.71-1.63 1.33-2.25a5.08 5.08 0 0 1 3.58-1.33c.6.1 1.45.82 1.46 1.33 0 1.2-1.7.82-1.72 2.12 1.12.67 4.08-.74 4.24-1.86.12-.82-1-1.29-.93-2.12.07-1.39 2-1.37 1.73-2.79-.91-.71-1.86.16-2.79 0-1.3-.21-2.48-1.78-3.05-2.78.57-.72 1.78-.24 2.65-.13 1-1.36 2.79-1.88 5.31-2.13.89-.09 2.09-.44 2.52.4.22 1.26-1.86 2-1.46 3.45 1.79.45 2.37-2 3.85-2.92a14.82 14.82 0 0 1 2.52-1.06c.82-.31 1.72-1.08 2.39-1.06s.86.62 1.59.93 1.51-.19 1.73.66c-1.54 2.66-7.27 1.13-8.76 3.85.33 1.82-.9 3.55.13 4.77.74.88 2.4.28 2.79 1.2.52 1.22-1.61 1.22-1.06 2.65 1.4.84 3.07-.8 4.37-1.46s3.16-1.54 3.32-3.18c-.7-1.35-3.31-.31-3.71-1.73-.22-.77.8-2.49 1.06-2.78 1.38-1.55 6.21-3.76 9.68-3.45.66.06 1.33.46 2 .53 2.28.23 5-1 6.77 0 1.44-.84 3.17.11 5.17-.14 1.55.92 1.12 2.86 3.46 3.72.63.23 1.42.07 2.25.26.62.15 1.28.88 2 1.2 1 .46 1.78.35 2 1.06s-.73 1.14-.66 1.86c.57.47.09 1.18.4 1.86.57 1.22 2 1.13 3.44 1.72 1 .41 3.15 1.68 3.06 2.65-.07.66-2 1.81-2.66 2.13-.45.22-2.69 1.3-3.45 1.19-1.25-.18-1.74-2.72-3.45-2.65a1.42 1.42 0 0 0-1.46 1.46c0 1.74 1.95 1.81 2 3.32.06 1.8-1 1.92-2.52 3a10.88 10.88 0 0 0-3.45-1.19c-.85 1 1.4 1.37.67 2.66-2.14.45-3.76-.61-5.71-1.2a10.78 10.78 0 0 1-2-.4c-.75-.43-1-1.72-1.59-2.38a5.48 5.48 0 0 0-3.32-1.86c-1.64 0-4 2-5.31.13.9-3 5.16-.78 8-1.86 1.05-.4 1.41-1.5 2.26-2 1.72-1 4.51-1.11 4.25-3.05-.13-1-1.5-1-2.26-1.46-1-.68-1.83-3.07-3.31-3.18-.77-.06-1.32.58-2.13.66-1.71.16-3.62-.69-5.17 0-.72.41-.24 1.07-.8 1.86s-1.55.82-2 1.46-.4 1.67-1.06 2.25c-1.09 1-3.39 1.12-4.78 1.59-.61.21-1.39.94-2 .94-1.09 0-1.56-1.48-2.78-.94-.11 1.42 1.5 2 2.52 2.66s2.26 1.42 2.65 2.65c-1.08 2.29-2.8-.12-4.51-.13-1.88 0-4.63 3.59-6.23.66.39-1.54 2.1-1.79 2.51-3.31-1.87.32-3.5 1.89-5.7 2.39-.93.2-1.83.15-2.65.39-1.59.47-2.7 1.64-4.38 2.26-.66.24-1.44.17-2.12.39a36.07 36.07 0 0 0-5.18 2.39 30.3 30.3 0 0 0-4.64 2.79c-.57.49-2 2.23-2 2.79.07.79 1.55 1.05 1.59 1.85 0 .49-.86 1.55-.26 2.26s1.63.12 2.78.26c2 .26 3.35 1.93 4.91 2.79a13.42 13.42 0 0 0 4.25 1.59c1.82.23 3.86-.53 4.11.93s-1.72 1.91-1.86 2.79c1 1.3-.67 1.92-.66 3a2.88 2.88 0 0 0 2.12 2.39c1.34.11 3.29-1.32 3.85-2.66.66-1.59.38-3.75 1.59-4.9 6.18.17 11.41-2.81 11-9.16a8.61 8.61 0 0 1-.26-2.12c.19-1 2-1.89 1.72-3.19 1.73-.53 1.66-3.31 3.45-3.71 1.5-.34 3.2 1.06 5.17.93.65 0 1.48-.62 2.13-.53 1.3.18 2.08 1.78 3.05 2.52s1.77.45 2 1.32c-.26 1.49-1.3 1.53-1.2 2.92a2.88 2.88 0 0 0 2 2.26 6.32 6.32 0 0 0 3.31-.8c1.78-.84 3.3-3.37 4.78-3.05 1.17.26 2.08 4 2.25 5.31a37 37 0 0 1-.13 3.85c.18 2.24 3 2 4.38 3.18.42.36.58 1.26.93 1.73.67.89 1.49.89 1.59 1.85.25 2.29-2.07 2.49-1.86 5-.48 1-1.69.94-1.59 2.26.16 2.09 3.16.49 4 2.12.44.88-.07 1.53-.4 2.79 1 1.22 1 3.18-.79 3.18-1 .13-1.26-1.02-2.42-1.3zM52.41 62.13c.63-.65-.26-2-1.19-1.47-.09.49.17 1.66 1.19 1.47zM145 74.2c-.55-.54-2.35-.39-3.58-.27-.87.09-1.9.27-2 .93 1.41.63 5.17 1.14 5.58-.66zm-6.9-2.26a1.62 1.62 0 0 0-.53-2.78c-.43-.12-1 .32-1.72.26s-1.5-.74-2.12-.79a3.19 3.19 0 0 0-2.53.92c0 .8.59.92.54 1.73-1.29.92-.61 4 .66 4.11s2-3.4 3.84-3.71c.68-.12 1.01.37 1.88.26zm-1.86 5.31c-1.88-.67-3.62.46-5.17.66-.92.13-2.6-.18-2.39 1.2.17 1.12 1.91.71 2.92.39a12.55 12.55 0 0 0 4.66-2.25zm-5.83-10.09c2.64-1.12-.52-4.59-1.73-4.9-2.15-.57-5.21 1.57-7.69 2.25-1.4.38-2.74.42-3.06 1.6 1.26 2.07 3.74-.46 5.58-.14.92.17 1.47 1.44 2.39 1.59a27.09 27.09 0 0 0 4.53-.4zm-1.86 2.13c-.55-.65-3.53.08-4.38.66-.59.41-1 1.4-1.59 2.13s-1.33 1.33-1.86 2-3.16 4.46-1.06 4.91c.9.18 2.74-1.68 2.92-2.39a7.94 7.94 0 0 1 3.58-5.31c1.11-.67 2.23-.59 2.41-2zM112 54.43c1.48 0 2.49-4.43 0-3.85-1.68.42-2.08 3.92 0 3.85zm-7.16 99.51c.07-.2.2-.34.27-.53-.43-1.32-1.7.48-.29.53zM48.7 42.89c0-.25-.15-.3-.13-.54-.41 0-.88-.07-.8.4a.55.55 0 0 0 .93.14zm139.44-20.84c.66.08 1-.12.93-.79-.59-.42-1.45.13-.93.79zm-15.25-13a.66.66 0 0 0-.8 0v.53c.56.12.66-.21.8-.53zm-50.42 10.22c.44-.29 1.12-.67.79-1.33-1.46-.68-3.94-.16-6.1-.4-1.23-1.73-3.28-2-3.45.8 2.47 2.01 6.21-.93 8.76.93zM98.72 32.94c.75-.27 1.8-.13 2-.94-.62-.49-1.26-1.16-2-1.19-1 0-1.43.82-2.39 1.33-1.12.59-2.68.74-2.79 1.72 2.06.41 3.91-.49 5.18-.92zm-.67-9.56c.85-.14 1.72.24 2.26-.53-.63-2.92-4.67-1.13-7-.93A6.73 6.73 0 0 0 92 24.58c1.78.42 4-.85 6.05-1.2zM137.86 159c1-.17.74-2.58-.53-2-.96.43-.47 2.14.53 2z" fill="#231f20"/>
                        <path d="M48.57 42.35c0 .24.16.29.13.54a.55.55 0 0 1-.93-.14c-.08-.47.39-.4.8-.4zM44.59 50.18a2.87 2.87 0 0 1-1.86 1.6 3.54 3.54 0 0 1-.67-.67c.06-1.26 1.85-2.18 2.53-.93z" fill="#231f20"/>
                    </svg>
                </div>
            </div>
        </div>
    </div>
</div>
{/if}

{include file="$template/includes/generate-password.tpl"}

{$footeroutput}
</body>
</html>