<?php

if (!defined("WHMCS"))
	die("This file cannot be accessed directly");

$reportdata["title"] = "Cumulative Server Income Forecasts";
$reportdata["description"] = "<p>The graph shows the cumulative income (revenue-expenses).</p><p>The report shows revenue (not including expenses) broken down by billing cycle for each of your servers.  It then uses the monthly cost entered for each server to estimate the annual gross profit (income) for each server.</p>";

$reportdata["tableheadings"] = array("Server Income","Monthly","Quarterly","Semi-Annual","Annual","Biennial","Triennial","Monthly Costs","Annual Gross Profit");

$currency = getCurrency('','1');

$query = "SELECT * FROM tblservers WHERE disabled=0 ORDER BY name ASC";
$result=mysql_query($query);
while ($data = mysql_fetch_array($result)) {
	$id = $data["id"];
	$name = $data["name"];
	$monthlycost = $data["monthlycost"];
	$monthly = $quarterly = $semiannually = $annually = $biennially = $triennially = 0;
	$query2 = "SELECT tblhosting.*,tblhosting.amount/tblcurrencies.rate AS reportamt FROM tblhosting INNER JOIN tblclients ON tblclients.id=tblhosting.userid INNER JOIN tblcurrencies ON tblcurrencies.id=tblclients.currency WHERE server='$id' AND (domainstatus='Active' OR domainstatus='Suspended') AND billingcycle!='Free Account' AND billingcycle!='One Time'";
	$result2=mysql_query($query2);
	while($data = mysql_fetch_array($result2)){
		$amount = $data["reportamt"];
		$billingcycle = $data["billingcycle"];
		if($billingcycle=="Monthly"){
			$monthly+=$amount;
		}elseif($billingcycle=="Quarterly"){
			$quarterly+=$amount;
		}elseif($billingcycle=="Semi-Annually"){
			$semiannually+=$amount;
		}elseif($billingcycle=="Annually"){
			$annually+=$amount;
		}elseif($billingcycle=="Biennially"){
			$biennially+=$amount;
		}elseif($billingcycle=="Triennially"){
			$triennially+=$amount;
		}
	}
	$monthly=number_format($monthly,2,".","");
	$quarterly=number_format($quarterly,2,".","");
	$semiannually=number_format($semiannually,2,".","");
	$annually=number_format($annually,2,".","");
	$biennially=number_format($biennially,2,".","");
    $triennially=number_format($triennially,2,".","");
	$totalserverincome=($monthly*12)+($quarterly*4)+($semiannually*2)+$annually+($biennially/2)+($triennially/3);
	$totalserverexpenditure=$monthlycost*12;
	$servertotal=number_format(($totalserverincome-$totalserverexpenditure),2,".","");
	$totalincome+=$totalserverincome;
	$totalexpenditure+=$totalserverexpenditure;
	$totalgrossprofit+=$servertotal;
	$reportdata["tablevalues"][] = array("$name",formatCurrency($monthly),formatCurrency($quarterly),formatCurrency($semiannually),formatCurrency($annually),formatCurrency($biennially),formatCurrency($triennially),formatCurrency($monthlycost),formatCurrency($servertotal));

}


$totalincome=formatCurrency($totalincome);
$totalexpenditure=formatCurrency($totalexpenditure);
$totalgrossprofit=formatCurrency($totalgrossprofit);

$data["footertext"]="<B>Total Income:</B> $totalincome<br><B>Total Expenses:</B> $totalexpenditure</br><B>Gross Profit:</B> $totalgrossprofit";






$months = array('January','February','March','April','May','June','July','August','September','October','November','December');

$chartdata['cols'][] = array('label'=>'Month','type'=>'string');

$query = "SELECT * FROM tblservers WHERE disabled=0 ORDER BY name ASC";
$result=mysql_query($query);
while ($data1 = mysql_fetch_array($result)) 
{
	$serverid=$data1["id"];
	$servername=$data1["name"];
	$servers[]=$servername;
	$servermonthlycost = $data1["monthlycost"];

	$query2 = "SELECT tblhosting.*,tblhosting.amount/tblcurrencies.rate AS reportamt FROM tblhosting INNER JOIN tblclients ON tblclients.id=tblhosting.userid INNER JOIN tblcurrencies ON tblcurrencies.id=tblclients.currency WHERE server='$serverid' AND (domainstatus='Active' OR domainstatus='Suspended') AND billingcycle!='Free Account' AND billingcycle!='One Time'";
	$result2=mysql_query($query2);
	while ($data = mysql_fetch_array($result2)) {
		$recurringamount = $data["amount"];
		$nextduedate = $data["nextduedate"];
		$billingcycle = $data["billingcycle"];
		$nextduedate = explode("-",$nextduedate);
		$year = $nextduedate[0];
		$month = $nextduedate[1];
		if ($billingcycle=="Monthly") {
			$recurrence = 1;
		} elseif ($billingcycle=="Quarterly") {
			$recurrence = 3;
		} elseif ($billingcycle=="Semi-Annually") {
			$recurrence = 6;
		} elseif ($billingcycle=="Annually") {
			$recurrence = 12;
		} elseif ($billingcycle=="Biennially") {
			$recurrence = 24;
		} else {
			$recurrence = 24;
		}
		$recurrences = 24/$recurrence;
		for ($i=0;$i<=24;$i+=$recurrence) {
			$new_time = mktime(0,0,0,$month+$i,1,$year);
			$totals[date("Y",$new_time)][date("m",$new_time)][$recurrence] += $recurringamount;
		}
	}
	
	
	for ($i=0;$i<=24;$i++) {
	    $new_time = mktime(0,0,0,date("m")+$i,1,date("Y"));
	    $months_array[date("Y",$new_time)][date("m",$new_time)] = "x";
	}

	$overallincome = 0;

	foreach ($months_array AS $year=>$month) {
	    foreach ($month AS $mon=>$x) {
	        $monthlyincome = $totals[$year][$mon][1]+$totals[$year][$mon][3]+$totals[$year][$mon][6]+$totals[$year][$mon][12]+$totals[$year][$mon][24];
			$monthlyincome -= $servermonthlycost;
	        $overallincome += $monthlyincome;
	        
	        ${$servername}[$months[$mon-1]." ".$year]['monthlyincome']=$monthlyincome;
	        ${$servername}[$months[$mon-1]." ".$year]['overallincome']=$overallincome;
	    }
	}
	
	
	$chartdata['cols'][] = array('label'=>$servername.' Revenue Forecast Total','type'=>'number');
}


foreach ($months_array AS $year=>$month)
{
    foreach ($month AS $mon=>$x)
    {
		$sv=array();
		$sv=array(array('v'=>$months[$mon-1]." ".$year));
		foreach ($servers as $serv)
		{
        	$monthlyincome=${$serv}[$months[$mon-1]." ".$year]['monthlyincome'];
        	$overallincome=${$serv}[$months[$mon-1]." ".$year]['overallincome'];
    		//$sv[]=array('v'=>$monthlyincome,'f'=>formatCurrency($monthlyincome)); // Non-Cumulative
    		$sv[]=array('v'=>$overallincome,'f'=>formatCurrency($overallincome)); // Cumulative 
        }
                
	    $chartdata['rows'][] = array('c'=>$sv);

    }
}

#$args['colors'] = '#80D044,#F9D88C,#CC0000';

$reportdata["headertext"] = $chart->drawChart('Area',$chartdata,$args,'450px');

?>