<?php
function validate_ip($ip_addr) {
	if (preg_match("/^(\d{1,3})\.(\d{1,3})\.(\d{1,3})\.(\d{1,3})$/", $ip_addr)) {
		$parts=explode(".",$ip_addr);
		foreach ($parts as $ip_parts) {
			if (intval($ip_parts) > 255 || intval($ip_parts) < 0) {
				return false;
			}
		}
		return true;
	} else {
		return false;
	}
}

function excecute_whm_csf_command($url, $whmuser, $whmauth, $authmethod) {
	$curl = curl_init();
	curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, 0);
	curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, 0);
	curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
	if ($authmethod == "basic") {
		$authstr = 'Authorization: Basic ' . base64_encode($whmuser .':'. $whmauth) . "\r\n";
	} else {
		$authstr = 'Authorization: WHM ' . $whmuser . ':' . $whmauth . "\r\n";
	}
	$header[0] = $authstr;
	curl_setopt($curl, CURLOPT_HTTPHEADER, $header);
	curl_setopt($curl, CURLOPT_URL, $url);
	$r = curl_exec($curl);
	if ($r == false) {
		error_log("curl_exec threw error \"" . curl_error($curl) . "\" for $url");
	}
	curl_close($curl);
	return $r;
}

function search_for_ip($ip, $url, $whmuser, $whmauth, $authmethod) {
    $reason = "";
	$query_url = $url.'?action=grep&ip='.$ip;
	$data = excecute_whm_csf_command($query_url, $whmuser, $whmauth, $authmethod);
	$matches = array();
	$pattern = '/<p><pre style=\'font-family: Courier New, Courier; font-size: 12px\'>(.*?)<\/p>/s';
	preg_match($pattern, $data, $matches);
	$pattern = '/Temporary Blocks/';
	if (preg_match($pattern, $matches[1]) > 0) {
	  $pattern = '/\((.*)\)/s';
  	  preg_match($pattern, $matches[1], $matches);
  	  $reason = trim($matches[1]);
	}
	else {
	
	  // First check for a reason, if no reason is found check to see if the unblock link was displayed which indicates a block was found.
	  
	  $pattern = '/\#(.*)/s';
  	  preg_match($pattern, $matches[1], $matches);
  	  
  	  if (!isset($matches[1])){
	     $pattern = '/action=kill&ip='.$ip.'(.*)/s';  
	     preg_match($pattern, $data, $matches);
	     if (isset($matches[1])) {
	       $reason = "Unknown";
	     }
  	  }
  	  else {
	    $reason = trim($matches[1]);
  	  }
  	  
	}
	
	return $reason;		
}

function number_of_recent_unblocks($whmcs_client_id, $unblock_interval) {
  $query = "select id from tblactivitylog WHERE userid = " . $whmcs_client_id ." AND (date between DATE_SUB(now(), interval ". $unblock_interval ." minute) and now()) and description LIKE '%Unblocked the IP Address%'";
  $result = mysql_query($query);
  return mysql_num_rows($result);
}

function process_request($ip,$whmcs_client_id, $max_recent_blocks, $unblock_interval, $from_hook, $vars, $unblock = true) {

	$errors = "";
	$alerts = "";
	$unblocked_ip = false;
	$lang_file = $vars['_lang'];
	
	if (!validate_ip($ip)) {
	  $smartyvalues['errors'] = $lang_file["invalid_ip"];
	  return $smartyvalues;
	}
	
	
	if (number_of_recent_unblocks($whmcs_client_id, $unblock_interval) < $max_recent_blocks) {
		$query = "SELECT DISTINCT(s.ipaddress), s.username, s.password, s.accesshash, s.secure, s.name, s.type
					FROM tblservers s, tblhosting h
					WHERE s.id = h.server AND h.userid = $whmcs_client_id AND (s.type = 'cpanel' or s.type = 'directadmin') and h.domainstatus = 'Active'";
		$mysql_data = mysql_query($query);
		
		while ($server = mysql_fetch_array($mysql_data)) {
		
			$srv_ip = $server[0];
			$srv_user = $server[1];
			$srv_pass = $server[2];
			$srv_hash = $server[3];
			$srv_secure = $server[4];
			$srv_type = $server['type'];
			
			$auth_valid = false;
			if ($srv_hash) {
				$authhash = preg_replace("'(\r|\n)'","",$srv_hash);
				$authmethod = "accesshash";
				$auth_valid = true;
			} elseif ($srv_pass) {
				$authmethod = "basic";
				$authhash = decrypt($srv_pass);
				$auth_valid = true;
			} else {
				$errors = $errors . $lang_file['cannot_connect']. " ". $server["name"];
			}
			
			if ($srv_secure) {
	          if ($srv_type == "directadmin") {
	            $url = "https://$srv_ip:2222/CMD_PLUGINS_ADMIN/csf/index.html";
	          }
	          else {	    
	            $url = "https://$srv_ip:2087/cgi/configserver/csf.cgi";
	          }
			} else {
	          if ($srv_type == "directadmin") {
	            $url = "http://$srv_ip:2222/CMD_PLUGINS_ADMIN/csf/index.html";
	          }
	          else {	    
	            $url = "http://$srv_ip:2086/cgi/configserver/csf.cgi";
	          }
	        }
			
			if ($auth_valid) {
				$reason = search_for_ip($ip, $url, $srv_user, $authhash, $authmethod, $vars);
      	        if($vars['option4'] == "on" && strpos($reason,"do not delete") !== false) {
			      $errors = $errors . $lang_file['cannot_unblock'] .$ip . $lang_file['from'] . $server["name"] . $lang_file['contact_support'];
	            }
                else {
					if ($reason != "" && $unblock) {
	                  if ($srv_user != "root" && $srv_type == 'cpanel') {
				        $query_url = $url.'?action=qkill&ip='.$ip;  
				        $data = excecute_whm_csf_command($query_url, $srv_user, $authhash, $authmethod);
				        if (!preg_match('/Unblock '.$ip.'/s', $data)) {
				          $query_url = $url.'?action=kill&ip='.$ip;
					      $data = excecute_whm_csf_command($query_url, $srv_user, $authhash, $authmethod);
               	        }
			          }
			          else {
					    $query_url = $url.'?action=kill&ip='.$ip;
					    $data = excecute_whm_csf_command($query_url, $srv_user, $authhash, $authmethod);
					  }
					  

					  $alerts = $alerts . $lang_file['ip_was_removed'] . $server["name"] . "<br>" . $lang_file['reason']. $reason . "<br>";
			          logActivity("Unblocked the IP Address " . $ip . " from " . $server["name"] . " - User ID: ".$whmcs_client_id);
			          $unblocked_ip = true;
			        }
			        else {
			          if (!$from_hook && $reason == "") {
			            $alerts = $alerts . $lang_file['no_block_found']. $server["name"] . "<br>";
			          }
			          elseif($reason != "") {
				         $alerts = $alerts . $lang_file['ip_was_found'] . $server["name"] . "<br>" . $lang_file['reason']. $reason . "<br>";
			          }
			        }
		          }
	        }		
	    }		
    }
    else {
      $unblocked_ip = true;
	  $errors = $lang_file['max_unblocks'] . $unblock_interval . $lang_file['max_unblocks2'];
    }
	

	$smartyvalues["errors"] = $errors;
	$smartyvalues["alerts"] = $alerts;
	$smartyvalues["unblocked_ip"] = $unblocked_ip;
	  
	return $smartyvalues;
}
?>
