<?php

/**
 * 
 * SagePay Web Service API using Soap 
 * 
 * PHP version 5 
 * LICENSE: This source file is subject to version 3.01 of the PHP license
 * that is available through the world-wide-web at the following URI:
 * http://www.php.net/license/3_01.txt.  If you did not receive a copy of
 * the PHP License and are unable to obtain it through the web, please
 * send a note to license@php.net so we can mail you a copy immediately.
 *
 * @category   Class/Object based Request API for SagePay 
 * @package    API Intregraton
 * @author     Amanpreet Singh <anmoldeep8333@gmail.com>,<newsparktechnology@gmail.com> 
 * @version    SVN: $Id$
 * @link       http://www.newsparktechnology.com
 */
Class SAGEPAYDEBIT {
# SagePay Electronic Credentials 

    var $Username;
    var $Password;
    var $PIN;
    private $_Username;
    private $_Password;
    private $_Pin;
    public $returncode = array(
        '0' => 'Validation Successful',
        '1' => 'Invalid Branch Code',
        '2' => 'Validation Failed',
        '3' => 'Invalid Account Type',
        '4' => 'Input Data Incorrect',
        'Failed' => 'Authentication Error.Please Contact to Adminstrator',
        '200' => 'Error in Web Service.Please Contact to Adminstrator'
    );

    public function __construct($username, $password, $pin) {
        if (!$username || empty($username)) {

            $this->lastresponse = array('result' => 'error', 'Username Required !!');
        }
        if (!$password || empty($password)) {
            $this->lastresponse = array('result' => 'error', 'Password Required !!');
        }
        if (!$pin || empty($pin)) {
            $this->lastresponse = array('result' => 'error', 'Password Required !!');
        }

        $this->_Username = $username;
        $this->_Password = $password;
        $this->_Pin = $pin;
    }

    public function _do_soap_request($wsdl, $action, $api_params) {
        $soapClient = new SoapClient($wsdl, array("trace" => 1, 'soap_version' => SOAP_1_1, 'style' => SOAP_DOCUMENT, 'encoding' => SOAP_LITERAL));
        $commanparams = array('Username' => $this->_Username, 'Password' => $this->_Password, 'Pin' => $this->_Pin);
        $params = array_merge($api_params, $commanparams);
        try {
            $info = $soapClient->__call($action, array($params));
        } catch (SoapFault $fault) {
            $error = 1;
            $message = $fault->faultstring;
        }
        if ($error) {
            return array('result' => 'error', 'message' => $message);
        }
        return $info;
    }

    public function uploadBatch($params) {
        $soap = new SoapClient("http://www.netcash.co.za/netserv/ncUpload/service.asmx?wsdl", array("trace" => 1, 'soap_version' => SOAP_1_1, 'style' => SOAP_DOCUMENT, 'encoding' => SOAP_LITERAL));

        unset($request);
        $request = new SAGEPAYDEBIT();
        $request->Username = $params['Username'];
        $request->Password = $params['Password'];
        $request->PIN = $params['Pin'];
        $request->FileContents = $params['FileContents'];
// Send the request 
        $result = $soap->UploadBatchFile($request);
        return $result;
    }

}

?>