function reloadPage() {location.reload(true);}

(function ($) {
    $.fn.googlefonts = function (font) {
        $('head').append('<link href="https://fonts.googleapis.com/css?family=' + font.replace(/ /gi, '+') + ':400,700" rel="stylesheet" type="text/css">');
        $(this).css('font-family', font);
        return this;
    };
})(jQuery);

$(document).ready(function () {
    // GENERAL SETTINGS
    // Company Logo
    $('#logo-path').keyup(function () {
        $('#preview-logo').attr('src', '../' + $(this).val());
    });
    // Template Layout
    $('#width-slider').slider({
        range: 'min',
        value: $('#width-slider-amount').data('default-value').replace('px', ''),
        min: 480,
        max: 1920,
        step: 10,
        slide: function (event, element) {
            $('#width-slider-amount').text(element.value + 'px');
        }
    });
    // COLOR SETUP
    // Page Background
    preview('#page-background-picker', '.page-background-preview, .accordion-content .nav-bar-preview, #footer-preview', 'background');
    // Header Background
    preview('#header-background-picker', '.header-background-preview', 'background-color');
    preview('#header-border-picker', '.header-background-preview', 'border-bottom-color');
    preview('#header-text-picker', '.header-background-preview a.link3', 'color');
    // Content Background
    preview('#content-background-picker', '.content-background-preview, .accordion-content .dropdown-menu-preview, .accordion-content .form-elements-preview, .accordion-content .links-preview, .accordion-content #text-sample', 'background-color');
    preview('#content-border-picker', '.content-background-preview', 'border-color');
    // Footer
    preview('#footer-text-picker', '.footer-preview', 'color');
    // Navigation Bar
    preview('#nav-bar-background-picker', '.nav-bar-preview .navbar', 'background-color');
    preview('#nav-bar-text-picker', '.nav-bar-preview ul li a.link1', 'color');
    previewHover('#nav-bar-text-picker', '#nav-bar-hover-picker', '.nav-bar-preview ul li a.link1', 'color');
    // Dropdown Menu
    preview('#dropdown-menu-background-picker', '.dropdown-menu-preview ul ul li a.link2', 'background-color');
    previewHover('#dropdown-menu-background-picker', '#dropdown-menu-bghover-picker', '.dropdown-menu-preview ul ul li a.link2', 'background-color');
    preview('#dropdown-menu-text-picker', '.dropdown-menu-preview ul ul li a.link2', 'color');
    previewHover('#dropdown-menu-text-picker', '#dropdown-menu-hover-picker', '.dropdown-menu-preview ul ul li a.link2', 'color');
    // Boxed Content #1
    preview('#boxed-content1-background-picker', '.boxed-content1-preview', 'background-color');
    preview('#boxed-content1-text-picker', '.boxed-content1-preview', 'color');
    // Boxed Content #2
    preview('#boxed-content2-background-picker', '.boxed-content2-preview', 'background-color');
    preview('#boxed-content2-text-picker', '.boxed-content2-preview', 'color');
    // Boxed Content #3
    preview('#boxed-content3-background-picker', '.boxed-content3-preview', 'background-color');
    preview('#boxed-content3-text-picker', '.boxed-content3-preview', 'color');
    previewHover('#boxed-content4-background-picker', '#boxed-content3-background-picker', '.selectboxit-options li a:hover', 'background-color');
    // Boxed Content #4
    preview('#boxed-content4-background-picker', '.boxed-content4-preview, .selectboxit-option-anchor', 'background-color');
    preview('#boxed-content4-text-picker', '.boxed-content4-preview, .selectboxit-option-anchor', 'color');
    // Input & Textarea
    preview('#form-elements-background-picker', '.form-elements-preview input', 'background-color');
    preview('#form-elements-border-picker', '.form-elements-preview input', 'border-color');
    previewHover('#form-elements-border-picker', '#form-elements-bhover-picker', '#form-elements-preview input', 'border-color');
    $('#form-elements-shadowhover-picker').minicolors({
        opacity: true,
    });
    $('.form-elements-preview input').focusin(function () {
        $(this).css('border', '1px solid ' + $('#form-elements-bhover-picker').minicolors('rgbaString').replace('NaN', '1'));
		$(this).css('box-shadow', '0 0 6px ' + $('#form-elements-shadowhover-picker').minicolors('rgbaString').replace('NaN', '1'));
    });
	$('.form-elements-preview input').focusout(function () {
        $(this).css('border', '1px solid ' + $('#form-elements-border-picker').minicolors('rgbaString').replace('NaN', '1'));
		$(this).css('box-shadow', 'none');
    });
    preview('#form-elements-text-picker', '.form-elements-preview input', 'color');
    // Links
    preview('#links-text-picker', '.links-preview a', 'color');
    previewHover('#links-text-picker', '#links-texthover-picker', '.links-preview a', 'color');
    // Button #1
    preview('#button1-background-picker', '.button1-preview', 'background-color');
    previewHover('#button1-background-picker', '#button1-bghover-picker', '.button1-preview', 'background-color');
    preview('#button1-text-picker', '.button1-preview', 'color');
    // Button #2
    preview('#button2-background-picker', '.button2-preview', 'background-color');
    previewHover('#button2-background-picker', '#button2-bghover-picker', '.button2-preview', 'background-color');
    preview('#button2-text-picker', '.button2-preview', 'color');
    // Button #3
    preview('#button3-background-picker', '.button3-preview', 'background-color');
    previewHover('#button3-background-picker', '#button3-bghover-picker', '.button3-preview', 'background-color');
    preview('#button3-text-picker', '.button3-preview', 'color');
	// Table Title
    preview('#table-title-background-picker', '.table-title-preview', 'background-color');
    preview('#table-title-border-picker', '.table-title-preview, .table-preview', 'border-color');
	preview('#table-title-text-picker', '.table-title-preview h3', 'color');
	// Table Content
    preview('#table-th-background-picker', '.table-preview th', 'background-color');
	preview('#table-th-text-picker', '.table-preview th a', 'color');
	preview('#table-td-background-picker', '.table-preview td', 'background-color');
	preview('#table-td-text-picker', '.table-preview td', 'color');
    // TYPOGRAPHY
    // Heading 1
    $('#heading1-font').change(function () {
        $('.text-h1-sample').googlefonts($(this).val());
    });
    $('#heading1-slider').slider({
        range: 'min',
        min: 10,
        max: 40,
        slide: function (event, element) {
            $('#heading1-slider-amount').text(element.value + 'px');
            $('.text-h1-sample').css('font-size', element.value + 'px');
        }
    });
    preview('#heading1-text-picker', '.text-h1-sample', 'color');
    // Heading 2
    $('#heading2-font').change(function () {
        $('.text-h2-sample').googlefonts($(this).val());
    });
    $('#heading2-slider').slider({
        range: 'min',
        min: 10,
        max: 40,
        slide: function (event, element) {
            $('#heading2-slider-amount').text(element.value + 'px');
            $('.text-h2-sample').css('font-size', element.value + 'px');
        }
    });
    preview('#heading2-text-picker', '.text-h2-sample', 'color');
    // Heading 3
    $('#heading3-font').change(function () {
        $('.text-h3-sample').googlefonts($(this).val());
    });
    $('#heading3-slider').slider({
        range: 'min',
        min: 10,
        max: 40,
        slide: function (event, element) {
            $('#heading3-slider-amount').text(element.value + 'px');
            $('.text-h3-sample').css('font-size', element.value + 'px');
        }
    });
    preview('#heading3-text-picker', '.text-h3-sample', 'color');
    // Body Text
    $('#body-font').change(function () {
        $('.text-p-sample').googlefonts($(this).val());
    });
    $('#body-slider').slider({
        range: 'min',
        min: 10,
        max: 40,
        slide: function (event, element) {
            $('#body-slider-amount').text(element.value + 'px');
            $('.text-p-sample').css('font-size', element.value + 'px');
			$('.text-p-sample-nocolor').css('font-size', element.value + 'px');
        }
    });
    preview('#body-text-picker', '.text-p-sample', 'color');
    // POST NEW
    $('#save-button').click(function () {
        var values = {};
        $('[data-variable]').each(function (index) {
            var name = $(this).data('variable');
            var value;
            if ($(this).data('variable').match(/^rgb/)) {
                value = $(this).minicolors('rgbaString').replace('NaN', '1')
            } else if ($(this).data('variable').match(/^px/)) {
                value = $(this).text();
            } else if ($(this).data('variable').match(/^url/)) {
                value = $(this).val();
            } else if ($(this).data('variable').match(/^f/)) {
                value = $(this).val();
            } else {
                value = $(this).val();
            }
            if (value != '' && value != '""') {
                values[name] = value;
            }
        });
        console.log(values);
		
		if ($('#fluid').is(':checked')) {
			values['layoutType'] = 'fluid'; 
		} else {
			values['layoutType'] = 'fixed'; 
		}
        console.log(values);

        $.post('addonmodules.php?module=flexeditor', values, reloadPage);
    });
    // POST DEFAULT
    $('#default-button').click(function () {
        var values = {};
        $('[data-default-value]').each(function (index) {
            var name = $(this).data('variable');
            var value;
            value = $(this).data('default-value');
            if (value != '' && value != '""') {
                values[name] = value;
            }
			values['layoutType'] = 'fixed';
        });
        console.log(values);
        $.post('addonmodules.php?module=flexeditor', values, reloadPage);
    });
});

function preview(picker, preview, style) {
    $(picker).minicolors({
        opacity: true,
        change: function (hex, opacity) {
            $(preview).css(style, $(this).minicolors('rgbaString').replace('NaN', '1'));
        }
    });
}
function previewHover(pickerNormal, pickerHover, preview, style) {
    $(pickerHover).minicolors({
        opacity: true,
    });
    $(preview).hover(

    function () {
        $(this).css(style, $(pickerHover).minicolors('rgbaString').replace('NaN', '1'));
    },

    function () {
        $(preview).css(style, $(pickerNormal).minicolors('rgbaString').replace('NaN', '1'));
    });
}