<?php

/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */

/**
 *
 * BusyRack development team.
 *
 * LICENSE: This source file is subject to BusyRack Development license
 * that is available through the world-wide-web at the following URI:
 * http://www.busyrack.com/license.txt  If you did not receive a copy of
 * the License and are unable to obtain it through the web, please send
 * a note to license@busyrack.com so we can mail you a copy immediately.
 *
 * @category   WHMCS Addon
 * @package    Enhanced Support System
 * @author     Tom Tran <tom@busyrack.com>
 * @author     BusyRack Dev Team <dev@busyrack.com>
 * @copyright  2013 The BusyRack Development Team
 * @license    http://www.busyrack.com/license.txt BusyRack License
 * @version    CVS: $Id:$
 * @link       http://dev.busyrack.com
 * @see        <Other Modules>
 * @since      File available since Release 1.0
 * @deprecated <File deprecated in Release ?>
 */

/**
 * BUGS:
 */

if (!defined("WHMCS"))
        die("This file cannot be accessed directly");

/* BEGIN: WHMCS Addon Module Interface */
if (!function_exists('br_enhanced_support_config')) {
    function br_enhanced_support_copyright() {
        $config = br_enhanced_support_config();
        return '
        <div style="text-align:center;background-color:#ffffff;">
        '.(isset($config['name']) ? $config['name'].' - ' : '').'
        Developed by <a style="text-decoration: none;"
        title="BusyRack - Software Services for Hosting Industry"
        href="http://www.busyrack.com"><span
        style="font-family:ubuntu,Arial,Helvetica;
        font-weight:bold;color:#055576;">busy</span><span
        style="font-family: ubuntu, Arial, Helvetica;
        font-weight: bold; color: #d9740a;">rack</span><span
        style="font-family:ubuntu,Arial,Helvetica; font-size: 60%;
        color: #3d7533;">.com</span></a>
        Copyright &copy; 2012-'.date('Y').'. All rights reserved.
        </div>
        ';
    }

    function br_enhanced_support_config() {
        $configArray = array(
            'name' => 'Enhanced Support System',
            'description' => 'Enhanced Support System brings better WHMCS internal Support System',
            'version' => '1.4',
            'author' => 'BusyRack Dev Team <dev@busyrack.com>',
            'fields' => array(
            ),
        );
        return $configArray;
    }

    function br_enhanced_support_activate() {
        $result = true;
        $config = br_enhanced_support_config();
        if ($result) {
            return array(
                'status' => 'success',
                'description' => $config['name'].' has been activated.',
            );
        } else {
            return array(
                'status' => 'error',
                'description' => $config['name'].' has failed to activated.',
            );
        }
    }

    function br_enhanced_support_deactivate() {
        $result = true;
        $config = br_enhanced_support_config();
        if ($result) {
            return array(
                'status' => 'success',
                'description' => $config['name'].' has been de-activated.',
            );
        } else {
            return array(
                'status' => 'error',
                'description' => $config['name'].' has failed to de-activated.',
            );
        }
    }

    function br_enhanced_support_output($vars) {
        $sql = "SELECT * FROM `tblconfiguration` WHERE `setting`='br_enhanced_support'";
        $settings = array();
        if ($result = mysql_query($sql)) {
            if (mysql_num_rows($result) == 0) {
                $sql = "INSERT INTO `tblconfiguration`(`setting`,`value`) VALUES('br_enhanced_support', '')";
                mysql_query($sql);
            } else if ($row = mysql_fetch_array($result)) {
                $settings = unserialize($row['value']);
            }
        }

        if (isset($_POST['btnSubmit'])) {
            /* Saving the settings */
            $settings[$_SESSION['adminid']]['subscribe_tickets'] = $_POST['subscribe_tickets'];
            $sql = "UPDATE `tblconfiguration` SET `value`='".serialize($settings)."' WHERE `setting`='br_enhanced_support'";
            mysql_query($sql);
        }

        $setting = $settings[$_SESSION['adminid']];
        echo '
        <h2>Advanced Settings:</h2>
        <form action="" method="POST">
            <label>
                <input type="checkbox" name="subscribe_tickets" value="yes" '
                .((isset($setting['subscribe_tickets']) && ($setting['subscribe_tickets']=='yes'))?'checked="checked"':'')
                .'/>
                Send me emails when other admin users reply to tickets.
            </label>
        <div style="text-align:center;margin:auto;">
            <input type="submit" name="btnSubmit" value="Save" class="btn btn-primary"/>
        </div>
        </form>

        <h2>Installation</h2>
        README.txt:<br/>
        <textarea style="width:100%; height:500px;">'
        .htmlentities(@file_get_contents(dirname(__FILE__).'/README.txt'))
        .'</textarea>';
        echo br_enhanced_support_copyright();
    }

    function br_enhanced_support_hook_adminareapage($vars) {
        $out = array();
        if ( ($vars['filename'] == 'supporttickets')
        ||   ($vars['filename'] == 'supportcenter') ) {
            $table = 'tbltickets';
            foreach ($vars['ticketdepts'] as $dept) {
                $out['bz_ticketcounts'][$dept['id']]['bz_all'] = 0;
                foreach ($vars['ticketstatuses'] as $status) {
                    $fields = 'COUNT(`id`) as num_tickets';
                    $where = array(
                        'did' => intval($dept['id']),
                        'status' => $status['title'],
                    );
                    if ($result = select_query($table, $fields, $where)) {
                        if ($row = mysql_fetch_array($result)) {
                            $out['bz_ticketcounts'][$dept['id']][$status['title']] = $row['num_tickets'];
                            $out['bz_ticketcounts'][$dept['id']]['bz_all'] += $row['num_tickets'];
                        }
                    }
                }
            }
        }
        return $out;
    }

    function br_enhanced_support_hook_ticketadminreply($vars) {
        $sql = "SELECT * FROM `tblconfiguration` WHERE `setting`='br_enhanced_support'";
        $settings = array();
        if ($result = mysql_query($sql)) {
            if ($row = mysql_fetch_array($result)) {
                $settings = unserialize($row['value']);
            }
        }

        foreach ($settings as $adminid=>$setting) {
            /* If this ticket is in a department that this adminid is allowed to access */
            $depts = array();
            $email = '';
            $name  = '';
            $admin = '';
            $sql = "SELECT * FROM `tbladmins` WHERE `id`='".$adminid."'";
            if ($result = mysql_query($sql)) {
                if ($row = mysql_fetch_array($result)) {
                    $depts = explode(",", $row['supportdepts']);
                    $email = $row['email'];
                    $admin = $row['username'];
                    $name = $row['firstname'].' '.$row['lastname'];
                }
            }
            if ($adminid == $_SESSION['adminid']) continue;

            if (($setting['subscribe_tickets'] == 'yes') && in_array($vars['deptid'], $depts)) {
                /* send email */
                if ($email != '') {
                    br_enhanced_support_send_email($name, $email, $vars);
                }
            }
        }
        return;
    }

    function br_enhanced_support_send_email($name, $email, $vars) {
        if (!class_exists('PHPMailer')) {
            include_once(ROOTDIR.'includes/classes/class.phpmailer.php');
        }

        include_once(ROOTDIR.'/configuration.php');
        global $customadminpath;
        $sql = "SELECT * FROM `tblconfiguration` WHERE `setting`='SystemURL'";
        if ($result = mysql_query($sql)) {
            if ($row = mysql_fetch_array($result)) {
                define('WHMCS_URL', $row['value']);
                if (isset($customadminpath)) {
                    define('ADMIN_AREA', $row['value'].$customadminpath);
                } else {
                    define('ADMIN_AREA', $row['value']."admin");
                }
            }
        }
        if (!defined('ADMIN_AREA')) define('ADMIN_AREA', '');
        if (!defined('WHMCS_URL')) die('No SystemURL.');

        $subject = '[Ticket ID: '.$vars['ticketid'].'] New Ticket Admin Reply';
        $mailto  = "$name <$email>";
        $ticket_url = ADMIN_AREA."/supporttickets.php?action=viewticket&id=".$vars['ticketid'];

        $content = @file_get_contents(dirname(__FILE__).'/email.tpl');
        $content = str_replace("{name}", $name, $content);
        $content = str_replace("{ticketid}", $vars['ticketid'], $content);
        $content = str_replace("{deptname}", $vars['deptname'], $content);
        $content = str_replace("{subject}", $vars['subject'], $content);
        $content = str_replace("{message}", $vars['message'], $content);
        $content = str_replace("{priority}", $vars['priority'], $content);
        $content = str_replace("{admin}", $vars['admin'], $content);
        $content = str_replace("{status}", $vars['status'], $content);
        $content = str_replace("{ticket_url}", $ticket_url, $content);

        $sql = "SELECT `setting`,`value` FROM `tblconfiguration` WHERE `setting` IN
        ('SystemEmailsFromName','SystemEmailsFromEmail','MailType','SMTPHost','SMTPUsername','SMTPPassword','SMTPPort','SMTPSSL');";
        if ($result = mysql_query($sql)) {
            while ($row = mysql_fetch_array($result)) {
                if ($row['setting'] == 'MailType') $mailType = $row['value'];
                if ($row['setting'] == 'SMTPHost') $smtpHost = $row['value'];
                if ($row['setting'] == 'SMTPUsername') $smtpUsername = $row['value'];
                if ($row['setting'] == 'SMTPPassword') $smtpPassword = $row['value'];
                if ($row['setting'] == 'SMTPPort') $smtpPort = $row['value'];
                if ($row['setting'] == 'SMTPSSL') $smtpSSL = $row['value'];
                if ($row['setting'] == 'SystemEmailsFromName') $emailFromName = $row['value'];
                if ($row['setting'] == 'SystemEmailsFromEmail') $emailFromAddress = $row['value'];
            }
        }

        $mail = new PHPMailer();
        $mail->SetFrom($emailFromAddress, $emailFromName);
        $mail->AddReplyTo($emailFromAddress, $emailFromName);
        $mail->Subject = $subject;
        $mail->Body = $content;
        $mail->AddAddress($email, $name);

        if ($mailType == 'smtp') {
            /* SMTP */
            $mail->IsSMTP();
            $mail->Host = $smtpHost;
            $mail->Port = $smtpPort;
            $mail->SMTPAuth = true;
            $mail->SMTPSecure = $smtpSSL;
            $mail->Username = $smtpUsername;
            $mail->Password = $smtpPassword;
        }
        $mail->Send();
    }
}

/* END  : WHMCS Addon Module Interface */

