(function($) {

	$.jbm = {
		init: function(serviceid) {

			$.jbm.options = {
				serviceid: serviceid,
				api: 'modules/addons/backupmanager/api.php',
				alertBox: $("<div />"),
			};

			$.jbm.options.alertBox.addClass("alert text-center").hide();

			$('.tab-content').first().before($.jbm.options.alertBox);

			$.jbm.ajax({
				data: {
					action: "permissions"
				},
				success: function(response) {

					$.jbm.options.permissions = response.data;

					if($.jbm.options.permissions['backupmanager']['acl'] == '0')
					{
						$('div[menuitemname=Service Details Backups]').remove();
					}

					$.each(types, function(type_key, type_name) {

						if($.jbm.options.permissions['backupmanager']['acl'] == '0' || $.jbm.options.permissions['backupmanager']['sub'][type_key]['acl'] == '0')
						{
							$('#Primary_Sidebar-Service_Details_Backups-' + type_key).remove();
							$('#tab' + type_name.replace(' ', '')).remove();
						}
					});

					$.jbm.load.backups();
					$.jbm.load.queue();
				},
				error: function(response) {

					$('#jbmSidebar').html('<div class="alert alert-danger text-center" style="margin-top: 20px;">Unable to load account permissions</div>');

					$.each(types, function(type_key, type_name) {

						$('#Primary_Sidebar-Service_Details_Backups-' + type_key).remove();
						$('#tab' + type_name.replace(' ', '')).remove();
					});

					$.jbm.message({
						success: false,
						message: response.message
					});
				}
			});
		},
		download: {
			download: function(options) {

				options = $.extend({ type: '', id: 0 }, options);
				window.location = $.jbm.options.api + '?serviceid=' + $.jbm.options.serviceid + '&action=download&type=' + options.type + '&id=' + options.id;
			},
			generate: function(options) {

				options = $.extend({ type: '', id: 0, callback: function() {} }, options);

				$.jbm.ajax({
					data: {
						action: "createdownload",
						type: options.type,
						id: options.id
					},
					success: function(response) {

						options.callback();

						$.jbm.message({
							success: true,
							message: response.message
						});
					},
					error: function(response) {
		
						options.callback();

						$.jbm.message({
							success: false,
							message: response.message
						});
					}
				});
			},
			validate: function(options) {

				options = $.extend({ type: '', id: 0 }, options);

				$('#backupOptions' + options.type + options.id + ', #queueOptions' + options.type + options.id).hide();
				$('#backupOptionsLoader' + options.type + options.id + ', #queueOptionsLoader' + options.type + options.id).show();

				$.jbm.download.check({
					type: options.type, 
					id: options.id,
					success: function(response) {

						$('#backupOptions' + options.type + options.id + ', #queueOptions' + options.type + options.id).show();
						$('#backupOptionsLoader' + options.type + options.id + ', #queueOptionsLoader' + options.type + options.id).hide();

						if(response.data.ready)
						{
							$.jbm.download.download({ type: options.type, id: options.id });
						}
						else
						{
							$.jbm.message({
								success: true,
								message: 'Download isn\'t ready'
							});
						}
					},
					error: function() {

						$.jbm.download.generate({
							type: options.type, 
							id: options.id, 
							callback: function() {

								$('#backupOptions' + options.type + options.id + ', #queueOptions' + options.type + options.id).show();
								$('#backupOptionsLoader' + options.type + options.id + ', #queueOptionsLoader' + options.type + options.id).hide();
							}
						});
					}
				});
			},
			check: function(options) {

				options = $.extend({ type: '', id: 0, success: function() {}, error: function() {} }, options);

				$.jbm.ajax({
					data: {
						action: "checkdownload",
						type: options.type,
						id: options.id
					},
					success: function(response) {
						options.success(response);
					},
					error: function() {
						options.error();
					}
				});
			},
			remove: function(options) {

				options = $.extend({ type: '', id: 0 }, options);

				$('#queueOptions' + options.type + options.id).hide();
				$('#queueOptionsLoader' + options.type + options.id).show();

				$.jnm.ajax({
					data: {
						action: "removedownload",
						type: options.type,
						id: options.id
					},
					success: function(response) {

						$('#queueOptions' + options.type + options.id).parent().remove();
					},
					error: function(response) {

						$.jbm.message({
							success: true,
							message: response.message
						});
					}
				});

			}
		},
		restore: {
			set: function(options) {

				options = $.extend({ type: '', id: 0 }, options);

				$('#backupOptions' + options.type + options.id + ', #queueOptions' + options.type + options.id).hide();
				$('#backupOptionsLoader' + options.type + options.id + ', #queueOptionsLoader' + options.type + options.id).show();

				$.jbm.ajax({
					data: {
						action: "restoreset",
						type: options.type,
						id: options.id
					},
					success: function(response) {

						$('#backupOptions' + options.type + options.id + ', #queueOptions' + options.type + options.id).show();
						$('#backupOptionsLoader' + options.type + options.id + ', #queueOptionsLoader' + options.type + options.id).hide();

						$.jbm.message({
							success: true,
							message: response.message
						});
					},
					error: function(response) {

						$('#backupOptions' + options.type + options.id + ', #queueOptions' + options.type + options.id).show();
						$('#backupOptionsLoader' + options.type + options.id + ', #queueOptionsLoader' + options.type + options.id).hide();

						$.jbm.message({
							success: false,
							message: response.message
						});
					}
				});
			},
			status: function(options) {

				options = $.extend({ queue_id: 0 }, options);

				$.jbm.ajax({
					data: {
						action: "restorestatus",
						queue_id: options.queue_id
					},
					success: function(response) {

						if(response.data.status != 'pending')
						{
							$("#restoreQueue" + options.queue_id + " .progress").show();
							$("#restoreQueue" + options.queue_id + " .restorecancel").remove();
							$("#restoreQueue" + options.queue_id + " .restorecancelloader").remove();
							$("#restoreQueue" + options.queue_id + " .progress-bar-msg span").css({ color: '#' + (response.data.status == 'completed' ? "118d00" : "CC0000") }).html(response.message.replace(/ /g, '&nbsp;'));
							$("#restoreQueue" + options.queue_id + " .progress-bar").animate({ width: response.data.progress + "%" }, 500);
							$("#restoreQueue" + options.queue_id + " .progress-bar-text").html(response.data.progress + '%');
						}

						if(!response.data.stop)
						{
							setTimeout(function() { $.jbm.restore.status({ queue_id: options.queue_id }); }, 5000);
						}
					}
				});
			},
			cancel: function(options) {

				options = $.extend({ queue_id: 0 }, options);

				$("#restoreQueue" + options.queue_id + " .restorecancel").hide();
				$("#restoreQueue" + options.queue_id + " .restorecancelloader").show();

				$.jbm.ajax({
					data: {
						action: "restorecancel",
						queue_id: options.queue_id
					},
					success: function(response) {
						$("#restoreQueue" + options.queue_id).parent().remove();
					},
					error: function(response) {
						$("#restoreQueue" + response.queue_id + " .restorecancel").show();
						$("#restoreQueue" + response.queue_id + " .restorecancelloader").hide();
					}
				});
			}
		},
		load: {
			queue: function() {

				$.jbm.ajax({
					data: {
						action: "queue"
					},
					success: function(response) {

						var totalQueue = 0;

						if(response.data.download.success)
						{
							$.each(response.data.download.data, function(i, queue_details) {

								totalQueue++;

								var row = "<tr>";
								row += "<td>" + queue_details.date.replace(/ /g, '&nbsp;') + "</td>";
								row += "<td>";

								if(queue_details.extra_id != '0')
								{
									row += "Download&nbsp;" + types[queue_details.extra_details.type].replace(/ /g, '&nbsp;') + "&nbsp;Backup";
								}
								else if(queue_details.filemanager)
								{
									row += "Download&nbsp;Files&nbsp;Backup";
								}
								else
								{
									row += "Download&nbsp;Full&nbsp;Backup";
								}

								type = (queue_details.extra_id != '0' ? queue_details.extra_details.type : 'full');

								row += "</td>";
								row += "<td style=\"text-align: center;\" id=\"downloadQueue" + queue_details.id + "\">";

								if(queue_details.ready != '0')
								{
									if(queue_details.filemanager)
									{
										row += "Ready to Download (cPanel only)";
									}
									else
									{
										row += "<div id=\"queueOptions" + type + (type == 'full' ? queue_details.backup_id : queue_details.extra_id) + "\">";

										row += "<button class=\"btn btn-default btn-sm downloadbackup\" type=\"button\" onclick=\"$.jbm.download.validate({ type: '" + type + "', id: " + (type == 'full' ? queue_details.backup_id : queue_details.extra_id) + " });\">Download Backup</button>";
										row += "&nbsp;";
										row += "<button class=\"btn btn-default btn-sm deletedownload\" type=\"button\" onclick=\"$.jbm.download.remove({ type: '" + type + "', id: " + (type == 'full' ? queue_details.backup_id : queue_details.extra_id) + " });\">Remove Download</button>";

										row += "</div>";
									}

									row += "<div style=\"display: none; text-align: center; padding: 5px 0;\" id=\"queueOptionsLoader" + type + (type == 'full' ? queue_details.backup_id : queue_details.extra_id) + "\"><img src=\"assets/img/spinner.gif\" style=\"vertical-align: middle;\" alt=\"\" /></div>";
								}
								else if(queue_details.active == '0' && queue_details.pid == '0')
								{
									row += "Download&nbsp;Failed";
								}
								else
								{
									row += "Download&nbsp;in&nbsp;Progress";
								}

								row += "</td>";
								row += "</tr>";

								$("#tableQueue tbody").append(row);
							});
						}

						if(response.data.restore.success)
						{
							$.each(response.data.restore.data, function(i, queue_details) {

								totalQueue++;

								var row = "<tr>";
								row += "<td>" + queue_details.date.replace(/ /g, '&nbsp;') + "</td>";
								row += "<td>";

								if(queue_details.extra_id != '0')
								{
									row += "Restore&nbsp;" + types[queue_details.extra_details.type].replace(/ /g, '&nbsp;');
								}
								else if(queue_details.filemanager)
								{
									row += "Restore&nbsp;Files";
								}
								else
								{
									row += "Restore&nbsp;Full&nbsp;Account";
								}

								type = (queue_details.extra_id != '0' ? queue_details.extra_details.type : 'full');

								row += "</td>";
								row += "<td style=\"text-align: center;\" id=\"restoreQueue" + queue_details.queue_id + "\">";

								if(!queue_details.status_data.stop)
								{
									setTimeout(function() { updateRestoreStatus(queue_details.queue_id); }, 5000);
								}

								row += "<div class=\"progress-bar-msg\" style=\"font-weight: bold;\">";

								if(queue_details.status != 'pending')
								{
									row += "<span" + (queue_details.status_data.stop ? " style='color: #" + (queue_details.status == 'completed' ? "118d00" : "CC0000") + ";'" : '') + ">" + queue_details.status_data.msg.replace(/ /g, '&nbsp;') + "</span>";
								}

								row += "</div>";

								if(queue_details.status == 'pending' && !queue_details.filemanager)
								{
									row += "<button class=\"btn btn-default btn-sm restorecancel\" type=\"button\" onclick=\"$.jbm.restore.cancel({ queue_id: " + queue_details.queue_id + " })\">Cancel Restore</button>";
									row += "<div style=\"display: none; text-align: center; padding: 5px 0;\" class=\"restorecancelloader\"><img src=\"assets/img/spinner.gif\" style=\"vertical-align: middle;\" alt=\"\" /></div>";
								}

								row += "<div class=\"progress\" style=\"position: relative; margin-top: 5px; width: 250px; margin: 0 auto;" + (queue_details.status == 'pending' ? " display: none;" : '') + "\">";
								row += "<div class=\"progress-bar progress-bar-success\" style=\"width: " + queue_details.status_data.progress + "%;\"></div>";
								row += "<div class=\"progress-bar-text\" style=\"position: absolute; left: 0; top: 0; width: 100%; padding: 2px; color: #000;\">" + queue_details.status_data.progress + "%</div>";
								row += "</div>";

								row += "</td>";
								row += "</tr>";

								$("#tableQueue tbody").append(row);
							});
						}

						$("#Primary_Sidebar-Service_Details_Backups-queue .badge").removeClass("colorless").html(totalQueue);

						jQuery("#tableQueue").DataTable({
							"dom": '<"listtable"fit>pl',
							"responsive": true,
							"oLanguage": {
								"sEmptyTable": "No Records Found",
								"sInfo": "Showing _START_ to _END_ of _TOTAL_ entries",
								"sInfoEmpty": "Showing 0 to 0 of 0 entries",
								"sInfoFiltered": "(filtered from _MAX_ total entries)",
								"sInfoPostFix": "",
								"sInfoThousands": ",",
								"sLengthMenu": "Show _MENU_ entries",
								"sLoadingRecords": "Loading...",
								"sProcessing": "Processing...",
								"sSearch": "",
								"sZeroRecords":"No Records Found",
								"oPaginate": {
									"sFirst": "First",
									"sLast": "Last",
									"sNext": "Next",
									"sPrevious": "Previous"
								}
							},
							"pageLength": 10,
							"order": [
								[ 0, "asc" ]
							],
							"lengthMenu": [
								[10, 25, 50, -1],
								[10, 25, 50, "All"]
							],
							"aoColumnDefs": [{
								"bSortable": false,
								"aTargets": [ 2 ]
							}],
							"stateSave": true
						});

						$("#tableQueueLoading").fadeOut("slow", function() {
							$("#tableQueueContainer").fadeIn("slow");
						});
					}
				});
			},
			backups: function() {

				var lastBackup = 'Never';

				$.jbm.ajax({
					//async: false,
					data: {
						action: "backups"
					},
					success: function(response) {

						var lastBackupTime = 0;
						$.each(types, function(type, typename) { 

							if(response.data[type].backups != undefined)
							{
								$("#Primary_Sidebar-Service_Details_Backups-" + type + " .badge").removeClass("colorless").html(response.data[type].backups.length);

								$.each(response.data[type].backups, function(i, backup_details) {

									if(type == 'full' && backup_details.time > lastBackupTime)
									{
										lastBackup = backup_details.date;
										lastBackupTime = backup_details.time;
									}

									var row = "<tr>";
									if(type != 'full' && type != 'files' && type != 'cron') row += "<td>" + backup_details.filename.replace(/ /g, '&nbsp;') + "</td>";
									row += "<td>" + backup_details.date.replace(/ /g, '&nbsp;') + "</td>";
									if(type != 'ssl' && type != 'cron' && type != 'dnszone') row += "<td>" + (backup_details.size != 'unknown' ? $.jbm.bytesToSize(backup_details.size, 2).replace(/ /g, '&nbsp;') : backup_details.size) + "</td>";
									if(type == 'full') row += "<td>" + (backup_details.extention ? backup_details.extention : "Incremental") + "</td>";
									row += "<td>" + backup_details.location + "</td>";

									if($.jbm.options.permissions.backupmanager.sub[type].sub.download.acl == '1' || $.jbm.options.permissions.backupmanager.sub[type].sub.restore.acl == '1')
									{
										row += "<td>";

										if(type == 'files')
										{
											row += "Manage from cPanel";
										}
										else
										{
											if(!response.data[type].queue && !response.data.full.queue)
											{
												row += "<div class=\"btn-group\" id=\"backupOptions" + type + backup_details.id + "\">";
												row += "<button data-toggle=\"dropdown\" class=\"btn btn-default btn-sm dropdown-toggle\" type=\"button\" aria-expanded=\"false\">";
												row += " Backup Options <span class=\"caret\"></span>";
												row += "</button>";
												row += "<ul role=\"menu\" class=\"dropdown-menu\">";

												if($.jbm.options.permissions.backupmanager.sub[type].sub.download.acl == '1')
												{
													row += "<li><a class=\"setBulkAction\" href=\"javascript: void(0);\" onclick=\"$.jbm.download.validate({ type: '" + type + "', id: " + backup_details.id + " });\"><i class=\"glyphicon glyphicon-download-alt\"></i> " + (!backup_details.onthefly && !backup_details.download_ready ? (backup_details.download_progress ? "Download in Process" : "Generate Download") : "Download") + "</a></li>";
												}

												if($.jbm.options.permissions.backupmanager.sub[type].sub.restore.acl == '1')
												{
													row += "<li><a class=\"setBulkAction\" href=\"javascript: void(0);\" onclick=\"$.jbm.restore.set({ type: '" + type + "', id: " + backup_details.id + " });\"><i class=\"glyphicon glyphicon-refresh\"></i> Restore</a></li>";
												}

												row += "</ul>";
												row += "</div>";
											}

											row += "<div style=\"" + (response.data[type].queue || response.data.full.queue ? "" : "display: none; ") + "text-align: center; padding: 5px 0;\" id=\"backupOptionsLoader" + type + backup_details.id + "\"><img src=\"assets/img/spinner.gif\" style=\"vertical-align: middle;\" alt=\"\" />" + (response.data[type].queue || response.data.full.queue ? "&nbsp;Restore&nbsp;in&nbsp;Progress" : '') + "</div>";
										}

										row += "</td>";
									}

									row += "</tr>";

									$("#table" + typename.replace(/ /g, '') + " tbody").append(row);
								});

								jQuery("#table" + typename.replace(/ /g, '')).DataTable({
									"dom": '<"listtable"fit>pl',
									"responsive": true,
									"oLanguage": {
										"sEmptyTable": "No Backups Found",
										"sInfo": "Showing _START_ to _END_ of _TOTAL_ entries",
										"sInfoEmpty": "Showing 0 to 0 of 0 entries",
										"sInfoFiltered": "(filtered from _MAX_ total entries)",
										"sInfoPostFix": "",
										"sInfoThousands": ",",
										"sLengthMenu": "Show _MENU_ entries",
										"sLoadingRecords": "Loading...",
										"sProcessing": "Processing...",
										"sSearch": "",
										"sZeroRecords":"No Backups Found",
										"oPaginate": {
											"sFirst": "First",
											"sLast": "Last",
											"sNext": "Next",
											"sPrevious": "Previous"
										}
									},
									"pageLength": 10,
									"order": [
										[ 0, "asc" ]
									],
									"lengthMenu": [
										[10, 25, 50, -1],
										[10, 25, 50, "All"]
									],
									"aoColumnDefs": [{
										"bSortable": false,
										"aTargets": [ (jQuery("#table" + typename.replace(/ /g, '') + " thead tr th").length-1) ]
									}],
									"stateSave": true
								});

								$("#table" + typename.replace(/ /g, '') + "Loading").fadeOut("slow", function() {
									$("#table" + typename.replace(/ /g, '') + "Container").fadeIn("slow");
								});
							}
							else
							{
								$("#Primary_Sidebar-Service_Details_Backups-" + type + " .badge").removeClass("colorless").html(0);
							}
						});

						$.jbm.load.status({ lastBackup: lastBackup });
					}
				});
			},
			status: function(options) {

				options = $.extend({ lastBackup: 'Never' }, options);

				$.jbm.ajax({
					data: {
						action: "rotationsettings"
					},
					success: function(response) {

						if(parseInt(response.data.stopbackup_size) > 0 || parseInt(response.data.stopbackup_files) > 0)
						{
							$.jbm.ajax({
								data: {
									action: "rotation"
								},
								success: function(rotation_response) {

									var rules = (parseInt(response.data.stopbackup_size) > 0 ? response.data.stopbackup_size + " " + response.data.stopbackup_type + " of disk uasge" : '');
									rules = rules + (parseInt(response.data.stopbackup_files) > 0 ? (rules ? " OR " : '') + response.data.stopbackup_files + " inodes usage" : '');

									$('#jbmSidebar').html('<div style="text-align: center;"><strong>Backup Status:</strong><span class="label status status-' + (rotation_response.data.current_status ? 'unpaid' : 'active') + '">' + (rotation_response.data.current_status ? 'Disabled' : 'Enabled') + '</span><span style="font-size: 11px;">Last backup on - ' + options.lastBackup + '</span></div>' + (rotation_response.data.current_status ? '<br /><br />Notice that the backup system is disabled for your account. This can cause because your account disk space usage exceeded the allowed backup size. (' + rules + ')' : ''));
								}
							});
						}
					}
				});
			}
		},
		message: function(options) {

			options = $.extend({ success: false, message: 'Unknown Error', timeout: 15000 }, options);

			$.jbm.options.alertBox.removeClass('alert-success').removeClass('alert-danger').addClass('alert-' + (options.success ? 'success' : 'danger')).html(options.message);

			$.jbm.options.alertBox.slideUp('slow', function() {
				$.jbm.options.alertBox.slideDown('slow', function() {
					if(options.timeout) setTimeout(function() { $.jbm.options.alertBox.slideUp('slow'); }, options.timeout);
				});
			});
		},
		ajax: function(options) {

			options = $.extend({
				async: true,
				data: {},
				success: function() {},
				error: function() {}
			}, options);

			return $.ajax({
				url: $.jbm.options.api,
				data: $.extend({
					serviceid: $.jbm.options.serviceid,
				}, options.data),
				async: options.async,
				dataType: "json",
				success: function(response) {

					if(response.success)
					{
						options.success(response);
					}
					else
					{
						options.error(response);
					}
				},
				error: function() {

					options.error({
						success: false,
						message: "Unknown error",
						data: []
					});
				}
			});
		},
		bytesToSize: function(bytes, precision) {

			var kilobyte = 1024;
			var megabyte = kilobyte * 1024;
			var gigabyte = megabyte * 1024;
			var terabyte = gigabyte * 1024;
   
			if ((bytes >= 0) && (bytes < kilobyte)) 
			{
				return bytes + ' B';
			} 
			else if ((bytes >= kilobyte) && (bytes < megabyte)) 
			{
				return (bytes / kilobyte).toFixed(precision) + ' KB';
			} 
			else if ((bytes >= megabyte) && (bytes < gigabyte)) 
			{
				return (bytes / megabyte).toFixed(precision) + ' MB';
			} 
			else if ((bytes >= gigabyte) && (bytes < terabyte)) 
			{
				return (bytes / gigabyte).toFixed(precision) + ' GB';
			} 
			else if (bytes >= terabyte) 
			{
				return (bytes / terabyte).toFixed(precision) + ' TB';
			} 
			else 
			{
				return bytes + ' B';
			}
		}
	};
 
}(jQuery));