<?php
/**
 * Copyright (c) 2017, ZADomains.net
 *For any queries and support please contact support@zadomains.net
 * ZA Domains
 * support@zadomains.net
 * https://www.zadomains.net/
 * v1.6 - Added Registration Coupon Codes
 * v1.7 - Added ability to override registrant email
 * v1.8 - Added com, net, org support
 * v1.9 - Ability to update additional information on contacts
 * v1.9.1 - Fixed printf bug with OpenSRS balanace
 * v2.1 - Handle domains transferred away
 * v2.2 - Added support for Premium Domains
 * v2.3 - Support and fix for SOAP and PHP 5.6
 * v2.4 - Add configuration option to override API calls via SSL
 * v2.5 - New visual design. Force and support for SSL on all API calls
 * v2.6 - Added Suspend and Resume DNS functions - will put clientHold status on domain
 * v2.7 - No code changes. Recompiled for new PHP and WHMCS versions
 * v2.8 - Improved status management for Transfer and Domain Sync functions. New functionality added to notify customers via email using standard WHMCS template when domain transfers succeed or fail. ionCube Encryption removed
 * v2.9 - Update module description. Additional widget formatting
  * v3.0 - Added development/QA functionality
 * v3.1 - Added support for WHMCS 7.10 TLD & Pricing Sync tool
 * v3.2 - Added support to Cancel Domain Transfer
 */

if (!defined("WHMCS")) {
    die("This file cannot be accessed directly");
}

use WHMCS\Domains\DomainLookup\ResultsList;
use WHMCS\Domains\DomainLookup\SearchResult;
use WHMCS\Module\Registrar\Registrarmodule\ApiClient;
use WHMCS\Database\Capsule;
 

function widget_zadomains_info($vars) {

 	# Setup include dir
	$include_path = ROOTDIR . '/modules/registrars/zadomains';
	set_include_path($include_path . PATH_SEPARATOR . get_include_path());
	# Include registrar functions aswell
	require_once ROOTDIR . '/includes/registrarfunctions.php';
	
	
	# Grab module parameters
	$params = getregistrarconfigoptions('zadomains');

	# Set widget and module versions
	$module_version = "3.2";

	# Set widget contents
	$title = "ZADomains (v".$module_version.")";
	$template = '<p align = "center" class="textblack">%s</p>';
	
	# WHMCSInformation - START
    $opts = array(
        'ssl' => array(
            'ciphers' => 'SHA256',
            'verify_peer' => false,
            'verify_peer_name' => false
        )
    );

    $soapparams = array(
        'encoding' => 'ISO-8859-1',
        'verifypeer' => false,
        'verifyhost' => false,
        'soap_version' => SOAP_1_2,
        'trace' => 1,
        'exceptions' => 1,
        'connection_timeout' => 180,
        'stream_context' => stream_context_create($opts)
    );
   
	$client = new SoapClient("https://www.zadomains.net/api/API_WHMCS.asmx?wsdl", $soapparams );
	
	$zadomains_username = $params['Username'];
	$zadomains_password = $params['Password'];
 
	$result = $client->widget_zadomains_info(array(
		"zadomains_username" => $zadomains_username,
		"zadomains_password" => $zadomains_password,
		"module_version" => $module_version		
	));
 
 	# Get Result
	$resultstring = $result->widget_zadomains_infoResult;
	
	# Check for Error
	if (strpos($resultstring,'error') !== false) {
  		$resultarray = explode('|', $resultstring);
		$values["error"] = $resultarray[1];
		return array('title'=>$title,'content'=>sprintf($template,$values));
	}
	
	# Now unpack array
	$resultarray = explode('|', $resultstring);

	# New Version

	$versionmessage = '' ;
	if ($resultarray[0] == 'true')
	{
	
	$versionmessage = 'A new version of ZA Domains WHMCS Module is available. Log in to zadomains.net and download v' . $resultarray[1];
	
	}
	
	$message = $resultarray[2];
	$AccountBalance = $resultarray[3];
	$domaininfo = str_replace("[Registered]", $resultarray[4], $domaininfo);
	$domaininfo = str_replace("[Expiring]", $resultarray[5], $domaininfo);
	$domaininfo = str_replace("[Expired]", $resultarray[6], $domaininfo);
	$domaininfo = str_replace("[Redemption]", $resultarray[7], $domaininfo);
	$domaininfo = str_replace("[Pending Update]", $resultarray[8], $domaininfo);
	$domaininfo = str_replace("[Transfer Pending]", $resultarray[9], $domaininfo);	
	$Registered = $resultarray[4];
	$Expiring = $resultarray[5];
	$Expired = $resultarray[6];
	$Redemption = $resultarray[7];
	$PendingUpdate = $resultarray[8];
	$TransferPending = $resultarray[9];
	$usertype =  $resultarray[10];
	$ZACRBalanace = $resultarray[11];
	$OpenSRSBalance = $resultarray[12];
	if ($usertype=='RAR')
	{
	$reseller = 'hidden="hidden"';
	$rar = '';
	}else
	{
	$rar = 'hidden="hidden"';
	$reseller = '';
	}
	$output = <<<EOF
	<div class="widget-content-padded">
<div class="row">
    <div class="col-sm-12">
		<p class="item-figure color-blue" style="padding: 5px 0;font-size: 1.0em;">$message</p>        
		<p class="item-figure" style="padding: 5px 0;color:#d9534f; font-size: 1.0em;">$versionmessage</p>        
    </div>
</div>
<div class="row">
    <div class="col-sm-4 bordered-right" style="border-right: 1px solid #eee;text-align: center;">
        <div class="item" style="padding: 13px 0;white-space: nowrap;overflow: hidden;">
            <div class="data color-green" style="font-size: 1.8em;">$Registered</div>
            <div class="note" style="color: #a2a6af;font-size: .9em;">Registered</div>
        </div>
    </div>
    <div class="col-sm-4" style="text-align: center;">
        <div class="item" style="padding: 13px 0;white-space: nowrap;overflow: hidden;">
            <div class="data color-green" style="font-size: 1.8em">$Expiring</div>
            <div class="note" style="color: #a2a6af;font-size: .9em;">Expiring</div>
        </div>
    </div>
    <div class="col-sm-4">
        <div class="item" style="padding: 13px 0;white-space: nowrap;overflow: hidden;text-align: center;">
            <div class="data color-green" style="color: #d9534f;font-size: 1.8em">$Expired</div>
            <div class="note" style="color: #a2a6af;font-size: .9em;">Expired</div>
        </div>
    </div>
        <div class="col-sm-4" style="border-right: 1px solid #eee;border-top: 1px solid #eee;text-align: center;">
        <div class="item" style="padding: 13px 0;white-space: nowrap;overflow: hidden;">
            <div class="data color-green" style="color: #B161D6;font-size: 1.8em">$Redemption</div>
            <div class="note" style="color: #a2a6af;font-size: .9em;">Redemption</div>
        </div>
    </div>
        <div class="col-sm-4" style="border-right: 1px solid #eee;border-top: 1px solid #eee;text-align: center;">
        <div class="item" style="padding: 13px 0;white-space: nowrap;overflow: hidden;">
            <div class="data color-green" style="color: #6ecacc;font-size: 1.8em">$PendingUpdate</div>
            <div class="note" style="color: #a2a6af;font-size: .9em;">Pending Update</div>
        </div>
    </div>
        <div class="col-sm-4" style="border-right: 1px solid #eee;border-top: 1px solid #eee;text-align: center;">
        <div class="item" style="padding: 13px 0;white-space: nowrap;overflow: hidden;">
            <div class="data color-green" style="color: #eaae53;font-size: 1.8em">$TransferPending</div>
            <div class="note" style="color: #a2a6af;font-size: .9em;">Transfer Pending</div>
        </div>
    </div>
</div>
<div class="row" $rar>
    <div class="col-sm-4">
        <div class="mini-chart"  style="text-align: center;" >
            <a href="#">
                <span class="peity-line"data-peity='{ "fill": "rgba(64, 186, 189, 0.2)", "stroke": "rgba(64, 186, 189, 0.7)", "strokeWidth": 2, "width": 120}'>{$invoicesCreatedString}</span>
            </a>
        </div>
        <h4 class="item-title">
            <span class="title-text" style="display: block;    margin-top: 2px;    font-size: 13px;    color: #a2a6af;    font-weight: 300;    text-align: center;">Account Balance</span>
        </h4>
		<p class="item-figure color-blue" style="text-align: center;font-size: 1.6em;">R $AccountBalance</p>        
    </div>
    <div class="col-sm-4">
        <div class="mini-chart"  style="text-align: center;" >
            <a href="#">
                <span class="peity-line"data-peity='{ "fill": "rgba(64, 186, 189, 0.2)", "stroke": "rgba(64, 186, 189, 0.7)", "strokeWidth": 2, "width": 120}'>{$invoicesCreatedString}</span>
            </a>
        </div>
        <h4 class="item-title">
            <span class="title-text" style="display: block;    margin-top: 2px;    font-size: 13px;    color: #a2a6af;    font-weight: 300;    text-align: center;">ZACR Balance</span>
        </h4>
		<p class="item-figure color-blue" style="text-align: center;font-size: 1.6em;">R $ZACRBalanace</p>        
    </div>
	    <div class="col-sm-4">
        <div class="mini-chart"  style="text-align: center;" >
            <a href="#">
                <span class="peity-line"data-peity='{ "fill": "rgba(64, 186, 189, 0.2)", "stroke": "rgba(64, 186, 189, 0.7)", "strokeWidth": 2, "width": 120}'>{$invoicesCreatedString}</span>
            </a>
        </div>
        <h4 class="item-title">
            <span class="title-text" style="display: block;    margin-top: 2px;    font-size: 13px;    color: #a2a6af;    font-weight: 300;    text-align: center;">OpenSRS Balance</span>
        </h4>
		<p class="item-figure color-blue" style="text-align: center;font-size: 1.6em;">$ $OpenSRSBalance</p>        
    </div>
</div>
<div class="row" $reseller>
    <div class="col-sm-12">
        <div class="mini-chart"  style="text-align: center;" >
            <a href="#">
                <span class="peity-line"data-peity='{ "fill": "rgba(64, 186, 189, 0.2)", "stroke": "rgba(64, 186, 189, 0.7)", "strokeWidth": 2, "width": 120}'>{$invoicesCreatedString}</span>
            </a>
        </div>
        <h4 class="item-title">
            <span class="title-text" style="display: block;    margin-top: 2px;    font-size: 13px;    color: #a2a6af;    font-weight: 300;    text-align: center;">Account Balance</span>
        </h4>
		<p class="item-figure color-blue" style="text-align: center;font-size: 1.6em;">R $AccountBalance</p>        
    </div>
</div>
</div>
EOF;
	return array('title'=>$title,'content'=>sprintf($template,$output));
}

add_hook("AdminHomeWidgets",1,"widget_zadomains_info");
?>