<style>
    label.error{
        color: red;
        font-weight: normal;
        margin-top: 5px;
    }
    .sslgen{
        text-align: left;
    }
    .sslgen label{
        max-width: 100%;
        font-weight: 700;
    }
    .cert_gen_radio{
        border-bottom: 1px solid #ddd;
        padding: 15px 0;
        text-align: center;

    }
    .cert_gen_radio label, #csrDetails > label{
        font-size: 18px;
        font-weight: 400;
    }
    #csrDetails{
        background-color: #efefef;
        border-color: #bce8f1;
        border-radius: 10px;
        padding: 10px;
        display: none;
    }
    #org-info-details{
        background-color: #efefef;
        border-color: #bce8f1;
        border-radius: 10px;
        padding: 10px;
        margin-bottom: 15px;
        display: none;
    }

    .sslgen .form-control{
        width: 100%;
        padding: 4px;
        box-sizing: border-box;
        min-height: 30px;
    }
    textarea#sslAdditionalSan,textarea#sslAdditionalWildCardSan {
        min-height: 180px;
    }
    .inline-label{
        display:inline-block;
    }
    .ajax_loader{
        position:fixed;
        width:100%;
        height:100%;
        left:0;
        top:0;
        background:rgba(0,0,0,.5);
        display: none;
    }
    .ajax_loader img{
        position:absolute;
        left:50%;
        top:50%;
        margin: -100px 0 0 -100px;
    }
    #Primary_Sidebar-Service_Details_Overview-Information,#Primary_Sidebar-Service_Details_Overview-Addons{
        display: none;
    }
    .csr_info,.token_info,.autossl_info{
        display: none;
    }
    .additionalsan,.additionalwildcardsan{
        width: 90% !important;
        float: left;
        margin-bottom: 5px;
    }
    .addbtb {
        background: rgba(0, 0, 0, 0) url("../assets/ssl_resources/images/btn-add.png") no-repeat;
        cursor: pointer;
        display: block;
        float: left;
        height: 28px;
        margin-left: 5px;
        width: 31px;
        margin-top: 0px;
    }
    .lessbtn {
        background: rgba(0, 0, 0, 0) url("../assets/ssl_resources/images/btn-less.png") no-repeat scroll left top;
        cursor: pointer;
        display: block;
        float: left;
        height: 28px;
        width: 31px;
        margin-top: 0px;
    }
</style>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-validate/1.17.0/jquery.validate.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jqueryui/1.12.1/jquery-ui.js"></script>
<link href='https://cdnjs.cloudflare.com/ajax/libs/jqueryui/1.12.1/jquery-ui.min.css' rel='stylesheet' type='text/css' />
{if $errormessage}
    <div class="alert alert-danger">
        <strong>{$LANG.clientareaerrors}</strong>
        <ul>
            {$errormessage}
        </ul>
    </div>
{/if}
{if $majorStatus eq "initial"}

        <h2>{$LANG.sslgenerationtitle} - {$productName}</h2>
        <div class="form-group cert_gen_radio radio">
            <div class="col-md-6">
                <label for="csrChoice_existing"><input type="radio" id="csrChoice_existing" checked="checked" name="csrChoice" value="existing">{$LANG.csrChoiceExisting}</label>
            </div>
            <div class="col-md-6">
                <label for="csrChoice_autoinstall"><input type="radio" id="csrChoice_autoinstall" name="csrChoice" value="autoinstall">{$LANG.csrChoiceAutoInstall}</label>
            </div>
            <div class="clear"></div>
        </div>
        <div class="clear"></div>

        <form class="sslgen" id="frmStepOne" method="post" action="{$smarty.server.PHP_SELF}?action=productdetails&id={$serviceId}&page=steptwo">
            <input type="hidden" name="sslid" value="{$sslOrderId}">
            {if $isHostingProfileAvailable eq false}
                <div class="token_info">
                    <h3>{$LANG.token}</h3>
                    <p>{$LANG.tokens_tooltip}</p>
                    <div class="form-group">
                        <label for="sslAdminTitle">{$LANG.token}:</label>
                        <input class="form-control" type="text" value="{$sslToken}" readonly />
                    </div>
                    <p><input type="button" class="btn btn-primary" value="Copy Token" onclick="copyToken()"/></p>
                </div>
            {else}
                <input type="hidden" name="sslHostingProfile" id="sslHostingProfile" value="">
            {/if}
            <div class="autossl_info">
                <h3>{$LANG.sslServerInfoTitle}</h3>
                <p>{$LANG.sslIntstruction}</p>
            </div>
            <div class="csr_info autossl_info">
                <h3>{$LANG.sslCSRTitle}</h3>
                <p>{$LANG.sslCSRDesc}</p>
            </div>
            <div class="form-group csr_info autossl_info">
                <label for="sslCSRCountry">{$LANG.sslOrgCountry}:*</label>
                <select name="sslCSRCountry" id="sslCSRCountry" class="form-control">
                    <option value="" selected>{$LANG.pleasechooseone}</option>
                    {foreach from=$countries key=countryCode item=countryName}
                        <option value="{$countryCode}" {if $certInfo.sslCSRCountry eq $countryCode} selected{/if}>
                            {$countryName->name}
                        </option>
                    {/foreach}
                </select>
            </div>

            <div class="form-group csr_info autossl_info">
                <label for="sslCSRState">{$LANG.sslOrgState}:*</label>
                <input type="text" class="form-control" name="sslCSRState" id="sslCSRState" value="{$certInfo.sslCSRState}">
            </div>

            <div class="form-group csr_info autossl_info">
                <label for="sslCSRCity">{$LANG.sslOrgCity}:*</label>
                <input type="text" class="form-control" name="sslCSRCity" id="sslCSRCity" value="{$certInfo.sslCSRCity}">
            </div>

            <div class="form-group csr_info autossl_info">
                <label for="sslCSRCompany">{$LANG.csrOrg}:*</label>
                <input type="text" class="form-control" name="sslCSRCompany" id="sslCSRCompany" value="{$certInfo.sslCSRCompany}">
            </div>

            <div class="form-group csr_info autossl_info">
                <label for="sslCSRDivision">{$LANG.csrOrgDivision}:*</label>
                <input type="text" class="form-control" name="sslCSRDivision" id="sslCSRDivision" value="{$certInfo.sslCSRDivision}">
            </div>

            <div class="form-group csr_info">
                <label for="sslDomainName">{$LANG.sslDomainName}:*</label>
                <input type="text" class="form-control" name="sslDomainName" id="sslDomainName" value="{$certInfo.sslDomainName}">
            </div>

            <div class="form-group autossl_info">
                <label for="sslDomain">{$LANG.sslDomainName}:*</label>
                <select name="sslDomain" id="sslDomain" class="form-control sslDomain" data-fill="no">
                    <option value="">Loading...</option>
                </select>
                {if $vendorName eq "DIGICERT" && $isWWWDisplay}
                    <input type="hidden" name="is_www" value="No">
                    <input type='checkbox' name='is_www' id='is_www' {if $www_non_www_digicert eq 'Yes'} checked='checked' {/if} value='yes' />
                    <label for='www'>{$LANG.sslWWWLabel}</label>
                    <p>{$LANG.sslWWWDesc}</p>
                {/if}
                {if $isWildCardProduct eq false}
                    <input type='hidden' name='www' id='www' checked='checked' value='www.'>
                {/if}
            </div>

            <div class="form-group  autossl_info">
                <label for="sslCSREmail">{$LANG.sslCSREmail}:</label>
                <input type="text" class="form-control" name="sslCSREmail" id="sslCSREmail" value="{$certInfo.sslCSREmail}"/>
            </div>

            <div class="form-group csr_info autossl_info">
                <label>{$LANG.csrKeySize}:*</label><br>

                <label for="csrKeySize_4096" class="radio-inline"><input type="radio" id="csrKeySize_4096" {if $certInfo.sslCSRKeySize eq '4096'} checked {/if} name="sslCSRKeySize" value="4096">4096</label>
                <label for="csrKeySize_2048" class="radio-inline"><input type="radio" id="csrKeySize_2048" {if $certInfo.sslCSRKeySize eq '2048'} checked {/if}name="sslCSRKeySize" value="2048">2048</label>
            </div>

            <!--<div class="form-group csr_info autossl_info">
                {if $vendorName eq "DIGICERT" && $isFlexOrder neq "true"  && $sanCount eq 0  && $wildCardSANCount eq 0}
                    <h2>{$LANG.domainValidationTitle}</h2>
                    <p>{$LANG.domainValidationDesc}</p>
                    <div class="form-group checkbox generate_info autossl_info">
                        <input type="radio" id="baseDomainValidation" name="domainValidation" value="base_domain" checked><label for="baseDomainValidation">{$LANG.baseDomainDetails}</label><br/>
                        <input type="radio" id="fqdnValidation" name="domainValidation" value="fqdn"><label for="fqdnValidation">{$LANG.fqdnDetails}</label><br/>
                        <div class="clear"></div>
                    </div>
                    <div class="clear"></div>
                {/if}
            </div>-->

            <p class="csr_info">
                <a class="btn btn-primary" href="clientarea.php?action=productdetails&id={$serviceId}">{$LANG.backtoservicedetails}</a>
                <input type="submit" name="csrgeneratebtn" id="csrgeneratebtn" value="{$LANG.csrGeneratebtn}" class="btn btn-primary" />
            </p>

            <div id="generate_info">
                <h3 class="generate_info">{$LANG.sslServerInfoTitle}</h3>
                <p class="generate_info">{$LANG.sslServerInfoDesc}</p>
                <div class="form-group generate_info">
                    <label for="sslCsr">{$LANG.sslCSR}:*</label>
                    <textarea id="sslCsr" name="sslCsr" rows="15" class="form-control" onchange="decodeCSR()">{if $certInfo.sslCsr}{$certInfo.sslCsr}{/if}</textarea>
                    <br/>
                    <div id="csrDetails">
                        <label>{$LANG.sslCSRTitle}:</label>
                        <div class="row">
                            <div class="col-lg-6"><label>{$LANG.sslCSRCommonName} : </label><span data-csr="commonName"></span></div>
                            <div class="col-lg-6"><label>{$LANG.sslCSREmail} : </label><span data-csr="email"></span></div>
                        </div>
                        <div class="row">
                            <div class="col-lg-6"><label>{$LANG.sslCSRCompany} : </label><span data-csr="organization"></span></div>
                            <div class="col-lg-6"><label>{$LANG.sslCSRDivision} : </label><span data-csr="organizationUnit"></span></div>
                        </div>
                        <div class="row">
                            <div class="col-lg-6"><label>{$LANG.sslCSRState} : </label><span data-csr="state"></span></div>
                            <div class="col-lg-6"><label>{$LANG.sslCSRCity} : </label><span data-csr="city"></span></div>
                        </div>
                        <div class="row">
                            <div class="col-lg-6"><label>{$LANG.sslCSRCountry} : </label><span data-csr="country"></span></div>
                        </div>
                    </div>
                </div>
                {if $sanCount gt 0}
                    <p class="generate_info autossl_info">{$LANG.sslstore_san_csr_note}</p>
                    <div class="form-group generate_info">
                        <label for="sslAdditionalSan">{$LANG.sslAdditionalSan} ({$sanCount}):*</label> (Input every SAN in separate line)
                        <textarea id="sslAdditionalSan" name="sslAdditionalSan" rows="3" class="form-control">{if $certInfo.sslAdditionalSan}{$certInfo.sslAdditionalSan}{/if}</textarea>
                        <div class="theCount" style="padding:5px 0px;"><span id="linesUsed">0</span> of <span id="maxlines">{$sanCount}</span> SANs Used</div>
                    </div>
                    <div id="additinalDomaindiv" class="form-group autossl_info">
                        <label>{$LANG.sslAdditionalSan} ({$sanCount}):*</label>
                        <select id="additionalSANDD" name='sslAdditionalSanDD[]' class="additionalsan form-control">
                            <option value="">Loading...</option>
                        </select>
                        <a class='tooltips addbtb adddomain ssl-tooltipbox'><span class="tooltip">{$LANG.addDomainToolTip}</span></a>
                    </div>
                    <div class="clear"></div>
                {/if}
                {if $wildCardSANCount gt 0}
                    <p class="generate_info autossl_info">{$LANG.sslstore_wildcard_san_csr_note}</p>
                    <div class="form-group generate_info">
                        <label for="sslAdditionalWildCardSan">{$LANG.sslAdditionalWildCardSan} ({$wildCardSANCount}):*</label> (Input every Wildcard SAN in separate line)
                        <textarea id="sslAdditionalWildCardSan" name="sslAdditionalWildCardSan" rows="3" class="form-control">{if $certInfo.sslAdditionalWildCardSan}{$certInfo.sslAdditionalWildCardSan}{/if}</textarea>
                        <div class="theCount" style="padding:5px 0px;"><span id="linesUsedWildCard">0</span> of <span id="maxlinesWildCard">{$wildCardSANCount}</span> Wildcard SANs Used</div>
                    </div>
                    <div id="additinalWildCardDomaindiv" class="form-group autossl_info">
                        <label>{$LANG.sslAdditionalWildCardSan} ({$wildCardSANCount}):*</label>
                        <select id="additionalWildCardSANDD" name='sslAdditionalWildCardSanDD[]' class="additionalwildcardsan form-control">
                            <option value="">Loading...</option>
                        </select>
                        <a class='tooltips addbtb addwildcarddomain ssl-tooltipbox'><span class="tooltip">{$LANG.addWildCardDomainToolTip}</span></a>
                    </div>
                    <div class="clear"></div>
                {/if}
                {if $vendorName eq "DIGICERT" && $isWWWDisplay}
                <div class="form-group generate_info">
                    <input type="hidden" name="is_www" value="No">
                    <input type='checkbox' name='is_www' id='is_www' {if $www_non_www_digicert eq 'Yes'} checked='checked' {/if} value='yes' />
                    <label for='www'>{$LANG.sslWWWLabel}</label>
                    <p>{$LANG.sslWWWDesc}</p>
                </div>
                {/if}
                {if $isWildCardProduct eq false}
                    <input type='hidden' name='www' id='www' checked='checked' value='www.'>
                {/if}
                <div class="form-group generate_info">
                    <label for="sslServerType">{$LANG.sslservertype}:*</label>
                    <select name="sslServerType" id="sslServerType" class="form-control">
                        <option value="" selected>{$LANG.pleasechooseone}</option>
                        {foreach from=$webServerTypes key=webservertypeid item=webservertype}
                            <option value="{$webservertypeid}"{if $certInfo.sslServerType eq $webservertypeid} selected{/if}{if $defaultWebServer eq $webservertypeid} selected{/if}>
                                {$webservertype.displayName}
                            </option>
                        {/foreach}
                    </select>
                </div>
                <div class="form-group generate_info autossl_info">
                    <label for="sslSignatureAlgorithm">{$LANG.signature_algorithm_label}:*</label>
                    <p>{$signatureAlgorithmDescription}</p>
                    <select name="sslSignatureAlgorithm" id="sslSignatureAlgorithm" class="form-control">
                        <option value="" selected>{$LANG.pleasechooseone}</option>
                        {foreach from=$signatureAlgorithmList key=sigKey item=sigValue}
                            <option value="{$sigKey}"{if $certInfo.sslSignatureAlgorithm eq $sigKey} selected{/if}{if $vendorName eq "COMODO" || $vendorName eq 'SECTIGO'} selected{/if}>
                                {$sigValue}
                            </option>
                        {/foreach}
                    </select>
                </div>

                <h3 class="generate_info autossl_info">{$LANG.sslAdminTitle}</h3>
                <p class="generate_info autossl_info">{$LANG.sslAdminDesc}</p>
                <div class="form-group generate_info autossl_info">
                    <label for="sslAdminTitle">{$LANG.sslTitle}:*</label>
                    <input type="text" class="form-control" name="sslAdminTitle" id="sslAdminTitle" value="{$certInfo.sslAdminTitle}" onchange="copyContact()"/>
                </div>
                <div class="form-group generate_info autossl_info">
                    <label for="sslAdminFirstName">{$LANG.sslFirstName}:*</label>
                    <input type="text" class="form-control" name="sslAdminFirstName" id="sslAdminFirstName" value="{$certInfo.sslAdminFirstName}" onchange="copyContact()"/>
                </div>
                <div class="form-group generate_info autossl_info">
                    <label for="sslAdminLastName">{$LANG.sslLastName}:*</label>
                    <input type="text" class="form-control" name="sslAdminLastName" id="sslAdminLastName" value="{$certInfo.sslAdminLastName}" onchange="copyContact()" />
                </div>
                <div class="form-group generate_info autossl_info">
                    <label for="sslAdminEmail">{$LANG.sslEmail}:*</label>
                    <input type="text" class="form-control" name="sslAdminEmail" id="sslAdminEmail" value="{$certInfo.sslAdminEmail}" onchange="copyContact()"/>
                </div>
                <div class="form-group generate_info autossl_info">
                    <label for="sslAdminPhone">{$LANG.sslPhone}:*</label>
                    <input type="text" class="form-control" name="sslAdminPhone" id="sslAdminPhone" value="{$certInfo.sslAdminPhone}" onchange="copyContact()" />
                </div>
                {if $useDefaultTechDetails ne 1}
                    <h3 class="generate_info autossl_info">{$LANG.sslTechTitle}</h3>
                    <p class="generate_info autossl_info">{$LANG.sslTechDesc}</p>
                    <p class="generate_info autossl_info">
                        <input type="checkbox" name="sslSameAsAdmin" id="sslSameAsAdmin" onchange="copyContact()" />
                        <label class="inline-label" for="sslSameAsAdmin">{$LANG.sslSameAsAdmin}</label>
                    </p>

                    <div class="form-group generate_info autossl_info">
                        <label for="sslTechTitle">{$LANG.sslTitle}:*</label>
                        <input type="text" class="form-control" name="sslTechTitle" id="sslTechTitle" value="{$certInfo.sslTechTitle}" />
                    </div>
                    <div class="form-group generate_info autossl_info">
                        <label for="sslTechFirstName">{$LANG.sslFirstName}:*</label>
                        <input type="text" class="form-control" name="sslTechFirstName" id="sslTechFirstName" value="{$certInfo.sslTechFirstName}" />
                    </div>
                    <div class="form-group generate_info autossl_info">
                        <label for="sslTechLastName">{$LANG.sslLastName}:*</label>
                        <input type="text" class="form-control" name="sslTechLastName" id="sslTechLastName" value="{$certInfo.sslTechLastName}" />
                    </div>
                    <div class="form-group generate_info autossl_info">
                        <label for="sslTechEmail">{$LANG.sslEmail}:*</label>
                        <input type="text" class="form-control" name="sslTechEmail" id="sslTechEmail" value="{$certInfo.sslTechEmail}" />
                    </div>
                    <div class="form-group generate_info autossl_info">
                        <label for="sslTechPhone">{$LANG.sslPhone}:*</label>
                        <input type="text" class="form-control" name="sslTechPhone" id="sslTechPhone" value="{$certInfo.sslTechPhone}" />
                    </div>
                {/if}

                {if $productValidationType ne 'DV' || $productCode eq 'ssl123' || $productCode eq 'ssl123wildcard'}
                    <h3 class="generate_info">{$LANG.sslOrgTitle}</h3>
                    <p class="generate_info">{$LANG.sslOrgDesc}</p>
                    {if $preAuthOrgList|@count gt 0}
                        <div class="form-group checkbox generate_info autossl_info">
                            <input type="radio" id="sslNewOrgDetails" name="sslOrgDetails" value="new" checked><label for="sslNewOrgDetails">{$LANG.newOrgDetails}</label><br/>
                            <input type="radio" id="sslPreAuthOrgDetails" name="sslOrgDetails" value="existing"><label for="sslPreAuthOrgDetails">{$LANG.preAuthOrgDetails}</label><br/>
                        </div>
                        <div class="form-group" id="showOrgList" style="display: none;">
                            <select name="sslOrgId" id="sslOrgId" class="form-control" onchange="getOrgInfo()">
                                {foreach from=$preAuthOrgList item=orgInfo}
                                    <option {if $certInfo.sslOrgId eq $orgInfo->org_id} selected{/if} value="{$orgInfo->org_id}">
                                        {$orgInfo->org_name}
                                    </option>
                                {/foreach}
                            </select>
                        </div>
                        <div id="org-info-details">
                            <label>{$LANG.sslOrgInfo}:</label>
                            <div class="row">
                                <div class="col-lg-6"><label>{$LANG.sslOrgName} : </label><span data-org="name"></span></div>
                                <div class="col-lg-6"><label>{$LANG.sslOrgAddress1} : </label><span data-org="address"></span></div>
                            </div>
                            <div class="row">
                                <div class="col-lg-6"><label>{$LANG.sslOrgAddress2} : </label><span data-org="address2"></span></div>
                                <div class="col-lg-6"><label>{$LANG.sslOrgCity} : </label><span data-org="city"></span></div>
                            </div>
                            <div class="row">
                                <div class="col-lg-6"><label>{$LANG.sslOrgState} : </label><span data-org="state"></span></div>
                                <div class="col-lg-6"><label>{$LANG.sslOrgCountry} : </label><span data-org="country"></span></div>
                            </div>
                            <div class="row">
                                <div class="col-lg-6"><label>{$LANG.sslOrgZipCode} : </label><span data-org="zip"></span></div>
                                <div class="col-lg-6"><label>{$LANG.sslPhone} : </label><span data-org="phone"></span></div>
                            </div>
                        </div>
                    {/if}
                    <div class="org-info">
                        <div class="form-group generate_info autossl_info">
                            <label for="sslOrgName">{$LANG.sslOrgName}:*</label>
                            <input type="text" class="form-control" name="sslOrgName" id="sslOrgName" value="{$certInfo.sslOrgName}" />
                        </div>
                        {if $vendorName neq "DIGICERT"}
                            <div class="form-group generate_info autossl_info">
                                <label for="sslOrgName">{$LANG.sslOrgDuns}:</label>
                                <input type="text" class="form-control" name="sslOrgDuns" id="sslOrgDuns" value="{$certInfo.sslOrgDuns}" />
                            </div>
                            <div class="form-group generate_info autossl_info">
                                <label for="sslOrgDivision">{$LANG.sslOrgDivision}:*</label>
                                <input type="text" class="form-control" name="sslOrgDivision" id="sslOrgDivision" value="{$certInfo.sslOrgDivision}" />
                            </div>
                        {/if}
                        <div class="form-group generate_info autossl_info">
                            <label for="sslOrgAddress1">{$LANG.sslOrgAddress1}:*</label>
                            <input type="text" class="form-control" name="sslOrgAddress1" id="sslOrgAddress1" value="{$certInfo.sslOrgAddress1}" />
                        </div>
                        <div class="form-group generate_info autossl_info">
                            <label for="sslOrgAddress2">{$LANG.sslOrgAddress2}:</label>
                            <input type="text" class="form-control" name="sslOrgAddress2" id="sslOrgAddress2" value="{$certInfo.sslOrgAddress2}" />
                        </div>
                        <div class="form-group generate_info autossl_info">
                            <label for="sslOrgCity">{$LANG.sslOrgCity}:*</label>
                            <input type="text" class="form-control" name="sslOrgCity" id="sslOrgCity" value="{$certInfo.sslOrgCity}" />
                        </div>
                        <div class="form-group generate_info autossl_info">
                            <label for="sslOrgState">{$LANG.sslOrgState}:*</label>
                            <input type="text" class="form-control" name="sslOrgState" id="sslOrgState" value="{$certInfo.sslOrgState}" />
                        </div>
                        <div class="form-group generate_info autossl_info">
                            <label for="sslOrgCountry">{$LANG.sslOrgCountry}:*</label>
                            <select name="sslOrgCountry" id="sslOrgCountry" class="form-control">
                                <option value="" selected>{$LANG.pleasechooseone}</option>
                                {foreach from=$countries key=countryCode item=countryName}
                                    <option value="{$countryCode}"{if $certInfo.sslOrgCountry eq $countryCode} selected{/if}>
                                        {$countryName->name}
                                    </option>
                                {/foreach}
                            </select>
                        </div>
                        <div class="form-group generate_info autossl_info">
                            <label for="sslOrgZipCode">{$LANG.sslOrgZipCode}:*</label>
                            <input type="text" class="form-control" name="sslOrgZipCode" id="sslOrgZipCode" value="{$certInfo.sslOrgZipCode}" />
                        </div>
                        <div class="form-group generate_info autossl_info">
                            <label for="sslOrgPhone">{$LANG.sslPhone}:*</label>
                            <input type="text" class="form-control" name="sslOrgPhone" id="sslOrgPhone" value="{$certInfo.sslOrgPhone}" />
                        </div>
                    </div>
                    {if $vendorName eq "DIGICERT"}
                        <!--<div class="org-contact">
                            <h3 class="generate_info autossl_info">{$LANG.sslOrgContact}</h3>
                            <input type="hidden" name="need_to_submit" value="no">
                            <div class="form-group generate_info autossl_info">
                                <label for="sslAdminTitle">{$LANG.sslTitle}:*</label>
                                <input type="text" class="form-control" name="sslAdminTitle" id="sslAdminTitle" value="{$certInfo.sslAdminTitle}" onchange="copyContact()"/>
                            </div>
                            <div class="form-group generate_info autossl_info">
                                <label for="sslAdminFirstName">{$LANG.sslFirstName}:*</label>
                                <input type="text" class="form-control" name="sslAdminFirstName" id="sslAdminFirstName" value="{$certInfo.sslAdminFirstName}" onchange="copyContact()"/>
                            </div>
                            <div class="form-group generate_info autossl_info">
                                <label for="sslAdminLastName">{$LANG.sslLastName}:*</label>
                                <input type="text" class="form-control" name="sslAdminLastName" id="sslAdminLastName" value="{$certInfo.sslAdminLastName}" onchange="copyContact()" />
                            </div>
                            <div class="form-group generate_info autossl_info">
                                <label for="sslAdminEmail">{$LANG.sslEmail}:*</label>
                                <input type="text" class="form-control" name="sslAdminEmail" id="sslAdminEmail" value="{$certInfo.sslAdminEmail}" onchange="copyContact()"/>
                            </div>
                            <div class="form-group generate_info autossl_info">
                                <label for="sslAdminPhone">{$LANG.sslPhone}:*</label>
                                <input type="text" class="form-control" name="sslAdminPhone" id="sslAdminPhone" value="{$certInfo.sslAdminPhone}" onchange="copyContact()" />
                            </div>
                        </div> -->
                    {/if}
                {/if}
                <p class="generate_info autossl_info">
                    <a class="btn btn-primary" href="clientarea.php?action=productdetails&id={$serviceId}">{$LANG.backtoservicedetails}</a>
                    <input type="submit" name="btnstepone" id="btnstepone" value="{$LANG.ordercontinuebutton}" class="btn btn-primary" />
                </p>
            </div>
        </form>
    <div id="autoInstallModal" class="aismodal">
        <!-- Modal content -->
        <div class="aismodal-content">
            <p><img src="assets/ssl_resources/images/icon_loading.gif" width="100"><br>{$LANG.autossl_process_msg}</p>
        </div>
    </div>

    <div class="ajax_loader"><img src="assets/ssl_resources/images/icon_loading.gif"></div>
    <script type="text/javascript">
        var vendorName = '{$vendorName}';
        var isFlexOrder = '{$isFlexOrder}';
        var profileAvailable = '{$isHostingProfileAvailable}';
        var profileData = [];
        
        $(document).ready(function(){
            disPlayTab();
            decodeCSR();

            $("#frmStepOne").validate({
                rules: {
                    sslCsr: "required",
                    sslAdditionalSan: "required",
                    'sslAdditionalSanDD[]': {
                        required: true
                    },
                    sslAdditionalWildCardSan: "required",
                    'sslAdditionalWildCardSanDD[]': {
                        required: true
                    },
                    sslServerType: "required",
                    sslSignatureAlgorithm: "required",
                    sslAdminTitle: "required",
                    sslAdminFirstName: "required",
                    sslAdminLastName: "required",
                    sslAdminEmail: "required",
                    sslAdminPhone: "required",
                    sslTechTitle: "required",
                    sslTechFirstName: "required",
                    sslTechLastName: "required",
                    sslTechEmail: "required",
                    sslTechPhone: "required",
                    sslOrgId: "required",
                    sslOrgName: "required",
                    sslOrgDivision: "required",
                    sslOrgAddress1: "required",
                    sslOrgCity: "required",
                    sslOrgState: "required",
                    sslOrgCountry: "required",
                    sslOrgZipCode: "required",
                    sslOrgPhone: "required",
                    sslDomain: "required",
                    sslCSRCountry: "required",
                    sslCSRState: "required",
                    sslCSRCity: "required",
                    sslCSRCompany: "required",
                    sslCSRDivision: "required",
                    sslDomainName: "required",
                    sslCSRKeySize: "required"
                },
                submitHandler: function(form){
                    if($('input:radio[name="csrChoice"]:checked').val() == 'autoinstall'){
                        form.submit();
                        $("#btnstepone").attr('disabled', true);
                        $("#autoInstallModal").show();
                    }
                    else{
                        form.submit();
                        $("#btnstepone").attr('disabled', true);
                    }
                }
            });

            /*Handle Organization details for Digicert*/
            if(vendorName == 'DIGICERT'){
                if($('select#sslOrgId').length >0 && $('select#sslOrgId').val() != ''){
                    $("#sslPreAuthOrgDetails").prop("checked", true);
                    $('#showOrgList').show();
                    $('.org-info').hide();
                    $('#org-info-details').show();
                    getOrgInfo();
                    //$('.org-contact').hide();
                }

                $('input:radio[name="sslOrgDetails"]').change(
                    function () {
                        if($('select#sslOrgId').length > 0 && $(this).val() == 'existing'){
                            $('#showOrgList').show();
                            $('.org-info').hide();
                            $('#org-info-details').show();
                            //$('.org-contact').hide();
                        }
                        else{
                            $('#showOrgList').hide();
                            $('.org-info').show();
                            $('#org-info-details').hide();
                            //$('.org-contact').show();
                        }
                    });

                    /*org list*/
                $( "#sslOrgName" ).autocomplete({
                    source: function( request, response ) {
                        $.ajax({
                            type: "POST",
                            url: "modules/servers/thesslstorefullv2/common.php",
                            /*url: "http://gd.geobytes.com/AutoCompleteCity",*/
                            dataType: "json",
                            data: {
                                q: request.term,
                                action: 'getorglist'
                            },
                            success: function( data ) {
                                response( data );
                            }
                        });
                    },
                    minLength: 6,
                    delay: 1500,
                    select: function(event, ui){
                        //alert('selected');
                    },
                    open: function(){
                        $( this ).removeClass( "ui-corner-all" ).addClass( "ui-corner-top" );
                    },
                    close: function(){
                        $( this ).removeClass( "ui-corner-top" ).addClass( "ui-corner-all" );
                    }
                });
            }

            $('input:radio[name="csrChoice"]').change(
                function () {
                    disPlayTab();
                }
            );

            $('select#sslDomain').change(function (){
                if($(this).val() in profileData){
                    $('input#sslHostingProfile').val(profileData[$(this).val()])
                }
            })
        });

        function disPlayTab(){
            var csrChoice = $('input:radio[name="csrChoice"]:checked').val();
            $('.generate_info').hide();
            if(csrChoice == 'autoinstall'){
                /*autoinstall*/
                if(profileAvailable){
                    $("#frmStepOne").attr('action','{$smarty.server.PHP_SELF}?action=productdetails&id={$serviceId}&page=autosslcomplete')
                    $('.autossl_info').show();
                    fetchDomainList();
                }
                else{
                    $('.token_info').show();
                }
            }
            if(csrChoice == 'existing'){
                $("#frmStepOne").attr('action','{$smarty.server.PHP_SELF}?action=productdetails&id={$serviceId}&page=steptwo');
                /*existing*/
                $('.token_info, .autossl_info').hide();
                $('.generate_info').show();
            }
        }

        function copyContact(){
            if($("input#sslSameAsAdmin:checked").length > 0){
                $("input#sslTechTitle").val($("input#sslAdminTitle").val());
                $("input#sslTechFirstName").val($("input#sslAdminFirstName").val());
                $("input#sslTechLastName").val($("input#sslAdminLastName").val());
                $("input#sslTechEmail").val($("input#sslAdminEmail").val());
                $("input#sslTechPhone").val($("input#sslAdminPhone").val())
            }
        }

        function fetchDomainList(){
            if($('select.sslDomain').attr('data-fill') == 'no'){
                $('.ajax_loader').show();
                $.ajax({
                    type: "POST",
                    url: 'modules/servers/thesslstorefullv2/common.php',
                    data: {ldelim}'action':'getcpaneldomainlist'{rdelim},
                    dataType: "json",
                    success:(function(result){
                        //console.log(result); return false;
                        var dd = $('select#sslDomain');
                        if(result.domainList.length > 0){
                            profileData = result.profileData;
                            var htmlOptions = '';
                            htmlOptions += '<option value="">' + '{$LANG.pleasechooseone}' + '</option>';
                            for (var i = 0; i < result.domainList.length; i++) {
                                htmlOptions += '<option value="' + result.domainList[i] + '">' + result.domainList[i] + '</option>';
                            }
                            dd.empty();
                            dd.append(htmlOptions);
                            $('select#additionalSANDD').empty().append(htmlOptions);
                            $('select#additionalWildCardSANDD').empty().append(htmlOptions);
                            dd.attr('data-fill','yes');
                        }
                        else{
                            dd.attr('data-fill','yes');

                            if(profileAvailable){
                                $('.token_info').hide();
                                $('.autossl_info').show();
                            } else {
                                $('.token_info').show();
                                $('.autossl_info').hide();
                            }
                        }
                        $('.ajax_loader').hide();
                    })
                });
            }
        }

        /*Handle the MAX SAN input line and Display the number of SAN used.*/
        $('#sslAdditionalSan').bind('change keyup', function(event) {
            /*Limit to arbitrary # of rows*/
            rows = $('#maxlines').text();
            var linesUsed = $('#linesUsed');
            var value = '';
            var splitval = $(this).val().split("\n");
            for(var a=0;a<rows && typeof splitval[a] != 'undefined';a++) {
                if(a>0) value += "\n";
                value += splitval[a];
                if(splitval.length>=rows)
                    linesUsed.css('color', 'red');
                else
                    linesUsed.css('color', '');
            }
            linesUsed.text(splitval.length);
            if (splitval.length==1 && sslAdditionalSan.value.length == 0 || splitval.length>rows) {
                linesUsed.text((splitval.length)-1);
            }
            $(this).val(value);
        });


        if(vendorName == 'DIGICERT' && isFlexOrder == true){
            /* Check the value of the Additional SANs is valid or not */
            $('#sslAdditionalSan').blur(function() {
                var lines = $('#sslAdditionalSan').val().split('\n');   // lines is an array of strings
                // Loop through all lines
                var isError = false;
                for (var i = 0; i < lines.length; i++) {
                    if (lines[i].indexOf('*.') > -1)
                    {
                        isError = true;
                    }
                }
                if(isError == true)
                {
                    alert("Wildcard domains are not allowed on this field. Please enter fully qualified domain names (domain.com, www.domain.com).");
                }
            });

            /* Check the value of the Additional Wildcard SANs is valid or not */
            $('#sslAdditionalWildCardSan').blur(function() {
                var lines = $('#sslAdditionalWildCardSan').val().split('\n');   // lines is an array of strings
                // Loop through all lines
                var isError = false;
                for (var i = 0; i < lines.length; i++) {
                    if (lines[i].indexOf('*.') < 0)
                    {
                        isError = true;
                    }
                }
                if(isError == true)
                {
                    alert("Specific subdomains or fully qualified domains are not allowed. These must be wildcard domain names (*.domain.com, *.domain2.com, *.domain3.com).");
                }
            });
        }

        /*add additional domain textbox on button click*/
        $("#additinalDomaindiv").on("click","a.adddomain", function(){
            var maxSan = {$sanCount};
            var additionalSan =  $("#additinalDomaindiv select").length;
            if(maxSan > additionalSan){
                var htmlOptions = "<div><select class='form-control additionalsan' name='sslAdditionalSanDD[]'>"+$('#additionalSANDD').html()+"</select>"+
                    "<a class='tooltips addbtb adddomain ssl-tooltipbox'><span class='tooltip'>{$LANG.addDomainToolTip}</span></a>"+
                    "<a class='tooltips lessbtn deldomain ssl-tooltipbox'><span class='tooltip'>{$LANG.removeDomainToolTip}</span></a></div>";
                $("#additinalDomaindiv").append(htmlOptions);
            }
            else{
                alert("Only "+ maxSan +" additional domains allow");
                return false;
            }
        })

        /* Remove additional domain textbox on button click */
        $("#additinalDomaindiv").on("click", "a.deldomain", function () {
            $(this).parent().remove();
        });


        /*Handle the MAX Wildcard SAN input line and Display the number of Wildcard SAN used.*/
        $('#sslAdditionalWildCardSan').bind('change keyup', function(event) {
            /*Limit to arbitrary # of rows*/
            rows = $('#maxlinesWildCard').text();
            var linesUsed = $('#linesUsedWildCard');
            var value = '';
            var splitval = $(this).val().split("\n");
            for(var a=0;a<rows && typeof splitval[a] != 'undefined';a++) {
                if(a>0) value += "\n";
                value += splitval[a];
                if(splitval.length>=rows)
                    linesUsed.css('color', 'red');
                else
                    linesUsed.css('color', '');
            }
            linesUsed.text(splitval.length);
            if (splitval.length==1 && sslAdditionalWildCardSan.value.length == 0 || splitval.length>rows) {
                linesUsed.text((splitval.length)-1);
            }
            $(this).val(value);
        });

        /*add additional wildcard domain textbox on button click*/
        $("#additinalWildCardDomaindiv").on("click","a.addwildcarddomain", function(){
            var maxWildCardSan = {$wildCardSANCount};
            var additionalWildCardSan =  $("#additinalWildCardDomaindiv select").length;
            if(maxWildCardSan > additionalWildCardSan){
                var htmlOptions = "<div><select class='form-control additionalWildCardSan' name='sslAdditionalWildCardSanDD[]'>"+$('#additionalWildCardSANDD').html()+"</select>"+
                    "<a class='tooltips addbtb addwildcarddomain ssl-tooltipbox'><span class='tooltip'>{$LANG.addWildCardDomainToolTip}</span></a>"+
                    "<a class='tooltips lessbtn delwildcarddomain ssl-tooltipbox'><span class='tooltip'>{$LANG.removeWildCardDomainToolTip}</span></a></div>";
                $("#additinalWildCardDomaindiv").append(htmlOptions);
            }
            else{
                alert("Only "+ maxWildCardSan +" additional wildcard domains allow");
                return false;
            }
        })

        /* Remove additional wildcard domain textbox on button click */
        $("#additinalWildCardDomaindiv").on("click", "a.delwildcarddomain", function () {
            $(this).parent().remove();
        });

        function decodeCSR(){
            $('#csrDetails').hide();
            if($('#sslCsr').val().trim() != ''){
                $('.ajax_loader').show();
                $('#csrDetails').hide();
                $.ajax({
                    type: "POST",
                    url: 'modules/servers/thesslstorefullv2/common.php',
                    data: {ldelim}'action' : 'decodecsr', 'csr' : $("#sslCsr").val().trim(), 'productCode' : '{$productCode}' {rdelim},
                    dataType: "json",
                    success:(function(result){
                        if(result.isError == false){
                            for (key in result.csrData){
                                $("span[data-csr='"+key+"']").html(result.csrData[key]);
                            }
                            $('#csrDetails').slideDown(500);
                        }
                        else{
                            alert(result.errorMessage);
                        }
                        $('.ajax_loader').hide();
                    })
                });
            }
        }

        function getOrgInfo(){
            $('#org-info-details').hide();
                $('.ajax_loader').show();
                $.ajax({
                    type: "POST",
                    url: 'modules/servers/thesslstorefullv2/common.php',
                    data: {ldelim}'action' : 'getorginfo', 'orgid' : $("#sslOrgId").val().trim(), {rdelim},
                    dataType: "json",
                    success:(function(result){
                        if(result.isError == false){
                            for (key in result.orgData){
                                $("span[data-org='"+key+"']").html(result.orgData[key]);
                            }
                            $('#org-info-details').slideDown(500);
                        }
                        else{
                            alert(result.errorMessage);
                        }
                        $('.ajax_loader').hide();
                    })
                });
        }

        function copyToken() {
            el = document.createElement('textarea');
            el.value = '{$sslToken}';
            document.body.appendChild(el);
            el.select();
            document.execCommand('copy');
            document.body.removeChild(el);
        }
    </script>
{else}
    <div class="alert alert-info">
        {$LANG.sslnoconfigurationpossible}
    </div>

    <form method="post" action="clientarea.php?action=productdetails">
        <input type="hidden" name="id" value="{$serviceid}" />
        <p>
            <input type="submit" value="{$LANG.invoicesbacktoclientarea}" class="btn btn-primary" />
        </p>
    </form>
{/if}