<?php
use Illuminate\Database\Capsule\Manager as Capsule;
use \WHMCS\Service\Service;

require_once dirname(__FILE__) . '/common.php';
function thesslstorefullv2_hook_headoutput($vars)
{
    if(checkTheSSLStoreModule($vars['id'])){
        $returnString = '';
        if ($vars['filename'] == 'cart') {
            $returnString .= "
                <script type='text/javascript'>
                    jQuery(document).ready(function() {
                        jQuery('a.sc_feature_link').click(function(){
                            window.open(jQuery(this).attr('href'),'null','location=no,toolbar=no,menubar=no,scrollbars=yes,resizable=yes,addressbar=0,titlebar=no,directories=no,channelmode=no,status=no')
                            return false;
                        })
                    });
                </script>";
        } elseif ($vars['filename'] == 'clientarea' && $vars['action'] == 'productdetails') {
            if (isset($vars['id'])) {
                //get service details
                $tblSSLOrders = Capsule::table('tblsslorders')
                    ->select('remoteid')
                    ->where('serviceid', '=', $vars['id'])
                    ->where('module', '=', 'thesslstorefullv2')
                    ->first();
                if ($tblSSLOrders != NULL) {
                    $returnString .= "
                        <script type='text/javascript'>
                            if(document.location.hash != ''){
                                document.location.href = document.location.href.replace(document.location.hash,'');
                            }
                            jQuery(document).ready(function(){
                                jQuery('#Primary_Sidebar-Service_Details_Actions-Upgrade_Downgrade_Options').remove(); 
                            });
                            
                        </script>
                    ";
                }
                $returnString .= "<link href='assets/ssl_resources/css/style.css' rel='stylesheet' type='text/css' />";
            }
        } elseif ($vars['filename'] == 'upgrade' && $vars['type'] == 'configoptions') {
            //This code prevent downgrade products
            if (isset($vars['id'])) {
                //get service details
                $tblSSLOrders = Capsule::table('tblsslorders')
                    ->select('remoteid')
                    ->where('serviceid', '=', $vars['id'])
                    ->where('module', '=', 'thesslstorefullv2')
                    ->first();
                if ($tblSSLOrders != NULL) {
                    $returnString .= "
                    <script type='text/javascript'>
                    jQuery(document).ready(function(){
                    jQuery('h1,.breadcrumb li.active').html('Upgrade')}
                    ";
                    foreach ($vars['configoptions'] as $configOption) {
                        $returnString .= "
                            jQuery(\"[name='configoption[" . $configOption['id'] . "]']\").blur(function(){
                                if({$configOption['selectedqty']} > jQuery(this).val() || isNaN(jQuery(this).val())){
                                    alert('This product doesn\'t support downgrade');
                                    jQuery(this).val({$configOption['selectedqty']});
                                }
                            })";
                    }
                    $returnString .= "
                    });
                    </script>";
                }
            }
        } // Perform hook code here...

        try {
            $configData = Capsule::table('tblproducts')
                ->join('tblhosting', 'tblhosting.packageid', '=', 'tblproducts.id')
                ->select('tblproducts.configoption1')
                ->where('tblhosting.id', '=', $vars['id'])
                ->first();
        } catch (\Exception $e) {
            logActivity("TheSSLStore Module Log|query, {$e->getMessage()}");
        }
        if (tssIsSiteLockProduct($configData->configoption1) || tssIsCodeGuardProduct($configData->configoption1)) {
            $returnString .= "
                <script type='text/javascript'>
                    jQuery(document).ready(function($) {
                        $('#type option[value=\"Immediate\"]').remove();
                        $('<div class=\"alert alert-danger text-center\">After the order is canceled the service will continue through the paid-through date. Once service has ended any associated data for this license will be permanently deleted. Please be sure to backup any important data before coverage lapses.</div>' ).insertBefore('.form-stacked');
                    });
                </script>";
        }
        return $returnString;
    }
}
function thesslstorefullv2_hook_PreInvoicingGenerateInvoiceItems($vars)
{
    customErrorLog("TheSSLStore Module Log| Started hook thesslstorefullv2_hook_PreInvoicingGenerateInvoiceItems");
    $result = Capsule::table('mod_sslstore_invoice_log')
            ->join('tblsslorders', 'mod_sslstore_invoice_log.serviceid', '=', 'tblsslorders.serviceid')
            ->select('mod_sslstore_invoice_log.serviceid','tblsslorders.serviceid','tblsslorders.module','tblsslorders.remoteid','tblsslorders.userid','mod_sslstore_invoice_log.invoiceid', 'mod_sslstore_invoice_log.addon_id', 'mod_sslstore_invoice_log.duedate','mod_sslstore_invoice_log.dateofinvoice')
            ->where('mod_sslstore_invoice_log.is_renewal_invoice', '=', 1)
            ->where('tblsslorders.userid', '=', $_SESSION['uid'])
            ->where('tblsslorders.module', '=', 'thesslstorefullv2')
            ->get();
        $resultData = json_decode(json_encode($result,JSON_OBJECT_AS_ARRAY),true);
        
        customErrorLog("TheSSLStore Module Log| thesslstorefullv2_hook_PreInvoicingGenerateInvoiceItems get Renewal Invoices Data:".json_encode($result,true));
        if(!empty($resultData)) {
            //get default setting for invoice generation days from WHMCS (Setup > Automation Settings)
            //get Invoice created settings from WHMCS
            $createInvoiceDaysBeforeData = Capsule::table('tblconfiguration')
                ->select('tblconfiguration.value')
                ->where('tblconfiguration.setting', '=', 'CreateInvoiceDaysBefore')
                ->first();

            $createInvoiceDaysBefore = (!empty($createInvoiceDaysBeforeData->value) ? $createInvoiceDaysBeforeData->value : 30);
            $days = date('Y-m-d', strtotime('-' . $createInvoiceDaysBefore . ' days'));
            
			customErrorLog("TheSSLStore Module Log| thesslstorefullv2_hook_PreInvoicingGenerateInvoiceItems func createInvoiceDaysBefore ,$createInvoiceDaysBefore, days - ".$days);
            foreach ($resultData as $key => $serviceData) {
                try {
                    if ($serviceData['addon_id'] == 0 && $serviceData['dateofinvoice'] >= $days) {
                       
                            $hostingData = Capsule::table('tblhosting')
                                ->select('tblhosting.id','tblhosting.nextduedate', 'tblhosting.nextinvoicedate')
                                ->where('tblhosting.id', '=', $serviceData['serviceid'])
                                ->first();

								customErrorLog("TheSSLStore Module Log| thesslstorefullv2_hook_PreInvoicingGenerateInvoiceItems func before update hostingData-".json_encode($hostingData,true));
                                if (changeTimeZone($hostingData->nextinvoicedate, 'Y-m-d') <= date('Y-m-d', strtotime('+' . $createInvoiceDaysBefore . ' days')) || changeTimeZone($hostingData->nextduedate, 'Y-m-d') <= date('Y-m-d', strtotime('+' . $createInvoiceDaysBefore . ' days'))) {
                                    try {
                                        $tblSSlOrderData = Capsule::table('mod_sslstore_orders_data')
                                            ->where('service_id', '=',  $serviceData['serviceid'])
                                            ->where('store_order_id', '=', $serviceData['remoteid'])
                                            ->first();
									customErrorLog("TheSSLStore Module Log| thesslstorefullv2_hook_PreInvoicingGenerateInvoiceItems func tblSSlOrderData ".json_encode($tblSSlOrderData,true));
                                    } catch (\Exception $e) {
                                        logActivity("TheSSLStore Module Log|query, {$e->getMessage()}");
                                    }

                                    if ($tblSSlOrderData->expiration_date != '0000-00-00 00:00:00' && (date('Y-m-d', strtotime(changeTimeZone($tblSSlOrderData->order_expiration_date))) != '1970-01-01' || date('Y-m-d', strtotime(changeTimeZone($tblSSlOrderData->order_expiration_date))) != '1970-1-1')) {
                                        //Get The value of the option "no_of_days_prior_to_expirationdate"
                                        $noOfDaysPriorToExpirationDate = tss_get_config_option('no_of_days_prior_to_expirationdate');
                                        //update next due date for renewal before number of($noOfDaysPriorToExpirationDate) days
                                        $CertificateEndDate = date('Y-m-d', strtotime(changeTimeZone($tblSSlOrderData->expiration_date)));
                                        if (!empty(changeTimeZone($tblSSlOrderData->order_expiration_date)) && (strtotime(changeTimeZone($tblSSlOrderData->order_expiration_date)) >= strtotime(changeTimeZone($tblSSlOrderData->expiration_date))) && (date('Y-m-d', strtotime(changeTimeZone($tblSSlOrderData->order_expiration_date))) != '1970-01-01' || date('Y-m-d', strtotime(changeTimeZone($tblSSlOrderData->order_expiration_date))) != '1970-1-1')) {
                                            //for Comodo 2&3 year product, SSL expiration date and order expiration will different
                                            $CertificateEndDate = date('Y-m-d',  strtotime(changeTimeZone($tblSSlOrderData->order_expiration_date)));
                                            if(changeTimeZone($hostingData->nextduedate, 'Y-m-d') != $certificateEndDate) {
                                                customErrorLog("TheSSLStore Module Log| thesslstorefullv2_hook_PreInvoicingGenerateInvoiceItems SSL expiration date and order expiration will different certificateEndDate, $CertificateEndDate without noOfDaysPriorToExpirationDate,  service-id: {$serviceData['serviceid']}");
                                            }
                                        }
                                        
                                        $CertificateEndDate = date('Y-m-d', strtotime($CertificateEndDate . '-' . $noOfDaysPriorToExpirationDate . ' days'));
                                        if(changeTimeZone($hostingData->nextduedate, 'Y-m-d') != $certificateEndDate) {
                                            customErrorLog("TheSSLStore Module Log| thesslstorefullv2_hook_PreInvoicingGenerateInvoiceItems SSL expiration date and order expiration will different certificateEndDate, $CertificateEndDate with noOfDaysPriorToExpirationDate, {$noOfDaysPriorToExpirationDate},  service-id: {$serviceData['serviceid']}");
                                        
                                            Capsule::table('tblhosting')
                                            ->where('id', '=', $serviceData['serviceid'])
                                            ->whereNotIn('billingcycle', ['One Time', 'Free Account'])
                                            ->update(['nextduedate' => $CertificateEndDate, 'nextinvoicedate' => $CertificateEndDate]);

                                            customErrorLog("TheSSLStore Module Log| thesslstorefullv2_hook_PreInvoicingGenerateInvoiceItems func after update nextduedate = $CertificateEndDate,service_id = {$serviceData['serviceid']} ");
                                            customErrorLog("TheSSLStore Module Log| Update nextduedate and nextinvoicedate in tblhosting table to, service_id = {$serviceData['serviceid']}");
                                        }
                                    }
                                }
                    } elseif ($serviceData['addon_id'] > 0 && $serviceData['dateofinvoice'] >= $days) {
                            $hostingData = Capsule::table('tblhostingaddons')
                                ->select('tblhostingaddons.nextduedate', 'tblhostingaddons.nextinvoicedate')
                                ->where('tblhostingaddons.id', '=', $serviceData['serviceid'])
                                ->first();

							customErrorLog("TheSSLStore Module Log| Addon thesslstorefullv2_hook_PreInvoicingGenerateInvoiceItems func hostingData= ".json_encode($hostingData,true).",service_id = {$serviceData['serviceid']} ");
                            if (isset($hostingData->nextinvoicedate)) {
                                if (changeTimeZone($hostingData->nextinvoicedate, 'Y-m-d') <= date('Y-m-d', strtotime('+' . $createInvoiceDaysBefore . ' days')) || changeTimeZone($hostingData->nextduedate, 'Y-m-d') <= date('Y-m-d', strtotime('+' . $createInvoiceDaysBefore . ' days'))) {
                                    try {
                                        $tblSSlOrderData = Capsule::table('mod_sslstore_orders_data')
                                            ->where('service_id', '=', $serviceData['serviceid'])
                                            ->first();
									customErrorLog("TheSSLStore Module Log| Addon thesslstorefullv2_hook_PreInvoicingGenerateInvoiceItems func tblSSlOrderData=".json_encode($tblSSlOrderData,true).",service_id = {$serviceData['serviceid']}, hostingData=".json_encode($hostingData,true));
                                    } catch (\Exception $e) {
                                        logActivity("TheSSLStore Module Log|query, {$e->getMessage()}");
                                    }

                                    if ($tblSSlOrderData->order_expiration_date != '0000-00-00 00:00:00' && (date('Y-m-d', strtotime(changeTimeZone($tblSSlOrderData->order_expiration_date))) != '1970-01-01' || date('Y-m-d', strtotime(changeTimeZone($tblSSlOrderData->order_expiration_date))) != '1970-1-1')) {
                                        //Get The value of the option "no_of_days_prior_to_expirationdate"
                                        $noOfDaysPriorToExpirationDate = tss_get_config_option('no_of_days_prior_to_expirationdate');
                                        //update next due date for renewal before number of($noOfDaysPriorToExpirationDate) days
                                        $CertificateEndDate = date('Y-m-d', strtotime(changeTimeZone($tblSSlOrderData->expiration_date)));
                                        if (!empty(changeTimeZone($tblSSlOrderData->order_expiration_date)) && (strtotime(changeTimeZone($tblSSlOrderData->order_expiration_date)) >= strtotime(changeTimeZone($tblSSlOrderData->expiration_date))) && (date('Y-m-d', strtotime(changeTimeZone($tblSSlOrderData->order_expiration_date))) != '1970-01-01' || date('Y-m-d', strtotime(changeTimeZone($tblSSlOrderData->order_expiration_date))) != '1970-1-1')) {
                                            //for Comodo 2&3 year product, SSL expiration date and order expiration will different
                                            $CertificateEndDate = date('Y-m-d',  strtotime(changeTimeZone($tblSSlOrderData->order_expiration_date)));
                                            if(changeTimeZone($hostingData->nextduedate, 'Y-m-d') != $certificateEndDate) {
                                                customErrorLog("TheSSLStore Module Log| Addon thesslstorefullv2_hook_PreInvoicingGenerateInvoiceItems SSL expiration date and order expiration will different certificateEndDate, $CertificateEndDate without noOfDaysPriorToExpirationDate,  service-id: {$serviceData['serviceid']}");
                                            }
                                        }
                                        
                                        $CertificateEndDate = date('Y-m-d', strtotime($CertificateEndDate . '-' . $noOfDaysPriorToExpirationDate . ' days'));
                                        if(changeTimeZone($hostingData->nextduedate, 'Y-m-d') != $certificateEndDate) {
                                            customErrorLog("TheSSLStore Module Log| Addon thesslstorefullv2_hook_PreInvoicingGenerateInvoiceItems func SSL expiration date and order expiration will different certificateEndDate, $CertificateEndDate with noOfDaysPriorToExpirationDate, {$noOfDaysPriorToExpirationDate},  service-id: {$serviceData['serviceid']}");

                                            Capsule::table('tblhosting')
                                                ->where('id', '=', $serviceData['serviceid'])
                                                ->whereNotIn('billingcycle', ['One Time', 'Free Account'])
                                                ->update(['nextduedate' => $CertificateEndDate, 'nextinvoicedate' => $CertificateEndDate]);
                                            customErrorLog("TheSSLStore Module Log| Addon thesslstorefullv2_hook_PreInvoicingGenerateInvoiceItems func CertificateEndDate=$CertificateEndDate,service_id = {$serviceData['serviceid']}, hostingData=". json_encode($hostingData,true));
                                        }
                                    }
                                    if(changeTimeZone($hostingData->nextduedate, 'Y-m-d') != $certificateEndDate) {
                                        customErrorLog("TheSSLStore Module Log| Addon thesslstorefullv2_hook_PreInvoicingGenerateInvoiceItems func CertificateEndDate=$CertificateEndDate,service_id = {$serviceData['serviceid']}, hostingData=". json_encode($hostingData,true));
                                        customErrorLog("TheSSLStore Module Log| Addon Update nextduedate and nextinvoicedate in tblhosting table to, {$CertificateEndDate}, service_id = {$serviceData['serviceid']}");
                                    }

                                }
                            }
                    }
                } catch (\Exception $e) {
                    logActivity("TheSSLStore Module Log|query, {$e->getMessage()}");
                }
            }
        }
    customErrorLog("TheSSLStore Module Log| End hook thesslstorefullv2_hook_PreInvoicingGenerateInvoiceItems");
}
function thesslstorefullv2_hook_InvoiceCreated($vars)
{
    customErrorLog("TheSSLStore Module Log| Start hook thesslstorefullv2_hook_InvoiceCreated");
    $result = Capsule::table('tblinvoiceitems')
            ->join('tblsslorders', 'tblinvoiceitems.relid', '=', 'tblsslorders.serviceid')
            ->select('tblinvoiceitems.relid', 'tblinvoiceitems.type','tblsslorders.serviceid','tblsslorders.module')
            ->where('tblsslorders.module', '=', 'thesslstorefullv2')
            ->where('tblinvoiceitems.invoiceid', '=', $vars['invoiceid'])
            ->get();
    $resultData = json_decode(json_encode($result,JSON_OBJECT_AS_ARRAY),true);
	customErrorLog("TheSSLStore Module Log| thesslstorefullv2_hook_InvoiceCreated func Vars Data =".json_encode($vars,true));
	customErrorLog("TheSSLStore Module Log| thesslstorefullv2_hook_InvoiceCreated func resultData =".json_encode($result,true));
    
    if(!empty($resultData)) {
        foreach ($resultData as $row) {
            try {
                if ($row['type'] == 'Hosting') {
                        $hostingData = Capsule::table('tblhosting')
                            ->select('tblhosting.nextduedate', 'tblhosting.nextinvoicedate')
                            ->where('tblhosting.id', '=', $row['relid'])
                            ->first();

                        if (isset($hostingData->nextinvoicedate)) {

                            customErrorLog("TheSSLStore Module Log| InvoiceCreated Hook NextDueDate ServiceId - {$row['relid']}, nextduedate - {$hostingData->nextduedate}, nextinvoicedate - {$hostingData->nextinvoicedate}");

                            //get default setting for invoice generation days from WHMCS (Setup > Automation Settings)
                            //get Invoice created settings from WHMCS
                            $createInvoiceDaysBeforeData = Capsule::table('tblconfiguration')
                                ->select('tblconfiguration.value')
                                ->where('tblconfiguration.setting', '=', 'CreateInvoiceDaysBefore')
                                ->first();

                            $createInvoiceDaysBefore = (!empty($createInvoiceDaysBeforeData->value) ? $createInvoiceDaysBeforeData->value : 0);

                            $certificateDueDate = date('Y-m-d', strtotime(changeTimeZone($hostingData->nextinvoicedate) . '-' . $createInvoiceDaysBefore . ' days'));

                            $is_renewal_invoice = 0;
							customErrorLog("TheSSLStore Module Log| thesslstorefullv2_hook_InvoiceCreated func createInvoiceDaysBefore=$createInvoiceDaysBefore,certificateDueDate=$certificateDueDate,relid= {$row['relid']}, nextduedate - {$hostingData->nextduedate}, nextinvoicedate - {$hostingData->nextinvoicedate}");
                            if ($hostingData->nextinvoicedate > date('Y-m-d') && $certificateDueDate == date('Y-m-d')) {
                                $is_renewal_invoice = 1;
								customErrorLog("TheSSLStore Module Log| thesslstorefullv2_hook_InvoiceCreated func createInvoiceDaysBefore=$createInvoiceDaysBefore,certificateDueDate=$certificateDueDate,relid= {$row['relid']}, nextduedate - {$hostingData->nextduedate}, nextinvoicedate - {$hostingData->nextinvoicedate}");
                            } else {
                                $is_renewal_invoice = 0; 
								customErrorLog("TheSSLStore Module Log| thesslstorefullv2_hook_InvoiceCreated func createInvoiceDaysBefore=$createInvoiceDaysBefore,certificateDueDate=$certificateDueDate,relid= {$row['relid']}, nextduedate - {$hostingData->nextduedate}, nextinvoicedate - {$hostingData->nextinvoicedate}");
                            }
							
							try {
								//we can't use common.php's functions here because when this hook called during placeorder cron, common.php is not include due to whmcs directory structure.
                            Capsule::table('mod_sslstore_invoice_log')->insertGetId(array('invoiceid' => $vars['invoiceid'], 'serviceid' => $row['relid'], 'addon_id' => 0, 'dateofinvoice' => date('Y-m-d'), 'dateoforder' => '', 'orderplaced' => 0, 'is_renewal_invoice' => $is_renewal_invoice, 'duedate' => $hostingData->nextinvoicedate));
								customErrorLog("TheSSLStore Module Log| thesslstorefullv2_hook_InvoiceCreated func mod_sslstore_invoice_log Insert log". $vars['invoiceid']);
							} catch (\Exception $e) {
								logActivity("TheSSLStore Module Log|query, {$e->getMessage()}");
							}
							
							customErrorLog("TheSSLStore Module Log| thesslstorefullv2_hook_InvoiceCreated func createInvoiceDaysBefore=$createInvoiceDaysBefore,certificateDueDate=$certificateDueDate,relid= {$row['relid']}, nextduedate - {$hostingData->nextduedate}, nextinvoicedate - {$hostingData->nextinvoicedate}");
                        } else {
							
							try {
								//we can't use common.php's functions here because when this hook called during placeorder cron, common.php is not include due to whmcs directory structure.
                            Capsule::table('mod_sslstore_invoice_log')->insertGetId(array('invoiceid' => $vars['invoiceid'], 'serviceid' => $row['relid'], 'addon_id' => 0, 'dateofinvoice' => date('Y-m-d'), 'dateoforder' => '', 'orderplaced' => 0));
								customErrorLog("TheSSLStore Module Log| thesslstorefullv2_hook_InvoiceCreated func mod_sslstore_invoice_log Insert log". $vars['invoiceid']);
							} catch (\Exception $e) {
								logActivity("TheSSLStore Module Log|query, {$e->getMessage()}");
							}
                            
							customErrorLog("TheSSLStore Module Log| thesslstorefullv2_hook_InvoiceCreated func hostingData= ".json_encode($hostingData,true).",relid= {$row['relid']}, nextduedate - {$hostingData->nextduedate}, nextinvoicedate - {$hostingData->nextinvoicedate}");
                        }
                   
                } elseif ($row['type'] == 'Addon') {
                        //we can't use common.php's functions here because when this hook called during placeorder cron, common.php is not include due to whmcs directory structure.
                        $hostingData = Capsule::table('tblhostingaddons')
                            ->select('tblhostingaddons.nextduedate', 'tblhostingaddons.nextinvoicedate')
                            ->where('tblhostingaddons.id', '=', $row['relid'])
                            ->first();

						customErrorLog("TheSSLStore Module Log| Addon thesslstorefullv2_hook_InvoiceCreated func hostingData= ".json_encode($hostingData,true).",relid= {$row['relid']}, nextduedate - {$hostingData->nextduedate}, nextinvoicedate - {$hostingData->nextinvoicedate}");
                        if (isset($hostingData->nextinvoicedate)) {

                            customErrorLog("TheSSLStore Module Log| Addon InvoiceCreated Hook NextDueDate Get Addon Log|ServiceId - {$row['relid']}, nextduedate - {$hostingData->nextduedate}, nextinvoicedate - {$hostingData->nextinvoicedate}");

                            //get default setting for invoice generation days from WHMCS (Setup > Automation Settings)
                            //get Invoice created settings from WHMCS
                            $createInvoiceDaysBeforeData = Capsule::table('tblconfiguration')
                                ->select('tblconfiguration.value')
                                ->where('tblconfiguration.setting', '=', 'CreateInvoiceDaysBefore')
                                ->first();

                            $createInvoiceDaysBefore = (!empty($createInvoiceDaysBeforeData->value) ? $createInvoiceDaysBeforeData->value : 0);

                            $certificateDueDate = date('Y-m-d', strtotime(changeTimeZone($hostingData->nextinvoicedate) . '-' . $createInvoiceDaysBefore . ' days'));

							customErrorLog("TheSSLStore Module Log| Addon thesslstorefullv2_hook_InvoiceCreated func hostingData= ".json_encode($hostingData,true).",relid= {$row['relid']}, nextduedate - {$hostingData->nextduedate}, nextinvoicedate - {$hostingData->nextinvoicedate}");
                            $is_renewal_invoice = 0;
                            if ($hostingData->nextinvoicedate > date('Y-m-d') && $certificateDueDate == date('Y-m-d')) {
                                $is_renewal_invoice = 1;
							customErrorLog("TheSSLStore Module Log| Addon thesslstorefullv2_hook_InvoiceCreated func hostingData= ".json_encode($hostingData,true).",relid= {$row['relid']}, nextduedate - {$hostingData->nextduedate}, nextinvoicedate - {$hostingData->nextinvoicedate}");
                            } else {
                                $is_renewal_invoice = 0;
								customErrorLog("TheSSLStore Module Log| Addon thesslstorefullv2_hook_InvoiceCreated func hostingData= ".json_encode($hostingData,true).",relid= {$row['relid']}, nextduedate - {$hostingData->nextduedate}, nextinvoicedate - {$hostingData->nextinvoicedate}");
                            }

                            //we can't use common.php's functions here because when this hook called during placeorder cron, common.php is not include due to whmcs directory structure.
                            Capsule::table('mod_sslstore_invoice_log')->insertGetId(array('invoiceid' => $vars['invoiceid'], 'serviceid' => 0, 'addon_id' => $row['relid'], 'dateofinvoice' => date('Y-m-d'), 'dateoforder' => '', 'orderplaced' => 0, 'is_renewal_invoice' => $is_renewal_invoice, 'duedate' => $hostingData->nextinvoicedate));
                        } else {
                            //we can't use common.php's functions here because when this hook called during placeorder cron, common.php is not include due to whmcs directory structure.
                            Capsule::table('mod_sslstore_invoice_log')->insertGetId(array('invoiceid' => $vars['invoiceid'], 'serviceid' => 0, 'addon_id' => $row['relid'], 'dateofinvoice' => date('Y-m-d'), 'dateoforder' => '', 'orderplaced' => 0));
                        }
                   
                }
            } catch (\Exception $e) {
                logActivity("TheSSLStore Module Log|query, {$e->getMessage()}");
            }
        }
    }
    customErrorLog("TheSSLStore Module Log| End hook thesslstorefullv2_hook_InvoiceCreated");
}
function thesslstorefullv2_hook_CancellationRequest($vars)
{
    if(checkTheSSLStoreModule($vars['relid'])){
        try {
            $server = Capsule::table('tblproducts')
                ->join('tblhosting', 'tblhosting.packageid', '=', 'tblproducts.id')
                ->select('tblproducts.servertype', 'tblproducts.configoption1')
                ->where('tblhosting.id', '=', $vars['relid'])
                ->first();
        } catch (\Exception $e) {
            logActivity("TheSSLStore Module Log|query, {$e->getMessage()}");
        }
        if ($server->servertype == 'thesslstorefullv2' && $vars['type'] == 'End of Billing Period') {
            try {
                //Update BillingCycle to "One Time"
                TSSDBClient::update('tblhosting', array('id' => $vars['relid']), array('billingcycle' => 'One Time'));

                $configData = Capsule::table('tblsslorders')->select('certtype', 'remoteid')->where('serviceid', '=', $vars['relid'])->first();

                if (tssIsSiteLockProduct($configData->certtype)) {
                    $cred = getCredentials();
                    $sslApi = new sslstore($cred["partnercode"], $cred["authToken"], false, '', $cred["mode"]);
                    $sitelockCancelReq = new sitelock_cancel_request();
                    $sitelockCancelReq->TheSSLStoreOrderID = $configData->remoteid;
                    $sitelockCancelResp = $sslApi->sitelock_cancel_subscription($sitelockCancelReq);
                }
            } catch (\Exception $e) {
                logActivity("TheSSLStore Module Log|Updating didn't work, {$e->getMessage()}");
            }
        }
    }
}

function thesslstorefullv2_hook_ClientAreaPageUpgrade($vars)
{
    if(checkTheSSLStoreModule($vars['id'])){
        if ($vars['type'] == 'package' && !isset($_POST['step'])) {
            //handle for codeguard & sitelock upgrade
            //Display only same billing cycle as per old product and remove other billing cycle
            try {
                $tblsslOrdersData = Capsule::table('tblsslorders')->where('serviceid', '=', $vars['id'])->first();
                if ($tblsslOrdersData != NULL && $tblsslOrdersData->module == 'thesslstorefullv2' && (tssIsCodeGuardProduct($tblsslOrdersData->certtype) || tssIsSiteLockProduct($tblsslOrdersData->certtype))) {
                    //Get CodeGaurd & Sitelock Upgrade Plan Billing Cycle Data...
                    $service = Service::find($vars['id']);
                    $billingCycle = strtolower($service->billingcycle);

                    $new_upgrade = [];
                    $billingCycleData = array('monthly', 'quarterly', 'semiannually', 'annually', 'biennially', 'triennially');

                    foreach ($vars['upgradepackages'] as $id => $upgradePackage) {
                        foreach ($upgradePackage['pricing'] as $key => $item) {
                            if (in_array($key, $billingCycleData) && strtolower($billingCycle) != strtolower($key)) {
                                unset($upgradePackage['pricing'][$key]);
                            }
                        }
                        $new_upgrade['upgradepackages'][$id] = $upgradePackage;
                    }
                    return $new_upgrade;
                }
            } catch (\Exception $e) {
                logActivity("TheSSLStore Module Log| {$e->getMessage()}");
            }
        } elseif ($vars['filename'] == 'upgrade' && $vars['type'] == 'configoptions') {
            //This code prevent main domain configurable option upgrade
            if (isset($vars['id'])) {
                //get service details
                $tblSSLOrders = Capsule::table('tblsslorders')
                    ->select('remoteid')
                    ->where('serviceid', '=', $vars['id'])
                    ->where('module', '=', 'thesslstorefullv2')
                    ->first();
                if ($tblSSLOrders != NULL) {
                    $new_upgrade = array();
                    foreach ($vars['configoptions'] as $key => $configOption) {
                        if (($configOption['optionname'] == 'Main Domain' || $configOption['optiontype'] == '2') && $configOption['selectedname'] != 'WildCard') {
                            unset($vars['configoptions'][$key]);
                        }
                        $new_upgrade['configoptions'] = $vars['configoptions'];
                    }
                    foreach ($vars['upgrades'] as $key => $configOption) {
                        if ($configOption['configname'] == 'Main Domain' || $configOption['originalvalue'] == 'WildCard' || $configOption['originalvalue'] == 'Standard') {
                            unset($vars['upgrades'][$key]);
                        }
                        $new_upgrade['upgrades'] = $vars['upgrades'];
                    }

                    return $new_upgrade;
                }
            }
        } elseif ($_POST['step'] == 2 && $_POST['type'] == 'configoptions') {
            $server = Capsule::table('tblproducts')
                ->join('tblhosting', 'tblhosting.packageid', '=', 'tblproducts.id')
                ->select('tblproducts.servertype')
                ->where('tblhosting.id', '=', $vars['id'])
                ->first();
            if ($server->servertype == 'thesslstorefullv2') {
                $serviceId = $vars['id'];
                $configoptionsArray = $vars['configoptions'];
                $configoptionsId = key($configoptionsArray);

                $configoptionsOriginalValue = $vars['upgrades'][0]['originalvalue'];
                $configoptionsNewValue = $configoptionsArray[$configoptionsId];
                $configoptionsValueDiff = $configoptionsNewValue - $configoptionsOriginalValue;

                function getProtectedValue($obj, $prop)
                {
                    $reflection = new ReflectionClass($obj);
                    $property = $reflection->getProperty($prop);
                    $property->setAccessible(true);
                    return $property->getValue($obj);
                }

                $currencyArray = getProtectedValue($vars['upgrades'][0]['price'], 'currency');
                $currencyId = $currencyArray['id'];

                //Select no of months for the active service from the table "mod_sslstore_orders_data"
                try {
                    $orderData = Capsule::table('mod_sslstore_orders_data')
                        ->select('mod_sslstore_orders_data.no_of_months')
                        ->where('mod_sslstore_orders_data.service_id', '=', $serviceId)
                        ->where('mod_sslstore_orders_data.ssl_status', '=', 'active')
                        ->first();

                    $no_of_months = $orderData->no_of_months;
                } catch (\Exception $e) {
                    logActivity("TheSSLStore Module Log|query, {$e->getMessage()}");
                }
                $noOfMonths = !empty($no_of_months) ? $no_of_months : 12;

                $cycles = array(1 => 'monthly', 3 => 'quarterly', 6 => 'semiannually', 12 => 'annually', 24 => 'biennially', 36 => 'triennially');
                $billingCycle = !empty($cycles[$noOfMonths]) ? $cycles[$noOfMonths] : 'annually';

                //Select price for the config option id from the table "tblpricing"
                try {
                    $orderData = Capsule::table('tblpricing')
                        ->select('tblpricing.' . $billingCycle)
                        ->where('tblpricing.relid', '=', $configoptionsId)
                        ->where('tblpricing.type', '=', 'configoptions')
                        ->where('tblpricing.currency', '=', $currencyId)
                        ->first();

                    $configOptionPrice = $orderData->$billingCycle;
                } catch (\Exception $e) {
                    logActivity("TheSSLStore Module Log|query, {$e->getMessage()}");
                }

                $finalPrice = $configOptionPrice * $configoptionsValueDiff;

                function accessProtected($obj, $prop, $configOptionPrice, $discount = 0)
                {
                    $reflection = new ReflectionClass($obj);
                    $property = $reflection->getProperty($prop);
                    $property->setAccessible(true);
                    $value = $configOptionPrice - $discount;
                    $property->setValue($obj, $value);
                }

                $upgrades = accessProtected($vars['upgrades'][0]['price'], 'price', $finalPrice);
                $subTotal = accessProtected($vars['subtotal'], 'price', $finalPrice);
                $discount = getProtectedValue($vars['discount'], 'price');
                $total = accessProtected($vars['total'], 'price', $finalPrice, $discount);
            }
        }
    }
}

function thesslstorefullv2_hook_PreUpgradeCheckout($vars)
{
    try {
        $result = Capsule::table('tblupgrades')
            ->join('tblsslorders', 'tblsslorders.serviceid', '=', 'tblupgrades.relid')
            ->select('tblupgrades.recurringchange')
            ->where('tblupgrades.id', '=', $vars['upgradeId'])
            ->where('tblupgrades.type', '=', 'configoptions')
            ->where('tblsslorders.module', '=', 'thesslstorefullv2')
            ->first();
    } catch (\Exception $e) {
        logActivity("TheSSLStore Module Log|query, {$e->getMessage()}");
    }
    $return = [];
    if ($result->recurringchange) {
        return ['amount' => $result->recurringchange];
    }
    $return;
}

add_hook("ClientAreaHeadOutput", 1, "thesslstorefullv2_hook_headoutput");
add_hook("PreInvoicingGenerateInvoiceItems", 1, "thesslstorefullv2_hook_PreInvoicingGenerateInvoiceItems");
add_hook("InvoiceCreated", 1, "thesslstorefullv2_hook_InvoiceCreated");
add_hook("CancellationRequest", 1, "thesslstorefullv2_hook_CancellationRequest");

add_hook('ClientAreaPageUpgrade', 1, "thesslstorefullv2_hook_ClientAreaPageUpgrade");
add_hook('PreUpgradeCheckout', 1, "thesslstorefullv2_hook_PreUpgradeCheckout");

function thesslstorefullv2_OrderProductUpgradeOverride($vars)
{
    if(checkTheSSLStoreModule($_POST['id'])){
        if ($_POST['type'] == 'package') {
            //handle for codeguard upgrade
            //Codeguard will upgrade product with full validity instead of remaining validity so our module is charge full amount instead of pro-rate amount
            try {
                $tblsslOrdersData = Capsule::table('tblsslorders')->where('serviceid', '=', $_POST['id'])->select('module', 'certtype')->first();
                if ($tblsslOrdersData != NULL && $tblsslOrdersData->module == 'thesslstorefullv2' && tssIsCodeGuardProduct($tblsslOrdersData->certtype)) {
                    if (isset($_SESSION['uid'])) { // get the currency from the logged in client
                        $uid = $_SESSION['uid'];
                        $user = Capsule::table('tblclients')
                            ->where('id', $uid)
                            ->first();
                        $curr = $user->currency;
                    }

                    //get new product's pricing
                    $billing_cycle = strtolower($vars['newproductbillingcycle']);
                    $new_product_pricing = Capsule::table('tblpricing')
                        ->where('relid', $vars['newproductid'])
                        ->where('type', 'product')
                        ->where('currency', $curr)
                        ->select($billing_cycle)
                        ->first();

                    $new_full_pricing = $new_product_pricing->{$billing_cycle}; //Get new product's full pricing
                    $new_product_per_day_pricing = $new_full_pricing / $vars['totaldays']; // Get new product's per day pricing
                    $new_product_amount_charge_by_system = $new_full_pricing - ($new_product_per_day_pricing * ($vars['totaldays'] - $vars['daysuntilrenewal'])); //New product's amount charge by system
                    $old_product_credit_amount = $new_product_amount_charge_by_system - $vars['price']; //old product's creditable amount
                    $final_amount = round($new_full_pricing - $old_product_credit_amount, 2); // final chargable amount
                    $return = array('price' => $final_amount, 'daysuntilrenewal' => $vars['totaldays']);
                    logModuleCall('thesslstorefullv2', 'OrderProductUpgradeOverride', $vars, $vars, $return, array());
                    return $return;
                }
            } catch (\Exception $e) {
                logActivity("TheSSLStore Module Log| {$e->getMessage()}");
            }

        }
    }
}

add_hook('OrderProductUpgradeOverride', 1, 'thesslstorefullv2_OrderProductUpgradeOverride');


add_hook("ClientAreaFooterOutput", 1, "thesslstorefullv2_hook_footeroutput");

function thesslstorefullv2_hook_footeroutput($vars)
{
    $returnString = '';
    if ($vars['filename'] == 'cart' && !empty($vars['productinfo']['pid'])) {
        $show_variables = Capsule::select('SHOW TABLE STATUS where name like "tblproducts"');

        if (isset($show_variables[0]->Collation)) {
            $character_set = $show_variables[0]->Collation;
        }

        if (isset($character_set)) {
            $productData = Capsule::table('tblproducts')
                ->join('mod_sslstore_product_data', Capsule::raw("`mod_sslstore_product_data`.`product_code` collate " . $character_set), '=', 'tblproducts.configoption1')
                ->select('mod_sslstore_product_data.is_flex', 'mod_sslstore_product_data.validation_type')
                ->where('tblproducts.id', '=', $vars['productinfo']['pid'])
                ->where('tblproducts.servertype', '=', 'thesslstorefullv2')
                ->first();
        } else {
            $productData = Capsule::table('tblproducts')
                ->join('mod_sslstore_product_data', Capsule::raw("`mod_sslstore_product_data`.`product_code` collate utf8_unicode_ci"), '=', 'tblproducts.configoption1')
                ->select('mod_sslstore_product_data.is_flex', 'mod_sslstore_product_data.validation_type')
                ->where('tblproducts.id', '=', $vars['productinfo']['pid'])
                ->where('tblproducts.servertype', '=', 'thesslstorefullv2')
                ->first();
        }

        if ($productData->is_flex == 'y' && $productData->validation_type != 'EV') {
            $returnString .= "
                <script type='text/javascript'>
                    jQuery(document).ready(function() {
                ";

            if ($vars['templatefile'] == 'configureproduct') {
                $options = array();
                foreach ($vars['configurableoptions'] as $configurableoptions) {
                    if ($configurableoptions['optiontype'] == 4) {
                        $options[] = $configurableoptions['id'];
                    }
                }
                if (!empty($options)) {
                    foreach ($options as $key => $value) {
                        if ($key == 0) {
                            $firstConfigvalue = $value;
                            $secondConfigvalue = $options[$key + 1];
                        } elseif ($key == 1) {
                            $firstConfigvalue = $value;
                            $secondConfigvalue = $options[$key - 1];
                        }

                        $returnString .= "

                        jQuery(document).on('change','#inputConfigOption" . $firstConfigvalue . "', function() {
                            var inputConfigOption" . $secondConfigvalue . " = jQuery('#inputConfigOption" . $secondConfigvalue . "');
                            var range_instance_" . $secondConfigvalue . " = inputConfigOption" . $secondConfigvalue . ".data('ionRangeSlider');

                            var inputConfigOption" . $firstConfigvalue . ";

                            if ((parseInt(jQuery('#inputConfigOption" . $firstConfigvalue . "').val()) + parseInt(jQuery('#inputConfigOption" . $secondConfigvalue . "').val())) > 249) {
                                
                                clearTimeout(inputConfigOption" . $firstConfigvalue . ");

                                inputConfigOption" . $firstConfigvalue . " = setTimeout(function() {
                                    var opposite_val" . $secondConfigvalue . " = 249 - jQuery('#inputConfigOption" . $firstConfigvalue . "').val();
                                    range_instance_" . $secondConfigvalue . ".update({
                                        from: opposite_val" . $secondConfigvalue . "
                                    });
                                    recalctotals();

                                },1000);
                            }

                        });
                        ";
                    }
                }

                $returnString .= '
                        jQuery("#inputBillingcycle option").each(function(index,value) {
                            jQuery(this).text(ucwords(jQuery(this).val()));
                        })
                    ';
            }
            $returnString .= "
                    });

                    function ucwords(str,force){
                        str=force ? str.toLowerCase() : str;  
                        return str.replace(/(\b)([a-zA-Z])/g,
                        function(firstLetter){
                            return firstLetter.toUpperCase();
                        });
                    }
                    $.ajaxPrefilter(function( options, original_Options, jqXHR ) {
                        options.async = true;
                    });
                </script>";
        }
    }
    return $returnString;
}

add_hook('ClientAreaPageCart', 1, function($vars) {
    // Perform hook code here...
    $getProductId = isset($vars['productinfo']['pid']) ? $vars['productinfo']['pid'] : 0;
    if($getProductId != 0) {
        $productResp = Capsule::table('tblproducts')->where('id', '=', $getProductId)->where('servertype', '=', "thesslstorefullv2")->whereIn('configoption1', ['pacbasic','pacpro','pacenterprise','digi_class1_smime','digi_client_premium'])->get();
        $productRespData = json_decode($productResp);
        $getsmimeID = isset($productRespData[0]->id) ? $productRespData[0]->id : 0;
        if(!empty($productRespData) && $getsmimeID != 0) {
            TSSDBClient::update('tblpricing', array('relid' => $getsmimeID), array('triennially' => -1.00));
            TSSDBClient::update('tblproductconfiglinks', array('pid' => $getsmimeID), array('pid' => 0));
        }
    }
});
?>
