<?php
/**
 * Copyright (c) 2017, ZADomains.net
 *For any queries and support please contact support@zadomains.net
 * ZA Domains
 * support@zadomains.net
 * https://www.zadomains.net/
 * v1.6 - Added Registration Coupon Codes
 * v1.7 - Added ability to override registrant email
 * v1.8 - Added com, net, org support
 * v1.9 - Ability to update additional information on contacts
 * v1.9.1 - Fixed printf bug with OpenSRS balanace
 * v2.1 - Handle domains transferred away
 * v2.2 - Added support for Premium Domains
 * v2.3 - Support and fix for SOAP and PHP 5.6
 * v2.4 - Add configuration option to override API calls via SSL
 * v2.5 - New visual design. Force and support for SSL on all API calls
 * v2.6 - Added Suspend and Resume DNS functions - will put clientHold status on domain
 * v2.7 - No code changes. Recompiled for new PHP and WHMCS versions
 * v2.8 - Improved status management for Transfer and Domain Sync functions. New functionality added to notify customers via email using standard WHMCS template when domain transfers succeed or fail. ionCube Encryption removed
 * v2.9 - Update module description. Additional widget formatting
 * v3.0 - Added development/QA functionality
 * v3.1 - Added support for WHMCS 7.10 TLD & Pricing Sync tool
 * v3.2 - Added support to Cancel Domain Transfer
  */

if (!defined("WHMCS")) {
    die("This file cannot be accessed directly");
}

use WHMCS\Domains\DomainLookup\ResultsList;
use WHMCS\Domains\DomainLookup\SearchResult;
use WHMCS\Module\Registrar\Registrarmodule\ApiClient;
use WHMCS\Database\Capsule;
use WHMCS\Domain\TopLevel\ImportItem;


# Configuration array
function zadomains_getConfigArray()
{
    $configarray = array(
        "Username" => array(
            "Type" => "text",
            "Size" => "50",
            "Description" => "Enter your ZA Domains.net username here"
        ),
        "Password" => array(
            "Type" => "password",
            "Size" => "50",
            "Description" => "Enter your ZA Domains.net password here"
        ),
        "ReplaceContact" => array(
            "Type" => "text",
            "Size" => "1",
            "Default" => "N",
            "Description" => "Enter Y to use company name instead of contact name as registrant"
        ),
        "ReplaceRegistrantEmail" => array(
            "Type" => "text",
            "Size" => "1",
            "Default" => "N",
            "Description" => "Enter Y to use RegistrantEmail setting instead of contact email"
        ),
        "RegistrantEmail" => array(
            "Type" => "text",
            "Size" => "50",
            "Default" => "",
            "Description" => "Email address to use for contact if ReplaceRegistrantEmail setting is set to Y"
        ),
        "RegistrationCouponCode" => array(
            "Type" => "text",
            "Size" => "50",
            "Default" => "",
            "Description" => "Enter registration coupon code"
        ),
        "FriendlyName" => array(
            "Type" => "System",
            "Value" => "ZA Domains (v3.0)"
        ),
        "Description" => array(
            "Type" => "System",
            "Value" => "Domain Management for White Label Domain Resellers and Registrars"
        ),
        "EnableTesting" => array(
            "Type" => "text",
            "Size" => "1",
            "Default" => "N",
            "Description" => "Enter Y to use return testing results from API"
        ),
        "TestRegisterSuccess" => array(
            "Type" => "text",
            "Size" => "1",
            "Default" => "Y",
            "Description" => "Enter Y to return success or N to return error for this method"
        ),
        "TestSyncSuccess" => array(
            "Type" => "text",
            "Size" => "1",
            "Default" => "Y",
            "Description" => "Enter Y to return success or N to return error for this method"
        ),
        "TestTransferSuccess" => array(
            "Type" => "text",
            "Size" => "1",
            "Default" => "Y",
            "Description" => "Enter Y to return success or N to return error for this method"
        ),
        "TestTransferSyncSuccess" => array(
            "Type" => "text",
            "Size" => "1",
            "Default" => "Y",
            "Description" => "Enter Y to return success or N to return error for this method"
        )
    );
    return $configarray;
}

# Released in WHMCS 7.10
function zadomains_GetTldPricing(array $params)
{
  try {
        
        $opts = array(
            'ssl' => array(
                'ciphers' => 'SHA256',
                'verify_peer' => false,
                'verify_peer_name' => false
            )
        );
        
        $soapparams = array(
            'encoding' => 'ISO-8859-1',
            'verifypeer' => false,
            'verifyhost' => false,
            'soap_version' => SOAP_1_2,
            'trace' => 1,
            'exceptions' => 1,
            'connection_timeout' => 180,
            'stream_context' => stream_context_create($opts)
        );
        
        $client = new SoapClient("https://www.zadomains.net/api/API_WHMCS.asmx?wsdl", $soapparams);
        
        // Parameter
        $username      = $params["Username"];
        $password      = $params["Password"];
        
 
        $result = $client->GetTldPricing(array(
            "zadomains_username" => $username,
            "zadomains_password" => $password
        ));

        // Parse Result
        $resultstring = $result->GetTldPricingResult;
        

		//logModuleCall("zadomains", "zadomains_GetTldPricing", "All Pricing", $resultstring, $resultstring, $resultstring);

        if (strpos($resultstring, 'error') !== false) {
            $resultarray     = explode('|', $resultstring);
            $values["error"] = $resultarray[1];
            return $values;
        }
        
		

        // Explode all the results
        $results   = new ResultsList();
        $tldsarray = explode('||', $resultstring);
	

        foreach ($tldsarray as $tldvalues) {
			$tldvalue = explode('|', $tldvalues);

			//logModuleCall("zadomains", "zadomains_GetTldPricing", "setExtension", "", $tldvalue[0], "");
//			logModuleCall("zadomains", "zadomains_GetTldPricing", "setMinYears", "", $tldvalue[1], "");
			//logModuleCall("zadomains", "zadomains_GetTldPricing", "setMaxYears", "", $tldvalue[2], "");
			//logModuleCall("zadomains", "zadomains_GetTldPricing", "setRegisterPrice", "", $tldvalue[3], "");
			//logModuleCall("zadomains", "zadomains_GetTldPricing", "setRenewPrice", "", $tldvalue[4], "");
			//logModuleCall("zadomains", "zadomains_GetTldPricing", "setTransferPrice", "", $tldvalue[5], "");
			//logModuleCall("zadomains", "zadomains_GetTldPricing", "setRedemptionFeeDays", "", $tldvalue[6], "");
			//logModuleCall("zadomains", "zadomains_GetTldPricing", "setRedemptionFeePrice", "", $tldvalue[7], "");
			logModuleCall("zadomains", "zadomains_GetTldPricing", "setExtension", "", $tldvalue[0], "");
			logModuleCall("zadomains", "zadomains_GetTldPricing", "setCurrency", "", $tldvalue[8], "");
			//logModuleCall("zadomains", "zadomains_GetTldPricing", "setEppRequired", "", $tldvalue[9], "");

            $item = (new ImportItem)
            ->setExtension($tldvalue[0])
            ->setMinYears($tldvalue[1])
            ->setMaxYears($tldvalue[2])
            ->setRegisterPrice($tldvalue[3])
            ->setRenewPrice($tldvalue[4])
            ->setTransferPrice($tldvalue[5])
            ->setRedemptionFeeDays($tldvalue[6])
            ->setRedemptionFeePrice($tldvalue[7])
            ->setCurrency($tldvalue[8])
            ->setEppRequired($tldvalue[9]);

			$results[] = $item;
        }
        
        return $results;
        
    }
    catch (\Exception $e) {
        return array(
            'error' => $e->getMessage()
        );
    }

}

function zadomains_CheckAvailability($params)
{
    try {
        
        $opts = array(
            'ssl' => array(
                'ciphers' => 'SHA256',
                'verify_peer' => false,
                'verify_peer_name' => false
            )
        );
        
        $soapparams = array(
            'encoding' => 'ISO-8859-1',
            'verifypeer' => false,
            'verifyhost' => false,
            'soap_version' => SOAP_1_2,
            'trace' => 1,
            'exceptions' => 1,
            'connection_timeout' => 180,
            'stream_context' => stream_context_create($opts)
        );
        
        $client = new SoapClient("https://www.zadomains.net/api/API_WHMCS.asmx?wsdl", $soapparams);
        
        // Parameter
        $username      = $params["Username"];
        $password      = $params["Password"];
        $tld           = $params["tld"];
        $sld           = $params["sld"];
        $tldsToInclude = $params['tldsToInclude'];
        $searchTerm    = $params['searchTerm'];
        $registercouponcode = $params["RegistrationCouponCode"];
	
        $enabletesting = $params["EnableTesting"];
        
        $result = $client->DomainCheckAvailability(array(
            "zadomains_username" => $username,
            "zadomains_password" => $password,
            "domainname" => $searchTerm,
            "tld" => $tldsToInclude
        ));
        
        // Parse Result
        $resultstring = $result->DomainCheckAvailabilityResult;
        
        if (strpos($resultstring, 'error') !== false) {
            $resultarray     = explode('|', $resultstring);
            $values["error"] = $resultarray[1];
            return $values;
        }
        
        // Explode all the results
        $results   = new ResultsList();
        $tldsarray = explode('||', $resultstring);
        foreach ($tldsarray as $tldvalues) {
            $tldvalue          = explode('|', $tldvalues);
            $resultdomain      = $searchTerm;
            $resulttld         = $tldvalue[0];
            $resultcanregister = $tldvalue[1];
            $resultispremium   = $tldvalue[2];
            $resultregistrationcost = $tldvalue[3];
            $resulttransfercost     = $tldvalue[4];
            $currency          = $tldvalue[5];
            
            $searchResult = new SearchResult($resultdomain, $resulttld);
            
            // Determine the appropriate status to return
            if ($resultcanregister == 'available') {
                $status = SearchResult::STATUS_NOT_REGISTERED;
            } elseif ($resultcanregister == 'registered') {
                $status = SearchResult::STATUS_REGISTERED;
            } elseif ($resultcanregister == 'reserved') {
                $status = SearchResult::STATUS_RESERVED;
            } else {
                $status = SearchResult::STATUS_TLD_NOT_SUPPORTED;
            }
            $searchResult->setStatus($status);
            
            // Return premium information if applicable
            if ($resultispremium == 'True') {
                $searchResult->setPremiumDomain(true);
                $searchResult->setPremiumCostPricing(array(
                    'register' => $resultregistrationcost,
                    'renew' => $resultregistrationcost,
                    'CurrencyCode' => 'ZAR'
                ));
            } else {
                $searchResult->setPremiumDomain(false);
                unset($params['premiumCost']);
            }
            
            // Append to the search results list
            $results->append($searchResult);
        }
        
        return $results;
        
    }
    catch (\Exception $e) {
        return array(
            'error' => $e->getMessage()
        );
    }
}

function zadomains_GetNameservers($params)
{
    
    $opts = array(
        'ssl' => array(
            'ciphers' => 'SHA256',
            'verify_peer' => false,
            'verify_peer_name' => false
        )
    );
    
    $soapparams = array(
        'encoding' => 'ISO-8859-1',
        'verifypeer' => false,
        'verifyhost' => false,
        'soap_version' => SOAP_1_2,
        'trace' => 1,
        'exceptions' => 1,
        'connection_timeout' => 180,
        'stream_context' => stream_context_create($opts)
    );
    
    $client = new SoapClient("https://www.zadomains.net/api/API_WHMCS.asmx?wsdl", $soapparams);
    
    
    $username = $params["Username"];
    $password = $params["Password"];
    $tld = $params["tld"];
    $sld = $params["sld"];
	        $enabletesting = $params["EnableTesting"];
    
    $result = $client->GetNameservers(array(
        "zadomains_username" => $username,
        "zadomains_password" => $password,
        "domainname" => $sld,
        "tld" => $tld
    ));
    
    $resultstring = $result->GetNameserversResult;
    
    if (strpos($resultstring, 'error') !== false) {
        $resultarray     = explode('|', $resultstring);
        $values["error"] = $resultarray[1];
        return $values;
    }
    
    $resultarray = explode('|', $resultstring);
    
    $values["ns1"] = $resultarray[0];
    $values["ns2"] = $resultarray[1];
    $values["ns3"] = $resultarray[2];
    $values["ns4"] = $resultarray[3];
    
    
    return $values;
    
}

function zadomains_SaveNameservers($params)
{
    $username    = $params["Username"];
    $password    = $params["Password"];
    $testmode    = $params["TestMode"];
    $tld    = $params["tld"];
    $sld    = $params["sld"];
    $nameserver1 = $params["ns1"];
    $nameserver2 = $params["ns2"];
    $nameserver3 = $params["ns3"];
    $nameserver4 = $params["ns4"];
	        $enabletesting = $params["EnableTesting"];
    # Put your code to save the nameservers here
    
    $opts = array(
        'ssl' => array(
            'ciphers' => 'SHA256',
            'verify_peer' => false,
            'verify_peer_name' => false
        )
    );
    
    $soapparams = array(
        'encoding' => 'ISO-8859-1',
        'verifypeer' => false,
        'verifyhost' => false,
        'soap_version' => SOAP_1_2,
        'trace' => 1,
        'exceptions' => 1,
        'connection_timeout' => 180,
        'stream_context' => stream_context_create($opts)
    );
    
    $client = new SoapClient("https://www.zadomains.net/api/API_WHMCS.asmx?wsdl", $soapparams);
    
    
    $result = $client->SaveNameservers(array(
        "zadomains_username" => $username,
        "zadomains_password" => $password,
        "domainname" => $sld,
        "tld" => $tld,
        "nameserver1" => $nameserver1,
        "nameserver2" => $nameserver2,
        "nameserver3" => $nameserver3,
        "nameserver4" => $nameserver4
        
    ));
    
    $resultstring = $result->SaveNameserversResult;
    
    if (strpos($resultstring, 'error') !== false) {
        $resultarray     = explode('|', $resultstring);
        $values["error"] = $resultarray[1];
        return $values;
    } else {
        return true;
    }
    
    return $values;
}


function zadomains_RegisterDomain($params)
{
    
    $username           = $params["Username"];
    $password           = $params["Password"];
    $testmode           = $params["TestMode"];
    $usecomp            = $params["ReplaceContact"];
    $useregistrantemail = $params["ReplaceRegistrantEmail"];
    $registercouponcode = $params["RegistrationCouponCode"];
    $tld                = $params["tld"];
    $sld                = $params["sld"];
    $regperiod          = $params["regperiod"];
    $nameserver1        = $params["ns1"];
    $nameserver2        = $params["ns2"];
    $nameserver3        = $params["ns3"];
    $nameserver4        = $params["ns4"];
    # Registrant Details
    $RegistrantFirstName     = $params["firstname"];
    $RegistrantLastName = $params["lastname"];
    $RegistrantAddress1 = $params["address1"];
    $RegistrantAddress2 = $params["address2"];
    $RegistrantCity     = $params["city"];
    $RegistrantStateProvince = $params["state"];
    $RegistrantPostalCode    = $params["postcode"];
    $RegistrantCountry  = $params["country"];
    $RegistrantEmailAddress  = $params["email"];
	
	# Testing Settings
	$enabletesting = $params["EnableTesting"];
	$testregistersuccess = $params["TestRegisterSuccess"];
    if ($enabletesting == "Y") {
		if ($testregistersuccess == "Y") {
			return $values;
		}else
		{
			$values["error"] = "Failed by Testing API";
			return $values;
		}
    }

    # Check if ReplaceRegistrantEmail flag is Y then replace email address with RegistrantEmail
    if ($useregistrantemail == "Y") {
        $RegistrantEmailAddress = $params["RegistrantEmail"];
    }
    
    $RegistrantPhone  = $params["phonenumber"];
    $RegistrantCompanyName = $params["companyname"];
    # Admin Details
    $AdminFirstName   = $params["adminfirstname"];
    $AdminLastName    = $params["adminlastname"];
    $AdminAddress1    = $params["adminaddress1"];
    $AdminAddress2    = $params["adminaddress2"];
    $AdminCity        = $params["admincity"];
    $AdminStateProvince    = $params["adminstate"];
    $AdminPostalCode  = $params["adminpostcode"];
    $AdminCountry     = $params["admincountry"];
    $AdminEmailAddress     = $params["adminemail"];
    $AdminPhone       = $params["adminphonenumber"];
    
    /**
     * Premium domain parameters.
     *
     * Premium domains enabled informs you if the admin user has enabled
     * the selling of premium domain names. If this domain is a premium name,
     * `premiumCost` will contain the cost price retrieved at the time of
     * the order being placed. The premium order should only be processed
     * if the cost price now matches the previously fetched amount.
     */
    $premiumDomainsEnabled = (bool) $params['premiumEnabled'];
    $premiumDomainsCost    = $params['premiumCost'];
    
    if ($premiumDomainsEnabled && $premiumDomainsCost) {
        $postfields['accepted_premium_cost'] = $premiumDomainsCost;
    }
    
    
    # Put your code to register domain here
    # If error, return the error message in the value below
    
    $opts = array(
        'ssl' => array(
            'ciphers' => 'SHA256',
            'verify_peer' => false,
            'verify_peer_name' => false
        )
    );
    
    $soapparams = array(
        'encoding' => 'ISO-8859-1',
        'verifypeer' => false,
        'verifyhost' => false,
        'soap_version' => SOAP_1_2,
        'trace' => 1,
        'exceptions' => 1,
        'connection_timeout' => 180,
        'stream_context' => stream_context_create($opts)
    );
    
    $client = new SoapClient("https://www.zadomains.net/api/API_WHMCS.asmx?wsdl", $soapparams);
    
    $username = $params["Username"];
    $password = $params["Password"];
    
    # Check if UseCompanyAsRegistrant flag is Y then replace Firstname and Lastname
    if ($usecomp == "Y") {
        if (trim($RegistrantCompanyName) !== "") {
            $RegistrantFirstName = $RegistrantCompanyName;
            $RegistrantLastName  = "";
        }
    }
    
    # Call different method for co.za than other tlds
    $result = $client->DomainRegister(array(
        "zadomains_username" => $username,
        "zadomains_password" => $password,
        "domainname" => $sld,
        "tld" => $tld,
        "nameserver1" => $nameserver1,
        "nameserver2" => $nameserver2,
        "nameserver3" => $nameserver3,
        "nameserver4" => $nameserver4,
        "firstname" => $RegistrantFirstName,
        "lastname" => $RegistrantLastName,
        "registrant_addressLine1" => $RegistrantAddress1,
        "registrant_addressLine2" => $RegistrantAddress2,
        "registrant_city" => $RegistrantCity,
        "registrant_province" => $RegistrantStateProvince,
        "registrant_postalcode" => $RegistrantPostalCode,
        "registrant_countrycode" => $RegistrantCountry,
        "registrant_contactno" => $RegistrantPhone,
        "registrant_faxno" => $RegistrantPhone,
        "registrant_email" => $RegistrantEmailAddress,
        "admin_firstname" => $AdminFirstName,
        "admin_lastname" => $AdminLastName,
        "admin_registrant_addressLine1" => $AdminAddress1,
        "admin_registrant_addressLine2" => $AdminAddress2,
        "admin_registrant_city" => $AdminCity,
        "admin_registrant_province" => $AdminStateProvince,
        "admin_registrant_postalcode" => $AdminPostalCode,
        "admin_registrant_countrycode" => $AdminCountry,
        "admin_registrant_contactno" => $AdminPhone,
        "admin_registrant_faxno" => $AdminPhone,
        "admin_registrant_email" => $AdminEmailAddress,
        "regperiod" => $regperiod,
        "couponcode" => $registercouponcode
    ));
    
    $resultstring = $result->DomainRegisterResult;
    if (strpos($resultstring, 'error') !== false) {
        $resultarray     = explode('|', $resultstring);
        $values["error"] = $resultarray[1];
        return $values;
    }
    
    return $values;
}

function zadomains_TransferDomain($params)
{
    $username           = $params["Username"];
    $password           = $params["Password"];
    $testmode           = $params["TestMode"];
    $usecomp            = $params["ReplaceContact"];
    $useregistrantemail = $params["ReplaceRegistrantEmail"];
    $tld                = $params["tld"];
    $sld                = $params["sld"];
    $regperiod          = $params["regperiod"];
    $nameserver1        = $params["ns1"];
    $nameserver2        = $params["ns2"];
    $nameserver3        = $params["ns3"];
    $nameserver4        = $params["ns4"];
    # Registrant Details
    $RegistrantFirstName     = $params["firstname"];
    $RegistrantLastName = $params["lastname"];
    $RegistrantAddress1 = $params["address1"];
    $RegistrantAddress2 = $params["address2"];
    $RegistrantCity     = $params["city"];
    $RegistrantStateProvince = $params["state"];
    $RegistrantPostalCode    = $params["postcode"];
    $RegistrantCountry  = $params["country"];
    $RegistrantEmailAddress  = $params["email"];
    $transfercode       = $params["transfersecret"];

	# Testing Settings
	$enabletesting = $params["EnableTesting"];
	$testtransfersuccess = $params["TestTransferSuccess"];
    if ($enabletesting == "Y") {
		if ($testtransfersuccess == "Y") {
			return $values;
		}else
		{
			$values["error"] = "Failed by Testing API";
			return $values;
		}
    }


    # Check if ReplaceRegistrantEmail flag is Y then replace email address with RegistrantEmail
    if ($useregistrantemail == "Y") {
        $RegistrantEmailAddress = $params["RegistrantEmail"];
    }
    
    $RegistrantPhone    = $params["phonenumber"];
    # Admin Details
    $AdminFirstName     = $params["adminfirstname"];
    $AdminLastName = $params["adminlastname"];
    $AdminAddress1 = $params["adminaddress1"];
    $AdminAddress2 = $params["adminaddress2"];
    $AdminCity     = $params["admincity"];
    $AdminStateProvince = $params["adminstate"];
    $AdminPostalCode    = $params["adminpostcode"];
    $AdminCountry  = $params["admincountry"];
    $AdminEmailAddress  = $params["adminemail"];
    $AdminPhone    = $params["adminphonenumber"];
    
    /**
     * Premium domain parameters.
     *
     * Premium domains enabled informs you if the admin user has enabled
     * the selling of premium domain names. If this domain is a premium name,
     * `premiumCost` will contain the cost price retrieved at the time of
     * the order being placed. The premium order should only be processed
     * if the cost price now matches that previously fetched amount.
     */
    $premiumDomainsEnabled = (bool) $params['premiumEnabled'];
    $premiumDomainsCost    = $params['premiumCost'];
    
    # Put your code to register domain here
    # If error, return the error message in the value below
    
    $opts = array(
        'ssl' => array(
            'ciphers' => 'SHA256',
            'verify_peer' => false,
            'verify_peer_name' => false
        )
    );
    
    $soapparams = array(
        'encoding' => 'ISO-8859-1',
        'verifypeer' => false,
        'verifyhost' => false,
        'soap_version' => SOAP_1_2,
        'trace' => 1,
        'exceptions' => 1,
        'connection_timeout' => 180,
        'stream_context' => stream_context_create($opts)
    );
    
    $client = new SoapClient("https://www.zadomains.net/api/API_WHMCS.asmx?wsdl", $soapparams);
    
    
    $username = $params["Username"];
    $password = $params["Password"];
    
    # Check if UseCompanyAsRegistrant flag is Y then replace Firstname and Lastname
    if ($usecomp == "Y") {
        if (trim($RegistrantCompanyName) !== "") {
            $RegistrantFirstName = $RegistrantCompanyName;
            $RegistrantLastName  = "";
        }
    }
    
    $result = $client->DomainTransfer(array(
        "zadomains_username" => $username,
        "zadomains_password" => $password,
        "domainname" => $sld,
        "tld" => $tld,
        "nameserver1" => $nameserver1,
        "nameserver2" => $nameserver2,
        "nameserver3" => $nameserver3,
        "nameserver4" => $nameserver4,
        "firstname" => $RegistrantFirstName,
        "lastname" => $RegistrantLastName,
        "registrant_addressLine1" => $RegistrantAddress1,
        "registrant_addressLine2" => $RegistrantAddress2,
        "registrant_city" => $RegistrantCity,
        "registrant_province" => $RegistrantStateProvince,
        "registrant_postalcode" => $RegistrantPostalCode,
        "registrant_countrycode" => $RegistrantCountry,
        "registrant_contactno" => $RegistrantPhone,
        "registrant_faxno" => $RegistrantPhone,
        "registrant_email" => $RegistrantEmailAddress,
        "admin_firstname" => $AdminFirstName,
        "admin_lastname" => $AdminLastName,
        "admin_registrant_addressLine1" => $AdminAddress1,
        "admin_registrant_addressLine2" => $AdminAddress2,
        "admin_registrant_city" => $AdminCity,
        "admin_registrant_province" => $AdminStateProvince,
        "admin_registrant_postalcode" => $AdminPostalCode,
        "admin_registrant_countrycode" => $AdminCountry,
        "admin_registrant_contactno" => $AdminPhone,
        "admin_registrant_faxno" => $AdminPhone,
        "admin_registrant_email" => $AdminEmailAddress,
        "transfercode" => $transfercode
    ));
    
    
    $resultstring = $result->DomainTransferResult;
    if (strpos($resultstring, 'error') !== false) {
        $resultarray     = explode('|', $resultstring);
        $values["error"] = $resultarray[1];
        return $values;
    }
    
    return $values;
}

function zadomains_RenewDomain($params)
{
    $username = $params["Username"];
    $password = $params["Password"];
    $testmode = $params["TestMode"];
    $tld = $params["tld"];
    $sld = $params["sld"];
            $enabletesting = $params["EnableTesting"];

    /**
     * Premium domain parameters.
     *
     * Premium domains enabled informs you if the admin user has enabled
     * the selling of premium domain names. If this domain is a premium name,
     * `premiumCost` will contain the cost price retrieved at the time of
     * the order being placed. A premium renewal should only be processed
     * if the cost price now matches that previously fetched amount.
     */
    $premiumDomainsEnabled = (bool) $params['premiumEnabled'];
    $premiumDomainsCost    = $params['premiumCost'];
    
    
    
    # Put your code to register domain here
    # If error, return the error message in the value below
    
    $opts = array(
        'ssl' => array(
            'ciphers' => 'SHA256',
            'verify_peer' => false,
            'verify_peer_name' => false
        )
    );
    
    $soapparams = array(
        'encoding' => 'ISO-8859-1',
        'verifypeer' => false,
        'verifyhost' => false,
        'soap_version' => SOAP_1_2,
        'trace' => 1,
        'exceptions' => 1,
        'connection_timeout' => 180,
        'stream_context' => stream_context_create($opts)
    );
    
    $client = new SoapClient("https://www.zadomains.net/api/API_WHMCS.asmx?wsdl", $soapparams);
    
    $result = $client->DomainRenew(array(
        "zadomains_username" => $username,
        "zadomains_password" => $password,
        "domainname" => $sld,
        "tld" => $tld
    ));
    
    
    $resultstring = $result->DomainRenewResult;
    if (strpos($resultstring, 'error') !== false) {
        $resultarray     = explode('|', $resultstring);
        $values["error"] = $resultarray[1];
        return $values;
    }
    
    return $values;
}

function zadomains_GetContactDetails($params)
{
    $username = $params["Username"];
    $password = $params["Password"];
    $tld = $params["tld"];
    $sld = $params["sld"];
            $enabletesting = $params["EnableTesting"];
    # Put your code to get WHOIS data here
    
    $opts = array(
        'ssl' => array(
            'ciphers' => 'SHA256',
            'verify_peer' => false,
            'verify_peer_name' => false
        )
    );
    
    $soapparams = array(
        'encoding' => 'ISO-8859-1',
        'verifypeer' => false,
        'verifyhost' => false,
        'soap_version' => SOAP_1_2,
        'trace' => 1,
        'exceptions' => 1,
        'connection_timeout' => 180,
        'stream_context' => stream_context_create($opts)
    );
    
    $client = new SoapClient("https://www.zadomains.net/api/API_WHMCS.asmx?wsdl", $soapparams);
    
    
    $result = $client->GetWHMCSContactDetails(array(
        "zadomains_username" => $username,
        "zadomains_password" => $password,
        "domainname" => $sld,
        "tld" => $tld
    ));
    
    
    $resultstring = $result->GetWHMCSContactDetailsResult;
    
    if (strpos($resultstring, 'error') !== false) {
        $resultarray     = explode('|', $resultstring);
        $values["error"] = $resultarray[1];
        return $values;
    }
    
    $resultarray = explode('|', $resultstring);
    
    # Data should be returned in an array as follows
    $values["Registrant"]["First Name"]   = $resultarray[0];
    $values["Registrant"]["Last Name"]    = $resultarray[1];
    $values["Registrant"]["Email"]   = $resultarray[2];
    $values["Registrant"]["Company Name"] = $resultarray[3];
    $values["Registrant"]["Address 1"]    = $resultarray[4];
    $values["Registrant"]["Address 2"]    = $resultarray[5];
    $values["Registrant"]["City"]    = $resultarray[6];
    $values["Registrant"]["State"]   = $resultarray[7];
    $values["Registrant"]["Postcode"]     = $resultarray[8];
    $values["Registrant"]["Country"] = $resultarray[9];
    $values["Registrant"]["Phone Number"] = $resultarray[10];
    
    $_SESSION["zadomainscontactid"] = $resultarray[13];
    return $values;
}

function zadomains_SaveContactDetails($params)
{
    $username = $params["Username"];
    $password = $params["Password"];
    $testmode = $params["TestMode"];
    $tld = $params["tld"];
    $sld = $params["sld"];
            $enabletesting = $params["EnableTesting"];
    
    $FirstName    = $params["contactdetails"]["Registrant"]["First Name"];
    $LastName     = $params["contactdetails"]["Registrant"]["Last Name"];
    $Email   = $params["contactdetails"]["Registrant"]["Email"];
    $Organisation = $params["contactdetails"]["Registrant"]["Company Name"];
    $AddressLine1 = $params["contactdetails"]["Registrant"]["Address 1"];
    $AddressLine2 = $params["contactdetails"]["Registrant"]["Address 2"];
    $City    = $params["contactdetails"]["Registrant"]["City"];
    $Province     = $params["contactdetails"]["Registrant"]["State"];
    $PostalCode   = $params["contactdetails"]["Registrant"]["Postcode"];
    $Country = $params["contactdetails"]["Registrant"]["Country"];
    $ContactNo    = $params["contactdetails"]["Registrant"]["Phone Number"];
    
    $fieldvalues = $FirstName . "|" . $LastName . "|" . $Email . "|" . $Organisation . "|" . $AddressLine1 . "|" . $AddressLine2 . "|" . $City . "|" . $Province . "|" . $PostalCode . "|" . $Country . "|" . $ContactNo;
    
    $zadomainscontactid = $_SESSION["zadomainscontactid"];
    
    
    
    $opts = array(
        'ssl' => array(
            'ciphers' => 'SHA256',
            'verify_peer' => false,
            'verify_peer_name' => false
        )
    );
    
    $soapparams = array(
        'encoding' => 'ISO-8859-1',
        'verifypeer' => false,
        'verifyhost' => false,
        'soap_version' => SOAP_1_2,
        'trace' => 1,
        'exceptions' => 1,
        'connection_timeout' => 180,
        'stream_context' => stream_context_create($opts)
    );
    
    $client = new SoapClient("https://www.zadomains.net/api/API_WHMCS.asmx?wsdl", $soapparams);
    
    
    $result = $client->SaveWHMCSContactDetails(array(
        "zadomains_username" => $username,
        "zadomains_password" => $password,
        "domainname" => $sld,
        "tld" => $tld,
        "contactid" => $zadomainscontactid,
        "fieldvalues" => $fieldvalues
        
    ));
    
    
    $resultstring = $result->SaveWHMCSContactDetailsResult;
    
    if (strpos($resultstring, 'error') !== false) {
        $resultarray     = explode('|', $resultstring);
        $values["error"] = $resultarray[1];
        return $values;
    } else {
        return true;
    }
    
    return $values;
}


function zadomains_TransferSync($params)
{
    $username = $params["Username"];
    $password = $params["Password"];
    $tld = $params["tld"];
    $sld = $params["sld"];
	
	# Testing Settings
	$enabletesting = $params["EnableTesting"];
	$testtransfersuccess = $params["TestTransferSyncSuccess"];
    if ($enabletesting == "Y") {
		if ($testtransfersuccess == "Y") {
			$values['completed'] = true; #  when transfer completes successfully
			return $values;
		}else
		{
        $values["failed"] = true;
        $values["reason"] = "Failed by Testing API";
        return $values;

		}
    }

    $opts = array(
        'ssl' => array(
            'ciphers' => 'SHA256',
            'verify_peer' => false,
            'verify_peer_name' => false
        )
    );
    
    $soapparams = array(
        'encoding' => 'ISO-8859-1',
        'verifypeer' => false,
        'verifyhost' => false,
        'soap_version' => SOAP_1_2,
        'trace' => 1,
        'exceptions' => 1,
        'connection_timeout' => 180,
        'stream_context' => stream_context_create($opts)
    );
    
    
    $client = new SoapClient("https://www.zadomains.net/api/API_WHMCS.asmx?wsdl", $soapparams);
    
    $result = $client->TransferSync(array(
        "zadomains_username" => $username,
        "zadomains_password" => $password,
        "domainname" => $sld,
        "tld" => $tld
        
    ));
    
    
    $resultstring  = $result->TransferSyncResult;
    $values = array();
    
    if (strpos($resultstring, 'error') !== false) {
        $resultarray = explode('|', $resultstring);
        $values["failed"] = true;
        $values["reason"] = $resultarray[1];
        return $values;
    }
    
    if (strpos($resultstring, 'failed') !== false) {


        $resultarray = explode('|', $resultstring);
        $values["failed"] = true;
        $values["reason"] = $resultarray[1];
        return $values;
    }
    
    if (strpos($resultstring, 'Registered') !== false) {
        $values['completed'] = true; #  when transfer completes successfully
        return $values;
    }
}

function zadomains_Sync($params)
{
    $username = $params["Username"];
    $password = $params["Password"];
    $tld = $params["tld"];
    $sld = $params["sld"];

	# Testing Settings
	$enabletesting = $params["EnableTesting"];
	$testsyncsuccess = $params["TestSyncSuccess"];
    if ($enabletesting == "Y") 
	{
		if ($testsyncsuccess == "Y") 
		{
			$values['active'] = true; # set to true if the domain is active
			$values['expirydate'] = "2050-01-01"; # populate with the domains expiry date if available        
			return $values;
		}else
		{
			$values["error"] = "Failed by Testing API";
			return $values;
		}
	}
    
    $opts = array(
        'ssl' => array(
            'ciphers' => 'SHA256',
            'verify_peer' => false,
            'verify_peer_name' => false
        )
    );
    
    $soapparams = array(
        'encoding' => 'ISO-8859-1',
        'verifypeer' => false,
        'verifyhost' => false,
        'soap_version' => SOAP_1_2,
        'trace' => 1,
        'exceptions' => 1,
        'connection_timeout' => 180,
        'stream_context' => stream_context_create($opts)
    );
    
    $client = new SoapClient("https://www.zadomains.net/api/API_WHMCS.asmx?wsdl", $soapparams);
    
    $result = $client->Sync(array(
        "zadomains_username" => $username,
        "zadomains_password" => $password,
        "domainname" => $sld,
        "tld" => $tld
    ));
    
    
    $resultstring = $result->SyncResult;
    
    $values = array();
   
   
	if (strpos($resultstring, 'Domain does not exist on your') !== false) 
	{
        $resultarray = explode('|', $resultstring);
        $values["active"] = false;
        $domainid=$params['domainid'];
        $updatedUserCount = Capsule::table('tbldomains')
        ->where('id', $domainid)
        ->update(
            [
                'status' => 'Transferred Away'
            ]
        );
		return $values;
    }     

	if (strpos($resultstring, 'No such domain') !== false) 
	{
        $resultarray       = explode('|', $resultstring);
        $values["active"] = false;
        $domainid=$params['domainid'];
        $updatedUserCount = Capsule::table('tbldomains')
        ->where('id', $domainid)
        ->update(
            [
                'status' => 'Transferred Away'
            ]
        );
		return $values;
    }     

    if (strpos($resultstring, 'TransferredAway') !== false) {
        $resultarray       = explode('|', $resultstring);
        $values["active"] = false;
        $domainid=$params['domainid'];
        $updatedUserCount = Capsule::table('tbldomains')
        ->where('id', $domainid)
        ->update(
            [
                'status' => 'Transferred Away'
            ]
        );
		return $values;
	}
    
    if (strpos($resultstring, 'Registered') !== false) 
	{
        $resultarray     = explode('|', $resultstring);
        $values['active']     = true; # set to true if the domain is active
        $values['expirydate'] = $resultarray[1]; # populate with the domains expiry date if available        
        
        return $values;
    }
    
  if (strpos($resultstring, 'error') !== false) 
  {
	   $resultarray     = explode('|', $resultstring);
        $values["error"] = $resultarray[1];
        return $values;
  }
}



function zadomains_AdminCustomButtonArray()
{
    
    $domainValues = localAPI("GetClientsDomains", array(
        "domainid" => $GLOBALS["_GET"]["id"]
    ));
    $statusValue  = $domainValues["domains"]["domain"]["0"]["status"];
    $domainname   = $domainValues["domains"]["domain"]["0"]["domainname"];

    
    $opts = array(
        'ssl' => array(
            'ciphers' => 'SHA256',
            'verify_peer' => false,
            'verify_peer_name' => false
        )
    );
    
    $soapparams = array(
        'encoding' => 'ISO-8859-1',
        'verifypeer' => false,
        'verifyhost' => false,
        'soap_version' => SOAP_1_2,
        'trace' => 1,
        'exceptions' => 1,
        'connection_timeout' => 180,
        'stream_context' => stream_context_create($opts)
    );
    
	# Get Suspend status
    $client = new SoapClient("https://www.zadomains.net/api/API_WHMCS.asmx?wsdl", $soapparams);
    
    $result = $client->ClientHoldStatus(array(
        "domainname" => $domainname
    ));
    
    $resultstring = $result->ClientHoldStatusResult;
    
	$buttonarray = array();

    if (strpos($resultstring, 'error') !== false) {
        
    } else {
        
        $isSuspended = $resultstring;
        
        if ($isSuspended == "true") {
			array_push($buttonarray,"Resume DNS" , "resumedns");
        }
        if ($isSuspended == "false") {
			array_push($buttonarray,"Suspend DNS" , "suspenddns");
        }
    }

	if (isGTLD($domainname))
	{
		array_push($buttonarray,"Auth Code" , "authcode");
	}


	# Get Domain status
    $client = new SoapClient("https://www.zadomains.net/api/API_WHMCS.asmx?wsdl", $soapparams);
    
    $result = $client->DomainStatus(array(
        "domainname" => $domainname
    ));
    
    $resultstring = $result->DomainStatusResult;

    if (strpos($resultstring, 'error') !== false) {
        
    } else {
        
        $domainstatus = $resultstring;
        
        if ($domainstatus == "pendingTransfer") {
			array_push($buttonarray,"Cancel Transfer" , "canceltransfer");

        }
    }

    return $buttonarray;
}

function zadomains_canceltransfer($params)
{
    
    $domainid = $params['domainid'];
    $sld = $params['sld'];
    $tld = $params['tld'];
    
    $username = $params["Username"];
    $password = $params["Password"];
    
    
    
    $opts = array(
        'ssl' => array(
            'ciphers' => 'SHA256',
            'verify_peer' => false,
            'verify_peer_name' => false
        )
    );
    
    $soapparams = array(
        'encoding' => 'ISO-8859-1',
        'verifypeer' => false,
        'verifyhost' => false,
        'soap_version' => SOAP_1_2,
        'trace' => 1,
        'exceptions' => 1,
        'connection_timeout' => 180,
        'stream_context' => stream_context_create($opts)
    );
    
    $client = new SoapClient("https://www.zadomains.net/api/API_WHMCS.asmx?wsdl", $soapparams);
    
    # Call different method for co.za than other tlds
    $result = $client->CancelTransfer(array(
        "zadomains_username" => $username,
        "zadomains_password" => $password,
        "domainname" => $sld,
        "tld" => $tld
    ));
    
    $resultstring = $result->CancelTransferResult;
    if (strpos($resultstring, 'error') !== false) {
        $resultarray     = explode('|', $resultstring);
        $values["error"] = $resultarray[1];
        return $values;
    }
    
    return $values;
}

function zadomains_resumedns($params)
{
    
    $domainid = $params['domainid'];
    $sld = $params['sld'];
    $tld = $params['tld'];
    
    $username = $params["Username"];
    $password = $params["Password"];
    
    
    
    $opts = array(
        'ssl' => array(
            'ciphers' => 'SHA256',
            'verify_peer' => false,
            'verify_peer_name' => false
        )
    );
    
    $soapparams = array(
        'encoding' => 'ISO-8859-1',
        'verifypeer' => false,
        'verifyhost' => false,
        'soap_version' => SOAP_1_2,
        'trace' => 1,
        'exceptions' => 1,
        'connection_timeout' => 180,
        'stream_context' => stream_context_create($opts)
    );
    
    $client = new SoapClient("https://www.zadomains.net/api/API_WHMCS.asmx?wsdl", $soapparams);
    
    # Call different method for co.za than other tlds
    $result = $client->ClientHold(array(
        "zadomains_username" => $username,
        "zadomains_password" => $password,
        "domainname" => $sld,
        "tld" => $tld,
        "clienthold" => False
    ));
    
    $resultstring = $result->ClientHoldResult;
    if (strpos($resultstring, 'error') !== false) {
        $resultarray     = explode('|', $resultstring);
        $values["error"] = $resultarray[1];
        return $values;
    }
    
    return $values;
}


function zadomains_suspenddns($params)
{
    
    $domainid = $params['domainid'];
    $sld = $params['sld'];
    $tld = $params['tld'];
    
    $username = $params["Username"];
    $password = $params["Password"];
    
    
    
    $opts = array(
        'ssl' => array(
            'ciphers' => 'SHA256',
            'verify_peer' => false,
            'verify_peer_name' => false
        )
    );
    
    $soapparams = array(
        'encoding' => 'ISO-8859-1',
        'verifypeer' => false,
        'verifyhost' => false,
        'soap_version' => SOAP_1_2,
        'trace' => 1,
        'exceptions' => 1,
        'connection_timeout' => 180,
        'stream_context' => stream_context_create($opts)
    );
    
    $client = new SoapClient("https://www.zadomains.net/api/API_WHMCS.asmx?wsdl", $soapparams);
    
    # Call different method for co.za than other tlds
    $result = $client->ClientHold(array(
        "zadomains_username" => $username,
        "zadomains_password" => $password,
        "domainname" => $sld,
        "tld" => $tld,
        "clienthold" => True
    ));
    
    $resultstring = $result->ClientHoldResult;
    if (strpos($resultstring, 'error') !== false) {
        $resultarray     = explode('|', $resultstring);
        $values["error"] = $resultarray[1];
        return $values;
    }
    
    return $values;
}

function zadomains_authcode($params)
{
    
    $domainid = $params['domainid'];
    $sld = $params['sld'];
    $tld = $params['tld'];
    
    $username = $params["Username"];
    $password = $params["Password"];
    
    $opts = array(
        'ssl' => array(
            'ciphers' => 'SHA256',
            'verify_peer' => false,
            'verify_peer_name' => false
        )
    );
    
    $soapparams = array(
        'encoding' => 'ISO-8859-1',
        'verifypeer' => false,
        'verifyhost' => false,
        'soap_version' => SOAP_1_2,
        'trace' => 1,
        'exceptions' => 1,
        'connection_timeout' => 180,
        'stream_context' => stream_context_create($opts)
    );
    
    $client = new SoapClient("https://www.zadomains.net/api/API_WHMCS.asmx?wsdl", $soapparams);
    
    # Call different method for co.za than other tlds
    $result = $client->SendAuthCode(array(
        "zadomains_username" => $username,
        "zadomains_password" => $password,
        "domainname" => $sld,
        "tld" => $tld
    ));
    
    $resultstring = $result->SendAuthCodeResult;
    if (strpos($resultstring, 'error') !== false) {
        $resultarray     = explode('|', $resultstring);
        $values["error"] = $resultarray[1];
        return $values;
    }
    
    return $values;
}

function isGTLD($domain)
{
	$tlds = array('.biz','.com','.co.uk','.xyz','.info','.mobi','.net','.org','.co','.cloud','.club','.domains','.me','.io','.email','.tv','.be','.photography','.us','.de','.nl','.tech','.host','.hosting','.site','.blog','.online','.website', '.africa','.capetown','.joburg','.durban');
	foreach ($tlds as &$tld) {
		// Search for extension in domain
		$pos = strpos($domain, $tld);

		// Note our use of ===.  Simply == would not work as expected
		if ($pos === false) {

		} else {
			return true;
		}		
	}

	// Not found
    return false;
}

?>