<?php
/*
 * Debitize Debit Order WHMCS Gateway Module
 */
if (!defined("WHMCS")) die("This file cannot be accessed directly");

/**
 * Define module related meta data.
 *
 * Values returned here are used to determine module related capabilities and
 * settings.
 *
 * @see https://developers.whmcs.com/payment-gateways/meta-data-params/
 *
 * @return array
 */
function debitizedo_MetaData()
{
	return array(
		'DisplayName' => 'Debitize Bank Account',
		'APIVersion' => '1.1', // Use API Version 1.1
	);
}

function debitizedo_config() {

	$configarray = array (
        "FriendlyName" => array (
            "Type" => "System",
            "Value" => "Debitize DO"
        )
	);
	return $configarray;
}

function debitizedo_link($params) {
	$invoiceid = $params['invoiceid']; # Invoice ID Number
	$description = $params['description']; # Description (eg. Company Name - Invoice #xxx)
	$amount = $params['amount']; # Format: xxx.xx
	$currency = $params['currency']; # Currency Code (eg. GBP, USD, etc...)

	//Client Variables
	$params['clientdetails']['firstname']; # Clients First Name
	$params['clientdetails']['lastname']; # Clients Last Name
	$params['clientdetails']['email']; # Clients Email Address
	$params['clientdetails']['address1']; # Clients Address
	$params['clientdetails']['address2'];
	$params['clientdetails']['city'];
	$params['clientdetails']['state'];
	$params['clientdetails']['postcode'];
	$params['clientdetails']['country'];
	$params['clientdetails']['phonenumber'];

	$code = '<form action="modules/gateways/debitizedo/debitizedo_callback.php?invoiceid='. $invoiceid . '" method="post">
				<input type="hidden" name="invoice_id" value="' . $invoiceid . '" />
				<input type="hidden" name="amount" value="' . $amount . '" />
				<input type="hidden" name="currency" value="' . $currency . '" />
				<input type="submit" value="Process Direct Debit" />
			</form>';

	return $code;

}
