<?php
if(!defined("WHMCS")){
    die("This file cannot be accessed directly");
}
set_time_limit(0);
/**
 * User: Parag Mehta<parag@paragm.com>
 * Date: 2/27/12
 * Time: 7:27 AM
 * This file is created by www.thesslstore.com for your use. You are free to change the file as per your needs.
 */

class baserequestv2
{
    public $AuthRequest;
    public function __construct()
    {
        $this->AuthRequest = new apirequestv2();
    }
    public function __toString()
   	{
   		return var_export($this,true);
   	}
}

class baseresponsev2
{
    public $AuthResponse;
    public function __construct()
    {
        $this->AuthResponse = new apiresponsev2();
    }
    public function __toString()
	{
		return var_export($this,true);
	}
}

class curlresponsev2
{
	public $info;
	public $response;
	public $error='';
}

/* Common class across request/response */

class apiresponsev2
{
   public $isError = false;
   public $Message;
   public $Timestamp = '';
   public $ReplayToken = '';
   public $InvokingPartnerCode='';
   public function __toString()
   {
       return var_export($this,true);
   }
}

class apirequestv2
{
	public $PartnerCode = '';
	public $AuthToken = '';
	public $ReplayToken = '';
	public $UserAgent = '';
}

class organizationAddressv2
{
    public $AddressLine1;
    public $AddressLine2;
    public $AddressLine3;
    public $City;
    public $Region;
    public $PostalCode;
    public $Country;
    public $Phone;
    public $Fax;
    public $LocalityName;
}

class organizationInfov2
{
    public $OrganizationName;
    public $DUNS;
    public $Division;
    public $IncorporatingAgency;
    public $RegistrationNumber;
    public $JurisdictionCity;
    public $JurisdictionRegion;
    public $JurisdictionCountry;
    /**
     * @var
     */
    public $OrganizationAddress;
}

class contactv2
{
    public $FirstName;
    public $LastName;
    public $Phone;
    public $Fax;
    public $Email;
    public $Title;
    public $OrganizationName;
    public $AddressLine1;
    public $AddressLine2;
    public $City;
    public $Region;
    public $PostalCode;
    public $Country;
}

class oldNewPairv2
{
    public $OldValue;
    public $NewValue;
}

class certificatev2
{
    public $FileName;
    public $FileContent;
}

class orderStatusv2
{
    public $isTinyOrder;
    public $isTinyOrderClaimed;
    public $MajorStatus;
    public $MinorStatus;
}

class productResponsev2
{
    public $ProductCode;
    public $ProductName;
    public $CanbeReissued;
    public $ReissueDays;
}

class productPricingv2
{
    public $NumberOfMonths;
    public $NumberOfServer;
    public $Price;
    public $PricePerAdditionalSAN;
    public $PricePerAdditionalServer;
    public $SRP;
}

class cwatch_admin_contactv2
{
    public $FirstName;
    public $LastName;
    public $Phone;
    public $Email;
    public $Country;
}
/* File Seperator */

class csr_requestv2 extends baserequestv2
{
    public $ProductCode = '';
	public $CSR = '';
}

class csr_download_requestv2 extends baserequestv2{
    public $CustomOrderID;
    public $TheSSLStoreOrderID;
}

class free_claimfree_requestv2 extends baserequestv2
{
    public function __construct()
    {
        $this->NewOrderRequest = new order_neworder_requestv2();
        parent::__construct();
    }
    public $ProductCode;
    public $RelatedTheSSLStoreOrderID;
    public $NewOrderRequest;
}


class free_cuinfo_requestv2 extends baserequestv2
{
    public function __construct()
    {
        $this->OrganisationInfo = new organizationInfov2();
        $this->OrganisationInfo->OrganizationAddress = new organizationAddressv2();
        $this->AdminContact = new contactv2();
        $this->TechnicalContact = new contactv2();
        parent::__construct();
    }

    public $CustomOrderID;
    public $ProductCode;
    public $ExtraProductCodes;
    public $OrganisationInfo;
    public $ValidityPeriod;
    public $ServerCount;
    public $CSR;
    public $DomainName;
    public $WebServerType;
    public $DNSNames;
    public $isCUOrder;
    public $isRenewalOrder;
    public $SpecialInstructions;
    public $RelatedTheSSLStoreOrderID;
    public $isTrialOrder;
    public $AdminContact;
    public $TechnicalContact;
    public $ApproverEmail;
    public $ReserveSANCount;
    public $AddInstallationSupport;
    public $EmailLanguageCode;
}

class health_validate_requestv2
{
    public $PartnerCode;
    public $AuthToken;
    public $ReplayToken;
    public $UserAgent;
}

class health_validate_token_request2
{
    public $IsUsedForTokenSystem=true;
    public $TokenCode;
    public $TokenID;
    public $ReplayToken;
    public $UserAgent;
}

class order_agreement_requestv2 extends baserequestv2
{
    public function __construct()
    {
        $this->OrganisationInfo = new organizationInfov2();
        $this->OrganisationInfo->OrganizationAddress = new organizationAddressv2();
        parent::__construct();
    }
    public $CustomOrderID;
    public $ProductCode;
    public $ExtraProductCodes;
    public $OrganisationInfo;
    public $ValidityPeriod;
    public $ServerCount;
    public $CSR;
    public $DomainName;
    public $WebServerType;
}

class order_download_requestv2 extends baserequestv2
{
    public $CustomOrderID;
    public $TheSSLStoreOrderID;
    public $ResendEmailType;
    public $RefundReason;
    public $RefundRequestID;
}

class order_inviteorder_requestv2 extends baserequestv2
{
    public $PreferVendorLink;
    public $ProductCode;
    public $ExtraProductCode;
    public $ServerCount;
    public $RequestorEmail;
    public $ExtraSAN;
    public $CustomOrderID;
    public $ValidityPeriod;
    public $AddInstallationSupport;
    public $EmailLanguageCode;
}

class order_neworder_requestv2 extends baserequestv2
{
    public function __construct()
    {
        $this->OrganisationInfo = new organizationInfov2();
        $this->OrganisationInfo->OrganizationAddress = new organizationAddressv2();
        $this->AdminContact= new contactv2();
        $this->TechnicalContact= new contactv2();
        parent::__construct();
    }
    public $CustomOrderID;
    public $ProductCode;
    public $ExtraProductCodes;
    public $OrganisationInfo;
    public $ValidityPeriod;
    public $ServerCount;
    public $CSR;
    public $DomainName;
    public $WebServerType;
    public $DNSNames;
    public $isCUOrder;
    public $isRenewalOrder;
    public $SpecialInstructions;
    public $RelatedTheSSLStoreOrderID;
    public $isTrialOrder;
    public $AdminContact;
    public $TechnicalContact;
    public $ApproverEmail;
    public $ReserveSANCount;
    public $AddInstallationSupport;
    public $EmailLanguageCode;
    public $PreOrganizationId;
}

class order_query_requestv2 extends baserequestv2
{
    public $StartDate;
    public $EndDate;
    public $SubUserID;
    public $ProductCode;
}

class order_refundrequest_requestv2 extends baserequestv2
{
    public $CustomOrderID;
    public $TheSSLStoreOrderID;
    public $ResendEmailType;
    public $RefundReason;
    public $RefundRequestID;
}

class order_refundstatus_requestv2 extends baserequestv2
{
    public $CustomOrderID;
    public $TheSSLStoreOrderID;
    public $ResendEmailType;
    public $RefundReason;
    public $RefundRequestID;
}

class order_reissue_requestv2 extends baserequestv2
{
    public function __construct()
    {
        $this->EditSAN = array();
        $this->DeleteSAN = array();
        $this->AddSAN = array();
        parent::__construct();
    }
    public $PartnerOrderID;
    public $CSR;
    public $WebServerType;
    public $DNSNames;
    public $isRenewalOrder;
    public $SpecialInstructions;
    public $EditSAN;
    public $DeleteSAN;
    public $AddSAN;
    public $isWildCard;
    public $ReissueEmail;
}

class order_resend_requestv2 extends baserequestv2
{
    public $CustomOrderID;
    public $TheSSLStoreOrderID;
    public $ResendEmailType;
    public $RefundReason;
    public $RefundRequestID;
}

class order_status_requestv2 extends baserequestv2
{
    public $CustomOrderID;
    public $TheSSLStoreOrderID;
    public $ResendEmailType;
    public $RefundReason;
    public $RefundRequestID;
}


class product_query_requestv2 extends baserequestv2
{
    public $ProductCode;
    public $ProductType;
}

class setting_setordercallback_requestv2 extends baserequestv2
{
    public $url;
}

class setting_setpricecallback_requestv2 extends baserequestv2
{
    public $url;
}

class setting_settemplate_requestv2 extends baserequestv2
{
    public $EmailSubject;
    public $EmailMessage;
    public $isDisabled;
    public $ReminderTemplateDays;
}

class user_add_requestv2 extends baserequestv2
{
    public $CustomPartnerCode;
    public $AuthenticationToken;
    public $PartnerEmail;
}

class user_activate_requestv2 extends baserequestv2
{
    public $PartnerCode;
    public $CustomPartnerCode;
    public $AuthenticationToken;
    public $PartnerEmail;
    public $isEnabled;
}

class user_deactivate_requestv2 extends baserequestv2
{
    public $PartnerCode;
    public $CustomPartnerCode;
    public $AuthenticationToken;
    public $PartnerEmail;
    public $isEnabled;
}

class user_query_requestv2 extends baserequestv2
{
    public $SubUserID;
}
class user_account_detail_requestv2 extends baserequestv2
{
    public $PartnerCode;
    public $AuthToken;
    public $ReplayToken;
    public $UserAgent;
    public $IPAddress;
}

class ee_order_status_requestv2 extends baserequestv2
{
    public $theSSLStoreOrderId;
}

class cwatch_product_list_requestv2 extends baserequestv2{
    public $ProductCode;
}

class cwatch_new_order_requestv2 extends baserequestv2{
    public function __construct(){
        $this->AdminContact = new contact();
        parent::__construct();
    }
    public $autoLicenseUpgrade;
    public $automaticRenewal;
    public $CustomOrderID;
    public $ProductCode;
    public $ValidityPeriod;
    public $ServerCount;
    public $DomainName;
    public $WebServerType;
    public $isCUOrder;
    public $isRenewalOrder;
    public $SpecialInstructions;
    public $isTrialOrder;
    public $AdminContact;
    public $ApproverEmail;
    public $EmailLanguageCode;
    public $RenewalDays;
}

class cwatch_update_site_requestv2 extends baserequestv2{
    public $TheSSLStoreOrderID;
    public $DomainName;
}

class cwatch_upgrade_license_requestv2 extends baserequestv2{
    public $TheSSLStoreOrderID;
    public $ValidityPeriod;
    public $ProductCode;
}

class cwatch_upgrade_link_requestv2 extends baserequestv2{
    public $url;
}

class digicert_create_organization_requestv2 extends baserequestv2{
    public $Name;
    public $AssumedName;
    public $Address;
    public $Address2;
    public $Zip;
    public $City;
    public $State;
    public $Country;
    public $Organization_Phone;
    public $Firstname;
    public $Lastname;
    public $Email;
    public $JobTitle;
    public $Contact_Phone;
    public $Is_EV_Organization;
}

class address
{
    public $addressLine1;
    public $addressLine2;
    public $addressLine3;
    public $city;
    public $state;
    public $zip;
    public $country;
}

class certTransparency
{
    public $ctLogging;
}

class corporation
{
    // public $contactType;
    public $firstName;
    public $lastName;
    public $title;
    public $company;
    public $email;
    public $fax;
    public $phone;
    /**
     * @var
     */
    public $address;
}

class technicalPrimary
{
    // public $contactType;
    public $firstName;
    public $lastName;
    public $title;
    public $company;
    public $email;
    public $fax;
    public $phone;
    /**
     * @var
     */
    public $address;
}

class org
{
    public $orgName;
    public $orgUnit;
    /**
     * @var
     */
    public $address;
}

class domain2
{
    public $cn;
    public $sans;
}

class ee_order_status_responsev2 extends baseresponsev2
{
    public function __construct()
    {
        $this->org = new org();
        $this->org->address = new address();
        $this->corporation = new corporation();
        $this->corporation->address = new address();
        $this->technicalPrimary = new technicalPrimary();
        $this->technicalPrimary->address = new address();
        $this->domain = new domain2();
        $this->certTransparency = new certTransparency();
        parent::__construct();
    }
    public $productType;
    public $csr;
    public $serverType;
    public $signatureAlgorithm;
    public $certChainType;
    public $org;
    public $corporation;
    public $technicalPrimary;
    public $domain;
    public $authType;
    public $locale;
    public $validityPeriodDays;
    public $certFormatList;
    public $theSSLStoreOrderId;
    public $IsEESiteSealAdd;
    public $symcOrderId;
    public $sealInfo;
    public $pkcs7;
    public $x509;
}

class digicert_list_organization_requestv2 extends baserequestv2{
    //
}

class digicert_organization_info_requestv2 extends baserequestv2{
    public $OrganizationId;
}

class csr_responsev2 extends baseresponsev2
{
	public $DominName;
	public $DNSNames;
	public $Country;
	public $Email;
	public $Locality;
	public $Organization;
	public $OrganisationUnit;
	public $State;
	public $hasBadExtensions = false;
	public $isValidDomainName = false;
	public $isWildcardCSR = false;
}

class csr_download_responsev2 extends baseresponsev2{
    public $CSR;
}

class free_claimfree_responsev2 extends baseresponsev2
{
    public $isAllowed;
    public $PartnerOrderID;
    public $LoginName;
    public $LoginPassword;
}

class free_cuinfo_responsev2 extends baseresponsev2
{
    public $isSupported;
    public $Months;
    public $SerialNumber;
    public $ExpirationDate;
    public $Issuer;
}

class health_validate_responsev2
{
    public $Status;
}

class health_validate_token_response2
{
    public $Status;
}

class order_download_responsev2 extends baseresponsev2
{
    public $PartnerOrderID;
    public $CertificateStartDate;
    public $CertificateEndDate;
    public $CertificateStatus;
    public $ValidationStatus;
    public $Certificates;
}

class order_responsev2 extends baseresponsev2
{
    public function __construct()
    {
        $this->OrderStatus = new orderStatusv2();
        parent::__construct();
    }
    public $PartnerOrderID;
    public $CustomOrderID;
    public $TheSSLStoreOrderID;
    public $VendorOrderID;
    public $RefundRequestID;
    public $isRefundApproved;
    public $TinyOrderLink;
    public $OrderStatus;
    public $OrderAmount;
    public $CertificateStartDate;
    public $CertificateEndDate;
    public $OrderExpiryDate;
    public $CommonName;
    public $DNSNames;
    public $State;
    public $Country;
    public $Locality;
    public $Organization;
    public $OrganizationalUnit;
    public $WebServerType;
    public $ReissueSuccessCode;
}

class order_approverlist_responsev2 extends baseresponsev2
{
    public $ApproverEmailList;
}

class order_agreement_responsev2 extends baseresponsev2
{
    public $Agreement;
}

class user_subuser_responsev2 extends baseresponsev2
{
    public $PartnerCode;
    public $CustomPartnerCode;
    public $AuthenticationToken;
    public $PartnerEmail;
    public $isEnabled;
}
class user_account_detail_responsev2 extends baseresponsev2
{
    public $PartnerCode;
    public $CompanyName;
    public $FullName;
    public $Email;
    public $AlternateEmail;
    public $AccountType;
    public $AccountBalance;
    public $CurrentPlan;
    public $AllowCredit;
    public $Address;
    public $City;
    public $Country;
    public $Phone;
    public $State;
    public $Zip;
}

class order_download_zipresponsev2 extends baseresponsev2
{
    public $PartnerOrderID;
    public $CertificateStartDate;
    public $CertificateEndDate;
    public $CertificateStatus;
    public $ValidationStatus;
    public $Certificates;
    public $Zip;
}
class order_replacement_requestv2 extends baserequestv2
{

}
class order_replacement_responsev2 extends baseresponsev2
{

}

class cwatch_order_responsev2 extends baseresponsev2{

    public function __construct()
    {
        $this->OrderStatus = new orderStatusv2();
        $this->AdminContact = new cwatch_admin_contactv2();
        parent::__construct();
    }
    public $PartnerOrderID;
    public $CustomOrderID;
    public $TheSSLStoreOrderID;
    public $VendorOrderID;
    public $RefundRequestID;
    public $isRefundApproved;
    public $TinyOrderLink;
    public $OrderStatus;
    public $OrderAmount;
    public $PurchaseDate;
    public $LicenseStartDate;
    public $LicenseEndDate;
    public $DomainName;
    public $Validity;
    public $ApproverEmail;
    public $ProductName;
    public $ProductCode;
    public $AdminContact;
    public $Token;
    public $LicenseKey;
}

class digicert_create_organization_responsev2 extends baseresponsev2{
    public $VendorOrganizationId;
    public $OrganizationId;
}

class digicert_list_organization_responsev2 extends baseresponsev2{
    public $OrganizationList;
}

class digicert_organization_info_responsev2 extends baseresponsev2{
    public $Name;
    public $AssumedName;
    public $Address;
    public $Address2;
    public $Zip;
    public $City;
    public $State;
    public $Country;
    public $Organization_Phone;
    public $Firstname;
    public $Lastname;
    public $Email;
    public $JobTitle;
    public $Contact_Phone;
    public $VendorOrganizationId;
    public $OrganizationId;
    public $Status;
}

/* File Seperator */

class sslstorev2
{
	public static $API_MODE_LIVE='LIVE';
	public static $API_MODE_TEST='TEST';
    public static $LOG_ALLAPICALLS=false;

	private $_apimode='TEST';
	private $_partnerCode='';
	private $_authToken='';
	private $_userAgent='';

	function __construct($partnerCode,$authToken,$apimode,$userAgent='WHMCSV2-FULL-4.8.1')
	{
		$this->EnsurePHPVersion();
		$this->_apimode = $apimode;
		$this->_partnerCode = $partnerCode;
		$this->_authToken = $authToken;
		$this->_userAgent = $userAgent;
	}

	public function EnsurePHPVersion()
	{
		if(floatval(phpversion())< 5.2)
		{
			throw new Exception('Not Supported version of PHP. Requires atleast 5.2 or greater version of PHP.');
		}
	}

	private function getAPIRequest()
	{
		$AuthRequest = new apirequestv2();
		$AuthRequest->AuthToken = $this->_authToken;
		$AuthRequest->PartnerCode = $this->_partnerCode;
		$AuthRequest->UserAgent = $this->_userAgent;
		$AuthRequest->ReplayToken = uniqid('SSLSTORE-PHP');
		return $AuthRequest;
	}

    private function cloneObjectFromJson($obj,$jsonobj)
    {
        if($jsonobj!=null && is_object($jsonobj))
        {
            foreach ($jsonobj AS $key => $val) $obj->{$key} = $val;
            return $obj;
        }
        else
            return $jsonobj; //No need to map as it's a scalar value
    }

	private function getCURL($url,$method,$message='')
	{
		$ch = curl_init();
		if (!$ch)
		{
			die("Couldn't initialize a cURL handle");
		}
		curl_setopt($ch, CURLOPT_URL,$url);
		if($method=='POST')
		{
			curl_setopt($ch, CURLOPT_POST, 1);
		}
		else
		{
			curl_setopt($ch,CURLOPT_HTTPGET,1);
		}
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
		curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 2);
		if($message!='')
			curl_setopt($ch, CURLOPT_POSTFIELDS,$message); //Append POST messages
		curl_setopt($ch,CURLOPT_HTTPHEADER,array ("Content-Type: application/json; charset=utf-8"));
		return $ch;
	}

	private function getCURLResponse($curl)
	{
		$returnresp = new curlresponsev2();
		$returnresp->response = curl_exec($curl);
		if(curl_errno($curl))
			$returnresp->error = curl_error($curl);
		$returnresp->info = curl_getinfo($curl);
		curl_close($curl); // close cURL handler
		return $returnresp; //Return Result
	}

    private function postToCurl($url,$requestData,$responseData,$HttpMethod='POST')
    {
        $logid = uniqid('api-without-token-'); //for calls without ID
        if(isset($requestData->AuthRequest))
        {
            $requestData->AuthRequest = $this->getAPIRequest();
            $logid = $requestData->AuthRequest->ReplayToken;
        }
        $msg = '';
        if($requestData!=null)
            $msg = json_encode($requestData); //SET JSON FORMAT if not null
       	$curl = $this->getCURL($url,$HttpMethod, $msg);
       	$response = $this->getCURLResponse($curl);

        if(sslstorev2::$LOG_ALLAPICALLS)
        {
            $requestfile = $logid . '-request.json';
            $responsefile = $logid . '-response.json';
            file_put_contents($requestfile, $msg);
            file_put_contents($responsefile, $response);
        }
        if($response->error=='')
       	{
       		$respobj = json_decode($response->response);
       		if($responseData!=null) //Indicates if Casting required to a class type
               $result = $this->cloneObjectFromJson($responseData,$respobj);
            else
               $result = $respobj; //Returns raw response if not

           if(isset($result->AuthRequest))
           {
                if($result->AuthResponse->ReplayToken!=$requestData->AuthRequest->ReplayToken)
                {
                       $result = $responseData;
                       die('Something wrong with API, ReplayTokens does not match!');
                }
           }
            return $result;
        }
        else
        {

            $responseData->AuthResponse->isError = true;
            $responseData->AuthResponse->Message = array($response->error);
            return $responseData;
        }
    }

	public function getURL()
	{
		if(strtoupper($this->_apimode)=='LIVE')
		   return 'https://api.thesslstore.com/rest';
		else
        {
            return 'https://sandbox-wbapi.thesslstore.com/rest';
            // return 'https://playground-api.thesslstore.com/rest';
        }
	}

    /**
     * @param csr_request $csr_request
     * @return csr_response
    */
	public function csr($csr_request)
	{
		$url = $this->getURL() . '/csr/';
		$csrreq =  new csr_requestv2();
		$csrreq->ProductCode = $csr_request->ProductCode;
		$csrreq->CSR = str_ireplace("\r\n",'',$csr_request->CSR);
        $csrresp = new csr_responsev2();
        return $this->postToCurl($url,$csrreq,$csrresp);
    }
	
	 /**
     * @param csr_download_request $csr_download_request
     * @return csr_download_response
     */
    public function csr_download($csr_download_request)
    {
        $url = $this->getURL() . '/csr/download/';
        $resp = new csr_download_responsev2();
        return $this->postToCurl($url,$csr_download_request,$resp);
    }

    /**
     * @param free_claimfree_request $free_claimfree_request
     * @return free_claimfree_response
    */
    public function free_claimfree($free_claimfree_request)
    {
        $url = $this->getURL() . '/free/claimfree/';
        $resp = new free_claimfree_responsev2();
        return $this->postToCurl($url,$free_claimfree_request,$resp);
    }

    /**
     * @param free_cuinfo_request $free_cuinfo_request
     * @return free_cuinfo_response
    */
    public function free_cuinfo($free_cuinfo_request)
    {
        $url = $this->getURL() . '/free/cuinfo/';
        $resp = new free_cuinfo_responsev2();
        return $this->postToCurl($url,$free_cuinfo_request,$resp);
    }

    /**
         * @return apiresponsev2
    */
    public function health_status()
  	{
        $url = $this->getURL() . '/health/status/';
        $resp = new apiresponsev2();
        return $this->postToCurl($url,null,$resp,'GET');
    }

    /**
     * @param health_validate_request $health_validate_request
     * @return health_validate_response
    */
    public function health_validate($health_validate_request)
    {
        $url = $this->getURL() . '/health/validate/';
        $resp = new health_validate_responsev2();
        $apidetails = $this->getAPIRequest();
        $health_validate_request->AuthToken = $apidetails->AuthToken;
        $health_validate_request->PartnerCode = $apidetails->PartnerCode;
        $health_validate_request->UserAgent = $apidetails->UserAgent;
        $health_validate_request->ReplayToken = $apidetails->ReplayToken;

        return $this->postToCurl($url,$health_validate_request,$resp);
    }

    /**
     * @param health_validate_request $health_validate_request
     * @return health_validate_response
     */
    public function health_validate_token($health_validate_token_request)
    {
        $url = $this->getURL() . '/health/validatetoken/';
        $resp = new health_validate_token_response2();
        $apidetails = $this->getAPIRequest();
        $health_validate_token_request->TokenID = $apidetails->TokenID;
        $health_validate_token_request->TokenCode = $apidetails->TokenCode;
        $health_validate_token_request->UserAgent = $apidetails->UserAgent;
        $health_validate_token_request->ReplayToken = $apidetails->ReplayToken;

        return $this->postToCurl($url,$health_validate_token_request,$resp);
    }

    /**
     * @param order_agreement_request $order_agreement_request
     * @return string
    */
    public function order_agreement($order_agreement_request)
    {
        $url = $this->getURL() . '/order/agreement/';
        $resp = new order_agreement_responsev2();
        return $this->postToCurl($url,$order_agreement_request,$resp);
    }

    /**
     * @param order_neworder_request $order_approverlist_request
     * @return order_approverlist_response
    */
    public function order_approverlist($order_approverlist_request)
    {
        $url = $this->getURL() . '/order/approverlist/';
        $resp = new order_approverlist_responsev2();
        return $this->postToCurl($url,$order_approverlist_request,$resp);
    }

    /**
     * @param order_download_request $order_download_request
     * @return order_download_response
    */
    public function order_download($order_download_request)
    {
        $url = $this->getURL() . '/order/download/';
        $resp = new order_download_responsev2();
        return $this->postToCurl($url,$order_download_request,$resp);
    }

    /**
     * @param order_download_request $order_download_request
     * @return order_download_zipresponse
     */
    public function order_download_zip($order_download_request)
    {
        $url = $this->getURL() . '/order/downloadaszip/';
        $resp = new order_download_zipresponsev2();
        return $this->postToCurl($url,$order_download_request,$resp);
    }


    /**
     * @param order_inviteorder_request $order_inviteorder_request
     * @return order_response
    */
    public function order_inviteorder($order_inviteorder_request)
    {
        $url = $this->getURL() . '/order/inviteorder/';
        $resp = new order_responsev2();
        return $this->postToCurl($url,$order_inviteorder_request,$resp);
    }

    /**
     * @param order_neworder_request $order_neworder_request
     * @return order_response
    */
    public function order_neworder($order_neworder_request)
    {
            $url = $this->getURL() . '/order/neworder/';
            $resp = new order_responsev2();
            return $this->postToCurl($url,$order_neworder_request,$resp);
    }

    /**  Should return array(order_response())
     * @param order_query_request $order_query_request
     * @return object
    */
    public function order_query($order_query_request)
    {
            $url = $this->getURL() . '/order/query/';
            $resp = null;
            return $this->postToCurl($url,$order_query_request,$resp);
    }

    /**
     * @param order_refundrequest_request $order_refundrequest_request
     * @return order_response
    */
    public function order_refundrequest($order_refundrequest_request)
    {
            $url = $this->getURL() . '/order/refundrequest/';
            $resp = new order_responsev2();
            return $this->postToCurl($url,$order_refundrequest_request,$resp);
    }

    /**
     * @param order_refundstatus_request $order_refundstatus_request
     * @return order_response
    */
    public function order_refundstatus($order_refundstatus_request)
    {
            $url = $this->getURL() . '/order/refundstatus/';
            $resp = new order_responsev2();
            return $this->postToCurl($url,$order_refundstatus_request,$resp);
    }

    /**
     * @param order_reissue_request $order_reissue_request
     * @return order_response
    */
    public function order_reissue($order_reissue_request)
    {
            $url = $this->getURL() . '/order/reissue/';
            $resp = new order_responsev2();
            return $this->postToCurl($url,$order_reissue_request,$resp);
    }

    /**
     * @param order_resend_request $order_resend_request
     * @return apiresponse
    */
    public function  order_resend($order_resend_request)
    {
            $url = $this->getURL() . '/order/resend/';
            $resp = new apiresponsev2();
            return $this->postToCurl($url,$order_resend_request,$resp);
    }

    /**
     * @param order_status_request $order_status_request
     * @return order_response
    */
    public function  order_status($order_status_request)
    {
            $url = $this->getURL() . '/order/status/';
            $resp = new order_responsev2();
            return $this->postToCurl($url,$order_status_request,$resp);
    }


    /**
     * @param order_neworder_request $order_validate_request
     * @return apiresponse
    */
    public function  order_validate($order_validate_request)
    {
            $url = $this->getURL() . '/order/validate/';
            $resp = new apiresponsev2();
            return $this->postToCurl($url,$order_validate_request,$resp);
    }

    /**
     * @param product_query_request $product_query_request
     * @return object
    */
    public function  product_query($product_query_request)
    {
            $url = $this->getURL() . '/product/query/';
            $resp = null;
            return $this->postToCurl($url,$product_query_request,$resp);
    }

    /**
     * @param setting_setordercallback_request $setting_setordercallback_request
     * @return apiresponse
    */
    public function  setting_setordercallback($setting_setordercallback_request)
    {
            $url = $this->getURL() . '/setting/setordercallback/';
            $resp = new apiresponsev2();
            return $this->postToCurl($url,$setting_setordercallback_request,$resp);
    }

    /**
     * @param setting_setpricecallback_request $setting_setpricecallback_request
     * @return apiresponse
    */
    public function  setting_setpricecallback($setting_setpricecallback_request)
    {
            $url = $this->getURL() . '/setting/setpricecallback/';
            $resp = new apiresponsev2();
            return $this->postToCurl($url,$setting_setpricecallback_request,$resp);
    }

    /**
     * @param setting_settemplate_request $setting_settemplate_request
     * @return apiresponse
    */
    public function  setting_settemplate($setting_settemplate_request)
    {
            $url = $this->getURL() . '/setting/settemplate/';
            $resp = new apiresponsev2();
            return $this->postToCurl($url,$setting_settemplate_request,$resp);
    }

    /**
     * @param user_add_request $user_add_request
     * @return user_subuser_response
    */
    public function  user_add($user_add_request)
    {
            $url = $this->getURL() . '/user/add/';
            $resp = new user_subuser_responsev2();
            return $this->postToCurl($url,$user_add_request,$resp);
    }

    /**
     * @param user_activate_request $user_activate_request
     * @return user_subuser_response
    */
    public function  user_activate($user_activate_request)
    {
            $url = $this->getURL() . '/user/activate/';
            $resp = new user_subuser_responsev2();
            return $this->postToCurl($url,$user_activate_request,$resp);
    }

    /**
     * @param user_deactivate_request $user_deactivate_request
     * @return user_subuser_response
    */
    public function user_deactivate($user_deactivate_request)
    {
            $url = $this->getURL() . '/user/deactivate/';
            $resp = new user_subuser_responsev2();
            return $this->postToCurl($url,$user_deactivate_request,$resp);
    }

    /**
     * @param user_query_request $user_query_request
     * @return object
    */
    public function user_query($user_query_request)
    {
            $url = $this->getURL() . '/user/query/';
            $resp = null;
            return $this->postToCurl($url,$user_query_request,$resp);
    } 
    /**
     * @param user_account_detail_request $user_account_detail_request
     * @return user_account_detail_response
     */
    public function user_account_detail($user_account_detail_request)
    {
        $url = $this->getURL() . '/user/accountdetail/';
        $resp = new user_account_detail_responsev2();
        $apidetails = $this->getAPIRequest();

        $user_account_detail_request->PartnerCode = $apidetails->PartnerCode;
        $user_account_detail_request->AuthToken = $apidetails->AuthToken;
        $user_account_detail_request->ReplayToken = $apidetails->ReplayToken;
        $user_account_detail_request->UserAgent = $apidetails->UserAgent;
        $user_account_detail_request->IPAddress = $apidetails->IPAddress;

        return $this->postToCurl($url,$user_account_detail_request,$resp);
    }

    /**
     * @param order_status_request $order_status_request
     * @return order_status_response
     */
    public function ee_order_status($order_status_request)
    {
        $url = $this->getURL() . '/ee/status/';
        $order_status_response = new ee_order_status_responsev2();
        return $this->postToCurl($url,$order_status_request,$order_status_response);
    }


    /**
     * @param order_replacement_request $order_replacement_request
     * @return object
     */
    public function order_replacement($order_replacement_request)
    {
        $url = $this->getURL() . '/order/getsymantecreplacementorders/';
        $resp = new order_replacement_responsev2();
        return $this->postToCurl($url,$order_replacement_request,$resp);
    }

    /**
     * @param cwatch_product_list_request $cwatch_product_list_request
     * @return object
     */
    public function  cwatch_product_list($cwatch_product_list_request)
    {
        $url = $this->getURL() . '/cwatch/listproducts/';
        $resp = new apiresponsev2();
        return $this->postToCurl($url,$cwatch_product_list_request,$resp);
    }

    /**
     * @param cwatch_invite_order_request $cwatch_invite_order_request
     * @return cwatch_order_response
     */
    public function cwatch_invite_order($cwatch_invite_order_request)
    {
        $url = $this->getURL() . '/cwatch/inviteorder/';
        $resp = new cwatch_order_responsev2();
        return $this->postToCurl($url,$cwatch_invite_order_request,$resp);
    }

    /**
     * @param cwatch_new_order_request $cwatch_new_order_request
     * @return cwatch_order_response
     */
    public function cwatch_new_order($cwatch_new_order_request)
    {
        $url = $this->getURL() . '/cwatch/placeorder/';
        $resp = new cwatch_order_responsev2();
        return $this->postToCurl($url,$cwatch_new_order_request,$resp);
    }

    /**
     * @param order_status_request $order_status_request
     * @return cwatch_order_response
     */
    public function  cwatch_order_status($order_status_request)
    {
        $url = $this->getURL() . '/cwatch/getstatus/';
        $resp = new cwatch_order_responsev2();
        return $this->postToCurl($url,$order_status_request,$resp);
    }

    /**
     * @param order_refundrequest_request $order_refundrequest_request
     * @return cwatch_order_response
     */
    public function cwatch_deactivate_license($order_refundrequest_request)
    {
        $url = $this->getURL() . '/cwatch/deactivatelicense/';
        $resp = new cwatch_order_responsev2();
        return $this->postToCurl($url,$order_refundrequest_request,$resp);
    }

    /**
     * @param cwatch_update_site_request $update_site_request
     * @return cwatch_order_response
     */
    public function cwatch_update_site($update_site_request)
    {
        $url = $this->getURL() . '/cwatch/updatesite/';
        $resp = new cwatch_order_responsev2();
        return $this->postToCurl($url,$update_site_request,$resp);
    }

    /**
     * @param cwatch_upgrade_license_request $upgrade_license_request
     * @return cwatch_order_response
     */
    public function cwatch_upgrade_license($upgrade_license_request)
    {
        $url = $this->getURL() . '/cwatch/upgradelicense/';
        $resp = new cwatch_order_responsev2();
        return $this->postToCurl($url,$upgrade_license_request,$resp);
    }

    /**  Should return array(cwatch_order_response())
     * @param cwatch_order_query_request $cwatch_order_query_request
     * @return object
     */
    public function cwatch_order_query($order_query_request)
    {
        $url = $this->getURL() . '/cwatch/orderquery/';
        $resp =  new cwatch_order_responsev2();
        return $this->postToCurl($url,$order_query_request,$resp);
    }

    /**
     * @param cwatch_upgrade_link_request $upgrade_link_request
     * @return cwatch_order_response
     */
    public function cwatch_upgrade_link($upgrade_link_request)
    {
        $url = $this->getURL() . '/setting/setcwatchupgradecallback/';
        $resp = new cwatch_order_responsev2();
        return $this->postToCurl($url,$upgrade_link_request,$resp);
    }

    /**
     * @param digicert_invite_order_request $digicert_invite_order_request
     * @return order_response
     */
    public function digicert_invite_order($digicert_invite_order_request)
    {
        $url = $this->getURL() . '/digicert/inviteorder/';
        $resp = new order_responsev2();
        return $this->postToCurl($url,$digicert_invite_order_request,$resp);
    }

    /**
     * @param digicert_create_organization_request $digicert_create_organization_request
     * @return digicert_create_organization_response
     */
    public function digicert_create_organization($digicert_create_organization_request)
    {
        $url = $this->getURL() . '/digicert/createorganization/';
        $resp = new digicert_create_organization_responsev2();
        return $this->postToCurl($url,$digicert_create_organization_request,$resp);
    }

    /**
     * @param digicert_list_organization_request $digicert_list_organization_request
     * @return digicert_list_organization_response
     */
    public function digicert_list_organization($digicert_list_organization_request)
    {
        $url = $this->getURL() . '/digicert/organizationlist/';
        $resp = new digicert_list_organization_responsev2();
        $apidetails = $this->getAPIRequest();
        $digicert_list_organization_request->AuthToken = $apidetails->AuthToken;
        $digicert_list_organization_request->PartnerCode = $apidetails->PartnerCode;
        $digicert_list_organization_request->UserAgent = $apidetails->UserAgent;
        $digicert_list_organization_request->ReplayToken = $apidetails->ReplayToken;
        return $this->postToCurl($url,$digicert_list_organization_request,$resp);
    }

    /**
     * @param digicert_organization_info_request $digicert_organization_info_request
     * @return digicert_organization_info_response
     */
    public function digicert_organization_info($digicert_organization_info_request)
    {
        $url = $this->getURL() . '/digicert/organizationinfo/';
        $resp = new digicert_organization_info_responsev2();
        return $this->postToCurl($url,$digicert_organization_info_request,$resp);
    }

    /**
     * @param digicert_neworder_request $digicert_neworder_request
     * @return order_response
     */
    public function digicert_neworder($digicert_neworder_request)
    {
        $url = $this->getURL() . '/digicert/neworder/';
        $resp = new order_responsev2();
        return $this->postToCurl($url,$digicert_neworder_request,$resp);
    }

    /**
     * @param digicert_order_status_request $digicert_order_status_request
     * @return order_response
     */
    public function digicert_order_status($digicert_order_status_request)
    {
        $url = $this->getURL() . '/digicert/status/';
        $resp = new order_responsev2();
        return $this->postToCurl($url,$digicert_order_status_request,$resp);
    }

    /**
     * @param digicert_refundrequest_request $digicert_refundrequest_request
     * @return order_response
     */
    public function digicert_refundrequest($digicert_refundrequest_request)
    {
        $url = $this->getURL() . '/digicert/refundrequest/';
        $resp = new order_responsev2();
        return $this->postToCurl($url,$digicert_refundrequest_request,$resp);
    }

    /**
     * @param digicert_download_request $digicert_download_request
     * @return order_download_response
     */
    public function digicert_download($digicert_download_request)
    {
        $url = $this->getURL() . '/order/download/';
        $resp = new order_download_responsev2();
        return $this->postToCurl($url,$digicert_download_request,$resp);
    }

    /**
     * @param digicert_download_zip_request $digicert_download_zip_request
     * @return order_download_zipresponse
     */
    public function digicert_download_zip($digicert_download_zip_request)
    {
        $url = $this->getURL() . '/order/downloadaszip/';
        $resp = new order_download_zipresponsev2();
        return $this->postToCurl($url,$digicert_download_zip_request,$resp);
    }

    /**
     * @param digicert_reissue_request $digicert_reissue_request
     * @return order_response
     */
    public function digicert_reissue($digicert_reissue_request)
    {
        $url = $this->getURL() . '/digicert/reissue/';
        $resp = new order_responsev2();
        return $this->postToCurl($url,$digicert_reissue_request,$resp);
    }
}

class messagehelperv2
{
    static function writeinfo($msg)
    {
        echo '<strong>' . $msg . '</strong><br/>';
        echo "\n";
    }

    static function writeerror($msg)
    {
        echo '<strong><span style="color:red">';
        echo '<pre>';
        var_dump($msg);
        echo '</pre>';
        echo '</span></strong><br/>';
        echo "\n";
    }

    static function writevarinfo($msg)
    {
        echo '<pre>';
        var_dump($msg);
        echo "</pre></br>\n";
    }
}

?>
