<?php
/**
 * Created by PhpStorm.
 * User: yogesh.patel
 * Date: 28-09-2018
 * Time: 05:34
 */

use Illuminate\Database\Capsule\Manager as Capsule;
require_once dirname(__FILE__).'/common.php';
require_once dirname(__FILE__).'/sslstoreapiv2.php';
if (!defined("WHMCS")) die("This file cannot be accessed directly");
class tss_custom_api{
    private $clientId = 0;
    private $panelHostingId = 0;
    function __construct()
    {
        if(strtolower($_POST['cst_action']) == 'syncservers'){
            $this->syncServers($_POST['server_name']);
        }else{
            if($this->checkAuthentication()){
                if(strtolower($_POST['cst_action']) == 'getproducts'){
                    $this->getProducts($_POST['pid'],$_POST['group']);
                }
                elseif(strtolower($_POST['cst_action']) == 'getproductfrominvoiceid'){
                    $this->getProductFromInvoiceId();
                }
                elseif(strtolower($_POST['cst_action']) == 'getclientid'){
                    $this->getClientId();
                }
                elseif(strtolower($_POST['cst_action']) == 'getauthdetails'){
                    $this->getClientAuthDetails($_POST['invoiceid']);
                }
                elseif(strtolower($_POST['cst_action']) == 'storesslinfo'){
                    $this->storeSSLInfo();
                }
                elseif(strtolower($_POST['cst_action']) == 'fetchsslinfo'){
                    $this->fetchSSLInfo();
                }
                elseif(strtolower($_POST['cst_action']) == 'getsslapimode'){
                    $this->getAPIMode();
                }
                elseif(strtolower($_POST['cst_action']) == 'getsslapicred'){
                    $this->getAPICred();
                }
                elseif(strtolower($_POST['cst_action']) == 'getssltoken'){
                    $this->getSSLToken();
                }
                elseif(strtolower($_POST['cst_action']) == 'updateorderinfo'){
                    $this->updateOrderInfo($_POST['orderid'],$_POST['pvtkeyid'],$_POST['updatePvtKey']);
                }
                elseif(strtolower($_POST['cst_action']) == 'updateorderinfobysslid'){
                    $this->updateorderinfoBySSLID($_POST['orderid'],$_POST['pvtkeyid'],$_POST['csr'],$_POST['updatePvtKey']);
                }
                elseif(strtolower($_POST['cst_action']) == 'autoinstallssl'){
                    $this->autoInstallSSL($_POST['store_order_id'], $_POST['common_name'], $_POST['pvt_key_id']);
                }
                elseif(!empty($_SESSION['uid'])){
                    $this->clientId = $_SESSION['uid'];
                }else{
                    if (!isset($_COOKIE['ee'])) {
                        echo json_encode(array('result' => 'error','message' => 'API Action Not Found'));
                        return false;
                    }
                }
            }
        }
    }
    private function checkAuthentication(){
        if (!isset($_COOKIE['ee'])) {
            $cPanelUserName = $_POST['cpanelusername'];
            $cpanelIP = $_SERVER['REMOTE_ADDR'];

            if(!empty($cPanelUserName) && !empty($cpanelIP)){
                try{
                    $tblHostingData =  Capsule::table('tblhosting')
                        ->select('tblhosting.userid', 'tblhosting.id')
                        ->leftJoin('tblservers','tblhosting.server','=','tblservers.id')
                        ->where('tblhosting.username', $cPanelUserName)
                        ->where('tblservers.ipaddress', $cpanelIP)
                        ->first();

                    if($tblHostingData == NULL){
                        logActivity("TheSSLStore Module Log|Invalid cPanel Auth with IP:{$cpanelIP} and UserName: {$cPanelUserName}");
                        echo json_encode(array('result' => 'error','message' => 'Account Not Found'));
                        return false;
                    }
                    else{
                        $this->clientId = $tblHostingData->userid;
                        $this->panelHostingId = $tblHostingData->id;
                    }
                }catch(\Exception $e){
                    logActivity("TheSSLStore Module Log|query, {$e->getMessage()}");
                }
            }
            elseif(!empty($_SESSION['uid'])){
                $this->clientId = $_SESSION['uid'];
                logActivity("TheSSLStore Module Log|UserName is not passed. Because it might be WHMCS order. UID: {$this->clientId}");
            }
            else{
                logActivity("TheSSLStore Module Log|UserName is not passed. Because it might be WHMCS order.");
            }
            return true;
        }else{
            return true;
        }
    }

    private function getProducts($pid, $group = ''){
        $products = array();
        $groups = array(
            'basic_home' => array('basic_0' => 'digi_ssl_dv_ee','basic_1' => 'digi_rapidssl','basic_2' => 'digi_rapidssl_wc'),
            'premium_home' => array('standard_https' => 'digi_ssl123_flex','business_https' => 'digi_truebizid_flex','premium_https' => 'digi_securesite_flex'),
            'premium_standard' => array('premium_business_0' => 'digi_ssl123_flex', 'premium_business_2' => 'digi_sslwebserver_flex', 'premium_business_1' => 'digi_sslwebserver_ev_flex','enhanced_ev_2' => 'digi_securesite_pro_flex','enhanced_ev_3' => 'digi_securesite_pro_ev_flex'),
            'premium_ev' => array('premium_ev_0' => 'digi_truebizid_flex','premium_ev_1' => 'digi_truebizid_ev_flex','enhanced_ev_2' => 'digi_securesite_pro_flex','enhanced_ev_3' => 'digi_securesite_pro_ev_flex'),
            'enhanced_ev' => array('enhanced_ev_0' => 'digi_securesite_flex','enhanced_ev_1' => 'digi_securesite_ev_flex','enhanced_ev_2' => 'digi_securesite_pro_flex','enhanced_ev_3' => 'digi_securesite_pro_ev_flex'),
            'standard_wc' => array('standard_wc_0' => 'digi_ssl123_flex'),
            'business_wc' => array('business_wc_0' => 'digi_truebizid_flex'),
            'premium_wc' => array('premium_wc_0' => 'digi_ssl_basic'),
        );

        try{
            $query =  Capsule::table('tblproducts')
                ->select('tblproducts.id','tblproducts.configoption1')
                ->where('tblproducts.servertype', 'thesslstorefullv2');
                //->where('tblproducts.hidden', 0);

            if(!empty($pid)){
                $query->whereIn('tblproducts.id', explode(',',$pid));
            }
            elseif(isset($groups[$group])){
                $query->whereIn('tblproducts.configoption1', array_values($groups[$group]));
            }

            $tblProductData = $query->get();
            $pids = array();
            foreach($tblProductData as $prd){
                $pids[$prd->id] = $prd->configoption1;
            }

            if(!empty($pids)){
                //Get Product from API
                $results = localAPI('GetProducts', array('pid' => implode(",",array_keys($pids))));

                foreach($results['products']['product'] as $prd){
                    $key = 'nokey';
                    if(isset($groups[$group])){
                        $key = array_search($pids[$prd['pid']], $groups[$group]);
                    }

                    //Retrieve the products data from 'mod_sslstore_product_data'`   table
                    $productsData = Capsule::table('mod_sslstore_product_data')->select('validation_type','is_san_enabled','is_wildcard')->where('product_code', '=', $pids[$prd['pid']])->first();
                    $validationType = $productsData->validation_type; // Reterieve validationType from the productsData.
                    $isSanEnabled = $productsData->is_san_enabled; // Reterieve from the productsData.

                    $products[$key]['id'] = $prd['pid'];
                    $products[$key]['name'] = $prd['name'];
                    $products[$key]['validationType'] = $validationType;
                    $products[$key]['isSanEnabled'] = $isSanEnabled;

                    //Retrieve the deafult currency from 'tblcurrencies' table
                    $currencyData = Capsule::table('tblcurrencies')->select('code')->where('default', '=', 1)->first();
                    $defaultCurrency = $currencyData->code; // Reterieve validationType from the productsData.
                    
                    if($validationType == 'EV' && $isSanEnabled == 'y'){
                        if(isset($prd['pricing'])){
                            foreach($prd['pricing'] as $currency => $pricing){
                                if($currency== $defaultCurrency)
                                {
                                    $products[$key]['prefix'] = $prd['pricing'][$currency]['prefix'];
                                    $products[$key]['suffix'] = $prd['pricing'][$currency]['suffix'];
        
                                    if($pricing['quarterly'] > -1){
                                        $products[$key]['standardPricing'][3] = $pricing['quarterly'];
                                    }
                                    if($pids[$prd['pid']]=='digi_ssl_dv_ee'){
                                        if($pricing['quarterly'] > -1){
                                            $products[$key]['standardPricing'][3] = 0;
                                        }
                                    }
                                    if($pricing['annually'] > -1){
                                        $products[$key]['standardPricing'][12] = $pricing['annually'];
                                    }
                                    if($pricing['biennially'] > -1){
                                        $products[$key]['standardPricing'][24] = $pricing['biennially'];
                                    }
                                    if($pricing['triennially'] > -1){
                                        $products[$key]['standardPricing'][36] = $pricing['triennially'];
                                    }
                                    break;
                                }
                            }
                        }
                    }elseif(isset($prd['configoptions']['configoption'][0]['options']['option'][0]['pricing'])){
                        foreach($prd['configoptions']['configoption'][0]['options']['option'][0]['pricing'] as $currency => $pricing){
                            if($currency== $defaultCurrency)
                            {
                                $products[$key]['prefix'] = $prd['pricing'][$currency]['prefix'];
                                $products[$key]['suffix'] = $prd['pricing'][$currency]['suffix'];

                                if($pricing['quarterly'] > -1){
                                    $products[$key]['standardPricing'][3] = $pricing['quarterly'];
                                }
                                if($pids[$prd['pid']]=='digi_ssl_dv_ee'){
                                    if($pricing['quarterly'] > -1){
                                        $products[$key]['standardPricing'][3] = 0;
                                    }
                                }
                                if($pricing['annually'] > -1){
                                    $products[$key]['standardPricing'][12] = $pricing['annually'];
                                }elseif($pricing['annually'] == -1){
                                    $products[$key]['standardPricing'][12] = 0;
                                }
                                if($pricing['biennially'] > -1){
                                    $products[$key]['standardPricing'][24] = $pricing['biennially'];
                                }
                                if($pricing['triennially'] > -1){
                                    $products[$key]['standardPricing'][36] = $pricing['triennially'];
                                }
                                break;
                            }
                        }
                    }elseif($productsData->is_wildcard == 'n'){
                        if(isset($prd['pricing'])){
                            foreach($prd['pricing'] as $currency => $pricing){
                                if($currency== $defaultCurrency)
                                {
                                    $products[$key]['prefix'] = $prd['pricing'][$currency]['prefix'];
                                    $products[$key]['suffix'] = $prd['pricing'][$currency]['suffix'];

                                    if($pricing['quarterly'] > -1){
                                        $products[$key]['standardPricing'][3] = $pricing['quarterly'];
                                    }
                                    if($pids[$prd['pid']]=='digi_ssl_dv_ee'){
                                        if($pricing['quarterly'] == -1){
                                            $products[$key]['standardPricing'][3] = 0;
                                        }
                                    }
                                    if($pricing['annually'] > -1){
                                        $products[$key]['standardPricing'][12] = $pricing['annually'];
                                    }
                                    if($pricing['biennially'] > -1){
                                        $products[$key]['standardPricing'][24] = $pricing['biennially'];
                                    }
                                    if($pricing['triennially'] > -1){
                                        $products[$key]['standardPricing'][36] = $pricing['triennially'];
                                    }
                                    break;
                                }
                            }
                        }
                    }
                    
                    if(isset($prd['configoptions']['configoption'][0]['options']['option'][1]['pricing'])){
                            foreach($prd['configoptions']['configoption'][0]['options']['option'][1]['pricing'] as $currency => $pricing){
                                if($currency== $defaultCurrency)
                                {
                                    if($pricing['quarterly'] > -1){
                                        $products[$key]['wildcardPricing'][3] = $pricing['quarterly'];
                                    }
                                    if($pricing['annually'] > -1){
                                        $products[$key]['wildcardPricing'][12] = $pricing['annually'];
                                    }
                                    if($pricing['biennially'] > -1){
                                        $products[$key]['wildcardPricing'][24] = $pricing['biennially'];
                                    }
                                    if($pricing['triennially'] > -1){
                                        $products[$key]['wildcardPricing'][36] = $pricing['triennially'];
                                    }
                                    break;
                                }
                            }
                    }elseif($productsData->is_wildcard == 'y'){
                        if(isset($prd['pricing'])){
                            foreach($prd['pricing'] as $currency => $pricing){
                                if($currency== $defaultCurrency)
                                {
                                    $products[$key]['prefix'] = $prd['pricing'][$currency]['prefix'];
                                    $products[$key]['suffix'] = $prd['pricing'][$currency]['suffix'];

                                    if($pricing['quarterly'] > -1){
                                        $products[$key]['wildcardPricing'][3] = $pricing['quarterly'];
                                    }
                                    if($pricing['annually'] > -1){
                                        $products[$key]['wildcardPricing'][12] = $pricing['annually'];
                                    }
                                    if($pricing['biennially'] > -1){
                                        $products[$key]['wildcardPricing'][24] = $pricing['biennially'];
                                    }
                                    if($pricing['triennially'] > -1){
                                        $products[$key]['wildcardPricing'][36] = $pricing['triennially'];
                                    }
                                    break;
                                }
                            }
                        }
                    }
                    
                    if($validationType == 'EV' && $isSanEnabled == 'y'){
                        if(isset($prd['configoptions']['configoption'][0]['options']['option'][0]['pricing'])){
                            foreach($prd['configoptions']['configoption'][0]['options']['option'][0]['pricing'] as $currency => $pricing){
                                if($currency== $defaultCurrency)
                                {
                                    $products[$key]['prefix'] = $prd['pricing'][$currency]['prefix'];
                                    $products[$key]['suffix'] = $prd['pricing'][$currency]['suffix'];

                                    if($pricing['quarterly'] > -1){
                                        $products[$key]['configStandardPricing'][3] = $pricing['quarterly'];
                                    }
                                    if($pricing['annually'] > -1){
                                        $products[$key]['configStandardPricing'][12] = $pricing['annually'];
                                    }
                                    if($pricing['biennially'] > -1){
                                        $products[$key]['configStandardPricing'][24] = $pricing['biennially'];
                                    }
                                    if($pricing['triennially'] > -1){
                                        $products[$key]['configStandardPricing'][36] = $pricing['triennially'];
                                    }
                                    break;
                                }
                            }
                        }
                    }else{
                        if(isset($prd['configoptions']['configoption'][1]['options']['option'][0]['pricing'])){
                            foreach($prd['configoptions']['configoption'][1]['options']['option'][0]['pricing'] as $currency => $pricing){
                                if($currency== $defaultCurrency)
                                {
                                    $products[$key]['prefix'] = $prd['pricing'][$currency]['prefix'];
                                    $products[$key]['suffix'] = $prd['pricing'][$currency]['suffix'];

                                    if($pricing['quarterly'] > -1){
                                        $products[$key]['configStandardPricing'][3] = $pricing['quarterly'];
                                    }
                                    if($pids[$prd['pid']]=='digi_ssl_dv_ee'){
                                        if($pricing['quarterly'] == -1){
                                            $products[$key]['configStandardPricing'][3] = 0;
                                        }
                                    }
                                    if($pricing['annually'] > -1){
                                        $products[$key]['configStandardPricing'][12] = $pricing['annually'];
                                    }elseif($pricing['annually'] == -1){
                                        $products[$key]['configStandardPricing'][12] = 0;
                                    }
                                    if($pricing['biennially'] > -1){
                                        $products[$key]['configStandardPricing'][24] = $pricing['biennially'];
                                    }
                                    if($pricing['triennially'] > -1){
                                        $products[$key]['configStandardPricing'][36] = $pricing['triennially'];
                                    }
                                    break;
                                }
                            }
                        }
                    }
                        
                    if(isset($prd['configoptions']['configoption'][2]['options']['option'][0]['pricing'])){
                        foreach($prd['configoptions']['configoption'][2]['options']['option'][0]['pricing'] as $currency => $pricing){
                            if($currency== $defaultCurrency)
                            {
                                if($pricing['quarterly'] > -1){
                                    $products[$key]['configWildcardPricing'][3] = $pricing['quarterly'];
                                }
                                if($pricing['annually'] > -1){
                                    $products[$key]['configWildcardPricing'][12] = $pricing['annually'];
                                }
                                if($pricing['biennially'] > -1){
                                    $products[$key]['configWildcardPricing'][24] = $pricing['biennially'];
                                }
                                if($pricing['triennially'] > -1){
                                    $products[$key]['configWildcardPricing'][36] = $pricing['triennially'];
                                }
                                break;
                            }
                        }
                    }

                    //Set the product details array for each product
                    
                    if($pids[$prd['pid']]=='digi_ssl_dv_ee')
                    {
                        $products[$key]['productDetails'] = array("trustLevel" => "very-low","protection" => "Encryption for 1 domain","encryption" => "Standard 256-bit encryption","siteSeal" => "","siteSealBrand" => "EE","warranty" => "","multiDomainsSupport" => "n","subDomainsSupport" => "n","verifiedCompany" => "","businessValidation" => "","issuanceTime" => "Instant");
                        $products[$key]['productCode'] = 'digi_ssl_dv_ee';
                    }
                    if($pids[$prd['pid']]=='digi_rapidssl')
                    {
                        $products[$key]['productDetails'] = array("trustLevel" => "low","protection" => "Encryption for 1 domain","encryption" => "Standard 256-bit encryption","siteSeal" => "Static site seal","siteSealBrand" => "rapidssl","warranty" => "$10,000","multiDomainsSupport" => "n","subDomainsSupport" => "n","verifiedCompany" => "","businessValidation" => "","issuanceTime" => "Instant");
                        $products[$key]['productCode'] = 'digi_rapidssl';
                    }
                    if($pids[$prd['pid']]=='digi_rapidssl_wc')
                    {
                        $products[$key]['productDetails'] = array("trustLevel" => "low","protection" => "Encryption for 1 domain","wc" => "true","encryption" => "Standard 256-bit encryption","siteSeal" => "Static site seal","siteSealBrand" => "rapidssl","warranty" => "$10,000","multiDomainsSupport" => "n","verifiedCompany" => "","businessValidation" => "","issuanceTime" => "Instant");
                        $products[$key]['productCode'] = 'digi_rapidssl_wc';
                    }
                    if($pids[$prd['pid']]=='digi_ssl123_flex')
                    {
                        $products[$key]['productDetails'] = array("mdwc" => "true","trustLevel" => "medium-center","protection" => "Protection for multiple domains","encryption" => "Standard 256-bit encryption","siteSeal" => "Static site seal","siteSealBrand" => "rapidssl","warranty" => "$500,000","multiDomainsSupport" => "y","subDomainsSupport" => "y","verifiedCompany" => "","businessValidation" => "","issuanceTime" => "Instant");
                        $products[$key]['productCode'] = 'digi_ssl123_flex';
                    }
                    if($pids[$prd['pid']]=='digi_sslwebserver_flex')
                    {
                        $products[$key]['productDetails'] = array("mdwc" => "true","trustLevel" => "medium","protection" => "Protection for multiple domains","encryption" => "Standard 256-bit encryption","businessValidation" => "Business validation","siteSeal" => "Dynamic site seal","siteSealBrand" => "rapidssl","warranty" => "$1,250,000","verifiedCompany" => "","issuanceTime" => "~1 Day");
                        $products[$key]['productCode'] = 'digi_sslwebserver_flex';
                    }
                    if($pids[$prd['pid']]=='digi_sslwebserver_ev_flex')
                    {
                        $products[$key]['productDetails'] = array("md" => "true","trustLevel" => "medium","protection" => "Protection for multiple domains","verifiedCompany" => "Verified company name in address bar","siteSeal" => "Norton™ Secured Seal—Internet’s #1 trust mark","siteSealBrand" => "rapidssl","poweredBy" => "Powered by DigiCert®—World’s most trusted root","businessValidation" => "Highest Business validation","encryption" => "Standard 256-bit encryption","ecc-crypto" => "ECC public-key cryptography","malwareScan" => "Includes malware scan","SecuresWWW" => "Secures www & non-www","warranty" => "$1,500,000","issuanceTime" => "~1 Day");
                        $products[$key]['productCode'] = 'digi_sslwebserver_ev_flex';
                    }
                    if($pids[$prd['pid']]=='digi_truebizid_flex')
                    {
                        $products[$key]['productDetails'] = array("mdwc" => "true","trustLevel" => "medium","protection" => "Protection for multiple domains","mdwc" => "true","encryption" => "Standard 256-bit encryption","businessValidation" => "Business validation","siteSeal" => "Dynamic site seal","siteSealBrand" => "geotrust","warranty" => "$1,250,000","verifiedCompany" => "","issuanceTime" => "~1 Day");
                        $products[$key]['productCode'] = 'digi_truebizid_flex';
                    }
                    if($pids[$prd['pid']]=='digi_truebizid_ev_flex')
                    {
                        $products[$key]['productDetails'] = array("md" => "true","trustLevel" => "medium","protection" => "Protection for multiple domains","verifiedCompany" => "Verified company name in address bar","siteSeal" => "Norton™ Secured Seal—Internet’s #1 trust mark","siteSealBrand" => "geotrust","poweredBy" => "Powered by DigiCert®—World’s most trusted root","businessValidation" => "Highest Business validation","encryption" => "Standard 256-bit encryption","ecc-crypto" => "ECC public-key cryptography","malwareScan" => "Includes malware scan","SecuresWWW" => "Secures www & non-www","warranty" => "$1,500,000","issuanceTime" => "~1 Day");
                        $products[$key]['productCode'] = 'digi_truebizid_ev_flex';
                    }
                    if($pids[$prd['pid']]=='digi_securesite_flex')
                    {
                        $products[$key]['productDetails'] = array("mdwc" => "true","trustLevel" => "high","protection" => "Protection for multiple domains","encryption" => "Standard 256-bit encryption","siteSeal" => "Dynamic site seal","siteSealBrand" => "digicert","businessValidation" => "Highest business validation","warranty" => "$1,750,000","verifiedCompany" => "Business name displayed in address bar","wildcardSAN" => "n","issuanceTime" => "~1 Day");
                        $products[$key]['productCode'] = 'digi_securesite_flex';
                    }
                    if($pids[$prd['pid']]=='digi_securesite_ev_flex')
                    {
                        $products[$key]['productDetails'] = array("mdwc" => "true","trustLevel" => "high","protection" => "Protection for multiple domains","encryption" => "Standard 256-bit encryption","siteSeal" => "Dynamic site seal","siteSealBrand" => "digicert","businessValidation" => "Highest business validation","warranty" => "$1,750,000","verifiedCompany" => "Business name displayed in address bar","wildcardSAN" => "n","issuanceTime" => "~1 Day");
                        $products[$key]['productCode'] = 'digi_securesite_ev_flex';
                    }
                    if($pids[$prd['pid']]=='digi_securesite_pro_flex')
                    {
                        $products[$key]['productDetails'] = array("md" => "true","trustLevel" => "very-high","protection" => "Protection for multiple domains","verifiedCompany" => "Verified company name in address bar","siteSeal" => "Norton™ Secured Seal—Internet’s #1 trust mark","siteSealBrand" => "digicert","poweredBy" => "Powered by DigiCert®—World’s most trusted root","businessValidation" => "Highest Business validation","encryption" => "Standard 256-bit encryption","ecc-crypto" => "ECC public-key cryptography","malwareScan" => "Includes malware scan","SecuresWWW" => "Secures www & non-www","warranty" => "$2,000,000","issuanceTime" => "~1 Day");
                        $products[$key]['productCode'] = 'digi_securesite_pro_flex';
                    }
                    if($pids[$prd['pid']]=='digi_securesite_pro_ev_flex')
                    {
                        $products[$key]['productDetails'] = array("md" => "true","trustLevel" => "very-high","protection" => "Protection for multiple domains","verifiedCompany" => "Verified company name in address bar","siteSeal" => "Norton™ Secured Seal—Internet’s #1 trust mark","siteSealBrand" => "digicert","poweredBy" => "Powered by DigiCert®—World’s most trusted root","businessValidation" => "Highest Business validation","encryption" => "Standard 256-bit encryption","ecc-crypto" => "ECC public-key cryptography","malwareScan" => "Includes malware scan","SecuresWWW" => "Secures www & non-www","warranty" => "$2,000,000","issuanceTime" => "~1 Day");
                        $products[$key]['productCode'] = 'digi_securesite_pro_ev_flex';
                    }
                    
                    
                    
                    if($pids[$prd['pid']]=='basicDV')
                    {
                        $products[$key]['productDetails'] = array("trustLevel" => "Very Low","protection" => "Encryption for 1 domain","encryption" => "Standard 256-bit encryption","siteSeal" => "","siteSealBrand" => "EE","warranty" => "","multiDomainsSupport" => "n","subDomainsSupport" => "n","verifiedCompany" => "","businessValidation" => "","issuanceTime" => "Instant");
                    }
                    if($pids[$prd['pid']]=='basicDVseal')
                    {
                        $products[$key]['productDetails'] = array("trustLevel" => "Very Low","protection" => "Encryption for 1 domain","encryption" => "Standard 256-bit encryption","siteSeal" => "Static site seal","siteSealBrand" => "EE","warranty" => "","multiDomainsSupport" => "n","subDomainsSupport" => "n","verifiedCompany" => "","businessValidation" => "","issuanceTime" => "Instant");
                    }
                    if($pids[$prd['pid']]=='quicksslpremiumwildcard')
                    {
                        $products[$key]['productDetails'] = array("trustLevel" => "Medium","protection" => "Protection for 1 domain","wc" => "true","encryption" => "Standard 256-bit encryption","siteSeal" => "Dynamic site seal","siteSealBrand" => "geotrust","warranty" => "$500,000","multiDomainsSupport" => "n","verifiedCompany" => "","businessValidation" => "","issuanceTime" => "Instant");
                    }
                    if($pids[$prd['pid']]=='wildcard_dv_geotrust')
                    {
                        $products[$key]['productDetails'] = array("trustLevel" => "Medium","protection" => "Protection for 1 domain","mdwc" => "true","encryption" => "Standard 256-bit encryption","siteSeal" => "Dynamic site seal","siteSealBrand" => "geotrust","warranty" => "$500,000","verifiedCompany" => "","businessValidation" => "","issuanceTime" => "Instant");
                    }
                    if($pids[$prd['pid']]=='truebizid')
                    {
                        $products[$key]['productDetails'] = array("trustLevel" => "Medium","protection" => "Protection for 1 domain","businessValidation" => "Business validation","encryption" => "Standard 256-bit encryption","siteSeal" => "Dynamic site seal","siteSealBrand" => "geotrust","warranty" => "$1,250,000","multiDomainsSupport" => "n","verifiedCompany" => "","issuanceTime" => "~1 Day");
                    }
                    if($pids[$prd['pid']]=='truebusinessidev')
                    {
                        $products[$key]['productDetails'] = array("trustLevel" => "High","protection" => "Protection for 1 domain","encryption" => "Standard 256-bit encryption","siteSeal" => "Dynamic site seal","siteSealBrand" => "geotrust","businessValidation" => "Highest business validation","warranty" => "$1,500,000","verifiedCompany" => "Verified company name in address bar","multiDomainsSupport" => "n","issuanceTime" => "~1 Day");
                    }
                    if($pids[$prd['pid']]=='truebusinessidwildcard')
                    {
                        $products[$key]['productDetails'] = array("trustLevel" => "Medium","protection" => "Protection for 1 domain","wc" => "true","encryption" => "Standard 256-bit encryption","siteSeal" => "Dynamic site seal","siteSealBrand" => "geotrust","businessValidation" => "Business validation","warranty" => "$1,250,000","multiDomainsSupport" => "n","verifiedCompany" => "","issuanceTime" => "~1 Day");
                    }
                    if($pids[$prd['pid']]=='truebizidmd')
                    {
                        $products[$key]['productDetails'] = array("trustLevel" => "Medium","protection" => "Protection for 1 domain","encryption" => "Standard 256-bit encryption","siteSeal" => "Dynamic site seal","siteSealBrand" => "geotrust","warranty" => "$1,250,000","businessValidation" => "Business validation","verifiedCompany" => "","wildcardSAN" => "n","issuanceTime" => "~1 Day");
                    }
                    if($pids[$prd['pid']]=='truebusinessidevmd')
                    {
                        $products[$key]['productDetails'] = array("trustLevel" => "High","protection" => "Protection for 1 domain","encryption" => "Standard 256-bit encryption","siteSeal" => "Dynamic site seal","siteSealBrand" => "geotrust","businessValidation" => "Highest business validation","warranty" => "$1,500,000","verifiedCompany" => "Business name displayed in address bar","wildcardSAN" => "n","issuanceTime" => "~1 Day");
                    }
                    if($pids[$prd['pid']]=='truebizidmdwc')
                    {
                        $products[$key]['productDetails'] = array("trustLevel" => "Medium","protection" => "Protection for 1 domain","mdwc" => "true","encryption" => "Standard 256-bit encryption","businessValidation" => "Business validation","siteSeal" => "Dynamic site seal","siteSealBrand" => "geotrust","warranty" => "$1,250,000","verifiedCompany" => "","issuanceTime" => "~1 Day");
                    }
                    if($pids[$prd['pid']]=='securesiteev')
                    {
                        $products[$key]['productDetails'] = array("trustLevel" => "Very High","protection" => "Protection for 1 domain","verifiedCompany" => "Verified company name in address bar","siteSeal" => "Norton™ Secured Seal—Internet’s #1 trust mark","siteSealBrand" => "norton","poweredBy" => "Powered by DigiCert®—World’s most trusted root","businessValidation" => "Highest Business validation","encryption" => "Standard 256-bit encryption","ecc-crypto" => "ECC public-key cryptography","malwareScan" => "Includes malware scan","SecuresWWW" => "Secures www & non-www","warranty" => "$1,750,000","issuanceTime" => "~1 Day");
                    }
                    if($pids[$prd['pid']]=='digi_securesite_ev_md')
                    {
                        $products[$key]['productDetails'] = array("md" => "true","trustLevel" => "Very High","protection" => "Protection for 1 domain","verifiedCompany" => "Verified company name in address bar","siteSeal" => "Norton™ Secured Seal—Internet’s #1 trust mark","siteSealBrand" => "norton","poweredBy" => "Powered by DigiCert®—World’s most trusted root","businessValidation" => "Highest Business validation","encryption" => "Standard 256-bit encryption","ecc-crypto" => "ECC public-key cryptography","malwareScan" => "Includes malware scan","SecuresWWW" => "Secures www & non-www","warranty" => "$1,750,000","issuanceTime" => "~1 Day");
                    }
                    if($pids[$prd['pid']]=='digi_ssl_basic')
                    {
                        $products[$key]['productDetails'] = array("mdwc" => "true","trustLevel" => "High","protection" => "Protection for 1 domain","encryption" => "Standard 256-bit encryption","siteSeal" => "Dynamic site seal","siteSealBrand" => "deigicert","businessValidation" => "Highest business validation","warranty" => "$1,500,000","verifiedCompany" => "Business name displayed in address bar","wildcardSAN" => "n","issuanceTime" => "~1 Day");
                    }
                    
                    
                    $products[$key]['productDetails']['description'] = preg_replace('#<a.*?>.*?</a>#i', '', $prd['description']);
                    

                    //End of Set the product details array for each product

                    //Set configoptions details for MultiDomain products
                    if($isSanEnabled=='y')
                    {

                        foreach ($prd['configoptions']['configoption'] as $configoptionForMainValue) {
                            if ($configoptionForMainValue['name'] == 'Main Domain' && $configoptionForMainValue['type'] == 2) {
                                $products[$key]['configOptionId'] = $configoptionForMainValue['id'];
                            }elseif ($configoptionForMainValue['name'] == 'Additional domains' && $configoptionForMainValue['type'] == 4) {
                                $products[$key]['configOptionIdFlex'] = $configoptionForMainValue['id'];
                            }elseif ($configoptionForMainValue['name'] == 'Additional Wildcard domains' && $configoptionForMainValue['type'] == 4) {
                                $products[$key]['configOptionIdWildcardFlex'] = $configoptionForMainValue['id'];
                            }
                        }
                        
                        if($pids[$prd['pid']]=='digi_ssl_dv_ee')
                        {
                            foreach ($prd['configoptions']['configoption'] as $configoption) {
                                if ($configoption['name'] == 'Site Seal') {
                                    $products[$key]['configOptionIdSiteSeal'] = $configoption['id'];
                                    $products[$key]['configOptionIdSiteSealYes'] = $configoption['options']['option'][1]['id'];
                                    $products[$key]['configOptionIdSiteSealNo'] = $configoption['options']['option'][0]['id'];
                                    $products[$key]['configOptionIdSiteSealPrice'] = $configoption['options']['option'][1]['pricing']['USD']['quarterly'];
                                }
                                if ($configoption['name'] == 'Main Domain') {
                                    $products[$key]['configOptionIdSiteSealMainDomain'] = $configoption['id'];
                                    $products[$key]['configOptionIdSiteSealStandard'] = $configoption['options']['option'][0]['id'];
                                    $products[$key]['configOptionIdSiteSealWildcard'] = $configoption['options']['option'][1]['id'];

                                }
                            }
                        }else{
                            $products[$key]['configOptionIdMainDomain'] = $prd['configoptions']['configoption'][0]['id'];
                            $products[$key]['configOptionIdStandard'] = $prd['configoptions']['configoption'][0]['options']['option'][0]['id'];
                            $products[$key]['configOptionIdWildcard'] = $prd['configoptions']['configoption'][0]['options']['option'][1]['id'];
                        }

                        $minMaxSan=array(
                            "wildcard_dv_geotrust" => array(

                                "MinSan" => 2,

                                "MaxSan" => 2,

                            ),
                            "truebizidmd" => array (

                                "MinSan" => 4,

                                "MaxSan" => 245,

                            ),
                            "truebusinessidevmd" => array (

                                "MinSan" => 4,

                                "MaxSan" => 245,

                            ),
                            "truebizidmdwc" => array
                            (
                                "MinSan" => 2,

                                "MaxSan" => 247,
                            ),
                            "securesiteev" => array
                            (
                                "MinSan" => 0,

                                "MaxSan" => 249,
                            ),
                            "digi_securesite_ev_md" => array
                            (
                                "MinSan" => 3,

                                "MaxSan" => 245,
                            ),
                            "digi_ssl123_flex" => array
                            (
                                "MinSan" => 0,

                                "MaxSan" => 249,
                            ),
                            "digi_truebizid_ev_flex" => array
                            (
                                "MinSan" => 0,

                                "MaxSan" => 249,
                            ),
                            "digi_truebizid_flex" => array
                            (
                                "MinSan" => 0,

                                "MaxSan" => 249,
                            ),
                            "digi_ssl_basic" => array
                            (
                                "MinSan" => 0,

                                "MaxSan" => 249,
                            ),
                            "digi_securesite_flex" => array
                            (
                                "MinSan" => 0,

                                "MaxSan" => 249,
                            ),
                            "digi_securesite_ev_flex" => array
                            (
                                "MinSan" => 0,

                                "MaxSan" => 249,
                            ),
                            "digi_securesite_pro_flex" => array
                            (
                                "MinSan" => 0,

                                "MaxSan" => 249,
                            ),
                            "digi_securesite_pro_ev_flex" => array
                            (
                                "MinSan" => 0,

                                "MaxSan" => 249,
                            ),
                            "digi_ssl_dv_ee" => array
                            (
                                "MinSan" => 0,

                                "MaxSan" => 249,
                            )
                        );

                        $products[$key]['maxSan'] = 0;
                        $products[$key]['minSan'] = 0;
                        $products[$key]['totalSan'] = 0;

                        $products[$key]['maxSan'] = $minMaxSan[$pids[$prd['pid']]]["MaxSan"];
                        $products[$key]['minSan'] = $minMaxSan[$pids[$prd['pid']]]["MinSan"];
                        $products[$key]['totalSan'] = $minMaxSan[$pids[$prd['pid']]]["MinSan"]+$minMaxSan[$pids[$prd['pid']]]["MaxSan"]+1;


                        // foreach($prd['configoptions']['configoption'][0]['options']['option'][0]['pricing'] as $configCurrency => $configPricing){
                        //     if($configCurrency== $defaultCurrency)
                        //     {
                        //         if($configPricing['monthly'] > -1){
                        //             $products[$key]['configpricing'][1] = $configPricing['monthly'];
                        //         }
                        //         if($configPricing['quarterly'] > -1){
                        //             $products[$key]['configpricing'][3] = $configPricing['quarterly'];
                        //         }
                        //         if($configPricing['semiannually'] > -1){
                        //             $products[$key]['configpricing'][6] = $configPricing['semiannually'];
                        //         }
                        //         if($configPricing['annually'] > -1){
                        //             $products[$key]['configpricing'][12] = $configPricing['annually'];
                        //         }
                        //         if($configPricing['biennially'] > -1){
                        //             $products[$key]['configpricing'][24] = $configPricing['biennially'];
                        //         }
                        //         if($configPricing['triennially'] > -1){
                        //             $products[$key]['configpricing'][36] = $configPricing['triennially'];
                        //         }
                        //         break;
                        //     }
                        // }
                    }
                }
            }
            else{
                echo json_encode(array('result' => 'error','message' => 'Products Not Found', 'products' => $products));
                return false;
            }
        }catch(\Exception $e){
            logActivity("TheSSLStore Module Log|query, {$e->getMessage()}");
        }

        $cssCount =  Capsule::table('tblconfiguration')->where('value', 'like', '%ee_email_template%')->where('setting','=','EmailCSS')->count('*');
        if ($cssCount=='0') {
            $EmailCSS =  Capsule::table('tblconfiguration')
                    ->select('value')
                    ->where('value', 'like', '%ee_email_template%')
                    ->where('setting','=','EmailCSS')
                    ->first();

            $newCSS = $EmailCSS->value.' .ee_email_template table, .ee_email_template table th, .ee_email_template table td, .ee_email_template table tr, .ee_email_template table tbody{border: 0 !important;}';

            Capsule::table('tblconfiguration')
                ->where('setting', 'EmailCSS')
                ->update(['value' => $newCSS]);
        }

        //AutoSSL Upsell Product Email Template
        $count = Capsule::table('tblemailtemplates')->where('name', 'Activate HTTPS on your Domain')->count('*');
        if ($count=='0') {
            Capsule::table('tblemailtemplates')->insert(['type' => 'general', 'name' => 'Activate HTTPS on your Domain', 'subject' => 'Activate HTTPS on your Domain', 'message' => '<div class="ee_email_template"><table width="100%" border="0" align="center" valign="top" cellpadding="0" cellspacing="0" style="">
            <tr>
                <td>
                    <table width="600" cellpadding="0" cellspacing="0" align="center" valign="top" style="padding:20px;">
                        <tr align="center">
                            <td align="center">
                                <h2 style="font-family:Arial, Helvetica, sans-serif;color:#A7AEB3;font-weight:bold;text-align:center;line-height:22px;font-size:18px;margin:0">Easy HTTPS Activation</h2>
                            </td>
                        </tr>
                    </table>
                    <table width="600" cellpadding="0" cellspacing="0" align="center" valign="top" style="">
                        <tr style="margin:0;padding:0">
                            <td style="margin:0;padding:0">
                                <table width="556" cellpadding="0" cellspacing="0" align="center" valign="top" style="background:#F7F8F9">
                                    <tr style="margin:0;padding:0">
                                        <td style="margin:0;padding:0">&nbsp;</td>
                                    </tr>
                                </table>
                            </td>
                        </tr>
                    </table>
                    <table width="600" cellpadding="0" cellspacing="0" align="center" valign="top" style="padding:0px 20px 20px 20px;background:#FFFFFF">
                        <tr>
                            <td>
                                <table width="556" cellpadding="0" cellspacing="0" align="center" valign="top" style="padding:0px 20px 20px 20px;background:#F7F8F9;margin-top:0px">
                                    <tr align="center">
                                        <td width="100%" align="center" valign="top">
                                            <img src="https://www.thesslstore.com/images/ee_whmcs_emails/logo.png" align="center" alt="Easy HTTPS Activation" />
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <table width="100%" cellpadding="0" cellspacing="0" align="center" valign="top" style="margin-top:30px;padding:0 60px">
                                                <tr align="left">
                                                    <td align="left">
                                                        <p style="font-family:Arial, Helvetica, sans-serif;color:#676767;font-weight:normal;text-align:left;line-height:19px;font-size:15px;margin:0">Dear {$fullname},</p>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td width="100%" align="center">
                                                        <h1 style="font-family:Arial, Helvetica, sans-serif;color:#000000;font-weight:900;text-align:center;line-height:48px;font-size:37px;margin:30px 0px 10px 0px">Action Required: <br />Activate HTTPS for</h1>
                                                       <h2 style="font-family:Arial, Helvetica, sans-serif;color:#51ABF6;font-weight:bold;text-align:center;line-height:32px;font-size:27px;margin:0;text-decoration:underline">{$domain}</h2>
                                                    </td>
                                                </tr>
                                            </table>
                                            <table width="100%" cellpadding="0" cellspacing="0" align="center" valign="top">
                                                <tr>
                                                    <td>&nbsp;</td>
                                                </tr>
                                            </table>
                                            <table width="100%" cellpadding="0" cellspacing="0" align="center" valign="top" style="margin:20px 0px 0px 0px;padding:0 40px">
                                                <tr align="center">
                                                    <td align="center">
                                                        <h3 style="font-family:Arial, Helvetica, sans-serif;color:#A7AEB3;font-weight:600;text-align:center;line-height:32px;font-size:21px;margin:0">Your {$companyname} hosting package <br/>includes a <span style="font-family:Arial, Helvetica, sans-serif;color:#000000;font-weight:600;text-align:center;line-height:32px;font-size:21px;margin:0">FREE SSL certificate!</span> Click the <br/>button below to get instant HTTPS on<br/> your website today.</h3>
                                                    </td>
                                                </tr>
                                                <tr align="center">
                                                    <td align="center">&nbsp;</td>
                                                </tr>
                                                <tr align="center">
                                                    <td align="center">
                                                        <img src="https://www.thesslstore.com/images/ee_whmcs_emails/activate.png" align="center" alt="Easy HTTPS Activation" style="margin-bottom:10px" />
                                                    </td>
                                                </tr>
                                                <tr align="center">
                                                    <td align="center">
                                                        <a href="{$cpanelurl}">
                                                            <img src="https://www.thesslstore.com/images/ee_whmcs_emails/btn_free.png" align="center" alt="Easy HTTPS Activation" />
                                                        </a>
                                                    </td>
                                                </tr>
                                            </table>
                                            <table width="100%" cellpadding="0" cellspacing="0" align="center" valign="top">
                                                <tr>
                                                    <td>&nbsp;</td>
                                                </tr>
                                            </table>
                                            <table width="100%" cellpadding="0" cellspacing="10" align="center" valign="top" style="padding:30px 20px;background:#fff;border:1px solid #EBEDEF">
                                                <tr style="margin:0;padding:0">
                                                    <td align="center" colspan="2" style="margin:0;padding:0">
                                                        <p style="font-family:Arial, Helvetica, sans-serif;color:#676767;font-weight:normal;text-align:center;line-height:28px;font-size:16px;margin:0px 0px 5px 0px">This encryption-only certificate meets the <br/>minimum standards for HTTPS browser security.<br/> This basic SSL/TLS certificate is:</p>
                                                    </td>
                                                </tr>
                                                <tr style="margin:0;padding:0">
                                                    <td style="margin:0;padding:0">
                                                        <table width="100%" cellpadding="0" cellspacing="10" align="center" valign="top" style="padding:0;margin:0">
                                                            <tr align="left" valign="middle" style="margin:0;padding:0">
                                                                <td align="left" valign="middle" width="20%" style="margin:0;padding:0"></td>
                                                                <td align="left" valign="middle" width="80%" style="font-family:Arial, Helvetica, sans-serif;text-align:left;font-weight:normal;line-height:28px;font-size:15px;color:#676767;margin: 0;padding:0;">
                                                                    <img src="https://psabxr.stripocdn.email/content/guids/CABINET_ff6710ea9153bb7447d3e70efc35c88b/images/39011632142616924.png" align="left" alt="Checkmark Icon" style="padding-top:4px" />&nbsp;&nbsp; Valid for 90 days
                                                                </td>
                                                            </tr>
                                                            <tr align="left" valign="middle" style="margin:0;padding:0">
                                                                <td align="left" valign="middle" width="20%" style="margin:0;padding:0"></td>
                                                                <td align="left" valign="middle" width="80%" style="font-family:Arial, Helvetica, sans-serif;text-align:left;font-weight:normal;line-height:28px;font-size:15px;color:#676767;margin: 0;padding:0;">
                                                                    <img src="https://psabxr.stripocdn.email/content/guids/CABINET_ff6710ea9153bb7447d3e70efc35c88b/images/39011632142616924.png" align="left" alt="Checkmark Icon" style="padding-top:4px" />&nbsp;&nbsp; FREE of charge
                                                                </td>
                                                            </tr>
                                                            <tr align="left" valign="middle" style="margin:0;padding:0">
                                                                <td align="left" valign="middle" width="20%" style="margin:0;padding:0"></td>
                                                                <td align="left" valign="middle" width="80%" style="font-family:Arial, Helvetica, sans-serif;text-align:left;font-weight:normal;line-height:28px;font-size:15px;color:#676767;margin: 0;padding:0;">
                                                                    <img src="https://psabxr.stripocdn.email/content/guids/CABINET_ff6710ea9153bb7447d3e70efc35c88b/images/39011632142616924.png" align="left" alt="Checkmark Icon" style="padding-top:4px" />&nbsp;&nbsp; Meets the 256-bit minimum requirement
                                                                </td>
                                                            </tr>
                                                            <tr align="left" valign="middle" style="margin:0;padding:0">
                                                                <td align="left" valign="middle" width="20%" style="margin:0;padding:0"></td>
                                                                <td align="left" valign="middle" width="80%" style="font-family:Arial, Helvetica, sans-serif;text-align:left;font-weight:normal;line-height:28px;font-size:15px;color:#676767;margin: 0;padding:0;">
                                                                    <img src="https://psabxr.stripocdn.email/content/guids/CABINET_ff6710ea9153bb7447d3e70efc35c88b/images/39011632142616924.png" align="left" alt="Checkmark Icon" style="padding-top:4px" />&nbsp;&nbsp; Validates domain control only
                                                                </td>
                                                            </tr>
                                                            <tr align="left" valign="middle" style="margin:0;padding:0">
                                                                <td align="left" valign="middle" width="20%" style="margin:0;padding:0"></td>
                                                                <td align="left" valign="middle" width="80%" style="font-family:Arial, Helvetica, sans-serif;text-align:left;font-weight:normal;line-height:28px;font-size:15px;color:#676767;margin: 0;padding:0;">
                                                                    <img src="https://psabxr.stripocdn.email/content/guids/CABINET_ff6710ea9153bb7447d3e70efc35c88b/images/39011632142616924.png" align="left" alt="Checkmark Icon" style="padding-top:4px" />&nbsp;&nbsp; Fast, hassle-free installation
                                                                </td>
                                                            </tr>
                                                        </table>
                                                    </td>
                                                </tr>
                                                <tr style="margin:0;padding:0">
                                                    <td align="center" colspan="2" style="margin:0;padding:0">
                                                        <a href="{$cpanelurl}">
                                                            <img src="https://www.thesslstore.com/images/ee_whmcs_emails/btn2.png" align="center" alt="Easy HTTPS Activation" />
                                                        </a>
                                                    </td>
                                                </tr>
                                            </table>
                                        </td>
                                    </tr>
                                </table>
                                <table width="556" cellpadding="0" cellspacing="0" align="center" valign="top">
                                    <tr>
                                        <td>&nbsp;</td>
                                    </tr>
                                </table>
                                <table width="556" cellpadding="0" cellspacing="0" align="center" valign="top" style="padding:30px 0px 0px 0px;background:#F7F8F9;">
                                    <tr align="center">
                                        <td align="center" colspan="2">
                                            <h2 style="font-family:Arial, Helvetica, sans-serif;color:#000000;font-weight:600;text-align:center;line-height:32px;font-size:25px;margin:0">Without HTTPS, Your Website <br/>Visitors Will See This</h2>
                                        </td>
                                    </tr>
                                    <tr valign="top" style="margin:0;padding:0">
                                        <td align="left" colspan="2" style="margin:0;padding:0px;">
                                            <table width="100%" cellpadding="0" cellspacing="0" align="center" valign="top" style="margin:0;padding:0 0 0 35px">
                                                <tr align="center" style="margin:0;padding:0">
                                                    <td align="center" style="margin:0;padding:10px 0 5px 60px">
                                                        <img src="https://www.thesslstore.com/images/ee_whmcs_emails/arrow.png" align="left" alt="Arrow Icon" />
                                                    </td>
                                                </tr>
                                            </table>
                                        </td>
                                    </tr>
                                    <tr valign="top" style="margin:0;padding:0">
                                        <td style="margin:0;padding:0">
                                            <table width="100%" cellpadding="0" cellspacing="0" align="center" valign="top" style="margin:0;padding:0 0 0 35px">
                                                <tr valign="top" style="margin:0;padding:0">
                                                    <td align="left" valign="top" style="margin:0">
                                                        <p style="font-family:Arial, Helvetica, sans-serif;color:#676767;font-weight:normal;text-align:left;line-height:28px;font-size:16px;margin-top:0px">If your HTTPS security SSL certificate accidentally lapses, your site visitors will get an abrupt warning before seeing your website.</p>
                                                    </td>
                                                    <td align="right" valign="top" style="margin:0;padding:0">
                                                        <img src="https://www.thesslstore.com/images/ee_whmcs_emails/notsecure.png" align="right" alt="Not Secure" />
                                                    </td>
                                                </tr>
                                            </table>
                                        </td>
                                    </tr>
                                    <tr align="center" style="margin:0;padding:0">
                                        <td align="center" style="margin:0;padding:0">&nbsp;</td>
                                    </tr>
                                    <tr align="center" style="margin:0;padding:0">
                                        <td align="center" colspan="2" style="margin:0;padding:0">
                                            <a href="{$cpanelurl}">
                                                <img src="https://www.thesslstore.com/images/ee_whmcs_emails/btn2.png" align="center" alt="Easy HTTPS Activation">
                                            </a>
                                        </td>
                                    </tr>
                                    <tr align="center" style="margin:0;padding:0">
                                        <td align="center" style="margin:0;padding:0">&nbsp;</td>
                                    </tr>
                                </table>
                            </td>
                        </tr>
                    </table>
                    <table width="600" cellpadding="0" cellspacing="0" align="center" valign="top" style="padding:20px;">
                        <tr align="center">
                            <td align="center">
                                <p style="font-family:Arial, Helvetica, sans-serif;color:#676767;font-weight:normal;text-align:center;line-height:20px;font-size:12px;margin:0px">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Duis a pulvinar leo.<br/> Vivamus vitae enim vitae nisi interdum tristique non vel lorem. Aenean quam<br/> orci, tincidunt imperdiet odio non, auctor tincidunt felis. Integer sit amet<br/> metus pretium, pharetra lacus at, feugiat lacu</p>
                            </td>
                        </tr>
                    </table>
                </td>
            </tr>
        </table>
    </div>
    <script> 
        if(document.getElementsByClassName("ee_email_template").length == 1){
            var removeHeaderForEE = document.getElementsByClassName("headerContent");
            removeHeaderForEE[0].parentNode.removeChild(removeHeaderForEE[0]);
        }
    </script>','fromname' => '', 'fromemail' => '','disabled' => '', 'custom' => '1','language' => '', 'copyto' => '', 'plaintext' => '']);
        }

        //HTTPS Activation Renewal/Upgrade Email Template  - For Basic Products
        $count = Capsule::table('tblemailtemplates')->where('name', 'HTTPS Activation Renewal/Upgrade Email')->count('*');
        if ($count=='0') {
            Capsule::table('tblemailtemplates')->insert(['type' => 'product', 'name' => 'HTTPS Activation Renewal/Upgrade Email', 'subject' => 'HTTPS Activation Renewal/Upgrade Email', 'message' => '<div class="ee_email_template">
    <table border="0" width="" cellspacing="0" cellpadding="0" align="center">
<tbody>
<tr>
<td>
<table style="padding: 20px;" width="600" cellspacing="0" cellpadding="0" align="center">
<tbody>
<tr align="center">
<td align="center">
<h2 style="font-family: Arial, Helvetica, sans-serif; color: #a7aeb3; font-weight: bold; text-align: center; line-height: 22px; font-size: 18px; margin: 0;">Easy HTTPS Activation</h2>
</td>
</tr>
</tbody>
</table>
<table style="padding: 0px; margin: 0;" width="600" cellspacing="0" cellpadding="0" align="center">
<tbody>
<tr style="margin: 0; padding: 0;">
<td style="margin: 0; padding: 0;"> </td>
</tr>
</tbody>
</table>
<table style="padding: 20px; background: #FFFFFF;" width="600" cellspacing="0" cellpadding="0" align="center">
<tbody>
<tr>
<td>
<table style="padding: 0px 20px; background: #F7F8F9; margin-top: -50px;" width="556" cellspacing="0" cellpadding="0" align="center">
<tbody>
<tr align="center">
<td align="center" valign="top" width="100%"><img src="https://www.thesslstore.com/images/ee_whmcs_emails/logo.png" alt="Easy HTTPS Activation" align="middle" /></td>
</tr>
<tr>
<td>
<table style="margin-top: 30px; padding: 0 60px;" width="100%" cellspacing="0" cellpadding="0" align="center">
<tbody>
<tr align="left">
<td align="left">
<p style="font-family: Arial, Helvetica, sans-serif; color: #676767; font-weight: normal; text-align: left; line-height: 19px; font-size: 15px; margin: 0;">Dear {$client_name},</p>
</td>
</tr>
<tr>
<td align="center" width="100%">
<h1 style="font-family: Arial, Helvetica, sans-serif; color: #000000; font-weight: 900; text-align: center; line-height: 48px; font-size: 37px; margin: 30px 0px 10px 0px;">Your 90-Day HTTPS <br />is About to Expire</h1>
</td>
</tr>
</tbody>
</table>
<table style="padding: 0 40px;" width="100%" cellspacing="0" cellpadding="0" align="center">
<tbody>
<tr align="center">
<td align="center">
<h3 style="font-family: Arial, Helvetica, sans-serif; color: #a7aeb3; font-weight: 600; text-align: center; line-height: 32px; font-size: 21px; margin-bottom: 30px;">Renew or upgrade by <span style="font-family: Arial, Helvetica, sans-serif; color: #000000; font-weight: 600; text-align: center; line-height: 32px; font-size: 21px; margin: 0;">{$expirationDate}</span> to <br />preserve security for <a style="font-family: Arial, Helvetica, sans-serif; color: #51abf6; font-weight: 600; text-align: left; line-height: 32px; font-size: 21px; margin: 0;" href="#!">{$domain}</a>. Don\'t risk harming your sales, conversions or reputation.</h3>
</td>
</tr>
<tr align="center">
<td align="center"> </td>
</tr>
<tr align="center">
<td align="center"><a href="{$cpanel_upgrade_product_url}"><img src="https://www.thesslstore.com/images/ee_whmcs_emails/upgrade-btn1.png" alt="Upgrade for 1 Year Protection" align="middle" /></a></td>
</tr>
<tr style="margin: 0; padding: 0;" align="center">
<td style="margin: 0; padding: 0;" align="center"> </td>
</tr>
<tr align="center">
<td align="center">
<p style="margin: 0;"><a style="font-family: Arial, Helvetica, sans-serif; color: #118ef5; font-weight: normal; text-align: center; line-height: 32px; font-size: 17px; margin: 0px;" href="{$cpanel_existing_product_url}">Renew for 90 Days</a></p>
</td>
</tr>
<tr style="margin: 0; padding: 0;" align="center">
<td style="margin: 0; padding: 0;" align="center"> </td>
</tr>
</tbody>
</table>
</td>
</tr>
</tbody>
</table>
<table width="556" cellspacing="0" cellpadding="0" align="center">
<tbody>
<tr align="left">
<td align="left">
<table style="background: #F7F8F9;" width="556" cellspacing="0" cellpadding="0" align="center">
<tbody>
<tr>
<th style="padding: 0px 20px 20px 20px;" valign="bottom" width="50%">
<p style="font-family: Arial, Helvetica, sans-serif; color: #9d9fa1; font-weight: 600; text-align: center; line-height: 30px; font-size: 22px; margin: 0; text-transform: uppercase;">RENEWAL</p>
<p style="font-family: Arial, Helvetica, sans-serif; color: #9d9fa1; font-weight: 600; text-align: center; line-height: 30px; font-size: 22px; margin: 0;">{$existing_product_price}</p>
</th>
<th style="padding: 0px 20px 20px 20px;"><img src="https://www.thesslstore.com/images/ee_whmcs_emails/thumbsUp.png" alt="Thumbs Up" align="middle" />
<p style="font-family: Arial, Helvetica, sans-serif; color: #118ef5; font-weight: 600; text-align: center; line-height: 30px; font-size: 22px; margin: 10px 0 0 0; text-transform: uppercase;">upgrade</p>
<p style="font-family: Arial, Helvetica, sans-serif; color: #118ef5; font-weight: normal; text-align: center; line-height: 20px; font-size: 22px; margin: 0; padding: 0px 0;"><sup style="font-family: Arial, Helvetica, sans-serif; color: #118ef5; font-weight: normal; text-align: center; line-height: 20px; font-size: 18px; margin: 0;">$</sup><span style="font-family: Arial, Helvetica, sans-serif; color: #118ef5; font-weight: bold; text-align: center; line-height: 30px; font-size: 24px; margin: 0;">{$upgrade_product_price}</span></p>
</th>
</tr>
</tbody>
</table>
<table style="background: #F1F3F5;" width="556" cellspacing="0" cellpadding="0" align="center">
<tbody>
<tr>
<td style="border-right: 1px dashed #DCE0E4; padding: 20px 20px;" valign="middle" width="50%">
<p style="font-family: Arial, Helvetica, sans-serif; color: #676767; font-weight: normal; text-align: center; line-height: 20px; font-size: 16px; margin: 0;">90 day coverage</p>
</td>
<td style="padding: 10px 20px;" valign="middle">
<p style="font-family: Arial, Helvetica, sans-serif; color: #118ef5; font-weight: normal; text-align: center; line-height: 20px; font-size: 16px; margin: 0;">1 year coverage</p>
<p style="text-align: center; margin: 0;"><img style="margin: 5px 0 0px 0px;" src="https://www.thesslstore.com/images/ee_whmcs_emails/line.png" alt="Underline" align="middle" /></p>
</td>
</tr>
</tbody>
</table>
<table style="background: #FBFCFC;" width="556" cellspacing="0" cellpadding="0" align="center">
<tbody>
<tr>
<td style="border-right: 1px dashed #DCE0E4; padding: 20px 20px;" valign="middle" width="50%">
<p style="font-family: Arial, Helvetica, sans-serif; color: #676767; font-weight: normal; text-align: center; line-height: 20px; font-size: 16px; margin: 0;">No warranty</p>
</td>
<td style="padding: 10px 20px;" valign="middle">
<p style="font-family: Arial, Helvetica, sans-serif; color: #118ef5; font-weight: normal; text-align: center; line-height: 20px; font-size: 16px; margin: 0;">$10,000 warranty</p>
</td>
</tr>
</tbody>
</table>
<table style="background: #F1F3F5;" width="556" cellspacing="0" cellpadding="0" align="center">
<tbody>
<tr>
<td style="border-right: 1px dashed #DCE0E4; padding: 20px 20px;" valign="middle" width="50%">
<p style="font-family: Arial, Helvetica, sans-serif; color: #676767; font-weight: normal; text-align: center; line-height: 20px; font-size: 16px; margin: 0;">{$site_seal}</p>
</td>
<td style="padding: 10px 20px;" valign="middle">
<p style="font-family: Arial, Helvetica, sans-serif; color: #909192; font-weight: normal; text-align: center; line-height: 20px; font-size: 16px; margin: 0;"><img src="https://www.thesslstore.com/images/ee_whmcs_emails/trustedSite.png" alt="TrustedSite" align="middle" /></p>
</td>
</tr>
</tbody>
</table>
<table style="background: #FBFCFC;" width="556" cellspacing="0" cellpadding="0" align="center">
<tbody>
<tr>
<td style="border-right: 1px dashed #DCE0E4; padding: 20px 20px;" valign="middle" width="50%">
<p style="font-family: Arial, Helvetica, sans-serif; color: #676767; font-weight: normal; text-align: center; line-height: 20px; font-size: 16px; margin: 0;">Generic brand</p>
</td>
<td style="padding: 10px 20px;" valign="middle">
<p style="font-family: Arial, Helvetica, sans-serif; color: #118ef5; font-weight: normal; text-align: center; line-height: 20px; font-size: 16px; margin: 0;">RapidSSL brand</p>
</td>
</tr>
</tbody>
</table>
<table style="background: #F7F8F9;" width="556" cellspacing="0" cellpadding="0" align="center">
<tbody>
<tr>
<td style="padding: 20px 10px;" valign="middle"><a href="{$cpanel_existing_product_url}"><img src="https://www.thesslstore.com/images/ee_whmcs_emails/renew-btn.png" alt="Renew for 90 Days" align="middle" /></a></td>
<td style="padding: 10px 10px;" valign="middle"><a href="{$cpanel_upgrade_product_url}"><img src="https://www.thesslstore.com/images/ee_whmcs_emails/upgrade-btn2.png" alt="Upgrade for 1 Year" align="middle" /></a></td>
</tr>
</tbody>
</table>
</td>
</tr>
</tbody>
</table>
<table width="556" cellspacing="0" cellpadding="0" align="center">
<tbody>
<tr>
<td> </td>
</tr>
</tbody>
</table>
<table style="padding: 30px 0px 0px 0px; background: #F7F8F9;" width="556" cellspacing="0" cellpadding="0" align="center">
<tbody>
<tr align="center">
<td colspan="2" align="center">
<h2 style="font-family: Arial, Helvetica, sans-serif; color: #000000; font-weight: 600; text-align: center; line-height: 32px; font-size: 25px; margin: 0;">Don’t Let Your HTTPS Expire!</h2>
</td>
</tr>
<tr style="margin: 0; padding: 0;" valign="top">
<td style="margin: 0; padding: 0px;" colspan="2" align="left">
<table style="margin: 0; padding: 0 0 0 35px;" width="100%" cellspacing="0" cellpadding="0" align="center">
<tbody>
<tr style="margin: 0; padding: 0;" align="center">
<td style="margin: 0; padding: 10px 0 5px 60px;" align="center"><img src="https://www.thesslstore.com/images/ee_whmcs_emails/arrow.png" alt="Arrow Icon" align="left" /></td>
</tr>
</tbody>
</table>
</td>
</tr>
<tr style="margin: 0; padding: 0;" valign="top">
<td style="margin: 0; padding: 0;">
<table style="margin: 0; padding: 0 0 0 35px;" width="100%" cellspacing="0" cellpadding="0" align="center">
<tbody>
<tr style="margin: 0; padding: 0;" valign="top">
<td style="margin: 0;" align="left" valign="top">
<p style="font-family: Arial, Helvetica, sans-serif; color: #676767; font-weight: normal; text-align: left; line-height: 28px; font-size: 16px; margin-top: 0px;">If your HTTPS security SSL certificate accidentally lapses, your site visitors will get an abrupt warning before seeing your website.</p>
</td>
<td style="margin: 0; padding: 0;" align="right" valign="top"><img src="https://www.thesslstore.com/images/ee_whmcs_emails/notsecure.png" alt="Not Secure" align="right" /></td>
</tr>
</tbody>
</table>
</td>
</tr>
<tr style="margin: 0; padding: 0;" align="center">
<td style="margin: 0; padding: 0;" align="center"> </td>
</tr>
<tr style="margin: 0; padding: 0;" align="center">
<td style="margin: 0; padding: 0;" colspan="2" align="center"><a href="{$cpanel_upgrade_product_url}"><img src="https://www.thesslstore.com/images/ee_whmcs_emails/upgrade-btn3.png" alt="Upgrade for 1 Year Protection" align="middle" /></a></td>
</tr>
<tr style="margin: 0; padding: 0;" align="center">
<td style="margin: 0; padding: 0;" align="center"> </td>
</tr>
</tbody>
</table>
<table width="556" cellspacing="0" cellpadding="0" align="center">
<tbody>
<tr>
<td> </td>
</tr>
</tbody>
</table>
<table style="padding: 30px 35px 25px 0px; background: #F7F8F9;" width="556" cellspacing="0" cellpadding="0" align="center">
<tbody>
<tr valign="top">
<td style="margin: 0; padding: 0 0 0 35px;" align="left" valign="top">
<p style="font-family: Arial, Helvetica, sans-serif; color: #9d9fa1; font-weight: bold; text-align: left; line-height: 32px; font-size: 18px; margin: 0px 0px 7px 0px;">Prefer to Renew Manually?</p>
<p style="font-family: Arial, Helvetica, sans-serif; color: #676767; font-weight: normal; text-align: left; line-height: 28px; font-size: 16px; margin-top: 0px;">Log into your hosting control<br />panel and look for "HTTPS <br />Activation" in security tools.</p>
</td>
<td align="right" valign="bottom"><img style="margin-bottom: 15px;" src="https://www.thesslstore.com/images/ee_whmcs_emails/certpanel.png" alt="CertPanel" align="right" /></td>
</tr>
</tbody>
</table>
</td>
</tr>
</tbody>
</table>
<table style="padding: 20px;" width="600" cellspacing="0" cellpadding="0" align="center">
<tbody>
<tr align="center">
<td align="center">
<p style="font-family: Arial, Helvetica, sans-serif; color: #676767; font-weight: normal; text-align: center; line-height: 20px; font-size: 12px; margin: 0px;">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Duis a pulvinar leo.<br />Vivamus vitae enim vitae nisi interdum tristique non vel lorem. Aenean quam<br />orci, tincidunt imperdiet odio non, auctor tincidunt felis. Integer sit amet<br />metus pretium, pharetra lacus at, feugiat lacu</p>
</td>
</tr>
</tbody>
</table>
</td>
</tr>
</tbody>
</table></div>
<script> 
    if(document.getElementsByClassName("ee_email_template").length == 1){
        var removeHeaderForEE = document.getElementsByClassName("headerContent");
        removeHeaderForEE[0].parentNode.removeChild(removeHeaderForEE[0]);
    }
</script>','fromname' => '', 'fromemail' => '','disabled' => '', 'custom' => '1','language' => '', 'copyto' => '', 'plaintext' => '']);
        }


        //HTTPS Activation Renewal Email Template - For Premium Products
        $count = Capsule::table('tblemailtemplates')->where('name', 'HTTPS Activation Renewal Email')->count('*');
        if ($count=='0') {
            Capsule::table('tblemailtemplates')->insert(['type' => 'product', 'name' => 'HTTPS Activation Renewal Email', 'subject' => 'HTTPS Activation Renewal Email', 'message' => '<div class="ee_email_template">
        <table width="" border="0" align="center" valign="top" cellpadding="0" cellspacing="0" style="">
            <tr>
                <td>
                    <table width="600px" cellpadding="0" cellspacing="0" align="center" valign="top" style="padding:20px;">
                        <tr align="center">
                            <td align="center">
                                <h2 style="font-family:Arial, Helvetica, sans-serif;color:#A7AEB3;font-weight:bold;text-align:center;line-height:22px;font-size:18px;margin:0">Easy HTTPS Activation</h2>
                            </td>
                        </tr>
                    </table>
                    <table width="600px" cellpadding="0" cellspacing="0" align="center" valign="top" style="padding:20px;background:#FFFFFF;margin-top:30px">
                        <tr>
                            <td>
                                <table width="556px" cellpadding="0" cellspacing="0" align="center" valign="top" style="padding:0px 20px 20px 20px;background:#F7F8F9;margin-top:-50px">
                                    <tr align="center">
                                        <td width="100%" align="center" valign="top">
                                            <img src="https://www.thesslstore.com/images/ee_whmcs_emails/logo.png" align="center" alt="Easy HTTPS Activation" />
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <table width="100%" cellpadding="0" cellspacing="0" align="center" valign="top" style="margin-top:30px;padding:0 60px">
                                                <tr align="left">
                                                    <td align="left">
                                                        <p style="font-family:Arial, Helvetica, sans-serif;color:#676767;font-weight:normal;text-align:left;line-height:19px;font-size:15px;margin:0">Dear {$client_name},</p>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td width="100%" align="center">
                                                        <h1 style="font-family:Arial, Helvetica, sans-serif;color:#000000;font-weight:900;text-align:center;line-height:48px;font-size:37px;margin:30px 0px 10px 0px">Your HTTPS <br/>is About to Expire</h1>
                                                    </td>
                                                </tr>
                                            </table>
                                            <table width="100%" cellpadding="0" cellspacing="0" align="center" valign="top" style="padding:0 40px">
                                                <tr align="center">
                                                    <td align="center">
                                                        <h3 style="font-family:Arial, Helvetica, sans-serif;color:#A7AEB3;font-weight:600;text-align:center;line-height:32px;font-size:21px;margin-bottom:30px">Renew by <span style="font-family:Arial, Helvetica, sans-serif;color:#000000;font-weight:600;text-align:center;line-height:32px;font-size:21px;margin:0">{$expirationDate}</span> to preserve <br/>security for <a href="{$domain}" style="font-family:Arial, Helvetica, sans-serif;color:#51ABF6;font-weight:600;text-align:left;line-height:32px;font-size:21px;margin:0">{$domain}</a>. Don\'t risk<br/> harming your sales, conversions or <br/>reputation.</h3>
                                                    </td>
                                                </tr>
                                                <tr align="center">
                                                    <td align="center">&nbsp;</td>
                                                </tr>
                                                <tr align="center">
                                                    <td align="center">
                                                        <a href="{$cpanel_existing_product_url}"><img src="https://www.thesslstore.com/images/ee_whmcs_emails/btn1.png" align="center" alt="HTTPS for 1 Year" /></a>
                                                    </td>
                                                </tr>
                                                <tr align="center">
                                                    <td align="center">
                                                        <p style="font-family:Arial, Helvetica, sans-serif;color:#9D9FA1;font-weight:bold;text-align:center;line-height:32px;font-size:14px;margin:20px 0 0 0">Your Certificate:</p>
                                                    </td>
                                                </tr>
                                            </table>
                                            <table width="100%" cellpadding="0" cellspacing="0" align="center" valign="top">
                                                <tr>
                                                    <td>&nbsp;</td>
                                                </tr>
                                            </table>
                                            <table width="100%" cellpadding="0" cellspacing="0" align="center" valign="top" style="padding-top:30px;background:#fff;border:1px solid #EBEDEF">
                                                <tr align="center">
                                                    <td align="center">
                                                        <p style="font-family:Arial, Helvetica, sans-serif;color:#676767;font-weight:bold;text-align:center;line-height:30px;font-size:24px;margin:0px 0px 15px 0px">Pro HTTPS</p>
                                                        <img src="https://www.thesslstore.com/images/ee_whmcs_emails/{$trustLevel}" align="center" alt="Trust Level" style="margin-bottom:15px" />
                                                    </td>
                                                </tr>
                                                <tr align="left">
                                                    <td align="left">
                                                        <table width="100%" cellpadding="0" cellspacing="0" align="center" valign="top" style="padding:20px 0px;background:#FAFBFB">
                                                            <tr>
                                                                <td>
                                                                    <p style="font-family:Arial, Helvetica, sans-serif;color:#909192;font-weight:bold;text-align:center;line-height:20px;font-size:16px;margin:0"><img src="https://www.thesslstore.com/images/ee_whmcs_emails/{$productImg}" align="center" alt="GroTrust Brand" style="margin-right:10px" /> {$productName}</p>
                                                                </td>
                                                            </tr>
                                                        </table>
                                                        <table width="100%" cellpadding="0" cellspacing="0" align="center" valign="top" style="background:#F1F3F5">
                                                            <tr>
                                                                <td width="33%" style="border-right: 1px dashed #DCE0E4;padding:20px 20px">
                                                                    <p style="font-family:Arial, Helvetica, sans-serif;color:#909192;font-weight:normal;text-align:right;line-height:20px;font-size:16px;margin:0">Domain:</p>
                                                                </td>
                                                                <td style="padding:20px 20px">
                                                                    <p style="font-family:Arial, Helvetica, sans-serif;color:#909192;font-weight:normal;text-align:left;line-height:20px;font-size:16px;margin:0;padding-bottom:7px"><a href="#!" style="font-family:Arial, Helvetica, sans-serif;color:#118EF5;font-weight:normal;text-align:left;line-height:20px;font-size:16px;margin:0">{$domain}</a></p>
                                                                    {$SANs}                                                 
                                                                </td>
                                                            </tr>
                                                        </table>
                                                        <table width="100%" cellpadding="0" cellspacing="0" align="center" valign="top" style="background:#FBFCFC">
                                                            <tr>
                                                                <td width="33%" style="border-right: 1px dashed #DCE0E4;padding:20px 20px">
                                                                    <p style="font-family:Arial, Helvetica, sans-serif;color:#909192;font-weight:normal;text-align:right;line-height:20px;font-size:16px;margin:0">Site Seal:</p>
                                                                </td>
                                                                <td style="padding:10px 20px">
                                                                    <p style="font-family:Arial, Helvetica, sans-serif;color:#909192;font-weight:normal;text-align:left;line-height:20px;font-size:16px;margin:0"><img src="https://www.thesslstore.com/images/ee_whmcs_emails/{$productSeal}" align="center" alt="TrustedSite" /></p>
                                                                </td>
                                                            </tr>
                                                        </table>
                                                        <table width="100%" cellpadding="0" cellspacing="0" align="center" valign="top" style="background:#F1F3F5">
                                                            <tr>
                                                                <td width="33%" style="border-right: 1px dashed #DCE0E4;padding:20px 20px">
                                                                    <p style="font-family:Arial, Helvetica, sans-serif;color:#909192;font-weight:normal;text-align:right;line-height:20px;font-size:16px;margin:0">Warranty:</p>
                                                                </td>
                                                                <td style="padding:20px 20px">
                                                                    <p style="font-family:Arial, Helvetica, sans-serif;color:#909192;font-weight:normal;text-align:left;line-height:20px;font-size:16px;margin:0">{$warranty}</p>
                                                                </td>
                                                            </tr>
                                                        </table>
                                                    </td>
                                                </tr>
                                            </table>
                                            <table width="100%" cellpadding="0" cellspacing="0" align="center" valign="top">
                                                <tr>
                                                    <td>&nbsp;</td>
                                                </tr>
                                            </table>
                                            <table width="100%" cellpadding="0" cellspacing="0" align="center" valign="top" style="background:#F7F8F9">
                                                <tr align="center">
                                                    <td align="center">
                                                        <img src="https://www.thesslstore.com/images/ee_whmcs_emails/coverageOptions.png" align="center" alt="Coverage Options" />
                                                        <table width="100%" cellpadding="0" cellspacing="0" align="center" valign="top" style="background:#F7F8F9">
                                                            <thead>
                                                                <tr>
                                                                    <th style="border-bottom:1px solid #E0E2E6">&nbsp;</th>
                                                                    <th style="font-family:Arial, Helvetica, sans-serif;color:#9D9FA1;font-weight:bold;text-align:left;line-height:32px;font-size:14px;margin:0;text-transform:uppercase;border-bottom:1px solid #E0E2E6;width:18%">plan</th>
                                                                    <th style="font-family:Arial, Helvetica, sans-serif;color:#9D9FA1;font-weight:bold;text-align:center;line-height:32px;font-size:14px;margin:0;text-transform:uppercase;border-bottom:1px solid #E0E2E6;width:18%">Coverage</th>
                                                                    <th style="font-family:Arial, Helvetica, sans-serif;color:#9D9FA1;font-weight:bold;text-align:center;line-height:32px;font-size:14px;margin:0;text-transform:uppercase;border-bottom:1px solid #E0E2E6;width:18%">cost</th>
                                                                    <th style="border-bottom:1px solid #E0E2E6;width:35%">&nbsp;</th>
                                                                </tr>
                                                            </thead>
                                                            <tbody>
                                                                <tr>
                                                                    <th>&nbsp;</th>
                                                                    <td style="font-family:Arial, Helvetica, sans-serif;color:#676767;font-weight:normal;text-align:left;line-height:18px;font-size:14px;margin:0;padding:10px 0">Pro HTTPS</td>
                                                                    <td style="font-family:Arial, Helvetica, sans-serif;color:#000000;font-weight:bold;text-align:center;line-height:20px;font-size:16px;margin:0;padding:10px 0">1 year</td>
                                                                    <td style="font-family:Arial, Helvetica, sans-serif;color:#55ADF6;font-weight:normal;text-align:center;line-height:20px;font-size:22px;margin:0;padding:10px 0"><sup style="font-family:Arial, Helvetica, sans-serif;color:#118EF5;font-weight:normal;text-align:center;line-height:20px;font-size:18px;margin:0">$</sup><span style="font-family:Arial, Helvetica, sans-serif;color:#118EF5;font-weight:bold;text-align:center;line-height:30px;font-size:24px;margin:0;">{$existing_product_price}</span></td>
                                                                    <td align="right" style="padding:10px 0">
                                                                        <a href="{$cpanel_existing_product_url}"><img src="https://www.thesslstore.com/images/ee_whmcs_emails/renewal-btn1.png" align="center" alt="Renewal for 1 Year" /></a>
                                                                    </td>
                                                                </tr>
                                                                <tr>
                                                                    <td valign="top"><img src="https://www.thesslstore.com/images/ee_whmcs_emails/thumbsUp.png" align="left" alt="Thumbs Up" /></td>
                                                                    <td style="font-family:Arial, Helvetica, sans-serif;color:#676767;font-weight:normal;text-align:left;line-height:18px;font-size:14px;margin:0;padding:10px 0">Pro HTTPS</td>
                                                                    <td style="font-family:Arial, Helvetica, sans-serif;color:#000000;font-weight:bold;text-align:center;line-height:20px;font-size:16px;margin:0;padding:10px 0">3 year</td>
                                                                    <td style="font-family:Arial, Helvetica, sans-serif;color:#55ADF6;font-weight:normal;text-align:center;line-height:20px;font-size:22px;margin:0;padding:10px 0"><sup style="font-family:Arial, Helvetica, sans-serif;color:#55ADF6;font-weight:normal;text-align:center;line-height:20px;font-size:18px;margin:0">$</sup><span style="font-family:Arial, Helvetica, sans-serif;color:#55ADF6;font-weight:bold;text-align:center;line-height:30px;font-size:24px;margin:0;">{$threeYearPrice}</span></td>
                                                                    <td align="right" style="padding:0px 0 10px 0">
                                                                        <a href="{$cpanel_existing_product_url}&year=3"><img src="https://www.thesslstore.com/images/ee_whmcs_emails/renewal-btn2.png" align="center" alt="Renewal for 3 Year" /></a>
                                                                    </td>
                                                                </tr>
                                                            </tbody>
                                                        </table>
                                                    </td>
                                                </tr>
                                            </table>
                                        </td>
                                    </tr>
                                </table>
                                <table width="556" cellpadding="0" cellspacing="0" align="center" valign="top">
                                    <tr>
                                        <td>&nbsp;</td>
                                    </tr>
                                </table>
                                <table width="556px" cellpadding="0" cellspacing="0" align="center" valign="top" style="padding:30px 0px 0px 0px;background:#F7F8F9">
                                    <tr align="center">
                                        <td align="center" colspan="2">
                                            <h2 style="font-family:Arial, Helvetica, sans-serif;color:#000000;font-weight:600;text-align:center;line-height:32px;font-size:25px;margin:0">Don\'t Let Your HTTPS Expire!</h2>
                                        </td>
                                    </tr>
                                    <tr valign="top" style="margin:0;padding:0">
                                        <td align="left" colspan="2" style="margin:0;padding:0px;">
                                            <table width="100%" cellpadding="0" cellspacing="0" align="center" valign="top" style="margin:0;padding:0 0 0 35px">
                                                <tr align="center" style="margin:0;padding:0">
                                                    <td align="center" style="margin:0;padding:10px 0 5px 60px">
                                                        <img src="https://www.thesslstore.com/images/ee_whmcs_emails/arrow.png" align="left" alt="Arrow Icon" />
                                                    </td>
                                                </tr>
                                            </table>
                                        </td>
                                    </tr>
                                    <tr valign="top" style="margin:0;padding:0">
                                        <td style="margin:0;padding:0">
                                            <table width="100%" cellpadding="0" cellspacing="0" align="center" valign="top" style="margin:0;padding:0 0 0 35px">
                                                <tr valign="top" style="margin:0;padding:0">
                                                    <td align="left" valign="top" style="margin:0">
                                                        <p style="font-family:Arial, Helvetica, sans-serif;color:#676767;font-weight:normal;text-align:left;line-height:28px;font-size:16px;margin-top:0px">If your HTTPS security SSL certificate accidentally lapses, your site visitors will get an abrupt warning before seeing your website.</p>
                                                    </td>
                                                    <td align="right" valign="top" style="margin:0;padding:0">
                                                        <img src="https://www.thesslstore.com/images/ee_whmcs_emails/notsecure.png" align="right" alt="Not Secure" />
                                                    </td>
                                                </tr>
                                            </table>
                                        </td>
                                    </tr>
                                    <tr align="center" style="margin:0;padding:0">
                                        <td align="center" style="margin:0;padding:0">&nbsp;</td>
                                    </tr>
                                    <tr align="center" style="margin:0;padding:0">
                                        <td align="center" colspan="2" style="margin:0;padding:0">
                                            <a href="{$cpanel_existing_product_url}"><img src="https://www.thesslstore.com/images/ee_whmcs_emails/btn3.png" align="center" alt="HTTPS for 1 Year" /></a>
                                        </td>
                                    </tr>
                                    <tr align="center" style="margin:0;padding:0">
                                        <td align="center" style="margin:0;padding:0">&nbsp;</td>
                                    </tr>
                                </table>
                                <table width="556" cellpadding="0" cellspacing="0" align="center" valign="top">
                                    <tr>
                                        <td>&nbsp;</td>
                                    </tr>
                                </table>
                                <table width="556" cellpadding="0" cellspacing="0" align="center" valign="top" style="padding:30px 35px 25px 0px;background:#F7F8F9">
                                    <tr valign="top">
                                        <td align="left" valign="top" style="margin:0;padding:0 0 0 35px">
                                            <p style="font-family:Arial, Helvetica, sans-serif;color:#9D9FA1;font-weight:bold;text-align:left;line-height:32px;font-size:18px;margin:0px 0px 7px 0px">Prefer to Renew Manually?</p>
                                            <p style="font-family:Arial, Helvetica, sans-serif;color:#676767;font-weight:normal;text-align:left;line-height:28px;font-size:16px;margin-top:0px">Log into your hosting control<br/> panel and look for "HTTPS <br/>Activation" in security tools.</p>
                                        </td>
                                        <td align="right" valign="bottom">
                                            <img src="https://www.thesslstore.com/images/ee_whmcs_emails/certpanel.png" align="right" alt="CertPanel" style="margin-bottom:15px" />
                                        </td>
                                    </tr>
                                </table>
                            </td>
                        </tr>
                    </table>
                    <table width="600px" cellpadding="0" cellspacing="0" align="center" valign="top" style="padding:20px;">
                        <tr align="center">
                            <td align="center">
                                <p style="font-family:Arial, Helvetica, sans-serif;color:#676767;font-weight:normal;text-align:center;line-height:20px;font-size:12px;margin:0px">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Duis a pulvinar leo.<br/> Vivamus vitae enim vitae nisi interdum tristique non vel lorem. Aenean quam<br/> orci, tincidunt imperdiet odio non, auctor tincidunt felis. Integer sit amet<br/> metus pretium, pharetra lacus at, feugiat lacu</p>
                            </td>
                        </tr>
                    </table>
                </td>
            </tr>
        </table>
    </div>
    <script> 
        if(document.getElementsByClassName("ee_email_template").length == 1){
            var removeHeaderForEE = document.getElementsByClassName("headerContent");
            removeHeaderForEE[0].parentNode.removeChild(removeHeaderForEE[0]);
        }
    </script>','fromname' => '', 'fromemail' => '','disabled' => '', 'custom' => '1','language' => '', 'copyto' => '', 'plaintext' => '']);
        }

        //Your SSL Certificate - Successful Installation Email Template
        $count = Capsule::table('tblemailtemplates')->where('name', 'All secure, Thanks!')->count('*');
        if ($count=='0') {
            Capsule::table('tblemailtemplates')->insert(['type' => 'general', 'name' => 'All secure, Thanks!', 'subject' => 'Your SSL Certificate - Successful Installation Email', 'message' => '<div class="ee_email_template">
        <table width="" border="0" align="center" valign="top" cellpadding="0" cellspacing="0" style="">
            <tr>
                <td>
                    <table width="600" cellpadding="0" cellspacing="0" align="center" valign="top" style="background:#F7F8F9">
                        <tr>
                            <td>
                                <table width="556px" cellpadding="0" cellspacing="0" align="center" valign="top">
                                    <tr align="center">
                                        <td width="100%" align="center" valign="top">
                                            <img src="https://www.thesslstore.com/images/ee_whmcs_emails/logo.png" align="center" alt="Easy HTTPS Activation" />
                                            <h2 style="font-family:Arial, Helvetica, sans-serif;color:#444545;font-weight:900;text-align:center;line-height:26px;font-size:20px;margin:15px 0 0 0">Easy HTTPS Activation</h2>
                                        </td>
                                    </tr>

                                </table>
                                <table width="100%" cellpadding="0" cellspacing="0" align="left" valign="top" style="padding:30px 50px;background:#ffffff;margin-top:25px">
                                    <tr align="left">
                                        <td align="left" colspan="2">
                                            <p style="font-family:Arial, Helvetica, sans-serif;color:#676767;font-weight:normal;text-align:left;line-height:20px;font-size:15px;margin:0px 0px 20px 0px">Dear {$client_name},</p>
                                            <p style="font-family:Arial, Helvetica, sans-serif;color:#676767;font-weight:normal;text-align:left;line-height:20px;font-size:15px;margin:0px 0px 20px 0px">This is to inform you that, the new certificate <strong>({$productName})</strong> has been installed on your domain(<strong>{$domainName}</strong>) successfully.</p>
                                            <p style="font-family:Arial, Helvetica, sans-serif;color:#676767;font-weight:normal;text-align:left;line-height:20px;font-size:15px;margin:0px 0px 20px 0px">To check please <a href="https://{$domainName}" target="_blank" rel="noopener">\'Click Here\'</a>.</p>
                                            <p style="font-family:Arial, Helvetica, sans-serif;color:#676767;font-weight:normal;text-align:left;line-height:20px;font-size:15px;margin:0px 0px 20px 0px">Thank you for using our services!</p>
                                        </td>
                                    </tr>
                                </table>
                            </td>
                        </tr>
                    </table>
                    <table width="600" cellpadding="0" cellspacing="0" align="center" valign="top" style="padding:20px;">
                        <tr align="center">
                            <td align="center">
                                <p style="font-family:Arial, Helvetica, sans-serif;color:#676767;font-weight:normal;text-align:center;line-height:20px;font-size:12px;margin:0px">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Duis a pulvinar leo.<br/> Vivamus vitae enim vitae nisi interdum <a href="#!"  style="font-family:Arial, Helvetica, sans-serif;color:#51ABF6;font-weight:normal;text-align:center;line-height:20px;font-size:12px;margin:0">tristique</a> non vel lorem. Aenean quam<br/> orci, tincidunt imperdiet odio non, auctor tincidunt felis. Integer sit amet<br/> metus pretium, pharetra lacus at, feugiat lacu</p>
                            </td>
                        </tr>
                    </table>
                </td>
            </tr>
        </table>
    </div>
    <script> 
        if(document.getElementsByClassName("ee_email_template").length == 1){
            var removeHeaderForEE = document.getElementsByClassName("headerContent");
            removeHeaderForEE[0].parentNode.removeChild(removeHeaderForEE[0]);
        }
    </script>','fromname' => '', 'fromemail' => '','disabled' => '', 'custom' => '1','language' => '', 'copyto' => '', 'plaintext' => '']);
        }
        
        //Thanks for upgrading, please complete OV/EV
        $count = Capsule::table('tblemailtemplates')->where('name', 'Thanks for upgrading, please complete OV/EV')->count('*');
        if ($count=='0') {
            Capsule::table('tblemailtemplates')->insert(['type' => 'general', 'name' => 'Thanks for upgrading, please complete OV/EV', 'subject' => 'Thanks for upgrading, please complete OV/EV', 'message' => '<div class="ee_email_template"><table border="0" width="" cellspacing="0" cellpadding="0" align="center">
<tbody>
<tr>
<td>
<table style="background: #F7F8F9;" width="600" cellspacing="0" cellpadding="0" align="center">
<tbody>
<tr>
<td>
<table width="556px" cellspacing="0" cellpadding="0" align="center">
<tbody>
<tr align="center">
<td align="center" valign="top" width="100%"><img src="https://www.thesslstore.com/images/ee_whmcs_emails/logo.png" alt="Easy HTTPS Activation" align="center" />
<h2 style="font-family: Arial, Helvetica, sans-serif; color: #444545; font-weight: 900; text-align: center; line-height: 26px; font-size: 20px; margin: 15px 0 0 0;">Easy HTTPS Activation</h2>
</td>
</tr>
</tbody>
</table>
<table style="padding: 30px 50px; background: #ffffff; margin-top: 25px;" width="100%" cellspacing="0" cellpadding="0" align="left">
<tbody>
<tr align="left">
<td colspan="2" align="left">
<p style="font-family: Arial, Helvetica, sans-serif; color: #676767; font-weight: normal; text-align: left; line-height: 20px; font-size: 15px; margin: 0px 0px 20px 0px;">Great choice! You’ve upgraded to a premium OV or EV SSL certificate that requires some additional validation of your organization. Don’t worry, we\'re here to help you along the way.</p>
<p style="font-family: Arial, Helvetica, sans-serif; color: #676767; font-weight: normal; text-align: left; line-height: 20px; font-size: 15px; margin: 0px 0px 20px 0px;">At this time, no action is required on your end. Validation specialists at DigiCert have started to review your certificate enrollment request and will contact you at <b>{$adminEmail}</b> if they need any additional info.</p>
<p style="font-family: Arial, Helvetica, sans-serif; color: #676767; font-weight: normal; text-align: left; line-height: 20px; font-size: 15px; margin: 0px 0px 20px 0px;">Here are a few things they\'ll be looking at: • Official government registration for your organization • A trusted third-party telephone listing for your organization (e.g. Yellow Pages, Google Verified Businesses, etc.)</p>
<p style="font-family: Arial, Helvetica, sans-serif; color: #676767; font-weight: normal; text-align: left; line-height: 20px; font-size: 15px; margin: 0px 0px 20px 0px;">Interested in expediting this process? You can email copies or links to the above information to the validation team at support@digicert.com, just mention this order <b># {$vendorOrderId}</b> in the subject line. This step is not necessary but may help get your order validated faster if you\'re in a pinch.</p>
<p style="font-family: Arial, Helvetica, sans-serif; color: #676767; font-weight: normal; text-align: left; line-height: 20px; font-size: 15px; margin: 0px 0px 20px 0px;">Please let us know if you have any questions or concerns about the validation process.</p>
<p style="font-family: Arial, Helvetica, sans-serif; color: #676767; font-weight: normal; text-align: left; line-height: 20px; font-size: 15px; margin: 0px 0px 20px 0px;">Regards, {$companyName}</p>
</td>
</tr>
</tbody>
</table>
</td>
</tr>
</tbody>
</table>
</td>
</tr>
</tbody>
</table></div>
<script> 
    if(document.getElementsByClassName("ee_email_template").length == 1){
        var removeHeaderForEE = document.getElementsByClassName("headerContent");
        removeHeaderForEE[0].parentNode.removeChild(removeHeaderForEE[0]);
    }
</script>','fromname' => '', 'fromemail' => '','disabled' => '', 'custom' => '1','language' => '', 'copyto' => '', 'plaintext' => '']);
        }

        echo json_encode(array('result' => 'success','message' => '','products' => $products, 'prd' =>$results['products']['product'] ));
        die();
    }

    private function getProductFromInvoiceId(){
        $product = array();
        try{
            $query = Capsule::table('tblinvoiceitems')
                ->select('tblproducts.name', 'tblhosting.orderid','tblhosting.packageid')
                ->leftJoin('tblhosting','tblhosting.id','=','tblinvoiceitems.relid')
                ->leftJoin('tblproducts','tblhosting.packageid','=','tblproducts.id')
                ->where('tblinvoiceitems.invoiceid', $_POST['invoiceid']);

            $tblOrderData = $query->first();


            if($tblOrderData != NULL){
                $results = localAPI('GetOrders', array('id' => $tblOrderData->orderid));
                if($results['result'] == 'success'){
                    $product['pid'] = $tblOrderData->packageid;
                    $product['name'] = $tblOrderData->name;
                    $product['amount'] = $results['orders']['order'][0]['amount'];
                    $product['prefix'] = $results['orders']['order'][0]['currencyprefix'];
                    $product['suffix'] = $results['orders']['order'][0]['currencysuffix'];
                    echo json_encode(array('result' => 'success','message' => '','product' => $product));
                    die();
                }
            }

        }catch(\Exception $e){
            logActivity("TheSSLStore Module Log|query, {$e->getMessage()}");
        }

        echo json_encode(array('result' => 'error','message' => 'No Product Found','product' => $product));
        die();
    }

    private function getClientId(){
        if($this->clientId){
            $cred = getTokens();
            $sslApi = new sslstorev2($cred["partnercode"],$cred["authToken"],$cred["mode"]);

            $sslUserAccountDetailsReq = new user_account_detail_requestv2();
            $sslUserAccountDetailsResponse =  $sslApi->user_account_detail($sslUserAccountDetailsReq);
            
            echo json_encode(array('result' => 'success','message' => '','clientId' => $this->clientId,'resellerDetails' => $sslUserAccountDetailsResponse));
            die();
            
            
        }
        echo json_encode(array('result' => 'error','message' => 'Client Not Found','clientId' => $this->clientId));
        die();
    }

    private function getClientAuthDetails($invoiceid){
        global $CONFIG, $autoauthkey;
        // $result = localAPI('GetClientsDetails', array('clientid' => $this->clientId,'stats' => false));
        if (!$autoauthkey) {
            $autoauthkey = "33P1u9inaut0authk33y123";
        }
        
        $command = 'CreateSsoToken';
        $postData = array(
            'client_id' => $this->clientId,
            'destination' => 'sso:custom_redirect',
            'sso_redirect_path' => 'viewinvoice.php?id='.$invoiceid,
        );
        // $adminUsername = $_POST['cpanelusername']; // Optional for WHMCS 7.2 and later
        
        $results = localAPI($command, $postData);
        if($results['result'] == 'success'){
            if(!empty($results['access_token'])){
                $timestamp = time();
                $url = urlencode($results['redirect_url']);
                echo json_encode(array('result' => 'success','message' => '','url' => $url));
                return;
            }
            else{
                echo json_encode(array('result' => 'error','message' => 'Auth Key Not Found'));
                return;
            }
        }
        else{
            $result = localAPI('GetClientsDetails', array('clientid' => $this->clientId,'stats' => false));
            if($result['result'] == 'success'){
                if(!empty($autoauthkey)){
                    $timestamp = time();
                    $goto = 'viewinvoice.php?id='.$invoiceid;
                    $url = urlencode($CONFIG['SystemURL'].'/dologin.php?email='.$result['email'].'&manualtime='.$timestamp.'&hash='.sha1($result['email'].$timestamp.$autoauthkey).'&goto='.$goto);
                    echo json_encode(array('result' => 'success','message' => '','url' => $url,'ssoError'=>$results));
                    return;
                }
                else{
                    echo json_encode(array('result' => 'error','message' => 'Auth Key Not Found'));
                    return;
                }
            }
            else{
                echo json_encode(array('result' => 'error','message' => $result['message']));
                return;
            }
            echo json_encode(array('result' => 'error','message' => $results['message'],'postData' => $results));
            return;
        }


    }
    
    private function autoInstallSSL($store_order_id, $common_name, $pvt_key_id){
        
        if(empty($store_order_id)){
            echo json_encode(array('result' => 'error','message' => 'StoreOrderID Not Found'));
            return;
        }
        
        if(isset($store_order_id)){
            $storeOrderID =  Capsule::table('mod_sslstore_orders_data')
                    ->select('mod_sslstore_orders_data.invoice_id','mod_sslstore_orders_data.service_id','mod_sslstore_orders_data.package_id','mod_sslstore_orders_data.store_order_id','mod_sslstore_orders_data.common_name','mod_sslstore_orders_data.order_placed_date')
                    ->where('mod_sslstore_orders_data.store_order_id', $store_order_id)
                    ->first();
                    
            $hostingdata =  Capsule::table('tblhosting')
                    ->select('tblhosting.orderid')
                    ->where('tblhosting.id', $storeOrderID->service_id)
                    ->first();
                    
            $hosting_id =  Capsule::table('mod_sslstore_panel_orders')
                    ->select('mod_sslstore_panel_orders.panel_hosting_id')
                    ->where('mod_sslstore_panel_orders.whmcs_order_id', $hostingdata->orderid)
                    ->first();

            if(!empty($pvt_key_id)) {
                //Store pvtKeyID in tblsslorders table
                $sslInfo = array();
                $sslInfo['pvtKeyID'] = (isset($pvt_key_id) ? $pvt_key_id : '');
                $results = Capsule::table('tblsslorders')->where('serviceid', $storeOrderID->service_id)->update(['configdata' => json_encode($sslInfo)]);
            }
  
            $id = TSSDB::insert1('mod_sslstore_auto_install_ssl', array(
                'hosting_id' => $hosting_id->panel_hosting_id,
                'service_id' => $storeOrderID->service_id,
                'addon_id' => (isset($storeOrderID->addonId)) ? $storeOrderID->addonId : 0,
                'store_order_id' => $storeOrderID->store_order_id,
                'domain_name' => $common_name,
                'created_date' => date('Y-m-d H:i:s'),
                'status' => '0'
            ));
            
            echo json_encode(array('result' => 'success','message' => $id));
            return;
        }

            
        if(!$id){
            echo json_encode(array('result' => 'error','message' => 'Sorry! Issue in set information, Please contact Admin'));
            return;
        }

        echo json_encode(array('result' => 'success','message' => $id));
        return;
    }

    private function storeSSLInfo(){
        $fields = array(
            'id' => array('type' => 'INT', 'auto_increment' => true),
            'whmcs_order_id' => array('type' => 'INT', 'unique_key' => true),
            'whmcs_invoice_id' => array('type' => 'INT', 'default' => 0),
            'whmcs_service_id' => array('type' => 'INT', 'default' => 0),
            'panel_hosting_id' => array('type' => 'INT', 'default' => 0),
            'configdata' => array('type' => 'TEXT'),
            'allow_autoinstall' => array('type' => 'VARCHAR', 'constraint'=> 10, 'default' => 'NO'),
            'cert_installed' => array('type' => 'VARCHAR', 'constraint'=> 10, 'default' => 'NO'),
            'pvtKeyID' => array('type' => 'VARCHAR', 'default' => ''),
        );
        TSSDB::createTable('mod_sslstore_panel_orders', $fields);

        if(empty($_POST['orderid'])){
            echo json_encode(array('result' => 'error','message' => 'OrderId Not Found'));
            return;
        }
        
        if(isset($_POST['invoiceid'])){
            $id = TSSDB::insert1('mod_sslstore_panel_orders', array('whmcs_order_id' => $_POST['orderid'], 'whmcs_service_id' => $_POST['serviceids'], 'whmcs_invoice_id' => $_POST['invoiceid'], 'panel_hosting_id' => $this->panelHostingId,'configdata' => json_encode($_POST['sslinfo'])));
        }else{
            $id = TSSDB::insert1('mod_sslstore_panel_orders', array('whmcs_order_id' => $_POST['orderid'], 'whmcs_service_id' => $_POST['serviceids'], 'panel_hosting_id' => $this->panelHostingId,'configdata' => json_encode($_POST['sslinfo'])));
        }
            
        if(!$id){
            echo json_encode(array('result' => 'error','message' => 'Sorry! Issue in set information, Please contact Admin'));
            return;
        }

        echo json_encode(array('result' => 'success','message' => ''));
        return;
    }

    private function fetchSSLInfo(){

        $sslInfo = array();

        if(!empty($_POST['storeorderid'])){
            try{
                $storeOrderID =  Capsule::table('mod_sslstore_orders_data')
                    ->select('mod_sslstore_orders_data.invoice_id','mod_sslstore_orders_data.service_id')
                    ->where('mod_sslstore_orders_data.store_order_id', $_POST['storeorderid'])
                    ->first();
                if($storeOrderID->invoice_id == 0){
                    $storeOrderData =  Capsule::table('mod_sslstore_panel_orders')
                    ->select('mod_sslstore_panel_orders.configdata','mod_sslstore_panel_orders.pvtKeyID')
                    ->leftJoin('mod_sslstore_orders_data','mod_sslstore_orders_data.service_id','=','mod_sslstore_panel_orders.whmcs_service_id')
                    ->where('mod_sslstore_orders_data.store_order_id', $_POST['storeorderid'])
                    ->first();
                }else{
                    $storeOrderData =  Capsule::table('mod_sslstore_panel_orders')
                    ->select('mod_sslstore_panel_orders.configdata','mod_sslstore_panel_orders.pvtKeyID')
                    ->leftJoin('mod_sslstore_orders_data','mod_sslstore_orders_data.invoice_id','=','mod_sslstore_panel_orders.whmcs_invoice_id')
                    ->where('mod_sslstore_orders_data.store_order_id', $_POST['storeorderid'])
                    ->first();
                }
                
                

                if($storeOrderData == NULL){
                    logActivity("TheSSLStore Module Log|No order found with store order id:{$_POST['storeorderid']}");
                    echo json_encode(array('result' => 'error','message' => 'SSL Info Not Found', 'sslInfo' => $sslInfo));
                    return false;
                }
                else{
                    $configData = json_decode($storeOrderData->configdata);
                    $sslInfo['commonName'] = $configData->commonName;
                    $sslInfo['additionalDomains'] = $configData->additionalDomains;
                    $sslInfo['subDomains'] = $configData->subDomains;
                    $sslInfo['csrCompany'] = $configData->csrCompany;
                    $sslInfo['csrDivision'] = $configData->csrDivision;
                    $sslInfo['csrCity'] = $configData->csrCity;
                    $sslInfo['csrState'] = $configData->csrState;
                    $sslInfo['csrCountry'] = $configData->csrCountry;
                    $sslInfo['csrEmail'] = $configData->csrEmail;
                    $sslInfo['orgAddress'] = $configData->address1;
                    $sslInfo['orgZipCode'] = $configData->postcode;
                    $sslInfo['orgPhone'] = $configData->orgPhone;
                    $sslInfo['adminFirstName'] = $configData->firstname;
                    $sslInfo['adminLastName'] = $configData->lastname;
                    $sslInfo['adminTitle'] = $configData->jobtitle;
                    $sslInfo['adminEmail'] = $configData->email;
                    $sslInfo['adminPhone'] = $configData->phonenumber;
                    $sslInfo['techFirstName'] = $configData->fields->TechFirstName;
                    $sslInfo['techLastName'] = $configData->fields->TechLastName;
                    $sslInfo['techTitle'] = $configData->fields->TechTitle;
                    $sslInfo['techEmail'] = $configData->fields->TechEmail;
                    $sslInfo['techPhone'] = $configData->fields->TechPhone;
                    $sslInfo['IsSiteSeal'] = $configData->fields->IsSiteSeal;

                    $sslInfo['selectedDomainName'] = $configData->fields->selectedDomainName;
                    $sslInfo['domainsCoverCount'] = $configData->fields->domainsCoverCount;
                    $sslInfo['domainsSubdomains'] = $configData->fields->domainsSubdomains;
                    $sslInfo['totalPrice'] = $configData->fields->totalPrice;
                    $sslInfo['discount'] = $configData->fields->discount;
                    $sslInfo['mainDomainID'] = $configData->fields->mainDomainID;
                    $sslInfo['mainDomainValue'] = $configData->fields->mainDomainValue;
                    $sslInfo['additionalStandardID'] = $configData->fields->additionalStandardID;
                    $sslInfo['additionalStandardValue'] = $configData->fields->additionalStandardValue;
                    $sslInfo['additionalWildcardID'] = $configData->fields->additionalWildcardID;
                    $sslInfo['additionalWildcardValue'] = $configData->fields->additionalWildcardValue;

                    $sslInfo['IsEE'] = $configData->fields->IsEE;
                    $sslInfo['IsEENoSiteSeal'] = $configData->fields->IsEENoSiteSeal;
                    $sslInfo['IsBasic'] = $configData->IsBasic;
                    $sslInfo['digicert_org_id'] = $configData->digicert_org_id;
                    $sslInfo['AutoWWW'] = $configData->AutoWWW;
                    $sslInfo['csr'] = $configData->csr;

                    if(isset($storeOrderData->pvtKeyID)){
                        $pvtKeyId = $storeOrderData->pvtKeyID;
                    }else{
                        $pvtKeyId = "";
                    }

                    echo json_encode(array('result' => 'success','message' => '', 'sslInfo' => $sslInfo, 'pvtKeyId' => $pvtKeyId));
                    die();
                }
            }catch(\Exception $e){
                logActivity("TheSSLStore Module Log|query, {$e->getMessage()}");
            }
        }
        else{
            echo json_encode(array('result' => 'error','message' => 'Store Order ID Not Found', 'sslInfo' => $sslInfo));
            die();
        }
    }

    private function getSSLToken(){
        //get token for active order
        $token = '';
        if(!empty($_POST['whmcsorderid'])){
            try{
                $tblsslOrdersData = Capsule::table('tblsslorders')
                    ->select('tblsslorders.remoteid', 'tblsslorders.certtype')
                    ->leftJoin('tblhosting', 'tblhosting.id', '=', 'tblsslorders.serviceid')
                    ->where('tblhosting.orderid', $_POST['whmcsorderid'])
                    ->first();

                if($tblsslOrdersData == NULL){
                    logActivity("TheSSLStore Module Log|No Store order found with  whmcs order id:{$_POST['whmcsorderid']}");
                    echo json_encode(array('result' => 'error', 'message' => 'Order Not Found', 'token' => $token));
                    return false;
                }
                else{
                    $cred = getTokens();
                    $sslApi = new sslstorev2($cred["partnercode"],$cred["authToken"],$cred["mode"]);
                    
                    // if($tblsslOrdersData->certtype == 'digi_ssl_dv_ee '){
                    //     //get order status for EE
                    //     // $order_status_request = new ee_order_status_requestv2();
                    //     // $order_status_request->theSSLStoreOrderId = $tblsslOrdersData->remoteid;
                    //     // $order_status_response =  $sslApi->ee_order_status($order_status_request);
                    //     // if($order_status_response == NULL || $order_status_response->AuthResponse->isError == true){
                    //     //     logActivity("TheSSLStore Module Log|EE Order Status: Request:".json_encode($order_status_request) ."Response:". json_encode($order_status_response));
                    //     //     echo json_encode(array('result' => 'error','message' => 'Token Not Found', 'token' => ''));
                    //     //     die();
                    //     // }
                    //     echo json_encode(array('result' => 'success','message' => '', 'partnercode' => $tblsslOrdersData->certtype, 'authToken' => 'hi'));
                    //     die();

                    // }
                    // else{
                        //get order status for Non EE
                        $order_status_request = new order_status_requestv2();
                        $order_status_request->TheSSLStoreOrderID = $tblsslOrdersData->remoteid;
                        $order_status_response =  $sslApi->order_status($order_status_request);
                        if($order_status_response == NULL || $order_status_response->AuthResponse->isError == true){
                            logActivity("TheSSLStore Module Log|Order Status: Request:".json_encode($order_status_request) ."Response:". json_encode($order_status_response));
                            echo json_encode(array('result' => 'error','message' => 'Token Not Found', 'token' => ''));
                            die();
                        }
                        echo json_encode(array('result' => 'success','message' => '', 'token' => $order_status_response->Token));
                        die();
                    // }
                }
            }
            catch(\Exception $e){
                logActivity("TheSSLStore Module Log|query, {$e->getMessage()}");
            }

        }
        else{
            echo json_encode(array('result' => 'error','message' => 'Order ID Not Found', 'token' => $token));
            die();
        }
    }

    private function syncServers($server_name){
        if(!empty($server_name)){
            try{
                $tblserversData = Capsule::table('tblservers')
                    ->select('tblservers.id')
                    ->where('tblservers.hostname', $server_name)
                    ->first();

                if($tblserversData == NULL){
                    logActivity("TheSSLStore Module Log|No Server found in whmcs with server name:{$server_name}");
                    echo json_encode(array('result' => 'error', 'message' => 'Server Not Found', 'server_name' => $server_name));
                    return false;
                }
                else{

                    $tblhostingData = Capsule::table('tblhosting')
                    ->select('tblhosting.domain','tblhosting.userid')
                    ->where('tblhosting.billingcycle', 'Free Account')
                    ->where('tblhosting.server', $tblserversData->id)
                    ->get();

                    if($tblhostingData == NULL){
                        logActivity("TheSSLStore Module Log|No Domains found in whmcs with server name:{$server_name}");
                        echo json_encode(array('result' => 'error', 'message' => 'Domain Not Found', 'server_name' => $server_name));
                        return false;
                    }else{
                        $domains_array = array();
                        $users_array = array();
                        foreach($tblhostingData as $hostings){
                            $domains_array[] = $hostings->domain;
                            $users_array[] = $hostings->domain.'__'.$hostings->userid;
                        }
                        $domains = implode(',', $domains_array);
                        $users = implode(',', $users_array);
                        echo json_encode(array('result' => 'success','message' => '', 'server_name' => $server_name, 'domain_name' => $domains, 'user_ids' => $users));
                        die();
                    }
                }
            }
            catch(\Exception $e){
                logActivity("TheSSLStore Module Log|query, {$e->getMessage()}");
            }

        }
        else{
            echo json_encode(array('result' => 'error','message' => 'Server Not Found', 'server_name' => $server_name));
            die();
        }
    }

    private function getAPIMode(){
        $cred = getTokens();
        echo json_encode(array('result' => 'success','message' => '','APIMode' => $cred["mode"]));
        die();
    }

    private function getAPICred(){
        $cred = getTokens();

        echo json_encode(array('result' => 'success','message' => '','APICred' => $cred));
        die();
    }
    public function redirectToPanel($invoiceId){
        if(Capsule::schema()->hasTable('mod_sslstore_panel_orders')){
            $tblPanelOrder = Capsule::table('mod_sslstore_panel_orders')->select('whmcs_order_id', 'configdata')->where('whmcs_invoice_id', $invoiceId)->first();
            
            //$_POST['ajax'] is set when payment will add from admin
            if($tblPanelOrder != NULL){
                $configData = json_decode($tblPanelOrder->configdata);
                $IsEE = $configData->fields->IsEE;

                //check if order is pending then accept it and make it active
                $getOrderResp = localAPI('GetOrders', array('id' => $tblPanelOrder->whmcs_order_id));
                if($getOrderResp['result'] == 'success'){
                    if(strtolower($getOrderResp['orders']['order'][0]['status']) != 'active'){
                        //accept order
                        $acceptOrderResp = localAPI('AcceptOrder', array('orderid' => $tblPanelOrder->whmcs_order_id));
                        if($acceptOrderResp['result'] != 'success'){
                            logActivity("TheSSLStore Module Log|Accept Order:" . json_encode($acceptOrderResp));
                            return;
                        }
                    }


                    //Get cpanel server user name and accesskey
                    $serverData = Capsule::table('mod_sslstore_panel_orders')
                        ->select('tblservers.ipaddress', 'tblservers.username', 'tblservers.accesshash', 'tblservers.secure', 'tblhosting.username as panelusername','mod_sslstore_orders_data.store_order_id')
                        ->leftJoin('tblhosting', 'tblhosting.id', '=', 'mod_sslstore_panel_orders.panel_hosting_id')
                        ->leftJoin('tblservers', 'tblservers.id', '=', 'tblhosting.server')
                        ->leftJoin('mod_sslstore_orders_data','mod_sslstore_orders_data.invoice_id','=','mod_sslstore_panel_orders.whmcs_invoice_id')
                        ->where('mod_sslstore_panel_orders.whmcs_invoice_id', $invoiceId)
                        ->first();
                    if($serverData != NULL){

                        //call tss order status to get token
                        $cred = getTokens();
                        $sslApi = new sslstorev2($cred["partnercode"],$cred["authToken"],$cred["mode"]);

                        $orderStatusReq = new order_status_requestv2();
                        $orderStatusReq->TheSSLStoreOrderID = $serverData->store_order_id;
                        $orderStatusReq->DateTimeCulture = 'hi-IN';
                        $orderStatusResp = $sslApi->order_status($orderStatusReq);
                        if($orderStatusResp == NULL || $orderStatusResp->AuthResponse->isError == true){
                            logActivity("TheSSLStore Module Log|Order Status: Request:".json_encode($orderStatusReq) ."Response:". json_encode($orderStatusResp));
                            return;
                        }

                        $query = 'http://' . $serverData->ipaddress . ':2086';
                        if($serverData->secure == 'on'){
                            $query = 'https://' . $serverData->ipaddress . ':2087';
                        }

                        $query .= '/json-api/create_user_session?api.version=1&user=' . $serverData->panelusername . '&service=cpaneld';

                        $curl = curl_init();
                        curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, 0);
                        curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, 0);
                        curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);

                        $header[0] = "Authorization: whm $serverData->username:$serverData->accesshash";
                        curl_setopt($curl, CURLOPT_HTTPHEADER, $header);
                        curl_setopt($curl, CURLOPT_URL, $query);

                        $result = curl_exec($curl);
                            
                        // $http_status = curl_getinfo($curl, CURLINFO_HTTP_CODE);

                        $result = json_decode($result);
                        if(isset($result->data->url) && !empty($result->data->url)){
                            if($IsEE == 'Yes'){
                                header('Location:' . $result->data->url . '&goto_uri=/frontend/paper_lantern/httpsactivation/install_process.live.php?token='.str_replace('#','hash',$orderStatusResp->Token).'&orderid='. $tblPanelOrder->whmcs_order_id.'&isEE='. $IsEE);
                            }else{
                                header('Location:' . $result->data->url . '&goto_uri=/frontend/paper_lantern/httpsactivation/install_process.live.php?token='.str_replace('#','hash',$orderStatusResp->Token).'&orderid='. $tblPanelOrder->whmcs_order_id);
                            }
                            exit();
                        } else{
                            logActivity("TheSSLStore Module Log|cpanel url response:" . json_encode($result));
                            return 0;
                        }
                    }else{
                        logActivity("TheSSLStore Module Log|SSL Order Not found.");
                        return 0;
                    }
                }else{
                    logActivity("TheSSLStore Module Log|Get Order:" . json_encode($getOrderResp));
                    return 0;
                }
            }else{
                return 0;
            }
        }else{
            return 0;
        }
    }

    private function updateOrderInfo($order_id, $pvt_key_id, $update_pvt_key){
        $results ='';
        try{
            if($_POST['updatePvtKey'] == true)
            {
                $results = Capsule::table('mod_sslstore_panel_orders')->where('whmcs_order_id', $_POST['orderid'])->update(['allow_autoinstall' => 'NO','cert_installed' => 'NO','pvtKeyID' => $_POST['pvtkeyid']]);
            }else
            {
                $results = Capsule::table('mod_sslstore_panel_orders')->where('whmcs_order_id', $_POST['orderid'])->update(['allow_autoinstall' => 'YES','cert_installed' => 'NO','pvtKeyID' => $_POST['pvtkeyid']]);
            }
            echo json_encode(array('result' => 'success','message' => '','results' => $results));
            die();
        }catch(\Exception $e){
            logActivity("TheSSLStore Module Log|query, {$e->getMessage()}");
        }
        echo json_encode(array('result' => 'success','message' => '','results' => $results));
        die();
    }

    private function updateorderinfoBySSLID($order_id, $pvt_key_id, $csr, $update_pvt_key){
        $results ='';
        try{
            if(!empty($order_id)){
                try{
                    $storeOrderID =  Capsule::table('mod_sslstore_orders_data')
                        ->select('mod_sslstore_orders_data.invoice_id','mod_sslstore_orders_data.service_id')
                        ->where('mod_sslstore_orders_data.store_order_id', $_POST['orderid'])
                        ->first();
                    if($storeOrderID->invoice_id == 0){
                        $storeOrderData =  Capsule::table('mod_sslstore_panel_orders')
                        ->select('mod_sslstore_panel_orders.whmcs_order_id','mod_sslstore_panel_orders.configdata')
                        ->leftJoin('mod_sslstore_orders_data','mod_sslstore_orders_data.service_id','=','mod_sslstore_panel_orders.whmcs_service_id')
                        ->where('mod_sslstore_orders_data.store_order_id', $_POST['orderid'])
                        ->first();
                    }else{
                        $storeOrderData =  Capsule::table('mod_sslstore_panel_orders')
                        ->select('mod_sslstore_panel_orders.whmcs_order_id','mod_sslstore_panel_orders.configdata')
                        ->leftJoin('mod_sslstore_orders_data','mod_sslstore_orders_data.invoice_id','=','mod_sslstore_panel_orders.whmcs_invoice_id')
                        ->where('mod_sslstore_orders_data.store_order_id', $_POST['orderid'])
                        ->first();
                    }
                }catch(\Exception $e){
                    logActivity("TheSSLStore Module Log|query, {$e->getMessage()}");
                }
            }

            $configData = json_decode($storeOrderData->configdata);

            $sslInfo = array();
            $sslInfo['commonName'] = $configData->commonName;
            $sslInfo['additionalDomains'] = $configData->additionalDomains;
            $sslInfo['subDomains'] = $configData->subDomains;
            $sslInfo['csrCompany'] = $configData->csrCompany;
            $sslInfo['csrDivision'] = $configData->csrDivision;
            $sslInfo['csrCity'] = $configData->csrCity;
            $sslInfo['csrState'] = $configData->csrState;
            $sslInfo['csrCountry'] = $configData->csrCountry;
            $sslInfo['csrEmail'] = $configData->csrEmail;
            $sslInfo['address1'] = $configData->address1;
            $sslInfo['postcode'] = $configData->postcode;
            $sslInfo['orgPhone'] = $configData->orgPhone;
            $sslInfo['firstname'] = $configData->firstname;
            $sslInfo['lastname'] = $configData->lastname;
            $sslInfo['jobtitle'] = $configData->jobtitle;
            $sslInfo['email'] = $configData->email;
            $sslInfo['phonenumber'] = $configData->phonenumber;
            $sslInfo['fields']['TechFirstName'] = $configData->fields->TechFirstName;
            $sslInfo['fields']['TechLastName'] = $configData->fields->TechLastName;
            $sslInfo['fields']['TechTitle'] = $configData->fields->TechTitle;
            $sslInfo['fields']['TechEmail'] = $configData->fields->TechEmail;
            $sslInfo['fields']['TechPhone'] = $configData->fields->TechPhone;
            $sslInfo['fields']['IsSiteSeal'] = $configData->fields->IsSiteSeal;

            $sslInfo['fields']['selectedDomainName'] = $configData->fields->selectedDomainName;
            $sslInfo['fields']['domainsCoverCount'] = $configData->fields->domainsCoverCount;
            $sslInfo['fields']['domainsSubdomains'] = $configData->fields->domainsSubdomains;
            $sslInfo['fields']['totalPrice'] = $configData->fields->totalPrice;
            $sslInfo['fields']['discount'] = $configData->fields->discount;
            $sslInfo['fields']['mainDomainID'] = $configData->fields->mainDomainID;
            $sslInfo['fields']['mainDomainValue'] = $configData->fields->mainDomainValue;
            $sslInfo['fields']['additionalStandardID'] = $configData->fields->additionalStandardID;
            $sslInfo['fields']['additionalStandardValue'] = $configData->fields->additionalStandardValue;
            $sslInfo['fields']['additionalWildcardID'] = $configData->fields->additionalWildcardID;
            $sslInfo['fields']['additionalWildcardValue'] = $configData->fields->additionalWildcardValue;

            $sslInfo['fields']['IsEE'] = $configData->fields->IsEE;
            $sslInfo['fields']['IsEENoSiteSeal'] = $configData->fields->IsEENoSiteSeal;
            $sslInfo['IsBasic'] = $configData->IsBasic;
            $sslInfo['digicert_org_id'] = $configData->digicert_org_id;
            $sslInfo['AutoWWW'] = $configData->AutoWWW;

            $sslInfo['csr'] = $csr;

            if($_POST['updatePvtKey'] == true)
            {


                $results = Capsule::table('mod_sslstore_panel_orders')->where('whmcs_order_id', $storeOrderData->whmcs_order_id)->update(['allow_autoinstall' => 'NO','cert_installed' => 'NO','pvtKeyID' => $_POST['pvtkeyid'],'configdata' => json_encode($sslInfo)]);
            }else
            {
                $results = Capsule::table('mod_sslstore_panel_orders')->where('whmcs_order_id', $storeOrderData->whmcs_order_id)->update(['allow_autoinstall' => 'YES','cert_installed' => 'NO','pvtKeyID' => $_POST['pvtkeyid'],'configdata' => json_encode($sslInfo)]);
            }
            echo json_encode(array('result' => 'success','message' => '','results' => $results));
            die();
        }catch(\Exception $e){
            logActivity("TheSSLStore Module Log|query, {$e->getMessage()}");
        }
        echo json_encode(array('result' => 'success','message' => '','results' => $results));
        die();
    }
}
$tss_custom_api = new tss_custom_api();
