--
-- `#prefix#AclRules`
--
CREATE TABLE IF NOT EXISTS `#prefix#AclRules` (
    `id`            int(10) unsigned NOT NULL AUTO_INCREMENT,
    `name`          varchar(255) unique NOT NULL,
    `fullAccess`    boolean NOT NULL,
    PRIMARY KEY (`id`)
    ) ENGINE=InnoDB  DEFAULT CHARSET=#charset# DEFAULT COLLATE #collation#;

--
-- `#prefix#AclResources`
--
CREATE TABLE IF NOT EXISTS `#prefix#AclResources` (
    `id`            int(10) unsigned NOT NULL AUTO_INCREMENT,
    `name`          varchar(255) unique NOT NULL,
    `is_custom`     int(10) unsigned NOT NULL,
    `logging`       varchar(255) NOT NULL,
    PRIMARY KEY (`id`)
    ) ENGINE=InnoDB  DEFAULT CHARSET=#charset# DEFAULT COLLATE #collation#;

--
-- `#prefix#AclRulesAdmin`
--
CREATE TABLE IF NOT EXISTS `#prefix#AclRulesAdmin` (
    `id`            int(10) unsigned NOT NULL AUTO_INCREMENT,
    `rule_id`       int(10) unsigned NOT NULL,
    `admin_id`      int(10) unsigned NOT NULL,
    PRIMARY KEY (`id`)
    ) ENGINE=InnoDB  DEFAULT CHARSET=#charset# DEFAULT COLLATE #collation#;

--
-- `#prefix#AclRulesAdminGroups`
--
CREATE TABLE IF NOT EXISTS `#prefix#AclRulesAdminGroups` (
    `id`            int(10) unsigned NOT NULL AUTO_INCREMENT,
    `rule_id`       int(10) unsigned NOT NULL,
    `group_id`      int(10) unsigned NOT NULL,
    PRIMARY KEY (`id`)
    ) ENGINE=InnoDB  DEFAULT CHARSET=#charset# DEFAULT COLLATE #collation#;

--
-- `#prefix#AclRulesResources`
--
CREATE TABLE IF NOT EXISTS `#prefix#AclRulesResources` (
    `id`            int(10) unsigned NOT NULL AUTO_INCREMENT,
    `rule_id`       int(10) unsigned NOT NULL,
    `resource_id`   int(10) unsigned NOT NULL,
    `is_allow_type` int(10) unsigned NOT NULL,
    PRIMARY KEY (`id`)
    ) ENGINE=InnoDB  DEFAULT CHARSET=#charset# DEFAULT COLLATE #collation#;

--
-- `#prefix#AclLogs`
--
CREATE TABLE IF NOT EXISTS `#prefix#AclLogs` (
    `id`                    int(10) unsigned NOT NULL AUTO_INCREMENT,
    `rel_id`                int(10) unsigned NOT NULL,
    `type`                  ENUM ('administrator', 'user') NOT NULL,
    `requested_resource`    varchar(255) NOT NULL,
    `resource_id`           int(10) unsigned NOT NULL,
    `rule_id`               int(10) unsigned NOT NULL,
    `date`                  DATETIME DEFAULT null,
    PRIMARY KEY (`id`)
    ) ENGINE=InnoDB  DEFAULT CHARSET=#charset# DEFAULT COLLATE #collation#;



