mgJsComponentHandler.addDefaultComponent('mg-pie-graph', {
    template : '#t-mg-pie-graph',
    props: [
        'component_id',
        'component_namespace',
        'component_index',
        'settings_key'
    ],
    data : function () {
        return {
            loading : false,
            noData: false,
            chart: null,
            type: '',
            isRestart : false,
            data: {},
            parseData: "{}",
            options: {},
            filter: {},
            parseFilter: "{}",
        };
    },
    created: function () {
        var self = this;
        self.updateProjects();
        self.$parent.$root.$on('reloadMgData', self.updateMgData);
    },
    mounted: function () {
        var self = this;
    },
    methods: {
        updateMgData: function(toReloadId, customParams){
            var self = this;
            if (("graph_" + self.component_id) === toReloadId && !self.settings_key) {
                self.updateProjects(customParams);
                self.$nextTick(function() {
                    self.$emit('restartRefreshingState');
                });
            }
            else if (("graph_rl_" + self.settings_key) === toReloadId && self.settings_key) {
                self.updateProjects(customParams);
                self.$nextTick(function () {
                    self.$emit('restartRefreshingState');
                });
            }
            else if (("graph_" + self.component_id) === toReloadId && self.settings_key && toReloadId !== "graph_rl_" + self.settings_key) {
                mgPageControler.vueLoader.runRefreshActions(["graph_rl_" + self.settings_key]);
            }
        },
        createChart: function () {
            var self = this;
            if (self.chart == null || self.isRestart === true) {
                self.$nextTick(function() {
                    self.isRestart = false;
                    var ctx = document.getElementById('canv_' + self.component_id);
                    self.fixDataStructure();
                    self.$nextTick(function() {
                        self.chart = new Chart(ctx, {
                            type: self.type,
                            data: {
                                datasets: self.data.datasets,
                            },
                            options: self.options
                        });
                        self.reloadChart();
                    });
                });
            }
        },
        updateProjects: function (customParams) {
            var self = this;
            self.loading = true;
            var request = this.$parent.$root.$options.methods.vloadData({
                loadData :      self.component_id,
                namespace :     self.component_namespace,
                index:          self.component_index,
                customParams:   (customParams ? customParams : [])
            }, true);
            request.done(function(data)
            {
                data = JSON.parse(data);

                if (data.data && data.data.rawData) {
                    data = data.data.rawData;
                    if (data.type) {
                        self.type = data.type;
                    }
                    if (data.data) {
                        self.parseData = JSON.stringify(data.dataParse);
                        self.data = data.data;
                        self.options = data.options;
                        if(self.data.datasets[0].data === undefined)
                        {
                            self.noData = true;
                        }else{
                            self.noData = false;
                        }
                    }
                    /* disabled for pie */
                    // if (data.options) {
                    //     self.options = data.options;
                    // }
                    /***/
                    if (data.filter) {
                        self.filter = data.filter;
                        self.parseFilter = JSON.stringify(data.filter);
                    }
                }
                self.$nextTick(function() {
                    if (!self.chart) {
                        self.createChart();
                    } else {
                        self.reloadChart();
                    }
                    self.loading = false;
                });
            })
                .fail(function() {});
        },
        reloadChart: function () {
            var self = this;
            if (self.chart)
            {
                //self.fixDataStructure();
                self.chart.options = self.options;
                self.chart.data.datasets = self.data.datasets;
                if(self.type === 'pie')
                {
                    self.chart.data.labels= self.data.labels;
                }

                self.chart.update();
            }
        },
        restartChart: function () {
            var self = this;
            self.isRestart = true;
            self.createChart();
        },
        loadModal: function(event, targetId, namespace, index, params, addSpinner){
            var self = this;
            var params = [];
            params.push({name: 'customParams', value: self.parseData});
            params.push({name: 'defaultFilter', value: self.parseFilter});
            mgPageControler.vueLoader.loadModal(event, targetId, typeof namespace !== 'undefined' ? namespace : getItemNamespace(targetId), index, params, addSpinner);
        },
        onOffSwitch: function(event, targetId){
            var switchPostData = $(event.target).is(':checked') ? {'value' : 'on'} : {'value' : 'off'};
            mgPageControler.vueLoader.ajaxAction(event, targetId, getItemNamespace(targetId), getItemIndex(targetId), switchPostData);
        },
        makeCustomAction : function(functionName, params, event, namespace, index) {
            mgPageControler.vueLoader.makeCustomAction(functionName, params, event, namespace, index);
        },
        redirect :  function (event, params) {
            mgPageControler.vueLoader.redirect(event, params);
        },
        //TODO: refactor this function to a recuring crowler
        fixDataStructure: function () {
            var self = this;
            var ctx = $('#canv_' + self.component_id);
            var width = ctx.width();
            var strlen = 0;

            for(key in self.data.labels)
            {
                strlen += self.data.labels[key].length;
            }

            var rows = Math.ceil((strlen * 7) / width);
            if(rows > 4)
            {
                var height = 500 + (rows * 20);
                ctx.height(height);
                ctx.attr('height', height);
            }
        }
    }
});
