mgJsComponentHandler.addDefaultComponent('mg-time-picker', {
    template: '#t-mg-time-picker',
    props: [
        'component_id',
        'component_namespace',
        'component_index',
        'predefined_date',
        'date_format'
    ],
    data : function() {
        return {
            date: null,
            options: {
                format: 'DD/MM/YYYY H:mm:ss',
                useCurrent: false,
                showClear: true,
                showClose: true,
            }
        }
    },
    components : {
        VueBootstrapDatetimePicker
    },
    created: function () {

        this.options.format = this.date_format;



        if(this.predefined_date.length === 0)
        {
            this.date = new Date();
        }
        else
        {
            this.date = new Date(moment(this.predefined_date, this.date_format).toString());
        }
    },
    methods: {
        customFormatter: function(date) {
            return moment(date).format(this.date_format);
        },
    }
});
