/* extend icons */
$.extend(true, $.fn.datetimepicker.defaults, {
    icons: {
        time:       'lu-zmdi lu-zmdi-timer',
        date:       'lu-zmdi lu-zmdi-calendar-alt',
        up:         'lu-zmdi lu-zmdi-long-arrow-up',
        down:       'lu-zmdi lu-zmdi-long-arrow-down',
        previous:   'lu-zmdi lu-zmdi-arrow-left',
        next:       'lu-zmdi lu-zmdi-arrow-right',
        today:      'lu-zmdi lu-zmdi-home',
        clear:      'lu-zmdi lu-zmdi-timer-off',
        close:      'lu-zmdi lu-zmdi-close'
    }
});

function printableVersionButton(vue, params, event, namespace)
{
    formData = $('#filterForm').serialize();
    var location = params.rawUrl+'&'+formData;;

    var myWindow = window.open(location, '', 'width=1024,height=768');
    myWindow.print();
}


function redirectUrl(vue, params, event, namespace)
{
    formData = $('#filterForm').serialize();

    if( params.newTab && params.newTab == true)
    {
        window.open(params.rawUrl+'&'+formData, '_blank');
    }else{
        window.open(params.rawUrl+'&'+formData);
    }
}

function filterText(vueComponent, params ,event, namespace, targetId)
{
    var self = vueComponent;
    self.refreshUrl();
    self.initRefreshActions(event, targetId);
    self.addUrlComponent('loadData', targetId);
    self.addUrlComponent('namespace', namespace);
    self.addUrlComponent('index', targetId);
    self.getActionId(event);
    self.addUrlComponent('ajax', '1');
    /* send post to ajax element */
    $.post(self.targetUrl, {filterName: event.target.name, filterValue : event.target.value})
        .done(function( data ) {
            data = data.data;

            data.refreshIds.forEach(function(value, key){

                self.$emit('reloadMgData', value);
            });

            if(data.status === 'success'){

            }
        }, 'json');
    self.refreshUrl();
}

function testConnection(vueComponent,params, event, namespace)
{
    var targetId = 'formCreateBaseJob';

    var formCont = new mgFormControler(targetId);
    formCont.getFieldsData();

    var self = vueComponent;
    vueComponent.showSpinner(event);
    self.refreshUrl();
    self.initRefreshActions(event, targetId);
    self.addUrlComponent('loadData', targetId);
    self.addUrlComponent('namespace', namespace);
    self.addUrlComponent('index', targetId);
    self.getActionId(event);
    self.addUrlComponent('ajax', '1');

    $.post(self.targetUrl, {formData: formCont.data})
        .done(function( data ) {
            data = data.data;
            vueComponent.hideSpinner(event);
            self.addAlert(data.status, data.message);
        }, 'json');
}