function redirectUrl(vue,params, event, namespace)
{
    window.location = params.rawUrl;
}

function redirectUrlFromProvider(params,vue, event, namespace)
{
    window.location = params.rawData.rawUrl;
}

function orderChange(self, data, event, namespace, index) {
    self.showSpinner(event);
    self.appActionBlockingState = true;
    var actionElementId = $(event.target).closest('tr').attr('actionid');
    var loadData = {
        loadData: data.id,
        namespace: namespace,
        index: index,
        actionElementId: actionElementId
    };
    var response = mgPageControler.vueLoader.vloadData(loadData);

    response.done(function (res) {

        if(res.data.status === 'error')
        {
            self.hideSpinner(event);
            self.appActionBlockingState = false;
            mgPageControler.vueLoader.handleErrorMessage(res.data);
            return;
        }

        self.runRefreshActions(res.data.refreshIds)

        $.each(mgPageControler.vueLoader.$children, function (index, value) {
            if(value.component_id === data.id)
            {
                value.updateProjects();
            }
        });
        self.hideSpinner(event);
        self.appActionBlockingState = false;
    }).fail(function(jqXHR, textStatus, errorThrown) {
        mgPageControler.vueLoader.handleServerError(jqXHR, textStatus, errorThrown);
        self.hideSpinner(event);
        self.appActionBlockingState = false;
    });
}
