--
-- `#prefix#scheduleTask`
--
CREATE TABLE IF NOT EXISTS `#prefix#scheduleTask` (
    `id`                        INT(11)     NOT NULL AUTO_INCREMENT,
    `type`                      VARCHAR(50) NOT NULL,
    `taskName`                  VARCHAR(50) NULL,
    `reportId`                  VARCHAR(50) NULL,
    `reportType`                VARCHAR(50),
    `filters`                   TEXT        NULL,
    `actions`                   TEXT        NULL,
    `lastTimestamp`             DATETIME    NULL,
    `created_at`                DATETIME    NULL,
    `updated_at`                DATETIME    NULL,
    `timePeriod`                VARCHAR(20) NULL,
    `customPeriodId`            INT(11)     NULL,
    `periodDate`                VARCHAR(50) NULL,
    `reportOutputFormat`        VARCHAR(256) NULL,
                                UNIQUE      KEY  `id` (`id`)
    )   ENGINE=InnoDB           DEFAULT 
        CHARSET=#charset#       DEFAULT     COLLATE #collation#;

--
-- `#prefix#customReport`
--
CREATE TABLE IF NOT EXISTS `#prefix#customReport` (
    `id`                        INT(11)         NOT NULL AUTO_INCREMENT,
    `name`                      VARCHAR(150)    NOT NULL,
    `description`               VARCHAR(255)    NOT NULL,
                                UNIQUE          KEY  `id` (`id`)
    )   ENGINE=InnoDB           DEFAULT 
        CHARSET=#charset#       DEFAULT         COLLATE #collation#;

--
-- `#prefix#customReportWidgets`
--
CREATE TABLE IF NOT EXISTS `#prefix#customReportWidgets` (
    `id`                        INT(11)         NOT NULL AUTO_INCREMENT,
    `report_id`                 INT(11)    NOT NULL,
    `name`                      VARCHAR(150)    NOT NULL,
    `description`               VARCHAR(255)    NOT NULL,
    `widget`                    VARCHAR(150)    NOT NULL,
    `advanceLevel`              VARCHAR(100)    NOT NULL,
    `query`                     TEXT            NULL,
    `php`                       TEXT            NULL,
    `filters`                   TEXT            NULL,
    `serialized`                TEXT            NULL,
    `expressions`               TEXT            NULL,
    `customization`             TEXT            NULL,
    `sequence`                  INT(20)         UNSIGNED,
    CONSTRAINT report_widget_order UNIQUE (report_id, sequence),
                                UNIQUE          KEY  `id` (`id`)
    )   ENGINE=InnoDB           DEFAULT 
        CHARSET=#charset#       DEFAULT         COLLATE #collation#;

--
-- `#prefix#customPeriods`
--
CREATE TABLE IF NOT EXISTS `#prefix#CustomPeriods` (
    `id`                        INT(11)         NOT NULL AUTO_INCREMENT,
    `months`                    VARCHAR(255)    NOT NULL,
    `daysInMonth`               VARCHAR(100)    NOT NULL,
    `daysInWeek`                VARCHAR(100)    NOT NULL,
    `time`                      VARCHAR(50)    NOT NULL,
                                UNIQUE          KEY  `id` (`id`)
    )   ENGINE=InnoDB           DEFAULT
        CHARSET=#charset#       DEFAULT         COLLATE #collation#;