<?php

if (!defined('WHMCS')) {
    die('This file cannot be accessed directly');
}

require 'cryptomusgateway/vendor/autoload.php';

use WHMCS\Database\Capsule;

function cryptomusgateway_MetaData(): array
{
    return [
        'DisplayName' => 'Cryptomus',
        'APIVersion' => '1.1',
        'DisableLocalCreditCardInput' => true,
        'failedEmail' => 'Credit Card Payment Failed',
        'successEmail' => 'Invoice Payment Confirmation',
        'pendingEmail' => 'Credit Card Payment Pending',
        'TokenisedStorage' => false,
    ];
}

function cryptomusgateway_config(): array
{
    $hours = ['1' => '1 Hour'];
    for ($i = 2; $i <= 12; $i++)
        $hours[$i] = $i . ' Hours';

    return [
        'FriendlyName' => [
            'Type' => 'System',
            'Value' => 'Cryptomus',
        ],
        'apiKey' => [
            'FriendlyName' => 'API key',
            'Type' => 'password',
            'Description' => 'Enter your API key here',
        ],
        'merchantUuid' => [
            'FriendlyName' => 'Merchant ID',
            'Type' => 'text',
            'Description' => 'Enter your Merchant ID here',
        ],
        'subtract' => [
            'FriendlyName' => 'Subtract',
            'Type' => 'dropdown',
            'Options' => range(0, 100),
            'Description' => 'Percentage of the acceptance fee charged to the client',
        ],
        'lifetime' => [
            'FriendlyName' => 'Invoice Lifetime',
            'Type' => 'dropdown',
            'Options' => $hours,
            'Description' => '',
        ],
        'comissionMode' => [
            'FriendlyName' => 'Comission',
            'Type' => 'yesno',
            'Description' => 'Take into account commission on the client side?',
        ],
        'payNowLabel' => [
            'FriendlyName' => 'Pay Now Button Text',
            'Type' => 'text',
            'Default' => 'Pay with Cryptomus',
            'Description' => 'Enter the text for the payment button',
        ],
        'convertToAdminCurrency' => [
            'FriendlyName' => 'Convert fiat to admin default currency',
            'Type' => 'yesno',
            'Description' => 'Convert fiat currency to default currency(Administration panel only)',
        ],
    ];
}

/**
 * @throws \Cryptomus\Api\RequestBuilderException
 */
function cryptomusgateway_link(array $params): string
{
    $apiKey = $params['apiKey'];
    $merchantUuid = $params['merchantUuid'];
    $langPayNow = $params['payNowLabel'] ?? 'Pay with Cryptomus';

    $invoiceId = $params['invoiceid'];
    $amount = $params['amount'];
    $currencyCode = $params['currency'];

    $lifetime = $params['lifetime'] ?? 12; // 12 hours is default value

    $systemUrl = $params['systemurl'];
    $returnUrl = $params['returnurl'];
    $moduleName = $params['paymentmethod'];
    $whmcsVersion = $params['whmcsVersion'];

    $data = [];
    $data['amount'] = (string)$amount;
    $data['currency'] = $currencyCode;
    $data['order_id'] = 'whmcs_' . $invoiceId;
    $data['url_return'] = $returnUrl;
    $data['url_callback'] = $systemUrl . '/modules/gateways/callback/' . $moduleName . '.php';
    $data['is_payment_multiple'] = true;
    $data['lifetime'] = (string)(3600 * (int)$lifetime);
    $data['is_refresh'] = false;
    $data['whmcs_version'] = $whmcsVersion;

    if ($_SERVER['SCRIPT_NAME'] === '/viewinvoice.php') {
       $data['is_refresh'] = true;
       $invoiceObject = Capsule::table('tblinvoices')
        ->where('id', 18)->first();
       $invoiceCreatedAt = new DateTime($invoiceObject->created_at);
       $invoiceUpdatedAt = new DateTime($invoiceObject->updated_at);

       if ($invoiceUpdatedAt > $invoiceCreatedAt) {
            $amount = (int)$amount;
            $data['order_id'] = "whmcs_upd_{$amount}_" . $invoiceId;
            var_dump($data['order_id']);
       }

    }

    if (isset($params['subtract'])) {
        $data['subtract'] = $params['subtract'];
    }

    $payment = \Cryptomus\Api\Client::payment($apiKey, $merchantUuid);

    try {
        $paymentCreate = $payment->create($data);
    } catch (\Exception $e) {
        // Handle exception or error logging
        logModuleCall('Cryptomus', 'link', ['invoiceId' => $invoiceId],  $e->getMessage());
        return 'Error processing payment: ' . $e->getMessage();
    }

    $htmlOutput = '<form action="' . htmlspecialchars($paymentCreate['url'], ENT_QUOTES) . '">';
    $htmlOutput .= '<input type="submit" value="' . htmlspecialchars($langPayNow, ENT_QUOTES) . '"/>';
    $htmlOutput .= '</form>';
    $htmlOutput .= '<!--' . print_r($params, true) . "-->";

    return $htmlOutput;
}
