<?php
# Required File Includes
include("../../../init.php");
include("../../../includes/functions.php");
include("../../../includes/gatewayfunctions.php");
include("../../../includes/invoicefunctions.php");

# Require Interexcel Sage Module
if(!function_exists('\Interexcel\show_debit_form')) {
	include( "../../addons/debitize/init.php" );
}

$base = '../../../';

$invoice_id = isset($_GET['invoiceid']) ? $_GET['invoiceid'] : null;

$process_form = isset($_POST['ie_action']) && $invoice_id;

$errors = array();
$saved = false;

// Form has been submitted. Validate the data
if( $process_form ) {

	// Get the client and other relevant detail from the invoice
	$invoice = \Interexcel\get_invoice($invoice_id);

	if( $invoice && $invoice['result'] == 'success' ) {

		// Get the client's detail
		$client_id    = $invoice['userid'];
		$detail       = array(
			'bank_name' => isset( $_POST['bank_name'] ) ? $_POST['bank_name'] : null,
			'branch_code' => isset( $_POST['branch_code'] ) ? $_POST['branch_code'] : null,
			'bank_account' => isset( $_POST['account_number'] ) ? $_POST['account_number'] : null,
			'bank_type' => isset( $_POST['account_type'] ) ? $_POST['account_type'] : null,
		);

		$accepted = isset($_POST['ie_accept']) && $_POST['ie_accept'] == 'on';
		// Accept terms & conditions
		if( !$accepted ) {
			$errors['ie_accept'] = 'You need to accept and agree to the terms &amp; conditions.';
		}

		// Should this be the default payment method?
		$make_default = isset( $_POST['make_default'] ) && $_POST['make_default'] == 'on' ? true : false;

		// Check that all values are set
		foreach ( $detail as $key => $val ) {
			if( !$val ) {
				$errors[$key] = ucwords(str_replace('_', ' ', $key)) . " is invalid.";
			}
		}

		$ENABLE_SAGE_VALIDATION = true;
		if( $ENABLE_SAGE_VALIDATION && empty($errors) ) {
			// There's no need to submit incomplete details.

			// We have values. Check if they're legit.
			$valid = \Interexcel\validate_bank(
				$detail['bank_account'],
				$detail['branch_code'],
				$detail['bank_type']
			);

			// Not a valid bank account
			if( $valid !== true ) {
				$errors['bank_name'] = $valid; //'The submitted banking details are invalid.';
			}
		}

		// No errors! Save the details.
		if( empty($errors) ) {
			Interexcel\add_client_bank( $client_id, $detail, $make_default );
			$saved = true;
		}

	} else {
		// We could not get the invoice.
		$errors[] = "Invalid invoice specified.";
	}
}
?>

<html>
	<head>
		<title>Direct Debit Payment</title>

		<script src="<?php echo $base; ?>assets/js/jquery.min.js"></script>

		<link rel="stylesheet" href="<?php echo $base; ?>assets/css/bootstrap.min.css" />

		<style type="text/css">
			.wrapper {
				width: 500px;
				margin: 0 auto;
				padding: 30px;
			}

			h1 {
				text-align: center;
			}

			h1 + p {
				margin: 2em;
			}

			p.center {
				text-align: center;
			}

			table.form {
				width: 100%;

			}
			table.form td {
				padding: 5px 10px;
				vertical-align: middle;
				font-size: 14px;
			}
			table.form td.ie-label {
				color: #000;
				text-align: right;
			}
			table.form label {
				display: block;
				font-weight: normal;
			}

			.form input[type="email"],
			.form input[type="password"],
			.form input[type="number"],
			.form textarea,
			.form select,
			.form input[type="text"] {
				padding: 5px 10px;
				font-weight: normal;
				width: 100%;
			}

			.form input[type="submit"] {
				margin: 1em;
				padding: 10px 20px;
				text-align: center;

			}

			.ie-success {
				color: #333;
				margin: 2em;
				padding: 10px 20px;
				border-left: 3px solid greenyellow;
			}

			.ie-errors {
				color: red;
				margin: 2em;
				padding: 10px 20px;
				border-left: 3px solid red;
			}

			.ie-errors ul {
				margin: 0;
			}

			/* Portrait & Landscape */
			@media only screen
			and (min-device-width: 320px)
			and (max-device-width: 640px) {

				.wrapper {
					width: 100%;
				}

			}

			/* Portrait */
			@media only screen
			and (min-device-width: 320px)
			and (max-device-width: 640px)
			and (orientation: portrait) {

			}

			/* Landscape */
			@media only screen
			and (min-device-width: 320px)
			and (max-device-width: 640px)
			and (orientation: landscape) {

			}


		</style>
	</head>

	<body>

		<div class="wrapper">

			<?php
			function _dt_get_logo($logo_path, $logo_name = "logo") {
				$logo_path = rtrim($logo_path, "/") . "/";

				$logo_extensions = array( 'jpg', 'png' );
				foreach ($logo_extensions as $ext) {
					$path = "{$logo_path}{$logo_name}.{$ext}";
					if( file_exists($path) ) {
						return array(
							'path' => $logo_path,
							'name' => $logo_name,
							'ext' => $ext,
							'src' => $path,
						);
						break;
					}
				}

				return '';
			}

			$src = '';
			$logo = _dt_get_logo("../../../");

			if( $logo )
				$src = $logo['src'];

			if( !$logo ) {
				$exist = _dt_get_logo(dirname(__FILE__));
				if( $exist ) {
					$src = "{$exist['name']}.{$exist['ext']}";
				}
			}

			if( $src ) {
				echo "<p><img src='$src' title='' /></p>";
			}
			?>

			<h1>Direct Debit Payment</h1>

			<p class="desc center">
				We'll save your banking details to process debit orders on your behalf.
			</p>

			<form class="ie-form" id="debit-order" action="#" method="POST">

				<?php
				if(isset($errors) && !empty($errors)) {
					echo "<div class='ie-errors'>";
						echo "<p>There were some issues with the details you've submitted. Please see them below.</p>";
						echo "<ul>";
							foreach ( $errors as $error ) {
								echo "<li>{$error}</li>";
							}
						echo "</ul>";
					echo "</div>";
				}
				if(isset($saved) && $saved === true) {
					echo "<div class='ie-success'>";
						echo "<p>Saved!</p>";
						echo "<p>You will be redirected to the client area in 5 seconds. <a href='../../../clientarea.php'>Click here</a> to return immediately.</p>";
						?>
						<script type="text/javascript">
							setTimeout(function () {
								window.location.href = "../../../clientarea.php";
							}, 5000);
						</script>
					<?php
					echo "</div>";

					die();
				}
				?>

				<input type="hidden" name="ie_action" value="validate_bank_account" />
				<input type="hidden" name="invoice_id" value="<?php echo $invoice_id; ?>" />

				<?php
				$to = '#'; //$base . 'modules/gateways/directdebit.php?invoiceid=4';
				\Interexcel\show_debit_form('Save &amp; Continue');
				?>

				<p class="">
					<label style="font-weight: normal;" for="make_default"><input id="make_default" type="checkbox" name="make_default" /> Make this your default payment method?</label>
				</p>

				<p class="">
					<label for="ie_accept"><input id="ie_accept" type="checkbox" name="ie_accept" /> I understand &amp; accept that you will debit my account.</label>
				</p>

			</form>

		</div>

	</body>
</html>
