<?php
/**
 *
 *************
 * IMPORTANT *
 *************
 *
 * Please remember this files gets cached! So if changes are made, please
 * edit and resave the addon module configuration for it to be detected!
 *
 * ---
 *
 * Addon Module Sample Hook File
 *
 * This is a demo hook file for an addon module. Addon Modules can utilise all of the WHMCS
 * hooks in exactly the same way as a normal hook file would, and can contain multiple hooks.
 *
 * For more info, please refer to the hooks documentation @ http://docs.whmcs.com/Hooks
 *
 * @package    WHMCS
 * @author     WHMCS Limited <development@whmcs.com>
 * @copyright  Copyright (c) WHMCS Limited 2005-2013
 * @license    http://www.whmcs.com/license/ WHMCS Eula
 * @version    $Id$
 * @link       http://www.whmcs.com/
 */

if (!defined("WHMCS")) {
	die( "This file cannot be accessed directly" );
}

if (!defined("IE_SAGE_DEBUG")) {
	require dirname( __FILE__ ) . '/init.php';
}

if( !function_exists('add_hook') ) {
	die("This file cannot be accessed directly");
}

add_hook('AdminAreaClientSummaryActionLinks', 1, function($vars) {
    $return = [];

    if (isset($vars['userid'])) {
        $updateUrl = "/modules/addons/debitize/popup.php?action=bank&clientid={$vars['userid']}";
        $deleteUrl = "/modules/addons/debitize/popup.php?action=delete-bank&clientid={$vars['userid']}";

        $return[] = "<a href='{$updateUrl}'>[Debitize] Update Bank Detail</a>";
        $return[] = "<a href='{$deleteUrl}' style='color:#CC0000;' onclick=\"return confirm('Are you sure you want to delete the bank detail?');\">[Debitize] Delete Bank Detail</a>";
    }

    return $return;
});

/**
 * After the cron has completed and the cron email has sent, but before the database backups.
 * The hook can be used to run automatic actions daily along with the WHMCS standard cron actions.
 *
 * @param bool $override Temporary parameter for testing
 */
add_hook("DailyCronJob",1,function ( $override = false ) {
	Interexcel\log_activity( "DailyCronJob called!");
	Interexcel\ielog( "DailyCronJob called!", [], 'debug', true );
	return Interexcel\ie_daily($override);
});

add_hook("AdminAreaHeadOutput",1,function($vars) {
	$path = "../modules/addons/debitize/assets/";
	$head_return = '<script type="text/javascript" src="'.$path.'js/admin.js.php"></script>';
	return $head_return;

});

/**
 * After the card details have been updated.
 * When this hook runs, the details have been saved, and the store remote function has been run when appropriate.
 *
    userid	    Int	    The ID of the user updating the CC details
    cardtype	String	The card type
    cardnum	    String	The full card number
    cardcvv	    String	The card CVV number
    expdate	    String	The card expiry
    cardstart	String	The card start date
    issuenumber	String	The card issue number
 *
 * @param array $vars An array with the following data
 */
add_hook("CCUpdate",1,function($vars) {
	// Validate user card details via Netcash web service
	$user_id = (int)$vars['userid'] ;

	Interexcel\log_activity( "CCUpdate called!");

	$vault_creds = \SageConf::vault_credentials();

	if( !$vault_creds || !$vault_creds['service_key'] ) {
		Interexcel\log_activity( "Card not tokenized. No vault service key specified.");
		return;
	}

	if(
		( !isset($vars['cardtype']) || $vars['cardtype'] == '' ) &&
		( !isset($vars['cardnum'])  || $vars['cardnum'] == '' )
	) {
		// Might've cleared. Delete
		\Interexcel\TokenModel::remove($user_id);
		Interexcel\log_activity( "CCUpdate exit - No card details.");
		return;
	}

	$exp_date_m = substr($vars['expdate'], 0, 2);
	$exp_date_y = '20' . substr($vars['expdate'], -2, 2);

	// TODO: Why are we getting incorrect credentials (100) error from API???
	$valid = true;
//    $valid = \Interexcel\validate_card(
//        $vars['cardtype'],
//        $vars['cardnum'],
//        $exp_date_m,
//        $exp_date_y
//    );
//    debitize_log( "CARD " . ($valid ? 'valid!' : 'invalid.'), $vars);

	if( $valid ) {

		$vault_creds = \SageConf::vault_credentials();
		$Card = new \Netcash\Card($vault_creds['service_key']);

		$user_query = Interexcel\get_user($user_id);

		if( isset($user_query['result']) && $user_query['result'] === 'success' ) {
			$client = $user_query['client'];

			$token = $Card->tokenizeCard(
				"{$client['fullname']}",
				$vars['cardnum'],
				$exp_date_m,
				$exp_date_y
			);

			if( $token ) {
				$mask = $Card->maskCard($vars['cardnum']);

				\Interexcel\TokenModel::add($user_id, array(
					'name_on_card' => $client['fullname'],
					'card_token' => $token,
					'card_mask' => $mask,
					'expiry_date' => "{$exp_date_y}-{$exp_date_m}-01",
				));

//             mysql_query("INSERT INTO mod_interexcel_tokens (user_id, card_token, card_mask) VALUES ( $user_id, '{$token}', '{$mask}' )");
			}
		}
	}

	// What to do if validation fails?
});

add_hook('InvoiceChangeGateway', 1, function($vars) {

	$notify = \Interexcel\OptionModel::getValue('notify_payment_method_change', false) == 'on';

	\Interexcel\log_activity("Invoice {$vars['invoiceid']} payment method changed to {$vars['paymentmethod']}");
	if( !$notify ) {
		return;
	}

	$vars['invoiceid']; // The id of the invoice being updated.
	$vars['paymentmethod']; // The new payment method selected.

	$msg = "<h1>Invoice Payment Method Changed</h1>";
	$msg .= "<p>The payment method for invoice {$vars['invoiceid']} changed to <strong>{$vars['paymentmethod']}</strong>.";

	\Interexcel\mail_admin("Invoice Payment Method Changed", $msg);
});
